/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.image.pojo.UserInfo;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ScanunitEditPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private static final String ITEM_KEY_ADVCONAP_ADD = "advconap_add";

    public void initialize() {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"textfield"});
        this.addClickListeners(new String[]{"cardentryflexpanelap5"});
        this.addClickListeners(new String[]{"imageap"});
        this.addClickListeners(new String[]{"labelap_add"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)opStatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        } else if (OperationStatus.ADDNEW.equals((Object)opStatus)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("imageap".equalsIgnoreCase(c.getKey()) || "labelap_add".equalsIgnoreCase(c.getKey()) || "cardentryflexpanelap5".equalsIgnoreCase(c.getKey()) || "cardentryflexpanelap6".equalsIgnoreCase(c.getKey())) {
            this.cardEntryAdd();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equalsIgnoreCase(ITEM_KEY_ADVCONAP_ADD)) {
            this.cardEntryAdd();
        }
    }

    private void cardEntryAdd() {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setHasRight(true);
        para.setBillFormId("bos_user");
        para.setFormId("bos_listf7");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        listFilterParameter.setFilter(qfilter);
        para.setListFilterParameter(listFilterParameter);
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        para.setShowTitle(false);
        para.setStatus(OperationStatus.ADDNEW);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ITEM_KEY_ADVCONAP_ADD));
        this.getView().showForm((FormShowParameter)para);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if (ITEM_KEY_ADVCONAP_ADD.equals(e.getActionId())) {
            Object[] pk = this.getSelectedEntryPK(e);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_user");
            Map mapObjects = BusinessDataReader.loadFromCache((Object[])pk, (DynamicObjectType)type, (boolean)false);
            Map<Long, Long> userExistedMap = this.getUserMap();
            boolean isUserMapNull = userExistedMap == null || userExistedMap.size() == 0;
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            ArrayList<Long> idArr = new ArrayList<Long>();
            for (Map.Entry entry : mapObjects.entrySet()) {
                Long userId = (Long)((DynamicObject)entry.getValue()).get("id");
                boolean isExits = false;
                if (!isUserMapNull) {
                    isExits = userExistedMap.containsKey(userId);
                }
                if (isExits) continue;
                idArr.add(userId);
            }
            if (idArr.size() > 0) {
                if (!isUserMapNull) {
                    for (Long userid : userExistedMap.keySet()) {
                        idArr.add(userid);
                    }
                }
                Map<Long, UserInfo> userDpt = this.getDptNameCollectionByUseridArr(idArr);
                model.deleteEntryData("entryentity");
                model.beginInit();
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("displayname", new Object[0]);
                vs.addField("dptname", new Object[0]);
                for (Map.Entry<Long, UserInfo> entry : userDpt.entrySet()) {
                    vs.addRow(new Object[]{entry.getKey(), entry.getValue().getDpt()});
                }
                model.batchCreateNewEntryRow("entryentity", vs);
                model.endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(true);
    }

    private Map<Long, UserInfo> getDptNameCollectionByUseridArr(List<Long> idArr) {
        HashMap<Long, UserInfo> userDpt = new HashMap<Long, UserInfo>();
        DynamicObjectCollection coll = null;
        String selectField = "id,entryentity.dpt,entryentity.ispartjob";
        QFilter idFilter = new QFilter("id", "in", idArr);
        coll = QueryServiceHelper.query((String)"basedata.ScanunitEditPlugin.getDptNameCollectionByUseridArr", (String)"bos_user", (String)selectField, (QFilter[])idFilter.toArray(), null);
        if (coll.size() > 0) {
            for (DynamicObject userObj : coll) {
                UserInfo u;
                Long userid;
                UserInfo userFromM;
                boolean ispartjob = (Boolean)userObj.get("entryentity.ispartjob");
                Long dpt = 0L;
                if (!ispartjob) {
                    dpt = (Long)userObj.get("entryentity.dpt");
                }
                if ((userFromM = (UserInfo)userDpt.get(userid = Long.valueOf(userObj.getLong("id")))) != null) {
                    if (dpt == 0L || userFromM.getDpt() == 0L) continue;
                    u = new UserInfo();
                    u.setId(userid);
                    u.setDpt(dpt);
                    userDpt.put(userid, u);
                    continue;
                }
                u = new UserInfo();
                u.setId(userid);
                u.setDpt(dpt);
                userDpt.put(userid, u);
            }
        }
        return userDpt;
    }

    private Map<Long, Long> getUserMap() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        if (collection.size() == 0) {
            return null;
        }
        HashMap<Long, Long> u = new HashMap<Long, Long>();
        for (DynamicObject obj : collection) {
            DynamicObject dynamicObject = (DynamicObject)obj.get("displayname");
            Long id = (Long)dynamicObject.get("id");
            u.put(id, id);
        }
        return u;
    }

    private Object[] getSelectedEntryPK(ClosedCallBackEvent e) {
        ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)e.getReturnData();
        Object[] pk = new Object[rowDataCol.size()];
        for (int i = 0; i < rowDataCol.size(); ++i) {
            ListSelectedRow selectrow = rowDataCol.get(i);
            if (StringUtils.isBlank((Object)selectrow.getPrimaryKeyValue())) continue;
            pk[i] = selectrow.getPrimaryKeyValue();
        }
        return pk;
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterLoadData(EventObject e) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        if (collection == null) {
            return;
        }
        for (DynamicObject obj : collection) {
            DynamicObject userObj = (DynamicObject)obj.get("displayname");
            DynamicObjectCollection userDpts = userObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : userDpts) {
                boolean temp = entry.getBoolean("ispartjob");
                if (temp) continue;
                obj.set("dptname", (Object)entry.getDynamicObject("dpt"));
            }
        }
        this.getModel().setDataChanged(false);
    }
}

