/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class TaskScanunitListPlugin
extends AbstractListPlugin
implements ClickListener,
ItemClickListener,
RowClickEventListener {
    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl("billlistap");
        list.setOrderBy("modifytime desc");
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"labelapdel"});
        this.addClickListeners(new String[]{"imageap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("imageap".equalsIgnoreCase(key)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("imageap", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u8ba4\u8981\u5220\u9664\u5f53\u524d\u8bb0\u5f55\u5417\uff1f", (String)"TaskScanunitListPlugin_0", (String)"bos-image-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("imageap".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteRightUser();
        }
    }

    private void deleteRightUser() {
        IDataModel model = this.getModel();
        String sscUnitIdStr = this.getPageCache().get("sscUnitId");
        Long sscUnitId = Long.parseLong(sscUnitIdStr);
        int entryIndex = model.getEntryCurrentRowIndex("entryentity");
        Long selectedEntryId = Long.valueOf(model.getValue("entryid", entryIndex) + "");
        model.getValue("entryentity", entryIndex);
        this.deleteUserEntry(sscUnitId, selectedEntryId);
        List<Map<String, Object>> userList = this.getUserList(sscUnitId);
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        ArrayList<Long> entryIds = new ArrayList<Long>(10);
        for (int i = 0; i < userList.size(); ++i) {
            long userId = (Long)userList.get(i).get("userId");
            long entryId = (Long)userList.get(i).get("entryId");
            userIds.add(userId);
            entryIds.add(entryId);
        }
        if (userList.size() > 0) {
            this.setListPerson(userIds, entryIds, userList);
            this.getView().updateView("entryentity");
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    private void deleteUserEntry(Long sscUnitId, Long entryid) {
        DynamicObject[] sscUnitColl;
        QFilter sscUnitIdQfilter = new QFilter("id", "=", (Object)sscUnitId);
        for (DynamicObject dynamicObject : sscUnitColl = BusinessDataServiceHelper.load((String)"bos_sscunitlist", (String)"id,seq,entryentity.id,entryentity.seq", (QFilter[])sscUnitIdQfilter.toArray())) {
            int i;
            DynamicObjectCollection col = (DynamicObjectCollection)dynamicObject.get("entryentity");
            for (i = 0; i < col.size(); ++i) {
                long id = (Long)((DynamicObject)col.get(i)).get("id");
                if (id != entryid) continue;
                col.remove(i);
            }
            for (i = 0; i < col.size(); ++i) {
                DynamicObject dyn = (DynamicObject)col.get(i);
                dyn.set("seq", (Object)(i + 1));
            }
        }
        SaveServiceHelper.save((DynamicObject[])sscUnitColl);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ((BillList)this.getControl("billlistap")).setPageRow(1000);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList entryentity = (BillList)this.getControl("billlistap");
        boolean isExistData = this.isExistData();
        if (!isExistData) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nodata_flexpanel"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"usercard_flexpanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"sscunitgroup_flexpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodata_flexpanel"});
        entryentity.clearSelection();
        entryentity.selectRows(0);
        this.init();
    }

    private boolean isExistData() {
        return QueryServiceHelper.exists((String)"bos_sscunitlist", (QFilter[])new QFilter[0]);
    }

    private void init() {
        ListSelectedRowCollection currentListAllRowCollection = ((IListView)this.getView()).getCurrentListAllRowCollection();
        if (currentListAllRowCollection != null && currentListAllRowCollection.size() > 0) {
            Object[] primaryKeyValues = currentListAllRowCollection.getPrimaryKeyValues();
            if (primaryKeyValues == null || primaryKeyValues.length == 0) {
                return;
            }
            String idFirst = primaryKeyValues[0] + "";
            this.getPageCache().put("sscUnitId", idFirst);
            Long id = Long.parseLong(idFirst);
            List<Map<String, Object>> userList = this.getUserList(id);
            if (userList.size() > 0) {
                this.setListPerson(null, null, userList);
                this.getView().updateView("entryentity");
            } else {
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    private void setListPerson(List<Long> userIds, List<Long> entryIds, List<Map<String, Object>> userList) {
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField("userfield", new Object[0]);
        tvs.addField("dptname", new Object[0]);
        tvs.addField("entryid", new Object[0]);
        for (Map<String, Object> user : userList) {
            Long userId = (Long)user.get("userId");
            Long userDpt = (Long)user.get("userDpt");
            Long entryId = (Long)user.get("entryId");
            tvs.addRow(new Object[]{userId, userDpt, entryId});
        }
        model.batchCreateNewEntryRow("entryentity", tvs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Long getRightEntryIdByUserId(Long userId, List<Map<String, Object>> userList) {
        for (Map<String, Object> map : userList) {
            Long userId1 = (Long)map.get("userId");
            if (!userId1.equals(userId)) continue;
            return (Long)map.get("entryId");
        }
        return null;
    }

    private List<Map<String, Object>> getUserList(Long id) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String selectFields = "id,entryentity.id entryid,entryentity.displayname displayname";
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_sscunitlist", (String)selectFields, (QFilter[])filter.toArray());
        if (coll.size() > 0) {
            DynamicObject[] userInfos;
            Map userDynamicObjectMap = coll.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("displayname"), Function.identity()));
            Set<Long> userIdList = coll.stream().map(dynamicObject -> dynamicObject.getLong("displayname")).collect(Collectors.toSet());
            for (DynamicObject dynamicObject2 : userInfos = this.getBosUserByIdList(userIdList)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Long userId = dynamicObject2.getLong("id");
                DynamicObject scanUser = (DynamicObject)userDynamicObjectMap.get(userId);
                if (scanUser == null) continue;
                Long entryId = scanUser.getLong("entryid");
                String name = dynamicObject2.getString("name");
                Long userDpt = 0L;
                boolean isPartJob = dynamicObject2.getBoolean("entryentity.ispartjob");
                if (!isPartJob) {
                    userDpt = dynamicObject2.getLong("entryentity.dpt");
                }
                map.put("userId", userId);
                map.put("name", name);
                map.put("entryId", entryId);
                map.put("userDpt", userDpt);
                list.add(map);
            }
        }
        this.sortUserIdByName(list);
        return list;
    }

    private DynamicObject getBosUserById(Long bosUserId) {
        DynamicObject bosUserInfo = null;
        QFilter userIdFilter = new QFilter("id", "=", (Object)bosUserId);
        DynamicObject[] bosUserInfos = BusinessDataServiceHelper.load((String)"bos_user", (String)"name", (QFilter[])new QFilter[]{userIdFilter});
        if (bosUserInfos.length < 1) {
            return bosUserInfo;
        }
        bosUserInfo = bosUserInfos[0];
        return bosUserInfo;
    }

    private DynamicObject[] getBosUserByIdList(Set<Long> bosUserIdList) {
        QFilter userIdListFilter = new QFilter("id", "in", bosUserIdList);
        String selectFields = "id,name,entryentity.dpt,entryentity.ispartjob";
        DynamicObject[] userInfos = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])new QFilter[]{userIdListFilter});
        return userInfos;
    }

    private void sortUserIdByName(List<Map<String, Object>> maps) {
        Collections.sort(maps, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                String name1 = (String)o1.get("name");
                String name2 = (String)o2.get("name");
                if (name1 == null && name2 == null) {
                    return 0;
                }
                Collator instance = Collator.getInstance(Locale.CHINA);
                return instance.compare(name1, name2);
            }
        });
    }

    private Long getDptNameByUserId(Long idArr) {
        boolean ispartjob;
        Long userDpt = 0L;
        String selectField = "id,entryentity.dpt,entryentity.ispartjob ";
        QFilter idFilter = new QFilter("id", "=", (Object)idArr);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_user", (String)selectField, (QFilter[])idFilter.toArray());
        if (coll.size() > 0 && !(ispartjob = ((Boolean)((DynamicObject)coll.get(0)).get("entryentity.ispartjob")).booleanValue())) {
            userDpt = (Long)((DynamicObject)coll.get(0)).get("entryentity.dpt");
        }
        return userDpt;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        ListSelectedRowCollection listCol = evt.getListSelectedRowCollection();
        if (listCol.size() > 0) {
            ListSelectedRow listRow = listCol.get(0);
            this.getPageCache().put("sscUnitId", listRow.getPrimaryKeyValue() + "");
            List<Map<String, Object>> userList = this.getUserList(Long.valueOf(listRow.getPrimaryKeyValue() + ""));
            ArrayList<Long> userIds = new ArrayList<Long>(10);
            ArrayList<Long> entryIds = new ArrayList<Long>(10);
            for (int i = 0; i < userList.size(); ++i) {
                long userId = (Long)userList.get(i).get("userId");
                long entryId = (Long)userList.get(i).get("entryId");
                userIds.add(userId);
                entryIds.add(entryId);
            }
            if (userList.size() > 0) {
                this.setListPerson(userIds, entryIds, userList);
            } else {
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map map = args.getSearchClickEvent().getFilterValues();
        List customlist = (List)map.get("customfilter");
        this.getModel().deleteEntryData("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operationName = afterDoOperationEventArgs.getOperateKey();
        if ("new".equals(operationName)) {
            BillList entryentity = (BillList)this.getControl("billlistap");
            entryentity.selectRows(0);
            this.init();
        } else if ("delete".equals(operationName)) {
            if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                BillList entryentity = (BillList)this.getControl("billlistap");
                entryentity.selectRows(0);
                this.init();
            }
        } else if ("modify".equals(operationName)) {
            this.initRightPage();
        }
    }

    private void initRightPage() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        Long primaryKey = (Long)listSelectedRows.get(0).getPrimaryKeyValue();
        this.getPageCache().put("sscUnitId", primaryKey + "");
        List<Map<String, Object>> userList = this.getUserList(primaryKey);
        ArrayList<Long> userIds = new ArrayList<Long>(10);
        ArrayList<Long> entryIds = new ArrayList<Long>(10);
        for (int i = 0; i < userList.size(); ++i) {
            long userId = (Long)userList.get(i).get("userId");
            long entryId = (Long)userList.get(i).get("entryId");
            userIds.add(userId);
            entryIds.add(entryId);
        }
        if (userList.size() > 0) {
            this.setListPerson(userIds, entryIds, userList);
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HasPermOrgResult allPermOrgs;
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "sys";
        }
        if (!((allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"bos_sscunitlist", (String)"4715a0df000000ac")).hasAllOrgPerm() || allPermOrgs.getHasPermOrgs() != null && allPermOrgs.getHasPermOrgs().size() != 0)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4fee\u6539\u6743\u9650\uff01", (String)"TaskScanunitListPlugin_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

