/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin.process;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.image.formplugin.process.ImageErrorInfoRetryProcess;
import kd.bos.image.pojo.ImageErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ProcessingProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private int batchCount;
    private List<ImageErrorInfo> errorInfos;
    private List<String> existImageNumberList;
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ImageRetryPool", (int)2);
    private static final Log log = LogFactory.getLog(ProcessingProgressFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.iniFormParameter(parameter);
        this.start();
    }

    private void iniFormParameter(FormShowParameter parameter) {
        this.batchCount = this.getBatchCount(parameter);
        this.errorInfos = this.getImageErrorInfos(parameter);
        this.existImageNumberList = this.getExistImageNumberList(parameter);
    }

    public void onProgress(ProgressEvent arg0) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            FormShowParameter parameter = this.getView().getFormShowParameter();
            this.iniFormParameter(parameter);
            ImageErrorInfoRetryProcess executer = new ImageErrorInfoRetryProcess(taskId, this.batchCount, this.errorInfos, this.existImageNumberList);
            threadPool.execute((Runnable)executer);
            this.setTaskId(taskId);
        } else {
            boolean completed = ImageErrorInfoRetryProcess.isCompleted(taskId);
            boolean finished = ImageErrorInfoRetryProcess.isFinished(taskId);
            boolean isInteruption = ImageErrorInfoRetryProcess.isInteruption(taskId);
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            if (completed) {
                bar.stop();
                ArrayList imageNos = ImageErrorInfoRetryProcess.getErrorImageNo(taskId);
                int errorCount = imageNos == null ? 0 : imageNos.size();
                int count = ImageErrorInfoRetryProcess.getExecuteCount(taskId);
                log.info("count = " + count + "; errorCount = " + errorCount);
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId("bos_operationresult");
                parameters.setShowTitle(false);
                parameters.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u6210\u529f\u8865\u507f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761", (String)"ProcessingProgressFormPlugin_0", (String)"bos-image-formplugin", (Object[])new Object[0]), count - errorCount, errorCount));
                parameters.setCustomParam("errorMsg", (Object)(imageNos == null ? new ArrayList() : imageNos));
                CloseCallBack close = new CloseCallBack((IFormPlugin)this, "errorRetry");
                parameters.setCloseCallBack(close);
                ImageErrorInfoRetryProcess.clearCache(taskId);
                this.getView().showForm(parameters);
            } else if (isInteruption) {
                ImageErrorInfoRetryProcess.clearCache(taskId);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6279\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ProcessingProgressFormPlugin_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
                this.getView().close();
                bar.stop();
            } else if (finished) {
                ImageErrorInfoRetryProcess.clearCache(taskId);
                this.getView().close();
                bar.stop();
            } else {
                int progress = ImageErrorInfoRetryProcess.getProgress(taskId);
                String tip = ImageErrorInfoRetryProcess.getProgressTip(taskId);
                arg0.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)tip)) {
                    this.setProgressTip(tip);
                }
            }
        }
    }

    private String getTaskId() {
        return this.getPageCache().get("taskid");
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("taskid", taskId);
        log.info("\u83b7\u53d6\u4efb\u52a1id:" + taskId);
    }

    private void start() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
        this.setProgressTip(ResManager.loadKDString((String)"\u5f85\u5904\u7406\u7684\u6570\u636e\u6bd4\u8f83\u591a\uff0c\u6b63\u5728\u5206\u6279...", (String)"ProcessingProgressFormPlugin_2", (String)"bos-image-formplugin", (Object[])new Object[0]));
    }

    private List<ImageErrorInfo> getImageErrorInfos(FormShowParameter parameter) {
        String str = (String)parameter.getCustomParam("errorInfos");
        return JSONObject.parseArray((String)str, ImageErrorInfo.class);
    }

    private List<String> getExistImageNumberList(FormShowParameter parameter) {
        String str = (String)parameter.getCustomParam("existedImageNumber");
        return JSONObject.parseArray((String)str, String.class);
    }

    private int getBatchCount(FormShowParameter parameter) {
        return (Integer)parameter.getCustomParam("batchcount");
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl("lblprogress");
        lblTip.setText(tip);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("errorRetry".equals(closedCallBackEvent.getActionId())) {
            this.getView().close();
        }
    }
}

