/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.imageplatform.util.BillImageFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.lang3.StringUtils;

public class ImageRescanNoticeHelper {
    private static final Log log = LogFactory.getLog(ImageRescanNoticeHelper.class);

    private static DynamicObject matchRule(String billType, String orgId, String msgScenario) {
        DynamicObject billTypeInfo = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billType)});
        if (billTypeInfo == null) {
            log.info("\u672a\u627e\u5230" + billType + "\u7684\u5355\u636e\u4fe1\u606f\uff0c\u65e0\u6cd5\u5339\u914d\u5230\u63d0\u9192\u89c4\u5219");
            return null;
        }
        Long dataId = null;
        Integer matchedPriority = 0;
        String billTypeId = billTypeInfo.getString("id");
        String querySql = "select a.fid,a.fnumber,a.fpriority,a.fmsgscenario,b.fbasedataid org ,c.fbasedataid billType from t_bas_rescanremind a left join t_bas_rescanremind_org b on a.fid = b.fid and b.fbasedataid = ? left join t_bas_rescanremind_bill c on a.fid = c.fid and c.fbasedataid = ? where a.fenable = '1'";
        try (DataSet ds = DB.queryDataSet((String)"bos.image.matchImageStrategy", (DBRoute)DBRoute.of((String)"sys"), (String)querySql, (Object[])new Object[]{Long.valueOf(orgId), billTypeId});){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long org = row.getLong("org");
                String bill = row.getString("billType");
                Integer priority = row.getInteger("fpriority");
                Long fid = row.getLong("fid");
                String messageScenario = row.getString("fmsgscenario");
                if (!messageScenario.contains(msgScenario)) continue;
                if (org != 0L && !StringUtils.isEmpty((CharSequence)bill)) {
                    dataId = fid;
                    break;
                }
                if (!ImageRescanNoticeHelper.checkRuleRight(org, bill, priority) || matchedPriority >= priority) continue;
                matchedPriority = priority;
                dataId = fid;
            }
        }
        if (dataId != null) {
            return BusinessDataServiceHelper.loadSingle(dataId, (String)"bas_rescanremind");
        }
        return null;
    }

    private static boolean checkRuleRight(Long org, String billType, int priority) {
        return org == 0L && StringUtils.isEmpty((CharSequence)billType) && priority == 10 || org == 0L && !StringUtils.isEmpty((CharSequence)billType) && priority == 20 || org != 0L && StringUtils.isEmpty((CharSequence)billType) && priority == 30;
    }

    public static void notice(String imageNo, String reason, String msgScenario, String rescanUser) {
        DynamicObject[] billImageInfos = new BillImageFacade().getMapObjbyImageNo(imageNo);
        if (billImageInfos == null || billImageInfos.length == 0) {
            log.info("\u672a\u627e\u5230" + imageNo + "\u7684\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8bb0\u5f55");
            return;
        }
        DynamicObject billImageInfo = billImageInfos[0];
        String imageNumber = billImageInfo.getString("imagenumber");
        String billNumber = billImageInfo.getString("billnumber");
        String billType = billImageInfo.getString("billtype");
        String orgId = billImageInfo.getString("creatororgid");
        log.info(imageNumber + "\u5bf9\u5e94\u7684\u5355\u636e\u7f16\u53f7\u662f" + billNumber);
        DynamicObject noticeRule = ImageRescanNoticeHelper.matchRule(billType, orgId, msgScenario);
        if (noticeRule == null) {
            return;
        }
        List<Long> userIds = ImageRescanNoticeHelper.targetUsers(noticeRule.getString("messageobject"), billImageInfo);
        if (userIds.size() == 0) {
            log.info("\u672a\u627e\u5230\u901a\u77e5\u5bf9\u8c61\uff0c\u901a\u77e5\u5904\u7406\u7ed3\u675f");
            return;
        }
        String[] message = ImageRescanNoticeHelper.buildMessage(noticeRule.getString("messagetitle"), noticeRule.getString("messagetemplate"), billImageInfo, reason, rescanUser);
        DynamicObjectCollection messageChannels = noticeRule.getDynamicObjectCollection("messagechannel");
        List channelNumberList = messageChannels.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        String notifyType = String.join((CharSequence)",", channelNumberList);
        String messageTitle = message[0];
        String messageContent = message[1];
        ImageRescanNoticeHelper.sendMessage(messageTitle, messageContent, notifyType, userIds);
    }

    private static String[] buildMessage(String titleTemplate, String contentTemplate, DynamicObject billImageInfo, String reason, String rescanUser) {
        ArrayList<Long> userIds = new ArrayList<Long>(2);
        userIds.add(Long.valueOf(rescanUser));
        Long creatorId = billImageInfo.getDynamicObject("creator").getLong("id");
        userIds.add(creatorId);
        DynamicObjectCollection userInfos = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
        String rescanUserName = "";
        String proposerName = "";
        for (DynamicObject user : userInfos) {
            Long userId = user.getLong("id");
            if (String.valueOf(userId).equals(rescanUser)) {
                rescanUserName = user.getString("name");
            }
            if (!userId.equals(creatorId)) continue;
            proposerName = user.getString("name");
        }
        String billNo = billImageInfo.getString("billnumber");
        Date createTime = billImageInfo.getDate("createtime");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String createTimeStr = dateFormat.format(createTime);
        Long orgId = Long.valueOf(billImageInfo.getString("creatororgid"));
        DynamicObject orgInfo = QueryServiceHelper.queryOne((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
        String orgName = orgInfo.getString("name");
        String billType = billImageInfo.getString("billtype");
        DynamicObject billTypeInfo = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billType)});
        String billTypeName = billTypeInfo.getString("name");
        String contentValue = contentTemplate.replace("{proposer}", proposerName).replace("{company}", orgName).replace("{billtype}", billTypeName).replace("{createtime}", createTimeStr).replace("{billno}", billNo).replace("{user}", rescanUserName).replace("{reason}", reason);
        String titleValue = titleTemplate.replace("{proposer}", proposerName).replace("{company}", orgName).replace("{billtype}", billTypeName).replace("{createtime}", createTimeStr).replace("{billno}", billNo).replace("{user}", rescanUserName).replace("{reason}", reason);
        return new String[]{titleValue, contentValue};
    }

    private static List<Long> targetUsers(String messageObjet, DynamicObject billImageInfo) {
        ArrayList<Long> userIdList = new ArrayList<Long>();
        if (messageObjet.contains("0")) {
            userIdList.add(billImageInfo.getDynamicObject("creator").getLong("id"));
        }
        if (messageObjet.contains("1")) {
            DynamicObject scanUser = billImageInfo.getDynamicObject("nextscanuserid");
            if (scanUser == null) {
                log.info("\u626b\u63cf\u5458\u4e3a\u7a7a");
                return userIdList;
            }
            Long scanUserId = scanUser.getLong("id");
            if (scanUserId.equals(1L)) {
                log.info("\u626b\u63cf\u5458\u662fadministrator\uff0c\u4e0d\u901a\u77e5");
                return userIdList;
            }
            if (userIdList.contains(scanUserId)) {
                log.info("\u7533\u8bf7\u4eba\u4e0e\u626b\u63cf\u5458\u662f\u540c\u4e00\u4e2a\u4eba");
                return userIdList;
            }
            userIdList.add(scanUserId);
        }
        return userIdList;
    }

    private static void sendMessage(String title, String content, String notifyType, List<Long> userIds) {
        LocaleString tag = new LocaleString();
        tag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u901a\u77e5", (String)"ImageExpireRemindTask_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        messageInfo.setMessageContent((ILocaleString)new LocaleString(content));
        messageInfo.setUserIds(userIds);
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setType("message");
        messageInfo.setMessageTag((ILocaleString)tag);
        messageInfo.setNotifyType(notifyType);
        Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        log.info("\u6d88\u606f\u5199\u5165\u5de5\u4f5c\u6d41\u961f\u5217\uff0cmsgId = " + msgId);
    }
}

