/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import com.alibaba.fastjson.JSONObject;
import com.siit.image.wscommon.tools.Encryptions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class NoticeImageSysHelper_NGXHC
extends NoticeImageSysHelper {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String STARTFLOW_URL = "/siitservice/startFlow/addFlow";
    private static final String IMAGE_URL = "/siitservice/createImagePathApi/createImagePath";
    private static final String SCAN_URL = "/siitservice/login/createLoginPoint";
    private static final String REJECT_URL = "/siitservice/reScanApi/rescan";
    private static final String DELETE_URL = "/siitservice/todeleteApi/deleteBill";
    private static final String CLIENTCODE = "JDCQY";
    private static final String ISV = "KINGDEE";
    private static final String DATASOURCE = "cosmic";
    private static final String FORMTYPE = "BILLCODE";
    public final String symbol = "NGXHC";
    private static final Log log = LogFactory.getLog(NoticeImageSysHelper_NGXHC.class);

    @Override
    public String startWorkFlow(NoticeImageSysStartWorkFlow startWorkFlow) throws Exception {
        String username = this.get2NameById(startWorkFlow.getUserId()).get("username");
        JSONObject jsonObject = this.buildSafety(startWorkFlow.getBarCode(), username);
        JSONObject startWorkFlowParams = this.buildStartWorkFlowParams(jsonObject, startWorkFlow);
        ImageSysInfo imageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        String url = imageSysInfo.getImageUrl();
        String requestUrl = url + STARTFLOW_URL;
        String startFlowJsonString = startWorkFlowParams.toJSONString();
        log.info("requestUrl:" + requestUrl + ",startFlowJsonString" + startFlowJsonString);
        String responseData = SSCImageUtils.sendHttpsRequestByPost(requestUrl, startFlowJsonString);
        log.info("responseData:" + responseData);
        JSONObject responseJsonObject = JSONObject.parseObject((String)responseData);
        boolean status = responseJsonObject.getBooleanValue("status");
        if (status) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fd\u4fe1\u5408\u6210\u89e6\u53d1\u5355\u636e\u626b\u63cf\u6d41\u7a0b\u63a5\u53e3\u5931\u8d25\uff0cerrorCode\uff1a%1$s\uff0cerrorMessage\uff1a%2$s", (String)"NoticeImageSysHelper_NGXHC_0", (String)"bos-image-formplugin", (Object[])new Object[0]), responseJsonObject.get((Object)"errorCode"), responseJsonObject.get((Object)"errorMessage")));
    }

    private JSONObject buildStartWorkFlowParams(JSONObject jsonObject, NoticeImageSysStartWorkFlow startWorkFlow) {
        JSONObject param = new JSONObject();
        String orgId = startWorkFlow.getOrgId();
        DynamicObject orgDynObj = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"number");
        String number = orgDynObj == null ? "" : orgDynObj.getString("number");
        param.put("formtype", (Object)FORMTYPE);
        param.put("datasource", (Object)DATASOURCE);
        param.put("barcode", (Object)startWorkFlow.getBarCode());
        param.put("billcode", (Object)startWorkFlow.getBillNumber());
        param.put("busstype", (Object)startWorkFlow.getBilltype());
        param.put("busscode", (Object)startWorkFlow.getBilltype());
        param.put("operatorname", (Object)startWorkFlow.getUsername());
        param.put("operatoruser", (Object)this.get2NameById(startWorkFlow.getUserId()).get("username"));
        param.put("companycode", (Object)number);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        param.put("subbilltime", (Object)sdf.format(new Date()));
        jsonObject.put("params", (Object)param);
        return jsonObject;
    }

    @Override
    public String getScanHomeUrl(NoticeImageSys2getScanHomeInfo scanHomeInfo) throws Exception {
        String userId = RequestContext.get().getUserId();
        String username = this.get2NameById(userId).get("username");
        JSONObject jsonObject = this.buildSafety("", username);
        JSONObject scanPageParams = this.buildScanPageParams(jsonObject, userId);
        String url = SSCImageUtils.getEnableImageSysInfo().getImageUrl();
        String requestUrl = url + SCAN_URL;
        String scanPageParamsJsonString = scanPageParams.toJSONString();
        log.info("requestUrl:" + requestUrl + ",scanPageParamsJsonString" + scanPageParamsJsonString);
        String responseData = SSCImageUtils.sendHttpsRequestByPost(requestUrl, scanPageParamsJsonString);
        log.info("responseData:" + responseData);
        JSONObject responseJsonObject = JSONObject.parseObject((String)responseData);
        boolean status = responseJsonObject.getBooleanValue("status");
        if (status) {
            return responseJsonObject.getString("data");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u5f97\u5f71\u50cf\u626b\u63cf\u5730\u5740\u5931\u8d25\uff0cerrorCode\uff1a%1$s\uff0cerrorMessage\uff1a%2$s", (String)"NoticeImageSysHelper_NGXHC_1", (String)"bos-image-formplugin", (Object[])new Object[0]), responseJsonObject.get((Object)"errorCode"), responseJsonObject.get((Object)"errorMessage")));
    }

    private JSONObject buildScanPageParams(JSONObject jsonObject, String userId) {
        JSONObject param = new JSONObject();
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user", (String)"phone,username");
        String phone = userObject.getString("phone");
        param.put("phone", (Object)(phone == null ? "" : phone));
        param.put("useraccount", (Object)userObject.getString("username"));
        jsonObject.put("params", (Object)param);
        return jsonObject;
    }

    @Override
    public String rescan(NoticeImageSys2RescanInfo rescanInfo) throws Exception {
        String username = this.get2NameById(rescanInfo.getRescanPerson() + "").get("username");
        JSONObject jsonObject = this.buildSafety(rescanInfo.getBarCode(), username);
        JSONObject rescanParams = this.buildRescanParams(jsonObject, rescanInfo);
        String url = SSCImageUtils.getEnableImageSysInfo().getImageUrl();
        String requestUrl = url + REJECT_URL;
        String rescanParamsJsonString = rescanParams.toJSONString();
        log.info("requestUrl:" + requestUrl + ",rescanParamsJsonString" + rescanParamsJsonString);
        String responseData = SSCImageUtils.sendHttpsRequestByPost(requestUrl, rescanParamsJsonString);
        log.info("responseData:" + responseData);
        JSONObject responseJsonObject = JSONObject.parseObject((String)responseData);
        boolean status = responseJsonObject.getBooleanValue("status");
        if (status) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fd\u4fe1\u9000\u56de\u91cd\u626b\u5f71\u50cf\u5931\u8d25\uff1aerrorCode\uff1a%1$s\uff0cerrorMessage\uff1a%2$s", (String)"NoticeImageSysHelper_NGXHC_2", (String)"bos-image-formplugin", (Object[])new Object[0]), responseJsonObject.get((Object)"errorCode"), responseJsonObject.get((Object)"errorMessage")));
    }

    private JSONObject buildRescanParams(JSONObject jsonObject, NoticeImageSys2RescanInfo rescanInfo) {
        JSONObject param = new JSONObject();
        param.put("barcode", (Object)rescanInfo.getBarCode());
        param.put("operatoruser", (Object)this.get2NameById(RequestContext.get().getUserId()).get("username"));
        param.put("operatorname", (Object)RequestContext.get().getUserName());
        param.put("reason", (Object)rescanInfo.getRescanMessage());
        param.put("remark", (Object)rescanInfo.getRescanMessage());
        jsonObject.put("params", (Object)param);
        return jsonObject;
    }

    @Override
    public String cancelRescan(NoticeImageSysCancelRescanInfo cancelRescanInfo) throws Exception {
        throw new KDBizException(ResManager.loadKDString((String)"\u56fd\u4fe1\u5408\u6210\u5f71\u50cf\u7cfb\u7edf\u4e0d\u652f\u6301\u53d6\u6d88\u5f71\u50cf\u9000\u56de\u91cd\u626b\uff01", (String)"NoticeImageSysHelper_GXHC_4", (String)"bos-image-formplugin", (Object[])new Object[0]));
    }

    @Override
    public String viewPhoto(NoticeImageSysViewInfo viewPhotoInfo) throws Exception {
        String username = this.get2NameById(viewPhotoInfo.getViewPersonId()).get("username");
        JSONObject jsonObject = this.buildSafety(viewPhotoInfo.getBarCode(), username);
        JSONObject viewPhotoParams = this.buildViewPhotoParams(jsonObject, viewPhotoInfo);
        String url = SSCImageUtils.getEnableImageSysInfo().getImageUrl();
        String requestUrl = url + IMAGE_URL;
        String viewPhotoParamsJsonString = viewPhotoParams.toJSONString();
        log.info("requestUrl:" + requestUrl + ",rescanParamsJsonString" + viewPhotoParamsJsonString);
        String responseData = SSCImageUtils.sendHttpsRequestByPost(requestUrl, viewPhotoParamsJsonString);
        log.info("responseData:" + responseData);
        JSONObject responseJsonObject = JSONObject.parseObject((String)responseData);
        boolean status = responseJsonObject.getBooleanValue("status");
        if (status) {
            return responseJsonObject.getString("data");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u5f97\u5f71\u50cf\u8c03\u9605\u5730\u5740\u5931\u8d25\uff0cerrorCode\uff1a%1$s\uff0cerrorMessage\uff1a%2$s", (String)"NoticeImageSysHelper_NGXHC_3", (String)"bos-image-formplugin", (Object[])new Object[0]), responseJsonObject.get((Object)"errorCode"), responseJsonObject.get((Object)"errorMessage")));
    }

    private JSONObject buildViewPhotoParams(JSONObject jsonObject, NoticeImageSysViewInfo viewPhotoInfo) {
        JSONObject param = new JSONObject();
        param.put("barcode", (Object)viewPhotoInfo.getBarCode());
        param.put("useraccount", (Object)this.get2NameById(viewPhotoInfo.getViewPersonId()).get("username"));
        jsonObject.put("params", (Object)param);
        return jsonObject;
    }

    @Override
    public String viewPhotoOnPhone() throws Exception {
        return null;
    }

    @Override
    public String viewPhotos() throws Exception {
        return null;
    }

    @Override
    public String viewPhotosOnPhone() throws Exception {
        return null;
    }

    @Override
    public String imageUpload() throws Exception {
        return null;
    }

    @Override
    public String synVoucherInfo() throws Exception {
        return null;
    }

    @Override
    public String deleteImage() throws Exception {
        return "1";
    }

    @Override
    public String destroyImage(NoticeImageSysDestroyInfo destroyInfo) throws Exception {
        String username = this.get2NameById(destroyInfo.getUseraccount()).get("username");
        JSONObject jsonObject = this.buildSafety(destroyInfo.getImageNo(), username);
        JSONObject destroyParams = this.buildDestroyParams(jsonObject, destroyInfo);
        String url = SSCImageUtils.getEnableImageSysInfo().getImageUrl();
        String requestUrl = url + DELETE_URL;
        String destroyParamsJsonString = destroyParams.toJSONString();
        log.info("requestUrl:" + requestUrl + ",rescanParamsJsonString" + destroyParamsJsonString);
        String responseData = SSCImageUtils.sendHttpsRequestByPost(requestUrl, destroyParamsJsonString);
        log.info("responseData:" + responseData);
        JSONObject responseJsonObject = JSONObject.parseObject((String)responseData);
        boolean status = responseJsonObject.getBooleanValue("status");
        if (status) {
            return "1";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u56fd\u4fe1\u5220\u9664\u5f71\u50cf\u5931\u8d25\uff0cerrorCode\uff1a%1$s\uff0cerrorMessage\uff1a%2$s", (String)"NoticeImageSysHelper_NGXHC_4", (String)"bos-image-formplugin", (Object[])new Object[0]), responseJsonObject.get((Object)"errorCode"), responseJsonObject.get((Object)"errorMessage")));
    }

    private JSONObject buildDestroyParams(JSONObject jsonObject, NoticeImageSysDestroyInfo destroyInfo) {
        JSONObject param = new JSONObject();
        param.put("barcode", (Object)destroyInfo.getImageNo());
        param.put("operatoruser", (Object)this.get2NameById(RequestContext.get().getUserId()).get("username"));
        param.put("reason", (Object)destroyInfo.getMessage());
        param.put("deletetype", (Object)"2");
        jsonObject.put("params", (Object)param);
        return jsonObject;
    }

    @Override
    public String submit2ImageSys() throws Exception {
        return null;
    }

    private JSONObject buildSafety(String imageNumber, String username) {
        JSONObject param = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date cur = new Date();
        String time = sdf.format(cur);
        JSONObject safety = new JSONObject();
        safety.put("time", (Object)time);
        safety.put("barcode", (Object)imageNumber);
        safety.put("useraccount", (Object)username);
        safety.put("clientcode", (Object)CLIENTCODE);
        String ticket = time + CLIENTCODE + imageNumber + username + ISV;
        safety.put("ticket", (Object)Encryptions.getMD5str((String)ticket));
        param.put("safety", (Object)safety);
        return param;
    }

    private Map<String, String> get2NameById(String id) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(id));
        String fields = "username,name";
        DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)fields, (QFilter[])new QFilter[]{filter});
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (user != null) {
            map.put("username", user.getString("username"));
            map.put("name", user.getString("name"));
        }
        return map;
    }
}

