/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.helper;

import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import com.siit.image.wscommon.tools.Encryptions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.image.util.ImageParamsUtils;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.pojo.ParamsSiit;
import kd.bos.imageplatform.pojo.Service_CreateImagePath;
import kd.bos.imageplatform.pojo.Service_RejectBill;
import kd.bos.imageplatform.pojo.Service_Rescan;
import kd.bos.imageplatform.pojo.Service_StartWorkFlow;

public class SiitParamsHelper {
    public ParamsSiit buildCreateImagePathParams(NoticeImageSysViewInfo nisv) {
        String imageNumber = nisv.getBarCode();
        String userId = nisv.getViewPersonId();
        String isEdit = nisv.getType();
        ParamsSiit params = new ParamsSiit();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("createImagePath", this.buildCreateImagePathSerivce(imageNumber, userId, isEdit)));
        return params;
    }

    private Service_CreateImagePath buildCreateImagePathSerivce(String barcode, String userId, String isEdit) {
        Service_CreateImagePath createImagePath = new Service_CreateImagePath();
        createImagePath.setEvaluation(isEdit);
        createImagePath.setServiceid("1");
        createImagePath.setBarcode(barcode);
        createImagePath.setType("1");
        createImagePath.setUseraccount(StringUtils.isNotBlank((CharSequence)userId) ? userId : "zhangsan");
        return createImagePath;
    }

    public ParamsSiit buildStartWorkFlowParams(NoticeImageSysStartWorkFlow startWorkFlow) {
        ParamsSiit params = new ParamsSiit();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("startWorkFlow", this.buildStartWorkFlow(startWorkFlow)));
        return params;
    }

    private Service_StartWorkFlow buildStartWorkFlow(NoticeImageSysStartWorkFlow niss) {
        Service_StartWorkFlow startWorkFlow = new Service_StartWorkFlow();
        startWorkFlow.setServiceid("1");
        startWorkFlow.setBarcode(niss.getBarCode());
        startWorkFlow.setBranchcode(niss.getOrgId());
        startWorkFlow.setUsername(niss.getUsername());
        startWorkFlow.setUseraccount(niss.getUserId());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String time = df.format(new Date());
        startWorkFlow.setBilldate(time);
        startWorkFlow.setBillcode(niss.getBillNumber());
        startWorkFlow.setBilltype(niss.getBilltype());
        return startWorkFlow;
    }

    public ParamsSiit buildRescanParams(NoticeImageSys2RescanInfo rescanInfo) {
        ParamsSiit params = new ParamsSiit();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("startRescanFlow", this.buildRescan(rescanInfo)));
        return params;
    }

    private Service_Rescan buildRescan(NoticeImageSys2RescanInfo rescanInfo) {
        Service_Rescan rescan = new Service_Rescan();
        rescan.setServiceid("1");
        rescan.setBarcode(rescanInfo.getBarCode());
        rescan.setUseraccount(String.valueOf(rescanInfo.getRescanPerson()));
        rescan.setRemark(rescanInfo.getRescanMessage());
        rescan.setScantype("0");
        return rescan;
    }

    public ParamsSiit buildRejectBillParams(NoticeImageSysDestroyInfo destroyInfo) {
        ParamsSiit params = new ParamsSiit();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("rejectBill", this.builDrejectBill(destroyInfo)));
        return params;
    }

    public ParamsSiit buildDeleteImageParams(NoticeImageSysDestroyInfo destroyInfo) {
        ParamsSiit params = new ParamsSiit();
        params.setSafety(this.buildSafetySiit());
        params.setServerbody(this.buildServerBody("deleteBarcode", this.builDdeleteImage(destroyInfo)));
        return params;
    }

    private Service_RejectBill builDrejectBill(NoticeImageSysDestroyInfo destroyInfo) {
        Service_RejectBill rejectBill = new Service_RejectBill();
        rejectBill.setServiceid("1");
        rejectBill.setBarcode(destroyInfo.getImageNo());
        rejectBill.setType("1");
        rejectBill.setUseraccount(ImageParamsUtils.getValue("GXUACCOUNT"));
        rejectBill.setUsername(destroyInfo.getUsername());
        rejectBill.setRemark(destroyInfo.getMessage());
        rejectBill.setBilltype("1");
        rejectBill.setOptype("2");
        return rejectBill;
    }

    private Service_RejectBill builDdeleteImage(NoticeImageSysDestroyInfo destroyInfo) {
        Service_RejectBill deleteBill = new Service_RejectBill();
        deleteBill.setServiceid("1");
        deleteBill.setBarcode(destroyInfo.getImageNo());
        deleteBill.setType("1");
        deleteBill.setUseraccount(ImageParamsUtils.getValue("GXUACCOUNT"));
        deleteBill.setUsername(destroyInfo.getUsername());
        deleteBill.setRemark(destroyInfo.getMessage());
        return deleteBill;
    }

    private Safety buildSafetySiit() {
        Safety safety = new Safety();
        safety.setClientcode("JDCQY");
        safety.setServicecode("ImageCenter");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = df.format(new Date());
        String symbol = "KINGDEE";
        safety.setTicket(Encryptions.getMD5str((String)(time + "ImageCenterJDCQY" + symbol)));
        safety.setTime(time);
        return safety;
    }

    private Serverbody buildServerBody(String methodName, Service service) {
        Serverbody serverbody = new Serverbody();
        serverbody.setServername(methodName);
        serverbody.setServertype("1");
        serverbody.setServices(this.buildServices(service));
        return serverbody;
    }

    private List<Service> buildServices(Service service) {
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(service);
        return services;
    }
}

