/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.pojo;

import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.obj.base.Safety;
import com.siit.image.wscommon.obj.base.Serverbody;
import com.siit.image.wscommon.obj.base.Service;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class ParamsSiit
extends Params {
    private static final Log log = LogFactory.getLog(ParamsSiit.class);

    public String toString() {
        String tmp = ((Object)((Object)this)).getClass().getName() + ":{";
        try {
            tmp = tmp + this.toXml() + "}";
        }
        catch (Exception e) {
            log.error("ParamsSiit.toXml()\u62a5\u9519 :" + e.getMessage() + "\n" + Arrays.toString(e.getStackTrace()));
        }
        return tmp;
    }

    public String toXml() throws Exception {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("params");
        Element safetyElement = root.addElement("safety");
        Safety safety = this.getSafety();
        safetyElement.addElement("clientcode").setText(safety.getClientcode());
        safetyElement.addElement("servicecode").setText(safety.getServicecode());
        safetyElement.addElement("time").setText(safety.getTime());
        safetyElement.addElement("ticket").setText(safety.getTicket());
        Element serverbodyElement = root.addElement("serverbody");
        Serverbody serverbody = this.getServerbody();
        serverbodyElement.addElement("servername").setText(serverbody.getServername());
        serverbodyElement.addElement("servertype").setText(serverbody.getServertype());
        Element servicesElement = serverbodyElement.addElement("services");
        List serviceList = serverbody.getServices();
        this.reflectXml(servicesElement, serviceList);
        OutputFormat format = OutputFormat.createCompactFormat();
        StringWriter writer = new StringWriter();
        XMLWriter output = new XMLWriter((Writer)writer, format);
        try {
            output.write(doc);
            writer.close();
            output.close();
        }
        catch (IOException e) {
            log.error("\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IOException\u5f02\u5e38!\u629b\u51fa,\u4e0d\u8f93\u51fa\u6808\u5806.\u5f02\u5e38\u4fe1\u606f:" + e);
            throw e;
        }
        return writer.toString();
    }

    private void reflectXml(Element servernameElement, List<Service> serviceList) {
        if (serviceList == null || serviceList.size() <= 0) {
            return;
        }
        for (Service service : serviceList) {
            Element serviceElement = servernameElement.addElement("service");
            try {
                this.addFields(service, serviceElement);
            }
            catch (SecurityException e) {
                log.error("\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570SecurityException\u5f02\u5e38,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error("\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IllegalArgumentException\u5f02\u5e38,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            }
        }
    }

    private void addFields(Object obj, Element element) {
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            ReflectionUtils.makeAccessible((Field)field);
            String fieldName = field.getName();
            if (field.isSynthetic()) continue;
            Object fieldValue = null;
            try {
                fieldValue = field.get(obj);
            }
            catch (IllegalArgumentException e) {
                log.error("\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IllegalAccessException\u5f02\u5e38--\u4e0d\u53ef\u8bbf\u95ee,\u4e0d\u7ec4\u6210xml\u7684\u5185\u5bb9,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("\u56fd\u4fe1\u8f6c\u6362\u53c2\u6570IllegalAccessException\u5f02\u5e38,\u5403\u6389,\u7b80\u5355\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f:", (Throwable)e);
            }
            if (fieldValue != null) {
                Class<?> tempClass = fieldValue.getClass();
                Element tempEle = element.addElement(fieldName);
                if (this.isCdataType(tempClass)) {
                    tempEle.setText(fieldValue.toString());
                    continue;
                }
                if (fieldValue instanceof Iterable) {
                    Method getChildName = null;
                    String childName = fieldName.substring(0, fieldName.length() - 1);
                    try {
                        getChildName = tempClass.getMethod("getChildName", new Class[0]);
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    if (getChildName != null) {
                        try {
                            childName = getChildName.invoke(fieldValue, new Object[0]).toString();
                        }
                        catch (Exception e) {
                            log.error((Throwable)e);
                        }
                    }
                    Iterable itAble = (Iterable)fieldValue;
                    for (Object next : itAble) {
                        Element childEle = tempEle.addElement(childName);
                        this.addFields(next, childEle);
                    }
                    continue;
                }
                this.addFields(fieldValue, tempEle);
                continue;
            }
            element.addElement(fieldName).setText("");
        }
    }

    private boolean isCdataType(Class c) {
        if (c.isPrimitive()) {
            return true;
        }
        return c.equals(String.class) || c.equals(Boolean.class) || c.equals(Integer.class) || c.equals(Double.class) || c.equals(Short.class) || c.equals(Long.class) || c.equals(Float.class) || c.equals(Character.class);
    }
}

