/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.imageplatform.util.WorkDateUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class ImageExpireRemindTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ImageExpireRemindTask.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Date START_CALENDAR = new Date(1577808000000L);
    private static final Date START_REMIND_TIME = new Date(1577808000000L);
    private static final long DAY_MILLs = 86400000L;
    private static final String WF_TASK = "wf_task";
    private static final String WF_EXECUTION = "wf_execution";
    private static final String WF_TASK_CATEGORY = "category";
    private static final String WF_EXECUTION_SUSPENSIONSTATE = "suspensionstate";
    private static final String BILL_IMAGE_MAP = "task_billimagemap";
    private static final String ENTER_NODE_TIME = "enternodetime";
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String IMAGE_STATE = "imagestate";
    private static final String CALENDAR_TYPE = "calendartype";
    private static final String EXPIRE_DAY = "expiredday";
    private static final String REMIND_CYCLE = "remindcycle";
    private static final String MESSAGE_TEMPLATE = "messagetemplate";
    private static final String MESSAGE_TITLE = "messagetitle";
    private static final String MESSAGE_CHANNEL = "msgchannelnumber";
    private static final String MESSAGE_OBJECT = "messageobject";
    private static final String PROPOSER = "proposer";
    private static final String COMPANY = "company";
    private static final String BILL_TYPE_NAME = "billTypeName";
    private static final String BILL_NO = "billno";
    private static final String CREATE_TIME = "createTime";
    private static final String TASK_TASK = "task_task";
    private static final String POOL_TYPE = "pooltype";
    private static final String TASK_STATE = "state";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("\u5f71\u50cf\u8d85\u671f\u63d0\u9192\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        DynamicObjectCollection enableImageRemindRule = SSCImageUtils.getEnableImageRemindRule();
        if (enableImageRemindRule == null || enableImageRemindRule.size() == 0) {
            logger.info("\u4e0d\u5b58\u5728\u542f\u7528\u7684\u5f71\u50cf\u8d85\u671f\u63d0\u9192\u89c4\u5219");
            return;
        }
        HashMap<Long, WorkDateUtil> orgWorkCalendarMap = new HashMap<Long, WorkDateUtil>(16);
        HashMap<String, Map<String, String>> remindMap = new HashMap<String, Map<String, String>>(16);
        Map<String, Map<String, String>> wfRemindMap = this.getWfRemindMap(enableImageRemindRule, orgWorkCalendarMap);
        logger.info("\u6784\u5efa\u5b8c\u5de5\u4f5c\u6d41\u4e2d\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9\u9700\u8981\u901a\u77e5\u7684\u5f71\u50cf\u6570\u636e\u65f6\u95f4\uff1a" + System.currentTimeMillis());
        Map<String, Map<String, String>> taskRemindMap = this.getTaskWaitUploadImageRemindMap(enableImageRemindRule, orgWorkCalendarMap);
        Map<String, Map<String, String>> rescanRemindMap = this.rescanRemindMap(enableImageRemindRule, orgWorkCalendarMap);
        remindMap.putAll(wfRemindMap);
        remindMap.putAll(taskRemindMap);
        remindMap.putAll(rescanRemindMap);
        this.expireRemind(remindMap, orgWorkCalendarMap);
        logger.info("\u5b8c\u6210\u5f71\u50cf\u8d85\u671f\u63d0\u9192\u5b9a\u65f6\u4efb\u52a1\u65f6\u95f4\uff1a" + System.currentTimeMillis());
    }

    private Map<String, Map<String, String>> rescanRemindMap(DynamicObjectCollection enableImageRemindRule, Map<Long, WorkDateUtil> orgWorkCalendarMap) {
        Iterator iterator = enableImageRemindRule.iterator();
        while (iterator.hasNext()) {
            DynamicObject remindRule = (DynamicObject)iterator.next();
            String noticeScene = remindRule.getString("noticescene");
            if (noticeScene.contains("2")) continue;
            iterator.remove();
        }
        if (enableImageRemindRule.isEmpty()) {
            logger.info("\u626b\u63cf\u5171\u4eab\u5f71\u50cf\u9000\u626b\u65f6\uff0c\u5339\u914d\u89c4\u5219\u4e2d\u4e0d\u5305\u542b\u9000\u626b\u7684\u89c4\u5219\uff0c\u505c\u6b62\u540e\u7eed\u626b\u63cf\u3002");
        }
        HashMap<String, Map<String, String>> remindMap = new HashMap<String, Map<String, String>>(16);
        QFilter poolTypeFilter = new QFilter(POOL_TYPE, "=", (Object)"1");
        QFilter stateFilter = new QFilter(TASK_STATE, "=", (Object)"2");
        QFilter imageStateFilter = new QFilter(IMAGE_STATE, "in", (Object)new String[]{"3"});
        QFilter modifyTimeFilter = new QFilter("modifytime", ">=", (Object)START_REMIND_TIME);
        try (DataSet taskRows = QueryServiceHelper.queryDataSet((String)"ImageExpireRemindTask_taskWaitUpload", (String)TASK_TASK, (String)"billid,modifytime as taskmodifytime", (QFilter[])new QFilter[]{poolTypeFilter, stateFilter}, null);
             DataSet billImageRows = QueryServiceHelper.queryDataSet((String)"ImageExpireRemindTask_wf_billImageMap", (String)BILL_IMAGE_MAP, (String)"id,billid,billtype,imagenumber,imagestate,billnumber,creatororgid,createtime,creator.name as creatorname,creator.id as creatorid", (QFilter[])new QFilter[]{imageStateFilter, modifyTimeFilter}, null);
             DataSet mainDataRows = taskRows.join(billImageRows).on("billid", "billid").select(new String[]{"billid", "billtype", IMAGE_NUMBER, "taskmodifytime", IMAGE_STATE, "billnumber", "creatororgid", "createtime", "creatorname", "creatorid"}).finish();
             DataSet orgRows = QueryServiceHelper.queryDataSet((String)"bos_org", (String)"bos_org", (String)"TO_CHAR(id) as orgid,name as orgname", null, null);
             DataSet metaRows = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)"number as metanumber,name as metaname", null, null);
             DataSet resultDataSet = mainDataRows.join(orgRows, JoinType.INNER).on("creatororgid", "orgid").select(new String[]{"billid", "billtype", IMAGE_NUMBER, IMAGE_STATE, "billnumber", "creatororgid", "createtime", "creatorname", "taskmodifytime", "orgname", "creatorid"}).finish().join(metaRows).on("billtype", "metanumber").select(new String[]{"billid", "billtype", IMAGE_NUMBER, IMAGE_STATE, "billnumber", "creatororgid", "createtime", "creatorname", "taskmodifytime", "orgname", "metaname", "creatorid"}).finish();){
            Date now = new Date();
            int count = 0;
            while (resultDataSet.hasNext()) {
                Row row = resultDataSet.next();
                String billType = row.getString("billtype");
                String creatorOrgId = row.getString("creatororgid");
                String imageNumber = row.getString(IMAGE_NUMBER);
                String imageState = row.getString(IMAGE_STATE);
                Date taskUpdateTime = row.getDate("taskmodifytime");
                ++count;
                if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)creatorOrgId)) {
                    logger.info(imageNumber + "\uff08\u5171\u4eab\u4efb\u52a1\u5f85\u4e0a\u4f20\u5f71\u50cf\uff09\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868billType\u6216creatorOrgId\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u63d0\u9192");
                    continue;
                }
                DynamicObject remindRule = this.matchRule(billType, creatorOrgId, enableImageRemindRule, imageNumber, imageState);
                if (remindRule == null) continue;
                if (taskUpdateTime == null) {
                    logger.info(imageNumber + "\u672a\u83b7\u53d6\u5230\u5171\u4eab\u4efb\u52a1\u66f4\u65b0\u65f6\u95f4\uff0c\u4e0d\u63d0\u9192");
                    continue;
                }
                Map<String, String> remindMsg = this.calExpireDay(remindRule, taskUpdateTime, orgWorkCalendarMap, imageNumber, creatorOrgId, now);
                if (remindMsg == null) continue;
                remindMsg.put(IMAGE_NUMBER, imageNumber);
                remindMsg.put(BILL_NO, row.getString("billnumber"));
                remindMsg.put(BILL_TYPE_NAME, row.getString("metaname"));
                remindMsg.put(PROPOSER, row.getString("creatorname"));
                remindMsg.put(COMPANY, row.getString("orgname"));
                remindMsg.put(CREATE_TIME, this.dateFormat.format(row.getDate("createtime")));
                remindMsg.put("creatorId", row.getString("creatorid"));
                remindMsg.put(CALENDAR_TYPE, remindRule.getString(CALENDAR_TYPE));
                remindMap.put(imageNumber, remindMsg);
            }
            logger.info("\u5171\u4eab\u4efb\u52a1\u5904\u7406\u4e2d\uff0c\u5f71\u50cf\u9000\u626b\u72b6\u6001\u7684\u4efb\u52a1\u6570\u91cf\u4e3a \uff1a" + count + "\uff0c\u9700\u8981\u63d0\u9192\u7684\u4efb\u52a1\u6570\u91cf\u4e3a \uff1a" + remindMap.size());
        }
        return remindMap;
    }

    /*
     * Exception decompiling
     */
    private Map<String, Map<String, String>> getTaskWaitUploadImageRemindMap(DynamicObjectCollection enableImageRemindRule, Map<Long, WorkDateUtil> orgWorkCalendarMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Map<String, String>> getWfRemindMap(DynamicObjectCollection enableImageRemindRule, Map<Long, WorkDateUtil> orgWorkCalendarMap) {
        HashMap<String, Map<String, String>> remindMap = new HashMap<String, Map<String, String>>(16);
        Map<String, Map<String, Object>> wfBillMap = this.getBillsFromWorkFlow();
        logger.info("\u505c\u7559\u5728\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e2a\u6570\uff1a" + wfBillMap.size());
        QFilter imageStateFilter = new QFilter(IMAGE_STATE, "in", (Object)new String[]{"0", "3"});
        QFilter modifyTimeFilter = new QFilter("modifytime", ">=", (Object)START_REMIND_TIME);
        QFilter billIdFilter = new QFilter("billid", "in", wfBillMap.keySet());
        HashMap<String, Map<String, Object>> noEnterNodeTimeMap = new HashMap<String, Map<String, Object>>(16);
        try (DataSet wfBillImageMapDataSet = QueryServiceHelper.queryDataSet((String)"ImageExpireRemindTask_wf_billImageMap", (String)BILL_IMAGE_MAP, (String)"id,billid,billtype,imagenumber,imagestate,billnumber,creatororgid,createtime,creator.name as creatorname,creator.id as creatorid,enternodetime", (QFilter[])new QFilter[]{imageStateFilter, modifyTimeFilter, billIdFilter}, null);
             DataSet orgRows = QueryServiceHelper.queryDataSet((String)"bos_org", (String)"bos_org", (String)"TO_CHAR(id) as orgid,name as orgname", null, null);
             DataSet metaRows = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)"number as metanumber,name as metaname", null, null);
             DataSet resultDataSet = wfBillImageMapDataSet.join(orgRows, JoinType.INNER).on("creatororgid", "orgid").select(new String[]{"id", "billid", "billtype", IMAGE_NUMBER, IMAGE_STATE, "billnumber", "creatororgid", "createtime", "creatorname", ENTER_NODE_TIME, "orgname", "creatorid"}).finish().join(metaRows, JoinType.INNER).on("billtype", "metanumber").select(new String[]{"id", "billid", "billtype", IMAGE_NUMBER, IMAGE_STATE, "billnumber", "creatororgid", "createtime", "creatorname", ENTER_NODE_TIME, "orgname", "metaname", "creatorid"}).finish();){
            Date now = new Date();
            while (resultDataSet.hasNext()) {
                Map<String, String> remindMsg;
                Row row = resultDataSet.next();
                String billType = row.getString("billtype");
                String billId = row.getString("billid");
                String creatorOrgId = row.getString("creatororgid");
                String imageNumber = row.getString(IMAGE_NUMBER);
                String imageState = row.getString(IMAGE_STATE);
                Date enterNodeTime = row.getDate(ENTER_NODE_TIME);
                if (StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)creatorOrgId)) {
                    logger.info(imageNumber + "\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868billType\u6216creatorOrgId\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u63d0\u9192");
                    continue;
                }
                DynamicObject remindRule = this.matchRule(billType, creatorOrgId, enableImageRemindRule, imageNumber, imageState);
                if (remindRule == null) continue;
                if (enterNodeTime == null) {
                    Map<String, Object> params = wfBillMap.get(billId);
                    if (params != null) {
                        enterNodeTime = (Date)params.get("enterNodeTime");
                        if (enterNodeTime == null) {
                            logger.info(imageNumber + "\u672a\u83b7\u53d6\u5230\u8fdb\u5165\u8282\u70b9\u65f6\u95f4");
                            continue;
                        }
                        noEnterNodeTimeMap.put(billId, params);
                    }
                    logger.info(imageNumber + "\u4ece\u5de5\u4f5c\u6d41\u83b7\u53d6\u5230\u63a5\u5165\u8282\u70b9\u65f6\u95f4 \uff1a" + enterNodeTime);
                }
                if ((remindMsg = this.calExpireDay(remindRule, enterNodeTime, orgWorkCalendarMap, imageNumber, creatorOrgId, now)) == null) continue;
                remindMsg.put(IMAGE_NUMBER, imageNumber);
                remindMsg.put(BILL_NO, row.getString("billnumber"));
                remindMsg.put(BILL_TYPE_NAME, row.getString("metaname"));
                remindMsg.put(PROPOSER, row.getString("creatorname"));
                remindMsg.put(COMPANY, row.getString("orgname"));
                remindMsg.put(CREATE_TIME, this.dateFormat.format(row.getDate("createtime")));
                remindMsg.put("creatorId", row.getString("creatorid"));
                remindMsg.put(CALENDAR_TYPE, remindRule.getString(CALENDAR_TYPE));
                remindMap.put(imageNumber, remindMsg);
            }
            if (!noEnterNodeTimeMap.isEmpty()) {
                this.fixBillImageMapData(noEnterNodeTimeMap);
            }
        }
        return remindMap;
    }

    /*
     * Exception decompiling
     */
    private Map<String, Map<String, Object>> getBillsFromWorkFlow() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fixBillImageMapData(Map<String, Map<String, Object>> noEnterNodeTimeMap) {
        DynamicObject[] billImageMaps;
        Set<String> billIds = noEnterNodeTimeMap.keySet();
        QFilter billIdFilter = new QFilter("billid", "in", billIds);
        for (DynamicObject billImage : billImageMaps = BusinessDataServiceHelper.load((String)BILL_IMAGE_MAP, (String)"id,billid,enternodetime,wfprocessingid", (QFilter[])new QFilter[]{billIdFilter})) {
            String billId = billImage.getString("billid");
            Map<String, Object> params = noEnterNodeTimeMap.get(billId);
            if (params == null) continue;
            billImage.set(ENTER_NODE_TIME, params.get("enterNodeTime"));
            billImage.set("wfprocessingid", params.get("taskId"));
        }
        SaveServiceHelper.save((DynamicObject[])billImageMaps);
    }

    private DynamicObject matchRule(String billType, String creatorOrgId, DynamicObjectCollection remindRules, String imageNumber, String imageState) {
        int priority = 0;
        int index = -1;
        for (int i = 0; i < remindRules.size(); ++i) {
            DynamicObject rule = (DynamicObject)remindRules.get(i);
            String orgId = "0".equals(rule.getString("orgid")) ? null : rule.getString("orgid");
            String billTypeNumber = rule.getString("billtypenumber");
            if (orgId != null && billTypeNumber != null && orgId.equals(creatorOrgId) && billTypeNumber.equals(billType)) {
                index = i;
                priority = 40;
                break;
            }
            if (orgId != null && billTypeNumber == null && orgId.equals(creatorOrgId)) {
                index = i;
                priority = 30;
                continue;
            }
            if (orgId == null && billTypeNumber != null && billTypeNumber.equals(billType) && priority < 20) {
                index = i;
                priority = 20;
                continue;
            }
            if (orgId != null || billTypeNumber != null || priority >= 10) continue;
            index = i;
            priority = 10;
        }
        if (priority == 0) {
            logger.info(imageNumber + "\u672a\u5339\u914d\u5230\u8d85\u671f\u63d0\u9192\u89c4\u5219\uff0c\u4e0d\u63d0\u9192");
            return null;
        }
        DynamicObject remindRule = (DynamicObject)remindRules.get(index);
        Long remindId = remindRule.getLong("id");
        String messageChannel = remindRule.getString(MESSAGE_CHANNEL);
        if (!messageChannel.contains(",")) {
            Set numberList = remindRules.stream().filter(dynamicObject -> dynamicObject.getLong("id") == remindId.longValue()).map(dynamicObject -> dynamicObject.getString(MESSAGE_CHANNEL)).collect(Collectors.toSet());
            boolean joinComplete = false;
            for (String s : numberList) {
                if (!s.contains(",")) continue;
                joinComplete = true;
                break;
            }
            if (!joinComplete) {
                remindRule.set(MESSAGE_CHANNEL, (Object)Strings.join(numberList, (String)","));
            }
        }
        String noticeScene = remindRule.getString("noticescene");
        boolean isMatchState = false;
        if ("0".equals(imageState)) {
            isMatchState = noticeScene.contains("1");
        } else if ("3".equals(imageState)) {
            isMatchState = noticeScene.contains("2");
        }
        if (!isMatchState) {
            logger.info(imageNumber + "\u5f71\u50cf\u72b6\u6001" + imageState + "\u4e0e\u89c4\u5219\u5339\u914d\u4e0d\u4e0a\uff0c\u4e0d\u63d0\u9192");
            return null;
        }
        return remindRule;
    }

    private Map<String, String> calExpireDay(DynamicObject remindRule, Date calDate, Map<Long, WorkDateUtil> orgWorkDateUtilMap, String imageNumber, String orgId, Date now) {
        if (calDate == null) {
            logger.info("calExpireDay() \u8d85\u671f\u8ba1\u7b97\u65e5\u671f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u63d0\u9192");
            return null;
        }
        HashMap<String, String> remindMsg = new HashMap<String, String>(8);
        long expiredDay = remindRule.getLong(EXPIRE_DAY);
        String calendarType = remindRule.getString(CALENDAR_TYPE);
        long currentTimeMills = System.currentTimeMillis();
        String dueDay = null;
        boolean hasExpired = false;
        if ("1".equals(calendarType)) {
            hasExpired = currentTimeMills > expiredDay * 86400000L + calDate.getTime();
            dueDay = (currentTimeMills - calDate.getTime()) / 86400000L + "";
            logger.info(imageNumber + "\u81ea\u7136\u65e5\u5386\u8ba1\u7b97 \uff1a\u8d85\u671f\u5929\u6570\u3010" + dueDay + "\u3011\uff0c\u662f\u5426\u8d85\u671f" + hasExpired);
        } else {
            WorkDateUtil workDateUtil = this.getWorkDateUtil(orgId, orgWorkDateUtilMap);
            if (workDateUtil == null) {
                logger.info(imageNumber + "\u5f71\u50cf\u5bf9\u5e94\u5de5\u4f5c\u65e5\u5386\u7ec4\u7ec7" + orgId + "\u5de5\u4f5c\u65e5\u5386\u4e3a\u7a7a\uff0c\u4e0d\u8ba1\u7b97\u8d85\u671f");
                return null;
            }
            int day = workDateUtil.calWorkDayBetweenDay(calDate, now);
            hasExpired = (long)day >= expiredDay;
            dueDay = String.valueOf(day);
            logger.info(imageNumber + "\u5de5\u4f5c\u65e5\u5386\u7ec4\u7ec7\u3010" + orgId + "\u3011\uff0c\u8d85\u671f" + day + "\u5929\uff0c\u89c4\u5219\u8d85\u671f\u5929\u6570:" + expiredDay + "\uff0c\u662f\u5426\u8d85\u671f " + hasExpired);
        }
        if (!hasExpired) {
            return null;
        }
        remindMsg.put(MESSAGE_TEMPLATE, remindRule.getString(MESSAGE_TEMPLATE));
        remindMsg.put(MESSAGE_TITLE, remindRule.getString(MESSAGE_TITLE));
        remindMsg.put(EXPIRE_DAY, String.valueOf(expiredDay));
        remindMsg.put(MESSAGE_CHANNEL, remindRule.getString(MESSAGE_CHANNEL));
        remindMsg.put(MESSAGE_OBJECT, remindRule.getString(MESSAGE_OBJECT));
        remindMsg.put(REMIND_CYCLE, remindRule.getString(REMIND_CYCLE));
        remindMsg.put(ENTER_NODE_TIME, this.dateFormat.format(calDate));
        remindMsg.put("creatororgid", orgId);
        remindMsg.put("dueDay", dueDay);
        return remindMsg;
    }

    private WorkDateUtil getWorkDateUtil(String orgId, Map<Long, WorkDateUtil> orgWorkDateUtilMap) {
        Long org = Long.valueOf(orgId);
        WorkDateUtil workDateUtil = orgWorkDateUtilMap.get(org);
        if (workDateUtil == null) {
            WorkDateUtil instance = WorkDateUtil.getInstance(org, START_CALENDAR, new Date());
            if (instance != null) {
                orgWorkDateUtilMap.put(org, instance);
                return instance;
            }
            return null;
        }
        return workDateUtil;
    }

    private void expireRemind(Map<String, Map<String, String>> imageRemindMap, Map<Long, WorkDateUtil> orgWorkDateUtilMap) {
        Set<String> imageNumberSet = imageRemindMap.keySet();
        Map<String, DynamicObject> latestRemindTimeMap = SSCImageUtils.getLatestRemindTime(imageNumberSet);
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bas_imageremindrecord");
        ArrayList<DynamicObject> saveRecordList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updateRecordList = new ArrayList<DynamicObject>(16);
        Date now = new Date();
        for (Map.Entry<String, Map<String, String>> entry : imageRemindMap.entrySet()) {
            String imageNumber = entry.getKey();
            DynamicObject remindRecord = latestRemindTimeMap.get(imageNumber);
            Map<String, String> remindMsg = entry.getValue();
            try {
                if (remindRecord == null) {
                    Long msgId = this.sendMessage(remindMsg);
                    remindRecord = new DynamicObject((DynamicObjectType)dt);
                    remindRecord.set(IMAGE_NUMBER, (Object)imageNumber);
                    remindRecord.set("firstremind", (Object)now);
                    remindRecord.set("latestremind", (Object)now);
                    remindRecord.set("messageid", (Object)msgId);
                    saveRecordList.add(remindRecord);
                    logger.info(imageNumber + "\u7b2c\u4e00\u6b21\u63d0\u9192");
                    continue;
                }
                Date latestRemindTime = remindRecord.getDate("latestremind");
                String calendarType = remindMsg.get(CALENDAR_TYPE);
                int cycleDay = Integer.parseInt(remindMsg.get(REMIND_CYCLE));
                boolean remindFlag = false;
                if ("1".equals(calendarType)) {
                    remindFlag = System.currentTimeMillis() > latestRemindTime.getTime() + (long)cycleDay * 86400000L;
                } else {
                    WorkDateUtil workDateUtil = this.getWorkDateUtil(remindMsg.get("creatororgid"), orgWorkDateUtilMap);
                    if (workDateUtil != null) {
                        int day = workDateUtil.calWorkDayBetweenDay(latestRemindTime, now);
                        boolean bl = remindFlag = day >= cycleDay;
                    }
                }
                if (!remindFlag) continue;
                Long msgId = this.sendMessage(remindMsg);
                remindRecord.set("latestremind", (Object)now);
                remindRecord.set("messageid", (Object)msgId);
                updateRecordList.add(remindRecord);
                logger.info(imageNumber + "\u8fbe\u5230\u91cd\u590d\u63d0\u9192\u5468\u671f\uff0c\u8fdb\u884c\u63d0\u9192");
            }
            catch (Exception e) {
                logger.error(imageNumber + "\u6d88\u606f\u63d0\u9192\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveRecordList.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])updateRecordList.toArray(new DynamicObject[0]));
    }

    private Long sendMessage(Map<String, String> remindMsg) {
        MessageInfo messageInfo = new MessageInfo();
        String contentValue = remindMsg.get(MESSAGE_TEMPLATE).replace("{billno}", remindMsg.get(BILL_NO)).replace("{proposer}", remindMsg.get(PROPOSER)).replace("{company}", remindMsg.get(COMPANY)).replace("{billtype}", remindMsg.get(BILL_TYPE_NAME)).replace("{createtime}", remindMsg.get(CREATE_TIME)).replace("{expireday}", remindMsg.get("dueDay"));
        String titleValue = remindMsg.get(MESSAGE_TITLE).replace("{billno}", remindMsg.get(BILL_NO)).replace("{proposer}", remindMsg.get(PROPOSER)).replace("{company}", remindMsg.get(COMPANY)).replace("{billtype}", remindMsg.get(BILL_TYPE_NAME)).replace("{createtime}", remindMsg.get(CREATE_TIME)).replace("{expireday}", remindMsg.get("dueDay"));
        LocaleString content = new LocaleString();
        content.setLocaleValue_zh_CN(titleValue + "\n" + contentValue);
        content.setLocaleValue_zh_TW(titleValue + "\n" + contentValue);
        content.setLocaleValue_en(titleValue + "\n" + contentValue);
        LocaleString title = new LocaleString();
        title.setLocaleValue_zh_CN(titleValue);
        title.setLocaleValue_zh_TW(titleValue);
        title.setLocaleValue_en(titleValue);
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(Long.valueOf(remindMsg.get("creatorId")));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u901a\u77e5", (String)"ImageExpireRemindTask_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(receivers);
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setType("message");
        messageInfo.setMessageTag((ILocaleString)tag);
        String notifyType = remindMsg.get(MESSAGE_CHANNEL);
        logger.info("\u901a\u77e5\u6e20\u9053\u7c7b\u578b\uff1a" + notifyType);
        messageInfo.setNotifyType(notifyType);
        Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        return msgId;
    }
}

