/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.service;

import com.alibaba.fastjson.JSONObject;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.image.api.ImageService;
import kd.bos.image.dto.ImageStatusSynMessage;
import kd.bos.image.enums.ImageQueryTypeEnum;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.image.pojo.NoticeImageInfo;
import kd.bos.image.pojo.ViewImageVo;
import kd.bos.imageplatform.common.Dom4jUtil;
import kd.bos.imageplatform.common.ISSCXMLTrans;
import kd.bos.imageplatform.common.ImageOperaionEnum;
import kd.bos.imageplatform.common.ImageSysEnum;
import kd.bos.imageplatform.common.SSCXMLTrans;
import kd.bos.imageplatform.helper.ImageRescanNoticeHelper;
import kd.bos.imageplatform.helper.NoticeImageSysFactory;
import kd.bos.imageplatform.helper.NoticeImageSysHelper;
import kd.bos.imageplatform.pojo.BaseImageInfo;
import kd.bos.imageplatform.pojo.BaseImageList;
import kd.bos.imageplatform.pojo.FpySendImageInfo;
import kd.bos.imageplatform.pojo.ImageReturnCode;
import kd.bos.imageplatform.pojo.ImageStateParamInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSys2getScanHomeInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysCancelRescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysStartWorkFlow;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.pojo.ReceiveImageInfo;
import kd.bos.imageplatform.pojo.SendImageInfo;
import kd.bos.imageplatform.util.BillImageFacade;
import kd.bos.imageplatform.util.SSCImageHandler;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.imageplatform.util.TaskInterUtils;
import kd.bos.invoice.util.InvoiceUtil;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.JSONUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ImageServiceImpl
implements ImageService {
    private static final Log log = LogFactory.getLog(ImageServiceImpl.class);
    public static final String NEEDIMAGESCAN = "needimagescan";
    public static final String ID_ISGEN_BILLTYPE_FBASEDATA_ID_ORG_FBASEDATA_ID = "id,isgen,billtype.FBasedataId,org.FBasedataId,imageprefix,israndom";
    public static final String ISGEN = "isgen";
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)ImageServiceImpl.class.getName(), (int)1);
    private static ISSCXMLTrans xmlTrans = null;
    private static final String DISCARD_STATE = "5";
    private static final String[] LEGAL_STATUS = new String[]{"0", "2", "3", "4"};
    private static final String NEW_FLOW_IMAGE_UPDATE = "KDflow_ImageUpdate(IERP-EAS)";
    private static final String OLD_FLOW_IMAGE_UPDATE = "BILLIMAGEMAP_EAS_UPDATE";
    private static final String NEW_FLOW_IMAGE_DELETE = "KDflow_ImageDelete(IERP-EAS)";
    private static final String OLD_FLOW_IMAGE_DELETE = "BILLIMAGEMAP_EAS_DELETE";
    private static final String GL_VOUCHER = "gl_voucher";
    private static final String LOCK_PREFIX = "/bos/image/imageReady/";
    private static final String ERP_SYNC_IMAGE_LOCK = "/bos/image/syncImage/";
    public static final String SUCCESS = "1";
    public static final String FAIL = "0";

    public ImageServiceImpl() {
        if (null == xmlTrans) {
            xmlTrans = new SSCXMLTrans();
        }
    }

    public boolean startWorkFlow(String ImageNumber, String orgId, String username, String userId, String billNumber, String billtype) {
        NoticeImageSysHelper instance = null;
        try {
            instance = NoticeImageSysFactory.getInstance();
        }
        catch (Exception e) {
            return true;
        }
        try {
            NoticeImageSysStartWorkFlow startWorkFlow = new NoticeImageSysStartWorkFlow();
            startWorkFlow.setBarCode(ImageNumber);
            startWorkFlow.setOrgId(orgId);
            startWorkFlow.setBillNumber(billNumber);
            startWorkFlow.setUserId(userId);
            startWorkFlow.setUsername(username);
            startWorkFlow.setBilltype(billtype);
            String result = SUCCESS;
            if (instance != null) {
                result = instance.startWorkFlow(startWorkFlow);
            }
            if (!result.equals(SUCCESS)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u5f71\u50cf\u89e6\u53d1\u4ee3\u529e\u51fa\u9519\uff0c\u539f\u56e0\uff1a%1$s", (String)"ImageServiceImpl_14", (String)"bos-image-formplugin", (Object[])new Object[0]), result));
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u5f85\u529e\u4efb\u52a1\u5931\u8d25:" + ImageNumber + e.getMessage(), (Throwable)e);
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setImageNo(ImageNumber);
            imageInfo.setBillData(e.getMessage());
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.PUSH);
            return false;
        }
        return true;
    }

    public String getScanHomeUrl(String personId, String scanLocation, boolean allowShowAnnotation, boolean allowHideMask, boolean allowEditAnnotationMask, String language) {
        String url = null;
        NoticeImageSys2getScanHomeInfo scanHomeInfo = new NoticeImageSys2getScanHomeInfo();
        scanHomeInfo.setPersonId(personId);
        scanHomeInfo.setScanLocation(scanLocation);
        scanHomeInfo.setAllowShowAnnotation(allowShowAnnotation);
        scanHomeInfo.setAllowHideMask(allowHideMask);
        scanHomeInfo.setAllowEditAnnotationMask(allowEditAnnotationMask);
        scanHomeInfo.setLanguage(language);
        try {
            url = NoticeImageSysFactory.getInstance().getScanHomeUrl(scanHomeInfo);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u626b\u63cf\u9996\u9875\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5f71\u50cf\u914d\u7f6e\u662f\u5426\u6b63\u786e:\u62a5\u9519\u4fe1\u606f:" + e.getMessage());
            throw new KDException(e.getMessage());
        }
        return url;
    }

    public String getImageInfo(String inputXml) {
        inputXml = inputXml.trim().replaceAll("\t|\r|\n", "");
        log.info("getImageInfo\u65b9\u6cd5-start\uff1a" + inputXml);
        BaseImageList baseList = Dom4jUtil.getImageList(inputXml, BaseImageInfo.class);
        BaseImageList newList = new BaseImageList();
        SSCImageHandler imageHandler = new SSCImageHandler();
        List<BaseImageInfo> imageList = baseList.getImageList();
        if (imageList == null || imageList.size() == 0) {
            return xmlTrans.bulidXml(newList);
        }
        boolean isFPY = SUCCESS.equals(imageList.get(0).getIsFPY());
        HashSet<String> imageNoSet = new HashSet<String>(16);
        for (BaseImageInfo imageInfo : imageList) {
            imageNoSet.add(imageInfo.getImageNo());
        }
        HashMap<String, DynamicObject> imageInfoInsideBatch = this.getImageInfoInsideBatchByNo(imageNoSet);
        for (String imageNo : imageNoSet) {
            DynamicObject mapObj = imageInfoInsideBatch.get(imageNo);
            if (mapObj != null) {
                SendImageInfo imageInfo;
                if (!isFPY) {
                    imageInfo = imageHandler.getImageInfo(mapObj);
                    this.transferredXml(imageInfo);
                    newList.addImageList(imageInfo);
                    continue;
                }
                imageInfo = imageHandler.getImageInfo(mapObj);
                FpySendImageInfo fpySendImageInfo = new FpySendImageInfo();
                ImageServiceImpl.copy(imageInfo, fpySendImageInfo);
                fpySendImageInfo.setApplierUserName(imageInfo.getApplier());
                QFilter filter = new QFilter("number", "=", (Object)imageInfo.getBilltype());
                DynamicObject billTypeObj = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"name", (QFilter[])new QFilter[]{filter});
                fpySendImageInfo.setBillTypeName(Optional.ofNullable(billTypeObj).map(obj -> obj.getString("name")).orElse(""));
                DynamicObject orgDynObj = BusinessDataServiceHelper.loadSingle((Object)mapObj.getString("creatororgid"), (String)"bos_org", (String)"name,number");
                fpySendImageInfo.setApplierCompany(Optional.ofNullable(orgDynObj).map(obj -> obj.getString("name")).orElse(""));
                fpySendImageInfo.setApplierCompanyNum(Optional.ofNullable(orgDynObj).map(obj -> obj.getString("number")).orElse(""));
                this.transferredXml(fpySendImageInfo);
                newList.addImageList(fpySendImageInfo);
                continue;
            }
            SendImageInfo sendImageInfo = new SendImageInfo();
            sendImageInfo.setImageNo(this.escapeXMLSpecialChar(imageNo));
            sendImageInfo.setSelfCreated(String.valueOf(Boolean.FALSE));
            newList.addImageList(sendImageInfo);
        }
        return xmlTrans.bulidXml(newList);
    }

    private HashMap<String, DynamicObject> getImageInfoInsideBatchByNo(Set<String> imageNoSet) {
        HashMap<String, DynamicObject> imageInfoMap = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("imagenumber", "in", imageNoSet);
        DynamicObjectCollection imageInfoCollection = QueryServiceHelper.query((String)"task_billimagemap", (String)"id,billid,billtype,imagenumber,billnumber,scanuserid,imagestate,creator,wfprocessingid,creatororgid,createbyxh", (QFilter[])new QFilter[]{filter});
        if (imageInfoCollection == null || imageInfoCollection.size() == 0) {
            return imageInfoMap;
        }
        for (DynamicObject imageInfo : imageInfoCollection) {
            imageInfoMap.put(imageInfo.getString("imagenumber"), imageInfo);
        }
        return imageInfoMap;
    }

    public Map<String, ImageInfo> getImageInfoInsideBatch(List<String> idsOrNumbers, String field) {
        QFilter[] qFilters;
        QFilter filter;
        HashMap<String, ImageInfo> imageInfoMap = new HashMap<String, ImageInfo>(16);
        DynamicObject[] imageResult = null;
        String resultkey = field;
        if (idsOrNumbers.isEmpty()) {
            return null;
        }
        if (ImageQueryTypeEnum.BillId.getField().equals(field)) {
            filter = new QFilter("billid", "in", idsOrNumbers);
            qFilters = new QFilter[]{filter};
            imageResult = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])qFilters);
            if (imageResult == null) {
                return null;
            }
        } else if (ImageQueryTypeEnum.ImageNumber.getField().equals(field)) {
            filter = new QFilter("imagenumber", "in", idsOrNumbers);
            qFilters = new QFilter[]{filter};
            imageResult = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])qFilters);
            if (imageResult == null) {
                return null;
            }
        } else if (ImageQueryTypeEnum.BillNumber.getField().equals(field)) {
            filter = new QFilter("billnumber", "in", idsOrNumbers);
            qFilters = new QFilter[]{filter};
            imageResult = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])qFilters);
            if (imageResult == null) {
                return null;
            }
        } else {
            return null;
        }
        for (DynamicObject obj : imageResult) {
            ImageInfo resultImageInfo = new ImageInfo();
            resultImageInfo.setBillId(obj.getString("billid"));
            resultImageInfo.setBillNo(obj.getString("billnumber"));
            resultImageInfo.setBilltype(obj.getString("billtype"));
            resultImageInfo.setCreator(obj.getString("creator"));
            resultImageInfo.setImageNo(obj.getString("imagenumber"));
            resultImageInfo.setOrgId(obj.getString("creatororgid"));
            resultImageInfo.setProcessingId(obj.getString("wfprocessingid"));
            resultImageInfo.setImageState(obj.getString("imagestate"));
            resultImageInfo.setScanclientip(obj.getString("scanclientip"));
            resultImageInfo.setScanuserId(obj.getString("scanuserid"));
            resultImageInfo.setCreatetime(obj.getDate("createtime"));
            resultImageInfo.setImageScan(obj.getString(NEEDIMAGESCAN));
            imageInfoMap.put(obj.getString(resultkey), resultImageInfo);
        }
        return imageInfoMap;
    }

    public String imageReady(String inputXml) {
        inputXml = inputXml.trim().replaceAll("\t|\r|\n", "");
        log.info("\u5f71\u50cf\u5c31\u7eea\uff0c\u5165\u53c2\uff1a" + inputXml);
        BaseImageList baseImageList = xmlTrans.parseXml(inputXml, ReceiveImageInfo.class);
        HashMap<String, ImageInfo> sscParams = new HashMap<String, ImageInfo>(4);
        SSCImageHandler sscImageHandler = new SSCImageHandler();
        BillImageFacade billImageFacade = new BillImageFacade();
        Map<String, DynamicObject> billIdImageNoMap = this.validateImageReadyParam(baseImageList);
        if (billIdImageNoMap == null) {
            return FAIL;
        }
        ArrayList<DynamicObject> needMinusCreditsPointBill = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, DynamicObject> entry : billIdImageNoMap.entrySet()) {
            DynamicObject billImageInfo = entry.getValue();
            String string = billImageInfo.getString("imagestate");
            if (!string.equals(FAIL)) continue;
            needMinusCreditsPointBill.add(billImageInfo);
        }
        sscImageHandler.minusCreditPointsByExpireImage(needMinusCreditsPointBill);
        Map imageNoMap = baseImageList.getImageList().stream().collect(Collectors.toMap(BaseImageInfo::getImageNo, Function.identity()));
        ArrayList<ImageInfo> syncEasList = new ArrayList<ImageInfo>(10);
        for (Map.Entry entry : billIdImageNoMap.entrySet()) {
            String billId = (String)entry.getKey();
            DLock dLock = DLock.create((String)("/bos/image/imageReady//" + billId)).fastMode();
            Throwable throwable = null;
            try {
                String imageNo;
                DynamicObject[] billImages;
                DynamicObject billImage;
                if (!dLock.tryLock(5000L) || (billImage = (billImages = billImageFacade.getMapObjbyImageNo(imageNo = ((DynamicObject)entry.getValue()).getString("imagenumber"))) != null && billImages.length > 0 ? billImages[0] : null) == null) continue;
                sscImageHandler.buildBillImageInfo(billImage, (BaseImageInfo)imageNoMap.get(imageNo));
                ReceiveImageInfo imageInfo = (ReceiveImageInfo)imageNoMap.get(imageNo);
                ImageInfo sscImageInfo = new ImageInfo();
                sscImageInfo.setBillId(billId);
                sscImageInfo.setScanuserId(imageInfo.getScanUserID());
                sscParams.put(billId, sscImageInfo);
                ImageInfo synParams = new ImageInfo();
                synParams.setImageNo(billImage.getString("imagenumber"));
                synParams.setBillId(billImage.getString("billid"));
                synParams.setImageState(billImage.getString("imagestate"));
                syncEasList.add(synParams);
                try (TXHandle txHandle = TX.requiresNew((String)"saveImageReady");){
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billImage});
                    this.saveImageQueue(billImage);
                }
                this.pushWorkFlow(billImage);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dLock == null) continue;
                if (throwable != null) {
                    try {
                        dLock.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dLock.close();
            }
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"uploadImage", (Object[])new Object[]{sscParams});
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u5171\u4eab\u72b6\u6001\u53d8\u66f4\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        this.synEas(syncEasList, false);
        TaskInterUtils.batchSendAllImageInfo2Mq(imageNoMap.keySet());
        return baseImageList.getImageList().get(baseImageList.getImageList().size() - 1).getImageNo();
    }

    private Map<String, DynamicObject> validateImageReadyParam(BaseImageList baseImageList) {
        List<BaseImageInfo> imageList = baseImageList.getImageList();
        HashMap<String, DynamicObject> billImageMap = new HashMap<String, DynamicObject>(imageList.size());
        Set<String> imageNoSet = imageList.stream().map(BaseImageInfo::getImageNo).collect(Collectors.toSet());
        log.info("\u5165\u53c2\u7684\u5f71\u50cf\u7f16\u7801\u96c6\u5408\uff1a" + imageNoSet);
        DynamicObject[] billImages = new BillImageFacade().getBillImageMapByImageNoSet(imageNoSet);
        if (billImages == null || billImages.length == 0) {
            return null;
        }
        for (DynamicObject billImage : billImages) {
            String imageNumber = billImage.getString("imagenumber");
            String billId = billImage.getString("billid");
            billImageMap.put(billId, billImage);
            imageNoSet.remove(imageNumber);
        }
        if (!imageNoSet.isEmpty()) {
            return null;
        }
        return billImageMap;
    }

    private void saveImageQueue(DynamicObject billImage) {
        String billId = billImage.getString("billid");
        String imageNumber = billImage.getString("imagenumber");
        String imageState = billImage.getString("imagestate");
        if ("4".equals(imageState) && InvoiceUtil.isExistImagequeue(billId, imageNumber)) {
            InvoiceUtil.changeRecStatus(billId, imageNumber, "retry");
            return;
        }
        DynamicObject imageQueueObj = BusinessDataServiceHelper.newDynamicObject((String)"task_imagequeue");
        imageQueueObj.set("billid", (Object)billId);
        imageQueueObj.set("imagenumber", (Object)imageNumber);
        imageQueueObj.set("creatime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{imageQueueObj});
    }

    private void pushWorkFlow(DynamicObject billImage) {
        String taskId = billImage.getString("wfprocessingid");
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            log.info("\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868\u672a\u8bb0\u5f55\u5230\u5de5\u4f5c\u6d41\u4efb\u52a1Id,\u4e0d\u6267\u884c\u63a8\u5de5\u4f5c\u6d41");
            return;
        }
        String user = billImage.getString("scanuserid");
        Long userId = 0L;
        try {
            userId = Long.parseLong(user);
        }
        catch (Exception e) {
            userId = RequestContext.get().getCurrUserId();
        }
        try (TXHandle handle = TX.requiresNew((String)"pushworkflow");){
            try {
                WorkflowServiceHelper.completeTask((Long)Long.valueOf(taskId), (Long)userId, (String)"Consent", (String)ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf\u6210\u529f", (String)"ImageServiceImpl_8", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error("\u5355\u636e" + billImage.getString("billnumber") + "imageReady\u63a8\u5de5\u4f5c\u6d41\u51fa\u9519\uff1a" + e);
            }
        }
    }

    public ImageInfo auditImage(ImageInfo imageInfo) {
        return NoticeImageSysFactory.getInstance().auditImage(imageInfo);
    }

    public String updateImageState(String inputXml) {
        DynamicObject[] billImages;
        DynamicObject[] hasImageData;
        inputXml = inputXml.trim().replaceAll("\t|\r|\n", "");
        log.info("\u4fee\u6539\u5f71\u50cf\u72b6\u6001\uff1a" + inputXml);
        BaseImageList baseList = xmlTrans.parseXml(inputXml, ImageStateParamInfo.class);
        SSCImageHandler imageHandler = new SSCImageHandler();
        List<BaseImageInfo> imageList = baseList.getImageList();
        if (imageList == null || imageList.size() == 0) {
            return null;
        }
        BillImageFacade billImageFacade = new BillImageFacade();
        HashMap<String, String> resultMap = new HashMap<String, String>(imageList.size());
        HashMap<String, ImageStateParamInfo> hasImageMap = new HashMap<String, ImageStateParamInfo>();
        HashMap<String, ImageStateParamInfo> noImageMap = new HashMap<String, ImageStateParamInfo>();
        for (BaseImageInfo imageInfo : imageList) {
            ImageStateParamInfo imageStateParamInfo = (ImageStateParamInfo)imageInfo;
            int state = imageStateParamInfo.getState();
            if (state == 2 || state == 4) {
                hasImageMap.put(imageInfo.getImageNo(), imageStateParamInfo);
            } else {
                noImageMap.put(imageInfo.getImageNo(), imageStateParamInfo);
            }
            resultMap.put(imageInfo.getImageNo(), FAIL);
        }
        HashMap<String, ImageInfo> sscParams = new HashMap<String, ImageInfo>(4);
        ArrayList<ImageInfo> syncEasList = new ArrayList<ImageInfo>(10);
        if (hasImageMap.size() > 0 && (hasImageData = billImageFacade.getBillImageMapByImageNoSet(hasImageMap.keySet())) != null && hasImageData.length > 0) {
            for (DynamicObject billImage : hasImageData) {
                String billId = billImage.getString("billId");
                try (DLock dLock = DLock.create((String)("/bos/image/imageReady//" + billId)).fastMode();){
                    DynamicObject billImageInfo;
                    if (!dLock.tryLock(5000L)) continue;
                    String imageNo = billImage.getString("imagenumber");
                    DynamicObject[] billImages2 = billImageFacade.getMapObjbyImageNo(imageNo);
                    DynamicObject dynamicObject = billImageInfo = billImages2 != null && billImages2.length > 0 ? billImages2[0] : null;
                    if (billImageInfo == null) continue;
                    String currImageState = String.valueOf(((ImageStateParamInfo)hasImageMap.get(imageNo)).getState());
                    String scanUserId = ((ImageStateParamInfo)hasImageMap.get(imageNo)).getScanUserID();
                    ImageInfo sscImageInfo = new ImageInfo();
                    sscImageInfo.setBillId(billId);
                    sscImageInfo.setScanuserId(((ImageStateParamInfo)hasImageMap.get(imageNo)).getScanUserID());
                    sscParams.put(billId, sscImageInfo);
                    ImageInfo synParams = new ImageInfo();
                    synParams.setImageNo(imageNo);
                    synParams.setBillId(billId);
                    synParams.setImageState(currImageState);
                    syncEasList.add(synParams);
                    billImageInfo.set("imagestate", (Object)currImageState);
                    billImageInfo.set("modifytime", (Object)new Date());
                    billImageInfo.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    billImageInfo.set("scanuserid", (Object)scanUserId);
                    billImageInfo.set("nextscanuserid", (Object)RequestContext.get().getCurrUserId());
                    try (TXHandle txHandle = TX.requiresNew((String)"saveImageReady");){
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billImageInfo});
                        this.saveImageQueue(billImageInfo);
                    }
                    this.pushWorkFlow(billImageInfo);
                    resultMap.put(imageNo, SUCCESS);
                }
            }
        }
        if (noImageMap.size() > 0 && (billImages = imageHandler.buildBillImageInfoAndUpdateTask(noImageMap)) != null && billImages.length > 0) {
            for (DynamicObject billImage : billImages) {
                ImageInfo synParams = new ImageInfo();
                synParams.setImageNo(billImage.getString("imagenumber"));
                synParams.setBillId(billImage.getString("billId"));
                synParams.setImageState(billImage.getString("imagestate"));
                syncEasList.add(synParams);
            }
            SaveServiceHelper.save((DynamicObject[])billImages);
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"uploadImage", (Object[])new Object[]{sscParams});
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u5171\u4eab\u72b6\u6001\u53d8\u66f4\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        this.synEas(syncEasList, false);
        TaskInterUtils.batchSendAllImageInfo2Mq(imageList.stream().map(BaseImageInfo::getImageNo).collect(Collectors.toSet()));
        ArrayList<ImageReturnCode> imageReturnCodes = new ArrayList<ImageReturnCode>(10);
        for (Map.Entry entry : resultMap.entrySet()) {
            imageReturnCodes.add(new ImageReturnCode(this.escapeXMLSpecialChar((String)entry.getKey()), (String)entry.getValue()));
        }
        String result = xmlTrans.bulidStatusXml(imageReturnCodes);
        return result;
    }

    @Deprecated
    public String viewPhoto(String imageNumber, String userID, String userName) {
        if (!imageNumber.contains(",")) {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setImageNo(imageNumber);
            ImageInfo imageInfoInside = this.getImageInfoInside(imageInfo);
            if (imageInfoInside == null || FAIL.equals(imageInfoInside.getImageState())) {
                return null;
            }
        }
        String url = null;
        NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
        viewPhotoInfo.setBarCode(imageNumber);
        viewPhotoInfo.setViewPersonId(userID);
        viewPhotoInfo.setViewPersonName(userName);
        try {
            url = NoticeImageSysFactory.getInstance().viewPhoto(viewPhotoInfo);
        }
        catch (Exception e) {
            log.error("\u67e5\u770b\u5f71\u50cf\u62a5\u9519:" + e.getMessage(), (Throwable)e);
        }
        return url;
    }

    private String viewPhotoInside(String imageNumber, String userID, String userName, boolean isMobile, String type) throws Exception {
        NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
        viewPhotoInfo.setBarCode(imageNumber);
        viewPhotoInfo.setViewPersonId(userID);
        viewPhotoInfo.setViewPersonName(userName);
        viewPhotoInfo.setApp(isMobile);
        viewPhotoInfo.setType(type);
        return NoticeImageSysFactory.getInstance().viewPhoto(viewPhotoInfo);
    }

    public ViewImageVo viewPhoto(ViewImageVo viewImageVo) {
        String billId = viewImageVo.getBillId();
        Object isRelatedView = SSCImageUtils.getImageSysParams("isrelatedview");
        boolean relatedViewFlag = false;
        if (isRelatedView != null) {
            relatedViewFlag = (Boolean)isRelatedView;
        }
        String imageSys = viewImageVo.getImageSys();
        ImageSysInfo enableImageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        if (imageSys == null) {
            imageSys = enableImageSysInfo.getNumber();
        }
        boolean isOverflow = false;
        String billType = viewImageVo.getBilltype();
        boolean isGlvoucher = GL_VOUCHER.equals(billType);
        log.info("\u5355\u636e\u7c7b\u578b \uff1a" + billType + ",\u662f\u5426\u4e3a\u51ed\u8bc1\uff1a" + isGlvoucher);
        if (relatedViewFlag && this.supportMultiViewImage(enableImageSysInfo)) {
            if (isGlvoucher && StringUtils.isNumeric((CharSequence)billId)) {
                HashSet<Long> billIds = new HashSet<Long>(16);
                billIds.add(Long.parseLong(billId));
                try {
                    Map<String, HashSet<Long>> directRelationBill = ImageServiceImpl.getVocherDirectRelationBill(Long.parseLong(billId));
                    if (directRelationBill != null) {
                        log.info(billId + "\u51ed\u8bc1DAP\u4e0a\u6e38\u5355\u636e\u7c7b\u578b\u4e2a\u6570\uff1a" + directRelationBill.size());
                        directRelationBill.values().forEach(billIds::addAll);
                        log.info(billId + "\u51ed\u8bc1DAP\u4e0a\u6e38\u5355\u636e\u4e2a\u6570\uff1a" + billIds.size());
                        for (Map.Entry<String, HashSet<Long>> entry : directRelationBill.entrySet()) {
                            HashSet<Long> dapBills;
                            String dapBillType = entry.getKey();
                            Map botpMap = BFTrackerServiceHelper.findSourceBills((String)dapBillType, (Long[])(dapBills = entry.getValue()).toArray(new Long[0]));
                            if (botpMap == null || botpMap.isEmpty()) continue;
                            Collection values = botpMap.values();
                            values.forEach(billIds::addAll);
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u51ed\u8bc1\u8054\u67e5DAP\u4e0a\u6e38\u5355\u636e\u6216BOTP\u4e0a\u6e38\u5355\u636e\u65f6\u5f02\u5e38\uff1a" + e);
                }
                isOverflow = this.getRelatedImagePhoto(billIds, viewImageVo, billId, true);
                if (!isOverflow) {
                    return viewImageVo;
                }
            } else {
                Map sourceBills = null;
                if (StringUtils.isNumeric((CharSequence)billId)) {
                    sourceBills = BFTrackerServiceHelper.findSourceBills((String)viewImageVo.getBilltype(), (Long[])new Long[]{Long.valueOf(billId)});
                }
                if (sourceBills != null && sourceBills.size() > 0) {
                    Collection values = sourceBills.values();
                    HashSet<Long> billIds = new HashSet<Long>();
                    values.forEach(billIds::addAll);
                    if (billIds.size() > 0) {
                        billIds.add(Long.parseLong(billId));
                        this.getRelatedImagePhoto(billIds, viewImageVo, billId, false);
                    } else {
                        log.info(billId + "\u65e0\u4e0a\u6e38\u5355\u636e");
                    }
                    return viewImageVo;
                }
            }
        }
        this.getSingleImagePhoto(billId, viewImageVo, isGlvoucher, isOverflow);
        return viewImageVo;
    }

    private boolean supportMultiViewImage(ImageSysInfo enableImageSys) {
        String number = enableImageSys.getNumber();
        return enableImageSys.getSupportMult() != false || number.equals(ImageSysEnum.FPY.getValue()) || number.equals(ImageSysEnum.FPY_IMC.getValue()) || number.equals(ImageSysEnum.DKWS_LINUX.getValue());
    }

    private boolean getRelatedImagePhoto(HashSet<Long> billIds, ViewImageVo viewImageVo, String billId, boolean isVoucher) {
        String prefix;
        log.info("\u9700\u8981\u8054\u67e5\u7684\u5355\u636e\uff1a" + billIds);
        QFilter billidsFilter = new QFilter("billid", "in", billIds.stream().map(Object::toString).collect(Collectors.toSet()));
        DynamicObjectCollection billImageMaps = QueryServiceHelper.query((String)"task_billimagemap", (String)"id,billid,billtype,imagenumber,imagestate", (QFilter[])new QFilter[]{billidsFilter});
        String string = prefix = isVoucher ? ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1", (String)"ImageServiceImpl_23", (String)"bos-image-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6b64\u5355\u636e", (String)"ImageServiceImpl_24", (String)"bos-image-formplugin", (Object[])new Object[0]);
        if (billImageMaps == null || billImageMaps.size() == 0) {
            viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u65e0\u9700\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"ImageServiceImpl_10", (String)"bos-image-formplugin", (Object[])new Object[0]), prefix).concat("\u3002"));
            return false;
        }
        ArrayList<String> imageNoList = new ArrayList<String>(billImageMaps.size());
        int count = 0;
        for (DynamicObject billImageMap : billImageMaps) {
            String state = billImageMap.getString("imagestate");
            if (FAIL.equals(state) || DISCARD_STATE.equals(state)) continue;
            String imageNumber = billImageMap.getString("imagenumber");
            if (billId.equals(billImageMap.getString("billid"))) {
                imageNoList.add(0, imageNumber);
            } else {
                imageNoList.add(imageNumber);
            }
            ++count;
        }
        if (imageNoList.size() == 0) {
            viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"ImageServiceImpl_11", (String)"bos-image-formplugin", (Object[])new Object[0]), prefix));
            return false;
        }
        if (isVoucher && count > 20) {
            viewImageVo.setMessage(ResManager.loadKDString((String)"\u51ed\u8bc1DAP\u548cBOTP\u4e0a\u6e38\u5355\u636e\u5f71\u50cf\u8fc7\u591a\uff0c\u4ec5\u5c55\u793a\u539f\u5355\u5f71\u50cf\u3002", (String)"ImageServiceImpl_22", (String)"bos-image-formplugin", (Object[])new Object[0]));
            return true;
        }
        String url = null;
        try {
            String barCodeStr = StringUtils.join((Object[])imageNoList.toArray(), (String)",");
            url = this.viewPhotoInside(barCodeStr, viewImageVo.getUserId(), viewImageVo.getUserName(), viewImageVo.isMobile(), viewImageVo.getType());
        }
        catch (Exception e) {
            viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u5f71\u50cf\u5931\u8d25\uff1a%s", (String)"ImageServiceImpl_33", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            viewImageVo.setUrl(url);
        }
        return false;
    }

    private void getSingleImagePhoto(String billId, ViewImageVo viewImageVo, boolean isVoucher, boolean isOverflow) {
        String prefix;
        boolean needRequest = true;
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billId);
        imageInfo = this.getImageInfoInside(imageInfo);
        String string = prefix = isVoucher ? ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1", (String)"ImageServiceImpl_23", (String)"bos-image-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6b64\u5355\u636e", (String)"ImageServiceImpl_24", (String)"bos-image-formplugin", (Object[])new Object[0]);
        if (imageInfo == null) {
            viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u65e0\u9700\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"ImageServiceImpl_10", (String)"bos-image-formplugin", (Object[])new Object[0]), prefix));
            needRequest = false;
        } else {
            String imageState = imageInfo.getImageState();
            if (DISCARD_STATE.equals(imageState)) {
                viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u5f71\u50cf\u5df2\u4f5c\u5e9f\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"ImageServiceImpl_13", (String)"bos-image-formplugin", (Object[])new Object[0]), prefix));
                needRequest = false;
            } else if (FAIL.equals(imageState)) {
                viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"ImageServiceImpl_11", (String)"bos-image-formplugin", (Object[])new Object[0]), prefix));
                if ("2".equals(imageInfo.getImageScan())) {
                    viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u65e0\u9700\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"ImageServiceImpl_10", (String)"bos-image-formplugin", (Object[])new Object[0]), prefix));
                }
                needRequest = false;
            }
        }
        if (!needRequest) {
            if (isOverflow) {
                String message = viewImageVo.getMessage();
                viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"%s\u4e14\u5173\u8054\u5355\u636e\u6570\u91cf\u8fc7\u591a\uff0c\u4e0d\u652f\u6301\u8054\u67e5\u5f71\u50cf\u3002", (String)"ImageServiceImpl_25", (String)"bos-image-formplugin", (Object[])new Object[0]), message));
            }
            return;
        }
        viewImageVo.setImageNo(imageInfo.getImageNo());
        String url = null;
        try {
            url = this.viewPhotoInside(viewImageVo.getImageNo(), viewImageVo.getUserId(), viewImageVo.getUserName(), viewImageVo.isMobile(), viewImageVo.getType());
        }
        catch (Exception e) {
            viewImageVo.setMessage(String.format(ResManager.loadKDString((String)"\u67e5\u770b\u5f71\u50cf\u5931\u8d25\uff1a%s", (String)"ImageServiceImpl_33", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            viewImageVo.setUrl(url);
        }
    }

    public String imageRscan(String barCode, String rescanMessage, String rescanPerson) {
        return this.doImageRescan(barCode, rescanMessage, rescanPerson, 1);
    }

    public String imageRescan(String imageNumber, String rescanMessage, String userId, Integer rescanType) {
        return this.doImageRescan(imageNumber, rescanMessage, userId, rescanType);
    }

    private String doImageRescan(String barCode, String rescanMessage, String userId, Integer rescanType) {
        String billId;
        String result;
        NoticeImageSys2RescanInfo imageRscanInfo = new NoticeImageSys2RescanInfo();
        imageRscanInfo.setBarCode(barCode);
        imageRscanInfo.setRescanMessage(rescanMessage);
        imageRscanInfo.setRescanPerson(Long.parseLong(userId));
        QFilter filter = new QFilter("imagenumber", "=", (Object)barCode);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject image = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"id,imagestate,billid,modifytime", (QFilter[])filters);
        if (image == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u652f\u6301\u5f71\u50cf!", (String)"ImageServiceImpl_9", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String imageState = image.getString("imagestate");
        if (!imageState.equals("2") && !imageState.equals("4")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5f71\u50cf\u5c31\u7eea\u6216\u8005\u5f71\u50cf\u91cd\u4f20\u7684\u5f71\u50cf\u624d\u80fd\u9000\u626b\u3002", (String)"ImageServiceImpl_31", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        try {
            result = NoticeImageSysFactory.getInstance().rescan(imageRscanInfo);
            image.set("imagestate", (Object)"3");
            billId = this.updateImagestateIntoRescan(image);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        ImageRescanNoticeHelper.notice(barCode, rescanMessage, String.valueOf(rescanType), userId);
        TaskInterUtils.sendAllImageInfo2Mq(barCode);
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setImageNo(barCode);
        imageInfo.setBillId(billId);
        imageInfo.setImageState("3");
        this.synEas(Collections.singletonList(imageInfo), false);
        return result;
    }

    public String cancelRescan(String barCode, String cancelMessage, String cancelUser) {
        String billId;
        String result;
        NoticeImageSysCancelRescanInfo cancelRescanInfo = new NoticeImageSysCancelRescanInfo();
        cancelRescanInfo.setBarCode(barCode);
        cancelRescanInfo.setCancelMessage(cancelMessage);
        cancelRescanInfo.setCancelUser(Long.parseLong(cancelUser));
        QFilter filter = new QFilter("imagenumber", "=", (Object)barCode);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject image = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"id,imagestate,billid,modifytime", (QFilter[])filters);
        if (image == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5355\u636e\u4e0d\u652f\u6301\u5f71\u50cf!", (String)"ImageServiceImpl_9", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String imageState = image.getString("imagestate");
        if (!imageState.equals("3")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u9000\u56de\u91cd\u626b\u72b6\u6001\u7684\u5f71\u50cf\u624d\u80fd\u53d6\u6d88\u9000\u626b\u3002", (String)"ImageServiceImpl_32", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        try {
            result = NoticeImageSysFactory.getInstance().cancelRescan(cancelRescanInfo);
            image.set("imagestate", (Object)"2");
            billId = this.updateImagestateIntoRescan(image);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        TaskInterUtils.sendAllImageInfo2Mq(barCode);
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setImageNo(barCode);
        imageInfo.setBillId(billId);
        imageInfo.setImageState("2");
        this.synEas(Collections.singletonList(imageInfo), false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteImage(String imageNo, String userName, String tag) {
        log.info(userName + "\u8c03\u7528deleteImage\u5220\u9664\u5f71\u50cf\uff1a" + imageNo);
        QFilter imageNoFilter = new QFilter("imagenumber", "=", (Object)imageNo);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)"id,imagestate,billtype,billid,imagenumber,billnumber", (QFilter[])new QFilter[]{imageNoFilter});
        if (dyn == null) {
            return "success";
        }
        try (TXHandle h = TX.requiresNew((String)"deleteImage");){
            try {
                this.deleteTableData(dyn);
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u8868\u6570\u636e\u65f6\u5f02\u5e38\uff1a" + e);
                h.markRollback();
                String string = "false";
                if (h != null) {
                    if (var7_7 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return string;
            }
        }
        ImageSysInfo enableImageSys = null;
        try {
            enableImageSys = SSCImageUtils.getEnableImageSysInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enableImageSys != null) {
            String imageSysNumber = enableImageSys.getNumber();
            String externalErpNumber = enableImageSys.getExternalerpNumber();
            log.info("\u5f71\u50cf\u7cfb\u7edf\u7f16\u7801\u4e3a\uff1a" + imageSysNumber + "\uff1b\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e3a\uff1a" + externalErpNumber);
            this.noticeImageSysDeleteImage(dyn, userName);
        }
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("fi", "kd.bos.imageplatform.service.status_update");){
            ImageInfo delParam = new ImageInfo();
            delParam.setImageNo(imageNo);
            this.synEas(Collections.singletonList(delParam), true);
            ImageStatusSynMessage message = ImageStatusSynMessage.transformFromDynamic((DynamicObject)dyn);
            message.setImageState(FAIL);
            publisher.publish((Object)message);
        }
        return "success";
    }

    private void deleteTableData(DynamicObject billImageInfo) {
        String imageState = billImageInfo.getString("imagestate");
        String imageNumber = billImageInfo.getString("imagenumber");
        QFilter filter = new QFilter("imagenumber", "=", (Object)imageNumber);
        this.deleteData("task_billimagemap", filter);
        if (!FAIL.equals(imageState)) {
            this.deleteData("task_imagequeue", filter);
            this.deleteData("task_invoice", filter);
        }
    }

    private void noticeImageSysDeleteImage(DynamicObject billImageInfo, String userName) {
        NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
        destroyInfo.setImageNo(billImageInfo.getString("imagenumber"));
        String remark = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\uff0c\u540c\u6b65\u5220\u9664\u5f71\u50cf\u4fe1\u606f\uff01", (String)"ImageServiceImpl_3", (String)"bos-image-formplugin", (Object[])new Object[0]);
        destroyInfo.setMessage(remark);
        destroyInfo.setOpreatePerson(userName);
        destroyInfo.setUseraccount(RequestContext.get().getUserId());
        destroyInfo.setUsername(RequestContext.get().getUserName());
        try {
            String result = NoticeImageSysFactory.getInstance().destroyImage(destroyInfo);
            log.info("\u5f71\u50cf\u7cfb\u7edf\u5220\u9664\u5f71\u50cf\u7ed3\u679c\uff1a" + result);
            if (!SUCCESS.equals(result)) {
                this.recordDeleteErrorInfo(billImageInfo, result);
            }
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u7cfb\u7edf\u5220\u9664\u5f71\u50cf\u5f02\u5e38\uff1a" + e);
            this.recordDeleteErrorInfo(billImageInfo, e.getMessage());
        }
    }

    private boolean deleteImageRetry(NoticeImageSysHelper noticeImageSysHelper, String userName, String imageNumber) {
        NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
        destroyInfo.setImageNo(imageNumber);
        String remark = ResManager.loadKDString((String)"\u5220\u9664\u5f71\u50cf\u91cd\u8bd5", (String)"ImageServiceImpl_26", (String)"bos-image-formplugin", (Object[])new Object[0]);
        destroyInfo.setMessage(remark);
        destroyInfo.setOpreatePerson(userName);
        destroyInfo.setUseraccount(RequestContext.get().getUserId());
        destroyInfo.setUsername(RequestContext.get().getUserName());
        try {
            String result = noticeImageSysHelper.destroyImage(destroyInfo);
            log.info("\u5220\u9664\u5f71\u50cf\u91cd\u8bd5\u7ed3\u679c\uff1a" + result);
            if (SUCCESS.equals(result)) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("\u5220\u9664\u5f71\u50cf\u91cd\u8bd5\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return false;
    }

    private void recordDeleteErrorInfo(DynamicObject billImageInfo, String errorMsg) {
        try {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setImageNo(billImageInfo.getString("imagenumber"));
            imageInfo.setBillData(errorMsg);
            imageInfo.setImageId(billImageInfo.getString("id"));
            imageInfo.setBillId(billImageInfo.getString("billid"));
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.DELETE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean discardImage(NoticeImageInfo noticeImageInfo) {
        boolean discardResult = false;
        String imageNo = noticeImageInfo.getImageNo();
        String userId = noticeImageInfo.getUserId();
        String remark = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5e9f\u5f03\uff0c\u540c\u6b65\u5e9f\u5f03\u5f71\u50cf\u4fe1\u606f", (String)"ImageServiceImpl_2", (String)"bos-image-formplugin", (Object[])new Object[0]);
        NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
        destroyInfo.setImageNo(imageNo);
        destroyInfo.setMessage(remark);
        destroyInfo.setOpreatePerson(userId);
        destroyInfo.setUseraccount(RequestContext.get().getUserId());
        destroyInfo.setUsername(RequestContext.get().getUserName());
        destroyInfo.setOrgId(noticeImageInfo.getOrgId());
        try {
            String result = NoticeImageSysFactory.getInstance().destroyImage(destroyInfo);
            log.info("\u5e9f\u5f03\u5f71\u50cf\u7ed3\u679c\uff1a" + result);
            discardResult = true;
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u7cfb\u7edf\u5220\u9664\u5f71\u50cf\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        QFilter billIdFilter = new QFilter("billid", "=", (Object)noticeImageInfo.getBillId());
        DynamicObject billImageMap = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"imagestate", (QFilter[])new QFilter[]{billIdFilter});
        if (billImageMap != null) {
            billImageMap.set("imagestate", (Object)DISCARD_STATE);
            SaveServiceHelper.update((DynamicObject)billImageMap);
        }
        return discardResult;
    }

    private void synEas(List<ImageInfo> images, boolean isDelete) {
        Object isSyneas = SSCImageUtils.getImageSysParams("issyneas");
        if (isSyneas != null && ((Boolean)isSyneas).booleanValue()) {
            try (TXHandle h = TX.requiresNew((String)"TX_TAG_5");){
                if (images.size() > 1) {
                    threadPool.execute(() -> {
                        for (ImageInfo image : images) {
                            JSONObject params = new JSONObject();
                            params.put("fbillid", (Object)image.getBillId());
                            params.put("fimagestate", (Object)image.getImageState());
                            params.put("fimagenumber", (Object)image.getImageNo());
                            this.invokeIscbUpdateService(Collections.singletonList(params));
                        }
                    });
                } else if (isDelete) {
                    this.invokeIscbDeleteService(Collections.singletonList(images.get(0).getImageNo()));
                } else {
                    JSONObject params = new JSONObject();
                    params.put("fbillid", (Object)images.get(0).getBillId());
                    params.put("fimagestate", (Object)images.get(0).getImageState());
                    params.put("fimagenumber", (Object)images.get(0).getImageNo());
                    this.invokeIscbUpdateService(Collections.singletonList(params));
                }
            }
            catch (Exception e) {
                log.error("\u540c\u6b65EAS\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void invokeIscbUpdateService(List paramList) {
        QFilter filter = new QFilter("number", "=", (Object)NEW_FLOW_IMAGE_UPDATE);
        boolean isNewFlow = QueryServiceHelper.exists((String)"isc_service_flow", (QFilter[])new QFilter[]{filter});
        Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{isNewFlow ? NEW_FLOW_IMAGE_UPDATE : OLD_FLOW_IMAGE_UPDATE, paramList});
        log.info("\u66f4\u65b0\u5f71\u50cf\u7f16\u7801\u670d\u52a1\u6d41\u7a0b\uff0c\u8c03\u7528\u53c2\u6570\uff1a" + paramList + "\uff0c\u8c03\u7528\u7ed3\u679c\uff1a" + result);
    }

    private void invokeIscbDeleteService(List paramList) {
        QFilter filter = new QFilter("number", "=", (Object)NEW_FLOW_IMAGE_DELETE);
        boolean isNewFlow = QueryServiceHelper.exists((String)"isc_service_flow", (QFilter[])new QFilter[]{filter});
        Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{isNewFlow ? NEW_FLOW_IMAGE_DELETE : OLD_FLOW_IMAGE_DELETE, paramList});
        log.info("\u5220\u9664\u5f71\u50cf\u7f16\u7801\u670d\u52a1\u6d41\u7a0b\uff0c\u8c03\u7528\u53c2\u6570\uff1a" + paramList + "\uff0c\u8c03\u7528\u7ed3\u679c\uff1a" + result);
    }

    private void addnewMapInfo(HashMap map) {
        try {
            Date now = new Date();
            QFilter filter1 = new QFilter("imagenumber", "=", map.get("imagenumber"));
            QFilter filter2 = new QFilter("billid", "=", map.get("billid"));
            if (QueryServiceHelper.exists((String)"task_billimagemap", (QFilter[])new QFilter[]{filter1})) {
                return;
            }
            if (QueryServiceHelper.exists((String)"task_billimagemap", (QFilter[])new QFilter[]{filter2})) {
                DynamicObject image = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"imagenumber,imagestate,creator,createtime,modifier,modifytime", (QFilter[])new QFilter[]{filter2});
                image.set("imagenumber", map.get("imagenumber"));
                image.set("imagestate", map.get("imagestate"));
                image.set("creator", map.get("creator"));
                if (map.get("createtime") != null) {
                    image.set("createtime", map.get("createtime"));
                } else {
                    image.set("createtime", (Object)now);
                }
                image.set("modifier", map.get("lastupdateuser"));
                if (map.get("lastupdatetime") != null) {
                    image.set("modifytime", map.get("lastupdatetime"));
                } else {
                    image.set("modifytime", (Object)now);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{image});
            } else {
                ORM orm = ORM.create();
                DynamicObject obj = orm.newDynamicObject("task_billimagemap");
                obj.set("billid", map.get("billid"));
                obj.set("imagenumber", map.get("imagenumber"));
                obj.set("imagestate", map.get("imagestate"));
                obj.set("creator", map.get("creator"));
                if (map.get("createtime") != null) {
                    obj.set("createtime", map.get("createtime"));
                } else {
                    obj.set("createtime", (Object)now);
                }
                obj.set("modifier", map.get("lastupdateuser"));
                if (map.get("lastupdatetime") != null) {
                    obj.set("modifytime", map.get("lastupdatetime"));
                } else {
                    obj.set("modifytime", (Object)now);
                }
                orm.insert(obj);
            }
        }
        catch (Exception e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u8c03\u7528addnewMapInfo\u51fa\u9519\uff0c\u5355\u636eID\uff1a%1$s\uff0c\u5f71\u50cf\u7f16\u7801\uff1a%2$s\uff0c\u51fa\u9519\u539f\u56e0\uff1a%3$s", (String)"ImageServiceImpl_16", (String)"bos-image-formplugin", (Object[])new Object[0]), map.get("billid"), map.get("imagenumber"), e.getMessage()));
        }
    }

    public boolean invokeSynBillImageMap(HashMap map) {
        try {
            String inputXml = (String)map.get("inputXml");
            String operation = (String)map.get("operation");
            if ("updateImageState".equals(operation)) {
                this.updateImageState(inputXml);
            } else if ("imageReady".equals(operation)) {
                String imageNumber = this.imageReady(inputXml);
                if (FAIL.equals(imageNumber)) {
                    return false;
                }
            } else if ("addnewMapInfo".equals(operation)) {
                this.addnewMapInfo(map);
            }
        }
        catch (Exception e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u4e0b\u4e00\u4ee3\u63a5\u53e3\u540c\u6b65\u5931\u8d25\uff1a%1$s", (String)"ImageServiceImpl_5", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        return true;
    }

    @Deprecated
    public String generateImageNumber(DynamicObject billInfo) {
        return null;
    }

    public String excuteImageStrategy(DynamicObject billInfo, Long orgId) {
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(billInfo.getString("billid"));
        imageInfo.setBillNo(billInfo.getString("billnumber"));
        imageInfo.setBilltype(billInfo.getString("billtype"));
        imageInfo.setImageScan(SUCCESS);
        imageInfo.setOrgId(orgId + "");
        imageInfo.setCreator(billInfo.getDynamicObject("creator").getPkValue().toString());
        return this.CreateImageInfo(imageInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SynEasImageMap(String massage, String imagenumber) {
        HashMap<String, String> imageMap = new HashMap<String, String>();
        imageMap.put("massage", massage);
        imageMap.put("imagenumber", imagenumber);
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.imageplatform.service.image");){
            pub.publish(imageMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo createHeterogeneImageInfo(ImageInfo imageInfo) {
        log.info("CreateHeterogeneImageInfo start \uff1a " + imageInfo);
        String imageInfoImageNo = imageInfo.getImageNo();
        String imageInfoBillNo = imageInfo.getBillNo();
        String imageInfoBillId = imageInfo.getBillId();
        String imageInfoBillType = imageInfo.getBilltype();
        String imageInfoImageState = imageInfo.getImageState();
        String heterogeneid = imageInfo.getHeterogeneid();
        if (StringUtils.isNotBlank((CharSequence)imageInfoImageState) && !ArrayUtils.contains((Object[])LEGAL_STATUS, (Object)imageInfoImageState)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5165\u53c2\u7684\u5f71\u50cf\u72b6\u6001\u4e0d\u5408\u6cd5\u3002", (String)"HeterogeneImageOpAction_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)heterogeneid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u6784\u5355\u636eID\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"HeterogeneImageOpAction_5", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String lockObject = ERP_SYNC_IMAGE_LOCK + heterogeneid;
        DLock dLock = DLock.create((String)lockObject, (String)ResManager.loadKDString((String)"\u5f02\u6784\u5f71\u50cf\u96c6\u6210\u64cd\u4f5c\u5f71\u50cf\u6620\u5c04\u8868\u3002", (String)"HeterogeneImageOpAction_2", (String)"bos-image-formplugin", (Object[])new Object[0]));
        DLockInfo lockInfo = null;
        dLock.lock();
        try {
            DynamicObject billImageMap;
            lockInfo = DLock.getLockInfo((String)lockObject);
            ImageInfo imageInfo2Update = new ImageInfo();
            String selectFields = "id,modifier,modifytime,billfieldmap,imagenumber,billnumber,imagestate,sourcesys,creatoraccount,creatorname,creator,orgname,creatororgid,billid,billtype,createtime,heterogeneid,createbyxh,needimagescan";
            QFilter idFilter = new QFilter("heterogeneid", "=", (Object)heterogeneid);
            DynamicObject[] billImageMaps = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
            if ((billImageMaps == null || billImageMaps.length == 0) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{imageInfoBillId}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{imageInfoBillType})) {
                idFilter = new QFilter("billid", "=", (Object)imageInfoBillId).and(new QFilter("billtype", "=", (Object)imageInfoBillType));
                billImageMaps = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
            }
            if (ArrayUtils.getLength((Object)billImageMaps) > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5f02\u6784\u5355\u636eID\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u591a\u4e2a\u5355\u636e\u3002", (String)"HeterogeneImageOpAction_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            if (billImageMaps != null && billImageMaps.length == 1) {
                billImageMap = billImageMaps[0];
                String billid = billImageMap.getString("billid");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{billid}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{imageInfoBillId}) && !billid.equals(imageInfoBillId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5f02\u6784\u5355\u636eID\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u5176\u4ed6\u5355\u636e\u3002", (String)"HeterogeneImageOpAction_4", (String)"bos-image-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isNotBlank((CharSequence)imageInfoBillId)) {
                    billImageMap.set("billid", (Object)imageInfoBillId);
                }
                if (StringUtils.isNotBlank((CharSequence)imageInfoBillNo)) {
                    billImageMap.set("billnumber", (Object)imageInfoBillNo);
                }
                if (StringUtils.isNotBlank((CharSequence)imageInfoBillType)) {
                    billImageMap.set("billtype", (Object)imageInfoBillType);
                }
                if (StringUtils.isNotBlank((CharSequence)heterogeneid)) {
                    billImageMap.set("heterogeneid", (Object)heterogeneid);
                }
                billImageMap.set("createbyxh", (Object)Boolean.FALSE);
                if (StringUtils.isBlank((CharSequence)billImageMap.getString("imagenumber")) && StringUtils.isNotBlank((CharSequence)imageInfoImageNo)) {
                    billImageMap.set("imagenumber", (Object)imageInfoImageNo);
                } else if (billImageMap.get("imagenumber") != null) {
                    imageInfo2Update.setImageNo(billImageMap.getString("imagenumber"));
                }
                if (StringUtils.isBlank((CharSequence)billImageMap.getString("imagestate")) && StringUtils.isNotBlank((CharSequence)imageInfoImageState)) {
                    billImageMap.set("imagestate", (Object)imageInfoImageState);
                } else if (billImageMap.getString("imagestate") != null) {
                    imageInfo2Update.setImageState(billImageMap.getString("imagestate"));
                }
                try (TXHandle txHandle = TX.requiresNew((String)"createImageInfo");){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billImageMap});
                    }
                    catch (Exception exc) {
                        log.error("\u4fdd\u5b58\u5f71\u50cf\u6620\u5c04\u6570\u636e\u5f02\u5e38\uff1a" + exc);
                        txHandle.markRollback();
                    }
                }
            } else {
                billImageMap = ImageInfo.covertImageInfo((ImageInfo)imageInfo, (String)imageInfo.getImageNo());
                billImageMap.set("createbyxh", (Object)Boolean.FALSE);
                try (TXHandle txHandle = TX.requiresNew((String)"createImageInfo");){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billImageMap});
                    }
                    catch (Exception exc) {
                        log.error("\u4fdd\u5b58\u5f71\u50cf\u6620\u5c04\u6570\u636e\u5f02\u5e38\uff1a" + exc);
                        txHandle.markRollback();
                    }
                }
            }
            ImageInfo imageInfo2 = imageInfo2Update;
            return imageInfo2;
        }
        finally {
            if (lockInfo != null) {
                // empty if block
            }
            dLock.unlock();
        }
    }

    public String CreateImageInfo(ImageInfo imageInfo) {
        QFilter heteroGeneFilter;
        log.info("CreateImageInfo\u5f00\u59cb \uff1a " + imageInfo);
        String sourceSys = imageInfo.getSourceSys();
        String billNo = imageInfo.getBillNo();
        String billMetaNumber = imageInfo.getBilltype();
        DynamicObject billImageMap = null;
        String heterogeneid = imageInfo.getHeterogeneid();
        String billData = imageInfo.getBillData();
        if (StringUtil.isEmpty((String)billData)) {
            HashMap<String, Integer> info = new HashMap<String, Integer>(2);
            info.put("uploadFlag", imageInfo.getUploadFlag());
            info.put("electricAutoCommit", imageInfo.getElectricAutoCommit());
            imageInfo.setBillData(((Object)info).toString());
        }
        String selectFields = "id,modifier,modifytime,billfieldmap,imagenumber,billnumber,imagestate,sourcesys,creatoraccount,creatorname,creator,orgname,creatororgid,billid,billtype,createtime,needimagescan,heterogeneid,createbyxh";
        if (!StringUtil.isEmpty((String)heterogeneid) && (billImageMap = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)selectFields, (QFilter[])new QFilter[]{heteroGeneFilter = new QFilter("heterogeneid", "=", (Object)heterogeneid)})) != null) {
            boolean repeated = false;
            if (sourceSys == null || "KDCC".equals(sourceSys)) {
                String billId = billImageMap.getString("billid");
                repeated = !billId.equals(imageInfo.getBillId());
            } else {
                String dbSourceSys = billImageMap.getString("sourcesys");
                String dbBillNo = billImageMap.getString("billnumber");
                boolean bl = repeated = !dbSourceSys.equals(sourceSys) || !dbBillNo.equals(billNo);
            }
            if (repeated) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f02\u6784\u5355\u636eid\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5355\u636e", (String)"ImageServiceImpl_29", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
        }
        if (sourceSys == null || "KDCC".equals(sourceSys)) {
            String billId = imageInfo.getBillId();
            QFilter idFilter = new QFilter("billid", "=", (Object)billId);
            billImageMap = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        } else {
            QFilter sourceSysFilter = new QFilter("sourcesys", "=", (Object)sourceSys);
            QFilter billNoFilter = new QFilter("billnumber", "=", (Object)billNo);
            billImageMap = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)selectFields, (QFilter[])new QFilter[]{sourceSysFilter, billNoFilter});
        }
        String resultImageNo = null;
        if (billImageMap != null) {
            String billNumber = billImageMap.getString("billnumber");
            String imageNo = billImageMap.getString("imagenumber");
            String imageState = billImageMap.getString("imagestate");
            if (!billNumber.equals(billNo)) {
                log.info("\u5355\u636e\u7f16\u7801\u53d1\u751f\u53d8\u5316\uff0cimageInfo.billNumber \uff1a" + billNo + "\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868billNumber\uff1a" + billNumber + "\uff0c\u65e7\u5f71\u50cf\u7f16\u7801:" + imageNo);
                this.deleteImage(imageNo, RequestContext.get().getUserName(), "createImage");
                if (!FAIL.equals(imageState)) {
                    this.informCreator(billNo, imageInfo.getCreator());
                }
            } else {
                resultImageNo = billImageMap.getString("imagenumber");
                log.info("\u5355\u636e\u7f16\u7801\u672a\u53d1\u751f\u53d8\u5316\uff0cimageNumber \uff1a" + resultImageNo);
            }
        }
        boolean needCreate = false;
        Map<String, Object> imageStrategy = this.getImageStrategy(imageInfo.getBilltype(), Long.valueOf(imageInfo.getOrgId()));
        if (imageStrategy != null) {
            needCreate = (Boolean)imageStrategy.get("isGen");
        }
        log.info("\u5339\u914d\u5230\u7684\u5f71\u50cf\u7f16\u7801\u751f\u6210\u7b56\u7565\u662f\u5426\u9700\u8981\u751f\u6210\u5f71\u50cf\u7f16\u7801\uff1a" + needCreate);
        if (resultImageNo == null) {
            if (!needCreate) {
                return null;
            }
            String prefix = (String)imageStrategy.get("prefix");
            boolean isRandom = (Boolean)imageStrategy.get("isRandom");
            if (StringUtil.isEmpty((String)prefix)) {
                prefix = "";
            }
            resultImageNo = (prefix + this.produceRandomCode(isRandom) + billNo).replace(" ", "");
            log.info("\u65b0\u521b\u5efa\u7684\u5f71\u50cf\u7f16\u7801\uff1a" + resultImageNo);
            billImageMap = ImageInfo.covertImageInfo((ImageInfo)imageInfo, (String)resultImageNo);
            billImageMap.set("createbyxh", (Object)Boolean.TRUE);
            this.startWorkFlow(resultImageNo, imageInfo.getOrgId(), RequestContext.get().getUserName(), imageInfo.getCreator(), imageInfo.getBillNo(), billMetaNumber);
            imageInfo.setImageState(FAIL);
            imageInfo.setImageNo(resultImageNo);
        } else {
            log.info("\u5b58\u5728\u5f71\u50cf\u7f16\u7801\uff0c\u5355\u53f7\u672a\u53d1\u751f\u6539\u53d8\uff1a" + billNo);
            imageInfo.setImageNo(resultImageNo);
            imageInfo.setImageState(billImageMap.getString("imagestate"));
            billImageMap.set("modifier", (Object)RequestContext.get().getUserId());
            billImageMap.set("modifytime", (Object)new Date());
            billImageMap.set("billfieldmap", (Object)imageInfo.getBillData());
            billImageMap.set(NEEDIMAGESCAN, (Object)imageInfo.getImageScan());
            billImageMap.set("sourcesys", (Object)(imageInfo.getSourceSys() == null ? "KDCC" : imageInfo.getSourceSys()));
            billImageMap.set("creatoraccount", (Object)imageInfo.getCreatorAccount());
            billImageMap.set("creatorname", (Object)imageInfo.getCreatorName());
            billImageMap.set("creator", (Object)imageInfo.getCreator());
            billImageMap.set("orgname", (Object)imageInfo.getOrgName());
            billImageMap.set("creatororgid", (Object)imageInfo.getOrgId());
            billImageMap.set("billid", (Object)imageInfo.getBillId());
            billImageMap.set("billtype", (Object)imageInfo.getBilltype());
            billImageMap.set("createbyxh", (Object)Boolean.TRUE);
        }
        Object[] objs = null;
        try (TXHandle txHandle = TX.requiresNew((String)"createImageInfo");){
            try {
                objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billImageMap});
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u5f71\u50cf\u6620\u5c04\u6570\u636e\u5f02\u5e38\uff1a" + e);
                txHandle.markRollback();
                String string = null;
                if (txHandle != null) {
                    if (var14_17 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var14_17.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return string;
            }
        }
        ImageSysInfo imageSysInfo = null;
        try {
            imageSysInfo = SSCImageUtils.getEnableImageSysInfo();
            NoticeImageSysFactory.getInstance().pushImageInfo(imageInfo);
        }
        catch (Exception e) {
            log.error("pushImageInfo\u5f02\u5e38:" + e);
            SSCImageUtils.recordErrorInfo(imageInfo, ImageOperaionEnum.CREATE);
        }
        if (objs != null && objs.length > 0) {
            if (imageSysInfo != null && "EAS".equalsIgnoreCase(imageSysInfo.getExternalerpNumber())) {
                Map<String, Object> map = this.buildMap(billImageMap);
                String jsonMessage = null;
                try {
                    jsonMessage = JSONUtils.toString(map);
                }
                catch (IOException e) {
                    log.error("build");
                }
                this.SynEasImageMap(jsonMessage, resultImageNo);
            }
            this.synEas(Collections.singletonList(imageInfo), false);
        }
        return resultImageNo;
    }

    private Map<Long, Map<String, Object>> getImageStrategyMap(String billType, List<Long> orgIdList) {
        return SSCImageUtils.matchImageStrategy(billType, orgIdList);
    }

    private Map<String, Object> getImageStrategy(String billType, Long orgId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(orgId);
        Map<Long, Map<String, Object>> imageStrategyMap = this.getImageStrategyMap(billType, orgIdList);
        return imageStrategyMap.get(orgId);
    }

    public Map<String, ImageInfo> createImageInfoBatch(List<ImageInfo> imageInfoList) {
        DynamicObject[] billImageMaps;
        HashMap<String, ImageInfo> result = new HashMap<String, ImageInfo>(16);
        if (imageInfoList == null || imageInfoList.size() == 0) {
            return result;
        }
        long allStart = System.currentTimeMillis();
        HashMap<String, String> heteroGeneBillIdMap = new HashMap<String, String>(imageInfoList.size());
        Iterator<ImageInfo> iterator = imageInfoList.iterator();
        while (iterator.hasNext()) {
            ImageInfo next = iterator.next();
            String heteroGeneId = next.getHeterogeneid();
            if (StringUtil.isEmpty((String)heteroGeneId)) continue;
            if (heteroGeneBillIdMap.containsKey(heteroGeneId)) {
                log.error("\u672c\u6b21\u63d0\u4ea4\u7684\u5355\u636e" + next.getBillNo() + "\u7684\u5f02\u6784\u5355\u636eid\u4e0e\u4e00\u540c\u63d0\u4ea4\u7684\u5355\u5f02\u6784\u5355\u636eid\u91cd\u590d");
                iterator.remove();
                continue;
            }
            heteroGeneBillIdMap.put(heteroGeneId, next.getBillId());
        }
        Set heteroGeneIdSet = heteroGeneBillIdMap.keySet();
        if (heteroGeneIdSet.size() > 0 && (billImageMaps = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"id,modifier,modifytime,billid,billfieldmap,imagenumber,billnumber,imagestate,sourcesys,creatoraccount,creatorname,creator,orgname,creatororgid,billid,billtype,createtime,needimagescan,heterogeneid", (QFilter[])new QFilter[]{new QFilter("heterogeneid", "in", heteroGeneIdSet)})) != null && billImageMaps.length > 0) {
            Set heterogeneIdList = Arrays.stream(billImageMaps).map(dynamicObject -> dynamicObject.getString("heterogeneid")).collect(Collectors.toSet());
            Iterator<ImageInfo> dbIterator = imageInfoList.iterator();
            while (dbIterator.hasNext()) {
                ImageInfo next = dbIterator.next();
                if (!heterogeneIdList.contains(next.getHeterogeneid())) continue;
                log.info("\u672c\u6b21\u63d0\u4ea4\u7684\u5355\u636e" + next.getBillNo() + "\u7684\u5f02\u6784\u5355\u636eid\u5728\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868\u4e2d\u5df2\u7ecf\u5b58\u5728");
                dbIterator.remove();
            }
        }
        List billIdList = imageInfoList.stream().map(ImageInfo::getBillId).collect(Collectors.toList());
        QFilter billIdListFilter = new QFilter("billid", "in", billIdList);
        DynamicObject[] billImageMaps2 = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"id,modifier,modifytime,billid,billfieldmap,imagenumber,billnumber,imagestate,sourcesys,creatoraccount,creatorname,creator,orgname,creatororgid,billid,billtype,createtime,needimagescan,createbyxh", (QFilter[])new QFilter[]{billIdListFilter});
        Map<String, ImageInfo> imageMap = imageInfoList.stream().collect(Collectors.toMap(ImageInfo::getBillId, Function.identity()));
        Map<String, String> billNoCreator = imageInfoList.stream().collect(Collectors.toMap(ImageInfo::getBillNo, ImageInfo::getCreator));
        HashMap<String, Object> billIdImageNumberMap = new HashMap<String, Object>(imageMap.size());
        HashMap<String, String> delImageNumberMap = new HashMap<String, String>();
        HashMap<String, String> delImageStateMap = new HashMap<String, String>();
        if (billImageMaps2 != null && billImageMaps2.length > 0) {
            for (DynamicObject dynamicObject2 : billImageMaps2) {
                String billId = dynamicObject2.getString("billid");
                String billNumber = dynamicObject2.getString("billnumber");
                String string = ((ImageInfo)imageMap.get(billId)).getBillNo();
                String imageNumber = dynamicObject2.getString("imagenumber");
                String imageState = dynamicObject2.getString("imagestate");
                if (!billNumber.equals(string)) {
                    billIdImageNumberMap.put(billId, null);
                    delImageNumberMap.put(string, imageNumber);
                    delImageStateMap.put(imageNumber, imageState);
                    continue;
                }
                billIdImageNumberMap.put(billId, dynamicObject2);
            }
        }
        if (!delImageNumberMap.isEmpty()) {
            for (Map.Entry entry : delImageNumberMap.entrySet()) {
                String imageNumber = (String)entry.getValue();
                String billNo = (String)entry.getKey();
                this.deleteImage(imageNumber, RequestContext.get().getUserName(), "batchCreateImage");
                String imageState = (String)delImageStateMap.get(imageNumber);
                if (FAIL.equals(imageState)) continue;
                this.informCreator(billNo, billNoCreator.get(billNo));
            }
        }
        ArrayList<DynamicObject> imageInfoInsertList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(billIdImageNumberMap.size());
        String billType = imageInfoList.get(0).getBilltype();
        List<Long> orgIds = imageInfoList.stream().map(imageInfo -> Long.valueOf(imageInfo.getOrgId())).collect(Collectors.toList());
        Map<Long, Map<String, Object>> orgImageStrategyMap = this.getImageStrategyMap(billType, orgIds);
        for (ImageInfo imageInfo2 : imageInfoList) {
            String billId = imageInfo2.getBillId();
            DynamicObject billImage = (DynamicObject)billIdImageNumberMap.get(billId);
            if (billImage != null) {
                arrayList.add(billImage);
                billImage.set("modifier", (Object)RequestContext.get().getUserId());
                billImage.set("modifytime", (Object)new Date());
                billImage.set("billfieldmap", (Object)imageInfo2.getBillData());
                billImage.set(NEEDIMAGESCAN, (Object)imageInfo2.getImageScan());
                billImage.set("sourcesys", (Object)(imageInfo2.getSourceSys() == null ? "KDCC" : imageInfo2.getSourceSys()));
                billImage.set("orgname", (Object)imageInfo2.getOrgName());
                billImage.set("creatoraccount", (Object)imageInfo2.getCreatorAccount());
                billImage.set("creatorname", (Object)imageInfo2.getCreatorName());
                billImage.set("creatororgid", (Object)imageInfo2.getOrgId());
                billImage.set("billid", (Object)imageInfo2.getBillId());
                billImage.set("billtype", (Object)imageInfo2.getBilltype());
                billImage.set("createbyxh", (Object)Boolean.TRUE);
                imageInfo2.setImageState(billImage.getString("imagestate"));
                imageInfo2.setImageNo(billImage.getString("imagenumber"));
                continue;
            }
            Map<String, Object> orgImageStrategy = orgImageStrategyMap.get(Long.valueOf(imageInfo2.getOrgId()));
            if (orgImageStrategy != null && ((Boolean)orgImageStrategy.get("isGen")).booleanValue()) {
                String prefix = (String)orgImageStrategy.get("prefix");
                boolean isRandom = (Boolean)orgImageStrategy.get("isRandom");
                String imageNumber = (prefix + this.produceRandomCode(isRandom) + imageInfo2.getBillNo()).replace(" ", "");
                billImage = ImageInfo.covertImageInfo((ImageInfo)imageInfo2, (String)imageNumber);
                billImage.set("createbyxh", (Object)Boolean.TRUE);
                imageInfoInsertList.add(billImage);
                imageInfo2.setImageNo(imageNumber);
                continue;
            }
            imageMap.remove(billId);
        }
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew((String)"batchCreateImageInfo");){
            try {
                SaveServiceHelper.save((DynamicObject[])imageInfoInsertList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u521b\u5efa\u5f71\u50cf\u7f16\u7801-\u4fdd\u5b58\u6216\u66f4\u65b0\u5f71\u50cf\u6620\u5c04\u6570\u636e\u65f6\u5f02\u5e38\uff1a" + e);
                handle.markRollback();
            }
        }
        catch (Throwable e) {
            Throwable throwable2 = e;
            throw e;
        }
        ImageSysInfo imageSysInfo = null;
        try {
            imageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (imageSysInfo != null) {
            long l = System.currentTimeMillis();
            this.pushImageInfoAsyn(imageMap);
            long pushEnd = System.currentTimeMillis();
            this.asynStartWorkFlow(imageSysInfo.getNumber(), imageInfoInsertList);
        }
        ArrayList<ImageInfo> arrayList2 = new ArrayList<ImageInfo>(imageMap.size());
        imageInfoInsertList.addAll(arrayList);
        if (imageInfoInsertList.size() > 0) {
            for (DynamicObject dynamicObject3 : imageInfoInsertList) {
                ImageInfo imageInfo3 = new ImageInfo();
                imageInfo3.setImageNo(dynamicObject3.getString("imagenumber"));
                imageInfo3.setBillId(dynamicObject3.getString("billid"));
                String imagestate = dynamicObject3.getString("imagestate");
                if (StringUtils.isEmpty((CharSequence)imagestate)) {
                    imagestate = FAIL;
                }
                imageInfo3.setImageState(imagestate);
                arrayList2.add(imageInfo3);
            }
        }
        if (imageSysInfo != null && "EAS".equalsIgnoreCase(imageSysInfo.getExternalerpNumber())) {
            for (DynamicObject dynamicObject4 : imageInfoInsertList) {
                Map<String, Object> map = this.buildMap(dynamicObject4);
                String imageNumber = dynamicObject4.getString("imagenumber");
                String jsonMassage = null;
                try {
                    jsonMassage = JSONUtils.toString(map);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.SynEasImageMap(jsonMassage, imageNumber);
            }
        }
        this.synEas(arrayList2, false);
        long allEnd = System.currentTimeMillis();
        return imageMap;
    }

    public void discardImageBatch(List<String> billIdList) {
        DynamicObject[] billImageMap;
        QFilter filter = new QFilter("billid", "in", billIdList);
        for (DynamicObject billImage : billImageMap = BusinessDataServiceHelper.load((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])new QFilter[]{filter})) {
            billImage.set("imagestate", (Object)DISCARD_STATE);
        }
        SaveServiceHelper.update((DynamicObject[])billImageMap);
        threadPool.execute(() -> {
            for (DynamicObject billImage : billImageMap) {
                String imageNo = billImage.getString("imagenumber");
                String remark = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5e9f\u5f03\uff0c\u540c\u6b65\u5e9f\u5f03\u5f71\u50cf\u4fe1\u606f", (String)"ImageServiceImpl_2", (String)"bos-image-formplugin", (Object[])new Object[0]);
                NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
                destroyInfo.setImageNo(imageNo);
                destroyInfo.setMessage(remark);
                destroyInfo.setOpreatePerson(String.valueOf(RequestContext.get().getCurrUserId()));
                destroyInfo.setUseraccount(String.valueOf(RequestContext.get().getCurrUserId()));
                destroyInfo.setUsername(RequestContext.get().getUserName());
                destroyInfo.setOrgId(billImage.getString("creatororgid"));
                try {
                    NoticeImageSysFactory.getInstance().destroyImage(destroyInfo);
                }
                catch (Exception e) {
                    log.error("\u5f71\u50cf\u7cfb\u7edf\u5220\u9664\u5f71\u50cf\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void asynStartWorkFlow(String number, List<DynamicObject> imageInfoList) {
        if (ImageSysEnum.GXHC.getValue().equals(number) && imageInfoList.size() > 0) {
            threadPool.execute(() -> {
                for (DynamicObject imageInfo : imageInfoList) {
                    this.startWorkFlow(imageInfo.getString("imagenumber"), imageInfo.getString("creatororgid"), RequestContext.get().getUserName(), imageInfo.getString("creator"), imageInfo.getString("billnumber"), imageInfo.getString("billtype"));
                }
            });
        }
    }

    private void informCreator(String billno, String creator) {
        MessageInfo messageInfo = new MessageInfo();
        String contentValue = String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u4fe1\u606f\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5370\u5c01\u9762\u3001\u626b\u63cf\u4e0a\u4f20\u5f71\u50cf", (String)"ImageServiceImpl_7", (String)"bos-image-formplugin", (Object[])new Object[0]), billno);
        LocaleString content = new LocaleString();
        content.setLocaleValue_zh_CN(contentValue);
        content.setLocaleValue_zh_TW(contentValue);
        content.setLocaleValue_en(contentValue);
        LocaleString title = new LocaleString();
        title.setLocaleValue_zh_CN(contentValue);
        title.setLocaleValue_zh_TW(contentValue);
        title.setLocaleValue_en(contentValue);
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(Long.valueOf(creator));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u901a\u77e5", (String)"ImageServiceImpl_17", (String)"bos-image-formplugin", (Object[])new Object[0]));
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(receivers);
        messageInfo.setSendTime(new Date());
        messageInfo.setType("message");
        messageInfo.setMessageTag((ILocaleString)tag);
        messageInfo.setNotifyType(MessageChannels.MC.getNumber());
        Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private String produceRandomCode(boolean isRandom) {
        if (!isRandom) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        str = str.append((char)(65 + new SecureRandom().nextInt(26)));
        str = str.append((char)(65 + new SecureRandom().nextInt(26)));
        return str.append('-').toString();
    }

    public ImageInfo getImageInfoInside(ImageInfo imageInfo) {
        ImageInfo resultImageInfo = new ImageInfo();
        DynamicObject imageResult = null;
        if (StringUtils.isNotEmpty((CharSequence)imageInfo.getImageNo())) {
            QFilter filter = new QFilter("imagenumber", "=", (Object)imageInfo.getImageNo());
            QFilter[] qFilters = new QFilter[]{filter};
            imageResult = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])qFilters);
            if (imageResult == null) {
                return null;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)imageInfo.getBillId())) {
            QFilter filter = new QFilter("billid", "=", (Object)imageInfo.getBillId());
            QFilter[] qFilters = new QFilter[]{filter};
            imageResult = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])qFilters);
            if (imageResult == null) {
                return null;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)imageInfo.getBillNo())) {
            QFilter filter = new QFilter("billnumber", "=", (Object)imageInfo.getBillNo());
            QFilter[] qFilters = new QFilter[]{filter};
            imageResult = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"billid,imagenumber,billtype,imagestate,scanclientip,scanuserid,wfprocessingid,creatororgid,creator,createtime,billnumber,needimagescan", (QFilter[])qFilters);
            if (imageResult == null) {
                return null;
            }
        } else {
            return null;
        }
        resultImageInfo.setBillId(imageResult.getString("billid"));
        resultImageInfo.setBillNo(imageResult.getString("billnumber"));
        resultImageInfo.setBilltype(imageResult.getString("billtype"));
        resultImageInfo.setCreator(imageResult.getString("creator"));
        resultImageInfo.setImageNo(imageResult.getString("imagenumber"));
        resultImageInfo.setOrgId(imageResult.getString("creatororgid"));
        resultImageInfo.setProcessingId(imageResult.getString("wfprocessingid"));
        resultImageInfo.setImageState(imageResult.getString("imagestate"));
        resultImageInfo.setScanclientip(imageResult.getString("scanclientip"));
        resultImageInfo.setScanuserId(imageResult.getString("scanuserid"));
        resultImageInfo.setCreatetime(imageResult.getDate("createtime"));
        resultImageInfo.setImageScan(imageResult.getString(NEEDIMAGESCAN));
        return resultImageInfo;
    }

    public void CreateImageInfoBatchAsyn(List<ImageInfo> imageInfoList) {
        this.createImageInfoBatch(imageInfoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushImageInfoAsyn(Map<String, ImageInfo> billImageInfoMap) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.imageplatform.service.createImageAsyn");){
            pub.publish(billImageInfoMap);
        }
    }

    private Map<String, Object> buildMap(DynamicObject obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SynEasImageMap", "SynEasImageMap");
        map.put("billid", obj.getString("billid"));
        map.put("billnumber", obj.get("billnumber"));
        map.put("billtype", obj.get("billtype"));
        map.put("imagenumber", obj.get("imagenumber"));
        map.put("imagestate", obj.get("imagestate"));
        map.put("creator", obj.get("creator"));
        map.put("createtime", obj.get("createtime"));
        map.put("modifier", obj.get("modifier"));
        map.put("modifytime", obj.get("modifytime"));
        map.put("creatororgid", obj.get("creatororgid"));
        return map;
    }

    private void deleteData(String table, QFilter filter) {
        QFilter[] qFilters = new QFilter[]{filter};
        BusinessDataWriter.delete((String)table, (QFilter[])qFilters);
    }

    public void deleteImageRetry(int day) {
        NoticeImageSysHelper instance = null;
        try {
            instance = NoticeImageSysFactory.getInstance();
        }
        catch (Exception e) {
            return;
        }
        QFilter compensateTimeFilter = new QFilter("createtime", ">=", (Object)new Date(System.currentTimeMillis() - (long)day * 86400000L));
        QFilter operationFilter = new QFilter("operation", "=", (Object)SUCCESS);
        QFilter retryCountFilter = new QFilter("retrycount", "<", (Object)1);
        QFilter failedFilter = new QFilter("retryresult", "=", (Object)FAIL);
        DynamicObject[] imageErrorInfos = BusinessDataServiceHelper.load((String)"bas_imageerrorinfo", (String)"id,imagenumber,creator,imageid,retrycount,retryresult", (QFilter[])new QFilter[]{compensateTimeFilter, operationFilter, retryCountFilter, failedFilter});
        if (imageErrorInfos != null && imageErrorInfos.length > 0) {
            Map errorInfoMap = Arrays.stream(imageErrorInfos).collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("imagenumber"), Function.identity()));
            Set<String> imageNumberSet = errorInfoMap.keySet();
            HashMap<String, Boolean> delResultMap = new HashMap<String, Boolean>(16);
            QFilter imageNumberFilter = new QFilter("imagenumber", "in", imageNumberSet);
            DynamicObjectCollection billImageMapCollection = QueryServiceHelper.query((String)"task_billimagemap", (String)"id,imagenumber", (QFilter[])new QFilter[]{imageNumberFilter});
            if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
                for (DynamicObject dynamicObject2 : billImageMapCollection) {
                    String imageNumber = dynamicObject2.getString("imagenumber");
                    String imageId = dynamicObject2.getString("id");
                    if (!imageId.equals(((DynamicObject)errorInfoMap.get(imageNumber)).getString("imageid"))) continue;
                    delResultMap.put(imageNumber, false);
                    errorInfoMap.remove(imageNumber);
                    log.info(imageNumber + "\u5b58\u5728\u4e14fid\u4e00\u6837\uff0c\u4e0d\u8fdb\u884c\u5220\u9664");
                }
            }
            for (Map.Entry entry : errorInfoMap.entrySet()) {
                DynamicObject errorInfo = (DynamicObject)entry.getValue();
                String imageNumber = errorInfo.getString("imagenumber");
                String userName = errorInfo.getDynamicObject("creator").getString("name");
                boolean result = this.deleteImageRetry(instance, userName, imageNumber);
                delResultMap.put(imageNumber, result);
            }
            for (DynamicObject errorInfo : imageErrorInfos) {
                String imageNumber = errorInfo.getString("imagenumber");
                boolean retryResult = delResultMap.get(imageNumber) != null && (Boolean)delResultMap.get(imageNumber) != false;
                errorInfo.set("retryresult", (Object)(retryResult ? 1 : 0));
                errorInfo.set("retrycount", (Object)1);
            }
            SaveServiceHelper.update((DynamicObject[])imageErrorInfos);
        }
    }

    public Map<String, Object> synHeteroGeneImageInfo(String sourceSys, String heteroGeneId, String imageNumber, String imageState) {
        DynamicObject billImageInfo;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        if (!ArrayUtils.contains((Object[])LEGAL_STATUS, (Object)imageState)) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("code", "bos-image.100001");
            resultMap.put("msg", ResManager.loadKDString((String)"\u5f71\u50cf\u72b6\u6001\u53ef\u9009\u503c\u4e3a0,2,3,4", (String)"ImageServiceImpl_27", (String)"bos-image-formplugin", (Object[])new Object[0]));
            return resultMap;
        }
        BillImageFacade billImageFacade = new BillImageFacade();
        DynamicObject[] billImageInfoByImageNo = billImageFacade.getMapObjbyImageNo(imageNumber);
        if (billImageInfoByImageNo != null && billImageInfoByImageNo.length > 0 && !heteroGeneId.equals((billImageInfo = billImageInfoByImageNo[0]).getString("heterogeneid"))) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("code", "bos-image.100002");
            resultMap.put("msg", ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\u5df2\u5b58\u5728", (String)"ImageServiceImpl_28", (String)"bos-image-formplugin", (Object[])new Object[0]));
            return resultMap;
        }
        String billId = null;
        try (DLock dLock = DLock.create((String)(ERP_SYNC_IMAGE_LOCK + heteroGeneId)).fastMode();){
            if (dLock.tryLock(5000L)) {
                DynamicObject billImageInfo2 = billImageFacade.getBillImageMapByHeteroGeneId(heteroGeneId);
                if (billImageInfo2 == null) {
                    log.info(heteroGeneId + "\u5728\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868\u4e2d\u4e0d\u5b58\u5728\u6570\u636e");
                    billImageInfo2 = BusinessDataServiceHelper.newDynamicObject((String)"task_billimagemap");
                    billImageInfo2.set("heteroGeneId", (Object)heteroGeneId);
                    billImageInfo2.set("imagenumber", (Object)imageNumber);
                    billImageInfo2.set("imagestate", (Object)imageState);
                    billImageInfo2.set("creator", (Object)RequestContext.get().getCurrUserId());
                    billImageInfo2.set("createbyxh", (Object)Boolean.FALSE);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{billImageInfo2});
                } else {
                    String billNo = billImageInfo2.getString("billnumber");
                    String oldImageNumber = billImageInfo2.getString("imagenumber");
                    String fbillId = billImageInfo2.getString("billid");
                    String oldImageState = billImageInfo2.getString("imagestate");
                    log.info("\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868\u4e2d\uff0c\u5355\u636eid = " + fbillId + "\uff0c\u5f71\u50cf\u72b6\u6001\u4e3a\uff1a" + oldImageState + "\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + billNo + "\uff0c\u5f71\u50cf\u7f16\u7801\u4e3a\uff1a" + oldImageNumber);
                    billImageInfo2.set("imagestate", (Object)imageState);
                    billImageInfo2.set("imagenumber", (Object)imageNumber);
                    SaveServiceHelper.update((DynamicObject)billImageInfo2);
                    billId = fbillId;
                    this.writeBack2Bill(billImageInfo2, imageNumber, imageState);
                }
            } else {
                log.warn("\u83b7\u53d6\u540c\u6b65ERP\u7684\u5206\u5e03\u5f0f\u9501\u8d85\u65f6\uff0c\u5f02\u6784\u5355\u636eid = " + heteroGeneId);
            }
        }
        if (StringUtils.isNotEmpty(billId)) {
            if ("2".equals(imageState) || "4".equals(imageNumber)) {
                dLock = DLock.create((String)("/bos/image/imageReady//" + billId)).fastMode();
                var10_11 = null;
                try {
                    if (dLock.tryLock(5000L) && (billImageInfo2 = billImageFacade.getBillImageMapByBillId(billId)) != null) {
                        this.pushWorkFlow(billImageInfo2);
                    }
                }
                catch (Throwable throwable) {
                    var10_11 = throwable;
                    throw throwable;
                }
                finally {
                    if (dLock != null) {
                        if (var10_11 != null) {
                            try {
                                dLock.close();
                            }
                            catch (Throwable throwable) {
                                var10_11.addSuppressed(throwable);
                            }
                        } else {
                            dLock.close();
                        }
                    }
                }
                try {
                    HashMap<String, ImageInfo> sscParams = new HashMap<String, ImageInfo>(4);
                    ImageInfo sscImageInfo = new ImageInfo();
                    sscImageInfo.setBillId(billId);
                    sscImageInfo.setScanuserId(RequestContext.get().getRequestId());
                    sscParams.put(billId, sscImageInfo);
                    DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"uploadImage", (Object[])new Object[]{sscParams});
                }
                catch (Exception e) {
                    log.error("\u901a\u77e5\u5171\u4eab\u72b6\u6001\u53d8\u66f4\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                }
            } else if ("3".equals(imageState)) {
                new SSCImageHandler().updateTask2Rescan(billId);
            }
        }
        resultMap.put("success", Boolean.TRUE);
        return resultMap;
    }

    public Map<String, Object> delHeteroGeneImageInfo(String heteroGeneId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        log.info("\u8c03\u7528\u5220\u9664\u5f02\u6784\u5f71\u50cf\u4fe1\u606f\u63a5\u53e3\uff0c\u4e0a\u4e0b\u6587\u7528\u6237\uff1a" + RequestContext.get().getUserName() + "\uff0c\u5f02\u6784\u5355\u636eid = " + heteroGeneId);
        boolean exists = QueryServiceHelper.exists((String)"task_billimagemap", (QFilter[])new QFilter[]{new QFilter("heterogeneid", "=", (Object)heteroGeneId)});
        if (!exists) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("code", "bos-image.100003");
            resultMap.put("msg", ResManager.loadKDString((String)"\u5f02\u6784\u5355\u636eid\u4e0d\u5b58\u5728", (String)"ImageServiceImpl_30", (String)"bos-image-formplugin", (Object[])new Object[0]));
            return resultMap;
        }
        int delete = DeleteServiceHelper.delete((String)"task_billimagemap", (QFilter[])new QFilter[]{new QFilter("heterogeneid", "=", (Object)heteroGeneId)});
        log.info("\u5220\u9664\u7ed3\u679c\uff1a" + delete);
        resultMap.put("success", Boolean.TRUE);
        return resultMap;
    }

    private String updateImagestateIntoRescan(DynamicObject image) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            image.set("modifytime", (Object)sdf.parse(sdf.format(new Date())));
        }
        catch (ParseException e) {
            log.error((Throwable)e);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{image});
        return image.getString("billid");
    }

    private static void copy(Object source, Object dest) {
        try {
            BeanInfo sourceBean = Introspector.getBeanInfo(source.getClass(), Object.class);
            PropertyDescriptor[] sourceProperty = sourceBean.getPropertyDescriptors();
            BeanInfo destBean = Introspector.getBeanInfo(dest.getClass(), Object.class);
            PropertyDescriptor[] destProperty = destBean.getPropertyDescriptors();
            block2: for (int i = 0; i < sourceProperty.length; ++i) {
                for (int j = 0; j < destProperty.length; ++j) {
                    if (!sourceProperty[i].getName().equals(destProperty[j].getName()) || sourceProperty[i].getPropertyType() != destProperty[j].getPropertyType()) continue;
                    destProperty[j].getWriteMethod().invoke(dest, sourceProperty[i].getReadMethod().invoke(source, new Object[0]));
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            log.error("\u5c5e\u6027\u590d\u5236\u5931\u8d25:" + e.getMessage());
        }
    }

    private void transferredXml(SendImageInfo sendImageInfo) {
        sendImageInfo.setApplierEmail(this.escapeXMLSpecialChar(sendImageInfo.getApplierEmail()));
        sendImageInfo.setApplierName(this.escapeXMLSpecialChar(sendImageInfo.getApplierName()));
        sendImageInfo.setImageNo(this.escapeXMLSpecialChar(sendImageInfo.getImageNo()));
        sendImageInfo.setBillNumber(this.escapeXMLSpecialChar(sendImageInfo.getBillNumber()));
        sendImageInfo.setBilltype(this.escapeXMLSpecialChar(sendImageInfo.getBilltype()));
        sendImageInfo.setApplierCompany(this.escapeXMLSpecialChar(sendImageInfo.getApplierCompany()));
        sendImageInfo.setImageLocationNo(this.escapeXMLSpecialChar(sendImageInfo.getImageLocationNo()));
        if (sendImageInfo instanceof FpySendImageInfo) {
            FpySendImageInfo fpySendImageInfo = (FpySendImageInfo)sendImageInfo;
            fpySendImageInfo.setApplierUserName(this.escapeXMLSpecialChar(fpySendImageInfo.getApplierUserName()));
            fpySendImageInfo.setBillTypeName(this.escapeXMLSpecialChar(fpySendImageInfo.getBillTypeName()));
            fpySendImageInfo.setApplierCompanyNum(this.escapeXMLSpecialChar(fpySendImageInfo.getApplierCompanyNum()));
        }
    }

    private String escapeXMLSpecialChar(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        value = value.replace("&", "&amp;");
        value = value.replace("<", "&lt;");
        value = value.replace(">", "&gt;");
        value = value.replace("\"", "&quot;");
        value = value.replace("'", "&apos;");
        return value;
    }

    private static Map<String, HashSet<Long>> getVocherDirectRelationBill(Long vchId) {
        QFilter vchIdFilter = new QFilter("voucherid", "=", (Object)vchId);
        DynamicObjectCollection directSrcBillRelationDynColl = QueryServiceHelper.query((String)"ai_daptracker", (String)String.join((CharSequence)",", "billtype", "sourcebillid"), (QFilter[])vchIdFilter.toArray());
        return directSrcBillRelationDynColl.stream().collect(Collectors.groupingBy(x -> x.getString("billtype"), LinkedHashMap::new, Collectors.mapping(x -> x.getLong("sourcebillid"), Collectors.toCollection(HashSet::new))));
    }

    private void writeBack2Bill(DynamicObject billImageInfo, String imageNumber, String imageState) {
        String billId = billImageInfo.getString("billid");
        if (StringUtil.isEmpty((String)billId)) {
            return;
        }
        String billType = billImageInfo.getString("billtype");
        String fieldMapString = billImageInfo.getString("billfieldmap");
        if (StringUtil.isEmpty((String)fieldMapString)) {
            return;
        }
        String imageNumberKey = null;
        String imageStateKey = null;
        try {
            String[] split;
            fieldMapString = fieldMapString.substring(1, fieldMapString.length() - 1);
            for (String element : split = fieldMapString.split(",")) {
                String[] keyValue = element.split("=");
                String key = keyValue[0].trim();
                if (key.equals("imagenumber")) {
                    imageNumberKey = keyValue[1].trim();
                    continue;
                }
                if (!key.equals("imagestatus")) continue;
                imageStateKey = keyValue[1].trim();
            }
        }
        catch (Exception e) {
            log.info("\u89e3\u6790\u5b57\u6bb5\u6620\u5c04\u5f02\u5e38\uff1a" + e);
        }
        log.info("imageNumberKey = " + imageNumberKey + "\uff0c imageStateKey = " + imageStateKey);
        if (!StringUtil.isEmpty(imageNumberKey) || !StringUtils.isEmpty(imageStateKey)) {
            DynamicObject billInfo = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(billId), (String)billType);
            if (!StringUtils.isEmpty(imageNumberKey)) {
                billInfo.set(imageNumberKey, (Object)imageNumber);
            }
            if (!StringUtils.isEmpty(imageStateKey)) {
                billInfo.set(imageStateKey, (Object)imageState);
            }
            try (TXHandle txHandle = TX.requiresNew((String)"apiWriteBackBillInfo");){
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{billInfo});
            }
        }
    }
}

