/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.util;

import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.fs.util.StringUtils;
import kd.bos.imageplatform.helper.NoticeImageSysFactory;
import kd.bos.imageplatform.pojo.NoticeImageSys2RescanInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysDestroyInfo;
import kd.bos.imageplatform.pojo.NoticeImageSysViewInfo;
import kd.bos.imageplatform.util.TaskInterUtils;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BillImageFacade {
    private static final Log log = LogFactory.getLog(BillImageFacade.class);
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String TASK_BILLIMAGEMAP = "task_billimagemap";
    private static final String BILL_ID = "billid";
    private static final String BILL_TYPE = "billType";
    private static final String ID_IMAGENUMBER = "id,imagenumber";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String TASK_BILLIMAGEMAP_FIELD = "id,billid,billtype,imagenumber,scanuserid,imagestate,creator,wfprocessingid,enternodetime,scanclientip,scantime,pagecount,sscunitid,modifier,creatororgid,billnumber,modifytime,heterogeneid,billfieldmap,createtime,nextscanuserid";

    public DynamicObject[] getMapObjbyImageNo(String imageNo) throws KDException {
        QFilter filter = new QFilter(IMAGE_NUMBER, "=", (Object)imageNo);
        QFilter[] filters = new QFilter[]{filter};
        return BusinessDataServiceHelper.load((String)TASK_BILLIMAGEMAP, (String)TASK_BILLIMAGEMAP_FIELD, (QFilter[])filters);
    }

    public boolean deleteImageSystemData(String bosType, String billID, boolean isImageSystem) throws KDException {
        boolean destroyImageResult = false;
        String imageNo = null;
        try {
            String remark = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5df2\u5220\u9664\uff0c\u540c\u6b65\u5220\u9664\u5f71\u50cf\u4fe1\u606f\uff01", (String)"BillImageFacade_0", (String)"bos-image-formplugin", (Object[])new Object[0]);
            String userName = RequestContext.get().getUserName();
            NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
            ORM orm = ORM.create();
            DynamicObject obj = orm.newDynamicObject(TASK_BILLIMAGEMAP);
            QFilter filter = new QFilter(BILL_ID, "=", (Object)billID);
            QFilter filter2 = new QFilter(BILL_TYPE, "=", (Object)bosType);
            QFilter[] filters = new QFilter[]{filter, filter2};
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_BILLIMAGEMAP, ID_IMAGENUMBER, filters);){
                DynamicObjectCollection collection = orm.toPlainDynamicObjectCollection(ds);
                imageNo = ((DynamicObject)collection.get(0)).getString(IMAGE_NUMBER);
            }
            destroyInfo.setImageNo(imageNo);
            destroyInfo.setMessage(remark);
            destroyInfo.setOpreatePerson(userName);
            String result = NoticeImageSysFactory.getInstance().destroyImage(destroyInfo);
            if ("1".equals(result) || "-1".equals(result)) {
                destroyImageResult = true;
            }
        }
        catch (Exception e) {
            log.error("deleteImageSystemData Exception");
        }
        return destroyImageResult;
    }

    public String getImageNumberByBillId(long bosType, String billID) throws KDException {
        String imageNumber = null;
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject(TASK_BILLIMAGEMAP);
        QFilter filter = new QFilter(BILL_ID, "=", (Object)billID);
        QFilter filter2 = new QFilter(BILL_TYPE, "=", (Object)bosType);
        QFilter[] filters = new QFilter[]{filter, filter2};
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_BILLIMAGEMAP, ID_IMAGENUMBER, filters, "createtime desc");){
            DynamicObjectCollection collection = orm.toPlainDynamicObjectCollection(ds);
            if (collection.size() > 0) {
                obj = (DynamicObject)collection.get(0);
                imageNumber = obj.getString("imageNumber");
            }
        }
        return imageNumber;
    }

    public String imageRescen(String bosType, String billid, String billNumber, long operateID, String reScanMsg, int taskid) throws Exception {
        boolean falg = true;
        try {
            falg = new TaskInterUtils().isTaskCanRescan(bosType, billid, taskid);
        }
        catch (Exception e) {
            throw new KDException(e.toString());
        }
        if (!falg) {
            throw new KDException(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u5ba1\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u9000\u56de\u91cd\u626b\uff01", (String)"BillImageFacade_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        ORM orm = ORM.create();
        DynamicObject obj = orm.newDynamicObject(TASK_BILLIMAGEMAP);
        QFilter filter = new QFilter(BILL_ID, "=", (Object)billid);
        QFilter filter2 = new QFilter(BILL_TYPE, "=", (Object)bosType);
        QFilter[] filters = new QFilter[]{filter, filter2};
        String imageNo = "";
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_BILLIMAGEMAP, ID_IMAGENUMBER, filters);){
            DynamicObjectCollection collection = orm.toPlainDynamicObjectCollection(ds);
            imageNo = ((DynamicObject)collection.get(0)).getString(IMAGE_NUMBER);
        }
        if (StringUtils.isEmpty((String)imageNo)) {
            throw new KDException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a[%1$s] \u4e0d\u5b58\u5728\u5f71\u50cf\u7f16\u7801\u4fe1\u606f\u3002", (String)"BillImageFacade_3", (String)"bos-image-formplugin", (Object[])new Object[0]), billNumber));
        }
        NoticeImageSys2RescanInfo rescanInfo = new NoticeImageSys2RescanInfo();
        rescanInfo.setBarCode(imageNo);
        rescanInfo.setRescanPerson(operateID);
        rescanInfo.setRescanMessage(reScanMsg);
        String noticeReturn = NoticeImageSysFactory.getInstance().rescan(rescanInfo);
        if (!"1".equals(noticeReturn)) {
            throw new KDException(ResManager.loadKDString((String)"\u901a\u77e5\u5f71\u50cf\u7cfb\u7edf\u91cd\u626b\u8fd4\u56de\u5931\u8d25\uff01", (String)"BillImageFacade_2", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        log.error("\u8c03\u7528\u9000\u626b\u5b8c\u6210!");
        return "1";
    }

    public String createImagePaths(String imageNumber, String billType, String userAccount, String userName) throws Exception {
        String result = "";
        NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
        viewPhotoInfo = new NoticeImageSysViewInfo();
        viewPhotoInfo.setBarCode(imageNumber);
        viewPhotoInfo.setViewPersonName(userName);
        viewPhotoInfo.setViewUserNumber(userAccount);
        viewPhotoInfo.setType(billType);
        result = NoticeImageSysFactory.getInstance().viewPhoto(viewPhotoInfo);
        return result;
    }

    public String createImagePathsByBillID(String billID, String billType, String userAccount, String userName) throws Exception {
        String result = null;
        ORM orm = ORM.create();
        DynamicObject mapInfo = orm.newDynamicObject(TASK_BILLIMAGEMAP);
        QFilter Filter = new QFilter(BILL_ID, "=", (Object)billID);
        QFilter Filter2 = new QFilter("billtype", "=", (Object)billType);
        QFilter[] Filters = new QFilter[]{Filter, Filter2};
        DynamicObjectCollection Collection2 = orm.query(TASK_BILLIMAGEMAP, "id,billid,billtype", Filters);
        if (Collection2 == null || Collection2.size() == 0) {
            BizLog.log((String)"createImagePathsByBillID cannot getBillImageMapCollection by idSet");
        } else {
            String imageNumber = null;
            mapInfo = (DynamicObject)Collection2.get(0);
            imageNumber = mapInfo.getString(IMAGE_NUMBER);
            result = this.createImagePaths(imageNumber, billType, userAccount, userName);
        }
        return result;
    }

    public void addnewMapInfo(HashMap map) {
        try {
            ORM orm = ORM.create();
            DynamicObject obj = orm.newDynamicObject(TASK_BILLIMAGEMAP);
            QFilter filter = new QFilter(IMAGE_NUMBER, "=", map.get(IMAGE_NUMBER));
            QFilter[] filters = new QFilter[]{filter};
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_BILLIMAGEMAP, "id,billid,imagenumber,imagestate,creator,createtime,modifier,modifytime", filters);){
                DynamicObjectCollection collection = orm.toPlainDynamicObjectCollection(ds);
                obj.set(BILL_ID, map.get(BILL_ID));
                obj.set(IMAGE_NUMBER, map.get(IMAGE_NUMBER));
                obj.set("imagestate", map.get("imagestate"));
                obj.set("creator", map.get("creator"));
                obj.set("createtime", map.get("createtime"));
                obj.set("modifier", map.get("lastupdateuser"));
                obj.set("modifytime", map.get("lastupdatetime"));
                if (collection.size() == 0) {
                    orm.insert(obj);
                } else if (collection.size() > 0) {
                    orm.update(obj);
                }
            }
            log.error("\u8c03\u7528addnewMapInfo\u6210\u529f,\u5355\u636eID:" + map.get(BILL_ID) + "  ,\u5f71\u50cf\u7f16\u7801:" + map.get(IMAGE_NUMBER));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528addnewMapInfo\u51fa\u9519,\u5355\u636eID:" + map.get(BILL_ID) + "  ,\u5f71\u50cf\u7f16\u7801:" + map.get(IMAGE_NUMBER) + "  ,\u51fa\u9519\u539f\u56e0:" + e.getMessage());
        }
    }

    public void updateStateAndNoticEAS() {
    }

    public DynamicObject[] getBillImageMapByImageNoSet(Set<String> imageNos) {
        QFilter imageNoFilter = new QFilter(IMAGE_NUMBER, "in", imageNos);
        return BusinessDataServiceHelper.load((String)TASK_BILLIMAGEMAP, (String)TASK_BILLIMAGEMAP_FIELD, (QFilter[])new QFilter[]{imageNoFilter});
    }

    public DynamicObject getBillImageMapByHeteroGeneId(String heteroGeneId) {
        QFilter heteroGeneFilter = new QFilter("heterogeneid", "=", (Object)heteroGeneId);
        return BusinessDataServiceHelper.loadSingle((String)TASK_BILLIMAGEMAP, (String)TASK_BILLIMAGEMAP_FIELD, (QFilter[])new QFilter[]{heteroGeneFilter});
    }

    public DynamicObject getBillImageMapByBillId(String billId) {
        QFilter heteroGeneFilter = new QFilter("billId", "=", (Object)billId);
        return BusinessDataServiceHelper.loadSingle((String)TASK_BILLIMAGEMAP, (String)TASK_BILLIMAGEMAP_FIELD, (QFilter[])new QFilter[]{heteroGeneFilter});
    }
}

