/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.imageplatform.pojo.BaseImageInfo;
import kd.bos.imageplatform.pojo.BaseImageList;
import kd.bos.imageplatform.pojo.ImageReturnCode;
import kd.bos.imageplatform.pojo.ImageStateParamInfo;
import kd.bos.imageplatform.pojo.ReceiveImageInfo;
import kd.bos.imageplatform.pojo.SendImageInfo;
import kd.bos.imageplatform.util.BillImageFacade;
import kd.bos.imageplatform.util.TaskInterUtils;
import kd.bos.imageplatform.util.WorkDateUtil;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SSCImageHandler {
    public static final String EXISTS_IMAGES = "Exists";
    public static final String IMAGE_ALLOW_SCAN = "AllowScan";
    public static final String IMAGE_READY = "1";
    public static final String SUCCESS = "1";
    public static final String FAIL = "0";
    private static final Log log = LogFactory.getLog(SSCImageHandler.class);
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String BILL_TYPE = "billtype";
    private static final String IMAGE_STATE = "imagestate";
    private static final String TASK_BILLIMAGEMAP = "task_billimagemap";
    private static final String SSCIMAGE_HANDLER_2 = "SSCImageHandler_2";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String BILL_ID = "billid";

    public SendImageInfo getImageInfo(DynamicObject mapObj) {
        log.info("SSCImageHandler.getImageInfo-start: mapObj" + mapObj);
        String creator = mapObj.getString("creator");
        SendImageInfo sendImageInfo = new SendImageInfo();
        DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)creator, (String)"bos_user");
        if (userObject != null) {
            String phone = userObject.getString("phone");
            String email = userObject.getString("email");
            String name = userObject.getString("name");
            sendImageInfo.setApplierPhone(phone);
            sendImageInfo.setApplierEmail(email);
            sendImageInfo.setApplierName(name);
        }
        sendImageInfo.setBillNo(mapObj.getString(BILL_ID));
        sendImageInfo.setImageNo(mapObj.getString(IMAGE_NUMBER));
        sendImageInfo.setBillNumber(mapObj.getString("billnumber"));
        sendImageInfo.setImageExists(EXISTS_IMAGES);
        sendImageInfo.setApplier(creator);
        sendImageInfo.setBilltype(mapObj.getString(BILL_TYPE));
        sendImageInfo.setApplierCompany("");
        sendImageInfo.setErpDataId(RequestContext.get().getAccountId());
        sendImageInfo.setSelfCreated(String.valueOf(mapObj.getBoolean("createbyxh")));
        if (FAIL.equals(mapObj.getString(IMAGE_STATE)) || "3".equals(mapObj.getString(IMAGE_STATE))) {
            sendImageInfo.setImageAllowScan(IMAGE_ALLOW_SCAN);
        }
        log.info("SSCImageHandler.getImageInfo-end: imageInfo" + sendImageInfo);
        return sendImageInfo;
    }

    public void buildBillImageInfo(DynamicObject billImage, BaseImageInfo imageReadyInfo) {
        ReceiveImageInfo receiveImageInfo = (ReceiveImageInfo)imageReadyInfo;
        if (receiveImageInfo != null) {
            String scanUserId = receiveImageInfo.getScanUserID();
            if (StringUtils.isBlank((CharSequence)scanUserId)) {
                scanUserId = "null";
            }
            if (scanUserId.contains("((()))")) {
                scanUserId = scanUserId.substring(0, scanUserId.indexOf("((()))"));
            }
            billImage.set("scanuserid", (Object)scanUserId);
            billImage.set("scanclientip", (Object)receiveImageInfo.getScanClientIP());
            int pageCount = receiveImageInfo.getPageCount();
            if (pageCount > 0) {
                billImage.set("pagecount", (Object)pageCount);
            }
            String sscUnit = receiveImageInfo.getScanClientIP();
            long sscUnitId = 0L;
            try {
                sscUnitId = this.getSSCUnitByName(sscUnit);
            }
            catch (Exception e) {
                log.error("\u4e0d\u5b58\u5728\u540d\u4e3a\u3010" + sscUnit + "\u3011\u7684\u626b\u63cf\u70b9");
            }
            billImage.set("sscunitid", (Object)sscUnitId);
        }
        String imageState = billImage.getString(IMAGE_STATE);
        String targetImageState = "2";
        if ("3".equals(imageState)) {
            targetImageState = "4";
        }
        billImage.set(IMAGE_STATE, (Object)targetImageState);
        billImage.set("modifier", (Object)RequestContext.get().getCurrUserId());
        billImage.set("scantime", (Object)new Date());
        billImage.set("nextscanuserid", (Object)RequestContext.get().getCurrUserId());
    }

    public void minusCreditPointsByExpireImage(List<DynamicObject> billImageList) {
        List<Map<String, Object>> billImageMap = this.buildCalExpireParam(billImageList);
        try {
            this.minusCreditPoints(billImageMap);
        }
        catch (Exception e) {
            log.error("\u5f71\u50cf\u8d85\u671f\u4fe1\u7528\u6263\u5206\u5f02\u5e38\uff1a" + e);
        }
    }

    private List<Map<String, Object>> buildCalExpireParam(List<DynamicObject> billImageList) {
        Map billImageMap = billImageList.stream().collect(Collectors.toMap(d -> d.getString("billId"), Function.identity()));
        Set<String> billIds = billImageMap.keySet();
        ArrayList<Map<String, Object>> calList = new ArrayList<Map<String, Object>>(billImageList.size());
        QFilter businessKeyFilter = new QFilter("businesskey", "in", billIds);
        QFilter categoryFilter = new QFilter("category", "=", (Object)"SSCImageUploadNew");
        DynamicObjectCollection wfTask = QueryServiceHelper.query((String)"wf_task", (String)"id,businesskey,createdate", (QFilter[])new QFilter[]{businessKeyFilter, categoryFilter});
        if (!wfTask.isEmpty()) {
            for (DynamicObject dynamicObject : wfTask) {
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                String billId = dynamicObject.getString("businesskey");
                param.put("billId", billId);
                DynamicObject billImage = (DynamicObject)billImageMap.get(billId);
                param.put("billType", billImage.getString(BILL_TYPE));
                Date enterNodeTime = billImage.getDate("enternodetime");
                if (enterNodeTime == null) {
                    enterNodeTime = dynamicObject.getDate("createdate");
                    billImage.set("enternodetime", (Object)enterNodeTime);
                    billImage.set("wfprocessingid", dynamicObject.get("id"));
                    log.info(billId + "\u8fdb\u5165\u8282\u70b9\u65f6\u95f4\u4e3a\u7a7a\uff0c\u5199\u56de\u5f71\u50cf\u6620\u5c04\u7ef4\u62a4\u8868enterNodeTime " + enterNodeTime);
                }
                param.put("calTime", enterNodeTime);
                param.put("orgId", billImage.getString("creatororgid"));
                param.put("billNo", billImage.getString("billnumber"));
                param.put("userId", billImage.getDynamicObject("creator").getPkValue());
                calList.add(param);
                billIds.remove(billId);
            }
        }
        if (billIds.isEmpty()) {
            return calList;
        }
        QFilter billIdFilter = new QFilter(BILL_ID, "in", billIds);
        QFilter poolTypeFilter = new QFilter("pooltype", "=", (Object)"3");
        DynamicObjectCollection sscTask = QueryServiceHelper.query((String)"task_task", (String)"billid,createtime", (QFilter[])new QFilter[]{billIdFilter, poolTypeFilter});
        Map<String, List<DynamicObject>> billTaskMap = sscTask.stream().collect(Collectors.groupingBy(d -> d.getString(BILL_ID)));
        for (Map.Entry<String, List<DynamicObject>> entry : billTaskMap.entrySet()) {
            String billId = entry.getKey();
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("billId", billId);
            DynamicObject billImage = (DynamicObject)billImageMap.get(billId);
            List<DynamicObject> tasks = entry.getValue();
            param.put("billType", billImage.getString(BILL_TYPE));
            param.put("orgId", billImage.getString("creatororgid"));
            param.put("billNo", billImage.getString("billnumber"));
            param.put("userId", billImage.getDynamicObject("creator").getPkValue());
            if (tasks == null || tasks.size() == 0) continue;
            Date calTime = tasks.get(0).getDate("createtime");
            for (DynamicObject d2 : tasks) {
                Date time = d2.getDate("createtime");
                if (calTime.compareTo(time) >= 0) continue;
                calTime = time;
            }
            param.put("calTime", calTime);
            calList.add(param);
            billIds.remove(billId);
        }
        if (!billIds.isEmpty()) {
            log.info(billIds + "\u5355\u636e\u4e0d\u5728\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9\u6216\u5171\u4eab\u4efb\u52a1\u5f85\u4e0a\u4f20\u5f71\u50cf\u8282\u70b9\uff0c\u4e0d\u6263\u5206\u3002");
        }
        return calList;
    }

    private void minusCreditPoints(List<Map<String, Object>> calExpireParam) throws Exception {
        HashMap<String, WorkDateUtil> orgWorkDateUtilMap = new HashMap<String, WorkDateUtil>(calExpireParam.size());
        Date startDate = new Date(1577808000000L);
        Date now = new Date();
        for (Map<String, Object> param : calExpireParam) {
            String billType = (String)param.get("billType");
            String billId = (String)param.get("billId");
            String userId = String.valueOf(param.get("userId"));
            String billNo = (String)param.get("billNo");
            String orgId = (String)param.get("orgId");
            Date calDate = (Date)param.get("calTime");
            if (StringUtils.isEmpty((CharSequence)(userId = this.queryCreditArgsUserId(billType, billId, userId)))) {
                log.error(String.format("minusCreditPoints error, billType:{%s}, billNo:{%s}", billType, billNo));
                continue;
            }
            int offset = 0;
            WorkDateUtil workDateUtil = (WorkDateUtil)orgWorkDateUtilMap.get(orgId);
            if (workDateUtil == null) {
                workDateUtil = WorkDateUtil.getInstance(Long.parseLong(orgId), startDate, now);
                if (workDateUtil != null) {
                    orgWorkDateUtilMap.put(orgId, workDateUtil);
                } else {
                    log.info(orgId + "\u65e0\u5de5\u4f5c\u65e5\u5386\uff0c\u4e0d\u8fdb\u884c\u4fe1\u7528\u6263\u5206");
                    continue;
                }
            }
            offset = workDateUtil.calWorkDayBetweenDay(calDate, now);
            log.info("\u5f71\u50cf\u5c31\u7eea\u8ba1\u7b97\u8d85\u671f\u5929\u6570\uff1acalDate = " + calDate + ", offset = " + offset);
            HashMap<String, String> serviceCallParam = new HashMap<String, String>();
            serviceCallParam.put("billId", billId);
            serviceCallParam.put("billNumber", billType);
            serviceCallParam.put("billNo", billNo);
            serviceCallParam.put("userId", userId);
            log.info("call minusCreditPoints, param:" + serviceCallParam);
            String json = SerializationUtils.toJsonString(serviceCallParam);
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"minusCreditPoints", (Object[])new Object[]{json, offset});
        }
    }

    private String queryCreditArgsUserId(String billType, String billId, String userId) {
        Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{billType, billId});
        if (userIdByAppObj == null) {
            return userId;
        }
        if (-1L == userIdByAppObj) {
            return "";
        }
        return userIdByAppObj + "";
    }

    private int computeHolidays(Date t1, Date t2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(t1);
        c2.setTime(t2);
        int count = 0;
        if (c1.compareTo(c2) > 0) {
            Calendar tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        while (c1.compareTo(c2) <= 0) {
            if (c1.get(7) == 1 || c1.get(7) == 7) {
                ++count;
            }
            c1.add(6, 1);
        }
        return count;
    }

    private long getSSCUnitByName(String sscUnitName) throws KDException {
        ORM orm = ORM.create();
        DynamicObject sscunitObj = orm.newDynamicObject("bos_sscunitlist");
        QFilter filter = new QFilter("name", "=", (Object)sscUnitName);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos_sscunitlist", (String)"id", (QFilter[])filters);
        if (collection != null && collection.size() > 0) {
            sscunitObj = (DynamicObject)collection.get(0);
        }
        return sscunitObj.getLong("id");
    }

    public void TaskCenterService(BaseImageList baseList) throws KDException {
        String imageNo = null;
        Object var3_3 = null;
        HashSet taskImageSet = new HashSet(16);
        ArrayList<ImageStateParamInfo> imageNoList = new ArrayList<ImageStateParamInfo>(10);
        BizLog.log((String)("*********taskImageSet.size:" + taskImageSet.size() + ",baseList.getImageList().size():" + baseList.getImageList().size()));
        if (taskImageSet.size() != baseList.getImageList().size()) {
            for (ImageStateParamInfo imageStateParamInfo : baseList.getImageList()) {
                imageNo = imageStateParamInfo.getImageNo();
                if (taskImageSet.contains(imageNo)) continue;
                imageNoList.add(imageStateParamInfo);
            }
        }
        String imageNoRes = new TaskInterUtils().updatJobIsImaStat(imageNoList, true);
        if (imageNo == null) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{ResManager.loadKDString((String)"imageNo\u4e3a\u7a7a", (String)"SSCImageHandler_0", (String)"bos-image-formplugin", (Object[])new Object[0])});
        }
        if (!imageNo.equals(imageNoRes)) {
            String message = "update SSC image state error!";
            BizLog.log((String)message);
        }
    }

    public void TaskCenterServiceRescan(BaseImageList baseList) {
        String imageNo = null;
        Object var3_3 = null;
        HashSet taskImageSet = new HashSet();
        ArrayList<ImageStateParamInfo> imageList = new ArrayList<ImageStateParamInfo>();
        BizLog.log((String)("*********taskImageSet.size:" + taskImageSet.size() + ",baseList.getImageList().size():" + baseList.getImageList().size()));
        if (taskImageSet.size() != baseList.getImageList().size()) {
            for (ImageStateParamInfo imageStateParamInfo : baseList.getImageList()) {
                imageNo = imageStateParamInfo.getImageNo();
                if (taskImageSet.contains(imageNo)) continue;
                imageList.add(imageStateParamInfo);
            }
        }
        String imageNoRes = new TaskInterUtils().updatJobIsImaStat(imageList, "2", false);
        if (imageNo == null) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{ResManager.loadKDString((String)"imageNo\u4e3a\u7a7a", (String)"SSCImageHandler_0", (String)"bos-image-formplugin", (Object[])new Object[0])});
        }
        if (!imageNo.equals(imageNoRes)) {
            String message = "update SSC image state error!";
            BizLog.log((String)message);
            throw new KDException(message);
        }
    }

    public DynamicObject[] buildBillImageInfoAndUpdateTask(HashMap<String, ImageStateParamInfo> imageNoMap) {
        DynamicObject[] noImageData = new BillImageFacade().getBillImageMapByImageNoSet(imageNoMap.keySet());
        HashMap<String, DynamicObject[]> billIdImageNumberMap = new HashMap<String, DynamicObject[]>(imageNoMap.size());
        for (DynamicObject billImage : noImageData) {
            DynamicObject[] imageNo = billImage.getString(IMAGE_NUMBER);
            ImageStateParamInfo imageStateParamInfo = imageNoMap.get(imageNo);
            String state = String.valueOf(imageStateParamInfo.getState());
            billImage.set(IMAGE_STATE, (Object)state);
            billImage.set("modifytime", (Object)new Date());
            billImage.set("modifier", (Object)RequestContext.get().getCurrUserId());
            billImage.set("scanuserid", (Object)imageStateParamInfo.getScanUserID());
            billImage.set("nextscanuserid", (Object)RequestContext.get().getCurrUserId());
            billIdImageNumberMap.put(billImage.getString(BILL_ID), imageNo);
        }
        DynamicObject[] tasks = null;
        if (billIdImageNumberMap.size() != 0) {
            QFilter filter = new QFilter(BILL_ID, "in", billIdImageNumberMap.keySet());
            tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"id,billid,billtype,tasktypeid,state,apprevalmessage,imagenumber,rescanopinion", (QFilter[])new QFilter[]{filter});
        }
        if (tasks == null || tasks.length == 0) {
            log.info("\u672a\u67e5\u8be2\u5230\u5355\u636e\u5bf9\u5e94\u7684\u4efb\u52a1\uff1a" + imageNoMap.keySet());
            return noImageData;
        }
        ArrayList<DynamicObject> changedTaskList = new ArrayList<DynamicObject>(tasks.length);
        ArrayList<DynamicObject> stateChangeList = new ArrayList<DynamicObject>(10);
        ORM orm = ORM.create();
        for (DynamicObject task : tasks) {
            Long userId;
            int taskState;
            int state;
            String billId = task.getString(BILL_ID);
            String imageNo = (String)billIdImageNumberMap.get(billId);
            ImageStateParamInfo imageStateParamInfo = imageNoMap.get(imageNo);
            if (imageStateParamInfo == null || (state = imageStateParamInfo.getState()) != 3 || (taskState = task.getInt("state")) != 7 && taskState != 13) continue;
            task.set("state", (Object)"2");
            task.set("rescanopinion", (Object)ResManager.loadKDString((String)"\u901a\u8fc7updateImageState.do\u63a5\u53e3\u8c03\u7528\u4fee\u6539", (String)"SSCImageHandler_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            changedTaskList.add(task);
            DynamicObject stateChangeobj = orm.newDynamicObject("task_statechange");
            stateChangeobj.set("message", (Object)ResManager.loadKDString((String)"\u901a\u8fc7updateImageState.do\u63a5\u53e3\u8c03\u7528\u4fee\u6539", (String)"SSCImageHandler_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            try {
                userId = Long.parseLong(imageStateParamInfo.getScanUserID());
            }
            catch (Exception e) {
                userId = Long.valueOf(RequestContext.get().getUserId());
            }
            stateChangeobj.set("operatorid", (Object)userId);
            stateChangeobj.set("operation", (Object)"5");
            stateChangeobj.set("changetime", (Object)new Timestamp(System.currentTimeMillis()));
            stateChangeobj.set("jobid", task.getPkValue());
            stateChangeobj.set("tasktype", (Object)task.getString("tasktypeid"));
            stateChangeobj.set(BILL_TYPE, (Object)task.getString(BILL_TYPE));
            stateChangeobj.set("oldjobstate", (Object)String.valueOf(taskState));
            stateChangeobj.set("newjobstate", (Object)"2");
            stateChangeList.add(stateChangeobj);
        }
        if (changedTaskList.size() > 0) {
            DynamicObject[] changeTaskArray = changedTaskList.toArray(new DynamicObject[0]);
            SaveServiceHelper.save((DynamicObject[])changeTaskArray);
        }
        if (stateChangeList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])stateChangeList.toArray(new DynamicObject[0]));
        }
        return noImageData;
    }

    public void updateTask2Rescan(String billId) {
        QFilter filter = new QFilter(BILL_ID, "in", (Object)billId);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"task_task", (String)"id,billid,billtype,tasktypeid,state,apprevalmessage,imagenumber,rescanopinion", (QFilter[])new QFilter[]{filter});
        if (tasks == null || tasks.length == 0) {
            log.info(billId + "\u672a\u67e5\u8be2\u5230\u5355\u636e\u5bf9\u5e94\u7684\u4efb\u52a1");
            return;
        }
        for (DynamicObject task : tasks) {
            int taskState = task.getInt("state");
            if (taskState != 7 && taskState != 13) continue;
            task.set("state", (Object)"2");
            task.set("rescanopinion", (Object)ResManager.loadKDString((String)"\u901a\u8fc7updateImageState.do\u63a5\u53e3\u8c03\u7528\u4fee\u6539", (String)"SSCImageHandler_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            DynamicObject stateChangeobj = BusinessDataServiceHelper.newDynamicObject((String)"task_statechange");
            stateChangeobj.set("message", (Object)ResManager.loadKDString((String)"\u901a\u8fc7updateImageState.do\u63a5\u53e3\u8c03\u7528\u4fee\u6539", (String)"SSCImageHandler_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            stateChangeobj.set("operatorid", (Object)RequestContext.get().getCurrUserId());
            stateChangeobj.set("operation", (Object)"5");
            stateChangeobj.set("changetime", (Object)new Timestamp(System.currentTimeMillis()));
            stateChangeobj.set("jobid", task.getPkValue());
            stateChangeobj.set("tasktype", (Object)task.getString("tasktypeid"));
            stateChangeobj.set(BILL_TYPE, (Object)task.getString(BILL_TYPE));
            stateChangeobj.set("oldjobstate", (Object)String.valueOf(taskState));
            stateChangeobj.set("newjobstate", (Object)"2");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stateChangeobj});
        }
    }

    public List<ImageReturnCode> updateImageStateBatch(HashMap<String, ImageStateParamInfo> imageNoMap) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<ImageReturnCode> imageReturnCodes = new ArrayList<ImageReturnCode>(16);
        HashSet<String> imageNoSet = new HashSet<String>(16);
        Set<String> imageNos = imageNoMap.keySet();
        log.info("\u5f71\u50cf\u7f16\u7801:" + imageNos);
        QFilter filter = new QFilter(IMAGE_NUMBER, "in", imageNos);
        DynamicObject[] billimagemaps = BusinessDataServiceHelper.load((String)TASK_BILLIMAGEMAP, (String)"id,imagenumber,imagestate,modifytime,modifier", (QFilter[])new QFilter[]{filter});
        if (billimagemaps == null || billimagemaps.length == 0) {
            for (String imageNo : imageNos) {
                imageReturnCodes.add(new ImageReturnCode(imageNo, FAIL));
            }
            return imageReturnCodes;
        }
        for (DynamicObject billimagemap : billimagemaps) {
            String imagenumber = billimagemap.getString(IMAGE_NUMBER);
            imageNoSet.add(imagenumber);
            int state = imageNoMap.get(imagenumber).getState();
            billimagemap.set(IMAGE_STATE, (Object)state);
            try {
                billimagemap.set("modifytime", (Object)sdf.parse(sdf.format(new Date())));
                billimagemap.set("modifier", (Object)RequestContext.get().getCurrUserId());
            }
            catch (ParseException e) {
                log.error((Throwable)e);
            }
            log.info(imagenumber + ":\u4fee\u6539\u72b6\u6001\u6210\u529f");
            imageReturnCodes.add(new ImageReturnCode(imagenumber, "1"));
        }
        SaveServiceHelper.save((DynamicObject[])billimagemaps);
        for (String imageNo : imageNos) {
            if (imageNoSet.contains(imageNo)) continue;
            imageReturnCodes.add(new ImageReturnCode(imageNo, FAIL));
        }
        return imageReturnCodes;
    }

    private boolean isRightState(int state) {
        String strState = state + "";
        return FAIL.equals(strState) || "1".equals(strState) || "2".equals(strState) || "3".equals(strState) || "4".equals(strState);
    }
}

