/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.BosImageDistributeSessionCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.common.ImageOperaionEnum;
import kd.bos.imageplatform.util.HttpClientUtils;
import kd.bos.isc.util.misc.NetUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class SSCImageUtils {
    private static final Log logger = LogFactory.getLog(SSCImageUtils.class);
    private static final int CONNECTIONTIMEOUT = 5000;
    private static final int READTIMEOUT = 30000;
    private static final String ERRORDESCNO_SUCCESS = "0000";
    private static final String ERRORDESCNO_TOKEN_INVAILD = "1300";
    private static final String ISC_ERRORDESCNO_SUCCESS = "0";
    private static final String TOKEN_URL = "/archivebase/scan/login/token";
    private static final String FPY_TOKEN_KEY = "imageFPYToken_";
    private static final String SYS_APP_ID = "18XSXYEL8//U";
    public static final String IMGSYS_CACHE_KEY = "enableImgSys";
    public static final String HAS_ENABLE_SYS = "hasEnableImgSys";

    public static void recordErrorInfo(ImageInfo imageInfo, ImageOperaionEnum imageOperaionEnum) {
        DynamicObject recordObject = SSCImageUtils.buildImageErrorDynamicObject(imageInfo);
        recordObject.set("operation", (Object)imageOperaionEnum.getValue());
        try (TXHandle h = TX.requiresNew((String)"recordErrorInfo");){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObject});
        }
    }

    private static DynamicObject buildImageErrorDynamicObject(ImageInfo imageInfo) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"bas_imageerrorinfo");
        DynamicObject recordobject = new DynamicObject((DynamicObjectType)dt);
        recordobject.set("imagenumber", (Object)imageInfo.getImageNo());
        recordobject.set("creator", (Object)RequestContext.get().getUserId());
        recordobject.set("createtime", (Object)new Date());
        String data = imageInfo.getBillData();
        if (StringUtils.isNotEmpty((String)data) && data.length() >= 1000) {
            data = data.substring(0, 998);
        }
        if (StringUtils.isEmpty((String)data)) {
            recordobject.set("errorinfo", (Object)"");
        } else {
            recordobject.set("errorinfo", (Object)data);
        }
        recordobject.set("billid", (Object)imageInfo.getBillId());
        recordobject.set("imageid", (Object)imageInfo.getImageId());
        recordobject.set("retrycount", (Object)0);
        recordobject.set("retryresult", (Object)Character.valueOf('0'));
        return recordobject;
    }

    public static void recordErrorInfoBatch(Map<ImageInfo, Boolean> actionResult, ImageOperaionEnum imageOperaionEnum) {
        ArrayList<DynamicObject> recordObjectList = new ArrayList<DynamicObject>(actionResult.size());
        for (Map.Entry<ImageInfo, Boolean> entry : actionResult.entrySet()) {
            boolean success = entry.getValue();
            if (success) continue;
            DynamicObject recordObject = SSCImageUtils.buildImageErrorDynamicObject(entry.getKey());
            recordObject.set("operation", (Object)imageOperaionEnum.getValue());
            recordObjectList.add(recordObject);
        }
        SaveServiceHelper.save((DynamicObject[])recordObjectList.toArray(new DynamicObject[0]));
    }

    public static final String sendHttpsRequestByPost(String url, String json) throws Exception {
        String responseContent = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientUtils.createHttpClient(5000, 30000);
            HttpPost httpPost = new HttpPost(url);
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                logger.info("response:" + responseContent);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001HTTP POST\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return responseContent;
    }

    public static final String sendFpyPostHttpsRequest(String apiNumber, String url, String json) throws Exception {
        String result = SSCImageUtils.requestIscApi(apiNumber, url, json);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String errcode = jsonObject.getString("errcode");
        if (ERRORDESCNO_TOKEN_INVAILD.equals(errcode)) {
            SSCImageUtils.removeFPYAccessToken();
            String fpyAccessToken = SSCImageUtils.getFpyAccessToken(SSCImageUtils.getEnableImageSysInfo());
            url = url.substring(0, url.lastIndexOf("=") + 1) + fpyAccessToken;
            logger.info("\u7b2c\u4e00\u6b21\u8bf7\u6c42token\u5931\u6548\uff0c\u91cd\u65b0\u83b7\u53d6token\u540e\u518d\u6b21\u8bf7\u6c42\uff0crequestUrl = " + url);
            return SSCImageUtils.requestIscApi(apiNumber, url, json);
        }
        return result;
    }

    public static String requestIscApi(String apiNumber, String url, String json) throws Exception {
        JSONObject params = JSONObject.parseObject((String)json);
        if (StringUtils.isBlank((String)apiNumber)) {
            params.remove("imageUrl");
            params.remove("fpy_access_token");
            json = JSONObject.toJSONString((Object)params);
            return SSCImageUtils.sendHttpsRequestByPost(url, json);
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_apic_script", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)apiNumber)});
        if (object == null) {
            try (InputStream in = SSCImageUtils.class.getClassLoader().getResource("resources/bos-image-invokeinvoice.dts").openStream();){
                String jsonStr = NetUtil.readText((InputStream)in);
                Object result = null;
                try (TXHandle h = TX.requiresNew();){
                    try {
                        result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{jsonStr, true});
                    }
                    catch (Exception e) {
                        logger.error("\u5bfc\u5165\u5f71\u50cf\u63a5\u53e3\u81ea\u5b9a\u4e49API\u5f02\u5e38\uff1a" + e);
                        h.markRollback();
                    }
                }
                if (result == null) {
                    logger.info(String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u8bf7\u6c42\u63a5\u53e3\u81ea\u5b9a\u4e49API\uff0c\u7f16\u7801:%1$s,\u5bfc\u5165\u6210\u529f", (String)"SSCImageUtils_4", (String)"bos-image-formplugin", (Object[])new Object[0]), apiNumber));
                }
            }
            catch (IOException e) {
                logger.warn("\u96c6\u6210\u7ba1\u7406API\u8c03\u7528\u5931\u8d25\uff0c\u76f4\u63a5\u8c03\u7528\u539f\u751f\u8bf7\u6c42", (Throwable)e);
                return SSCImageUtils.sendHttpsRequestByPost(url, json);
            }
        }
        Object result = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                result = DispatchServiceHelper.invokeExternalService((String)"image", (String)apiNumber, (Map)params);
            }
            catch (Exception e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
                h.markRollback();
            }
        }
        if (result == null) {
            params.remove("imageUrl");
            params.remove("fpy_access_token");
            json = JSONObject.toJSONString((Object)params);
            return SSCImageUtils.sendHttpsRequestByPost(url, json);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)result.toString());
            logger.info("isc\u8bf7\u6c42\u7f16\u7801\uff1a" + apiNumber + ",\u8bf7\u6c42\u6210\u529f\u3002");
        }
        catch (Exception e) {
            logger.warn("\u96c6\u6210\u7ba1\u7406API\u8c03\u7528\u5931\u8d25\uff0c\u76f4\u63a5\u8c03\u7528\u539f\u751f\u8bf7\u6c42", (Throwable)e);
            params.remove("imageUrl");
            params.remove("fpy_access_token");
            json = JSONObject.toJSONString((Object)params);
            return SSCImageUtils.sendHttpsRequestByPost(url, json);
        }
        return result.toString();
    }

    public static ImageSysInfo getEnableImageSysInfo() {
        String imageSysJsonString = BosImageDistributeSessionCache.get(IMGSYS_CACHE_KEY);
        ImageSysInfo imageSysInfo = null;
        boolean needQueryInDB = false;
        if (StringUtils.isNotEmpty((String)imageSysJsonString)) {
            imageSysInfo = (ImageSysInfo)JSONObject.parseObject((String)imageSysJsonString, ImageSysInfo.class);
        }
        if (imageSysInfo == null || imageSysInfo.getSupportMult() == null) {
            needQueryInDB = true;
        }
        if (needQueryInDB) {
            boolean hasEnable;
            String hasEnableImageSys = BosImageDistributeSessionCache.get(HAS_ENABLE_SYS);
            if (StringUtils.isNotEmpty((String)hasEnableImageSys) && !(hasEnable = Boolean.parseBoolean(hasEnableImageSys))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u3002", (String)"SSCImageUtils_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            QFilter filter = new QFilter("enable", "=", (Object)"A");
            DynamicObject imageConfig = BusinessDataServiceHelper.loadSingle((String)"bas_imageconfig", (String)"id,number,simplename,imagesystermip,imageport,externalerp.number,clientid,clientsecret,imageurl,imageplugin,supportmult,supportmobile", (QFilter[])new QFilter[]{filter});
            if (imageConfig == null) {
                BosImageDistributeSessionCache.put(HAS_ENABLE_SYS, String.valueOf(Boolean.FALSE));
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u3002", (String)"SSCImageUtils_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
            }
            imageSysInfo = new ImageSysInfo();
            String ip = imageConfig.getString("imagesystermip");
            String imageUrl = imageConfig.getString("imageurl");
            String port = imageConfig.getString("imageport");
            imageSysInfo.setNumber(imageConfig.getString("number"));
            imageSysInfo.setImageSysIp(ip);
            imageSysInfo.setName(imageConfig.getString("simplename"));
            imageSysInfo.setImagePort(port);
            if (StringUtils.isEmpty((String)imageUrl)) {
                imageSysInfo.setImageUrl("http://" + ip + ":" + port);
            } else {
                imageSysInfo.setImageUrl(imageUrl.trim());
            }
            imageSysInfo.setClientId(imageConfig.getString("clientid"));
            imageSysInfo.setClientSecret(imageConfig.getString("clientsecret"));
            imageSysInfo.setExternalerpNumber(imageConfig.getString("externalerp.number"));
            imageSysInfo.setSupportMobile(imageConfig.getBoolean("supportmobile"));
            imageSysInfo.setSupportMult(imageConfig.getBoolean("supportmult"));
            BosImageDistributeSessionCache.put(IMGSYS_CACHE_KEY, JSONObject.toJSONString((Object)imageSysInfo));
            BosImageDistributeSessionCache.put(HAS_ENABLE_SYS, String.valueOf(Boolean.TRUE));
        }
        return imageSysInfo;
    }

    public static DynamicObjectCollection getEnableImageRemindRule() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"bas_imageremind", (String)"id,number,messagetemplate,calendartype,messagetitle,messageobject,expiredday,remindcycle,msgchannel.FBasedataId.number as msgchannelnumber,priority,noticescene,org.FBasedataId as orgid,org.FBasedataId.name as orgname,billtype.FBasedataId.number as billtypenumber,billtype.FBasedataId.name as billtypename", (QFilter[])new QFilter[]{filter});
    }

    @Deprecated
    public static DynamicObjectCollection getEnableImageStrategy() {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"bos_imagestrategy", (String)"number,level,isgen,imageprefix,israndom,org.FBasedataId as orgid,org.FBasedataId.name as orgname,billtype.FBasedataId.number as billtypenumber,billtype.FBasedataId.name as billtypename", (QFilter[])new QFilter[]{filter});
    }

    public static Map<Long, Map<String, Object>> matchImageStrategy(String billType, List<Long> orgIdList) {
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(orgIdList.size());
        HashMap<Long, Integer> strategyLevelMap = new HashMap<Long, Integer>(orgIdList.size());
        HashMap<String, Object> defaultStrategy = new HashMap<String, Object>(4);
        int defaultLevel = 0;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billType)});
        String billTypeId = dynamicObject.getString("id");
        String querySql = "select a.fid,a.fnumber,a.flevel,a.fimageprefix,a.fisgen,a.fisrandom,b.fbasedataid org ,c.fbasedataid billType from t_bas_imagestrategy a left join t_bas_imastrategyorg b on a.fid = b.fid and b.fbasedataid in (%s) left join t_bas_imastrategybill c on a.fid = c.fid and c.fbasedataid = ? where a.fenable = '1'";
        String orgIdStr = orgIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        querySql = String.format(querySql, orgIdStr);
        try (DataSet ds = DB.queryDataSet((String)"bos.image.matchImageStrategy", (DBRoute)DBRoute.of((String)"sys"), (String)querySql, (Object[])new Object[]{billTypeId});){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long orgId = row.getLong("org");
                if (orgId == null) {
                    orgId = 0L;
                }
                String bill = row.getString("billType");
                Integer level = row.getInteger("flevel");
                boolean isRandom = "1".equals(row.getString("fisrandom"));
                boolean isGen = "1".equals(row.getString("fisgen"));
                String prefix = row.getString("fimageprefix");
                if (orgId != 0L && !StringUtils.isEmpty((String)bill)) {
                    strategyLevelMap.put(orgId, level);
                    HashMap<String, Object> strategyInfo = new HashMap<String, Object>(4);
                    strategyInfo.put("isRandom", isRandom);
                    strategyInfo.put("isGen", isGen);
                    strategyInfo.put("prefix", prefix);
                    resultMap.put(orgId, strategyInfo);
                    continue;
                }
                if (orgId != 0L) {
                    Integer matchedLevel = (Integer)strategyLevelMap.get(orgId);
                    if (matchedLevel != null && level >= matchedLevel) continue;
                    strategyLevelMap.put(orgId, matchedLevel);
                    HashMap<String, Object> strategyInfo = new HashMap<String, Object>(4);
                    strategyInfo.put("isRandom", isRandom);
                    strategyInfo.put("isGen", isGen);
                    strategyInfo.put("prefix", prefix);
                    resultMap.put(orgId, strategyInfo);
                    continue;
                }
                if (!StringUtils.isEmpty((String)bill)) {
                    if (defaultLevel >= 40) continue;
                    defaultLevel = 40;
                    defaultStrategy.put("isRandom", isRandom);
                    defaultStrategy.put("isGen", isGen);
                    defaultStrategy.put("prefix", prefix);
                    continue;
                }
                if (defaultLevel != 0 || level <= 40) continue;
                defaultLevel = 1;
                defaultStrategy.put("isRandom", isRandom);
                defaultStrategy.put("isGen", isGen);
                defaultStrategy.put("prefix", prefix);
            }
        }
        if (defaultLevel > 0) {
            for (Long orgId : orgIdList) {
                resultMap.putIfAbsent(orgId, defaultStrategy);
            }
        }
        return resultMap;
    }

    public static String getFpyAccessToken(ImageSysInfo imageSysInfo) throws Exception {
        String cachedToken = BosImageDistributeSessionCache.get(FPY_TOKEN_KEY + RequestContext.get().getCurrUserId());
        if (StringUtils.isEmpty((String)cachedToken)) {
            return SSCImageUtils.getFpyAccessTokenByRequest(imageSysInfo);
        }
        return cachedToken;
    }

    private static String getFpyAccessTokenByRequest(ImageSysInfo imageSysInfo) throws Exception {
        if (imageSysInfo == null) {
            throw new Exception(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\uff01", (String)"SSCImageUtils_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String clientId = imageSysInfo.getClientId();
        String clientSecret = imageSysInfo.getClientSecret();
        if (StringUtils.isEmpty((String)clientId) || StringUtils.isEmpty((String)clientSecret)) {
            throw new Exception(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\u7684clientId\u6216clientSecret\u4e3a\u7a7a\uff01", (String)"SSCImageUtils_6", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = SSCImageUtils.getMD5(clientId + clientSecret + timeStamp);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("imageUrl", (Object)imageSysInfo.getImageUrl());
        jsonObject.put("clientId", (Object)clientId);
        jsonObject.put("clientSecret", (Object)clientSecret);
        jsonObject.put("sign", (Object)sign);
        jsonObject.put("timestamp", (Object)timeStamp);
        jsonObject.put("fsource", (Object)4);
        Long currentUserId = RequestContext.get().getCurrUserId();
        DynamicObject userObject = BusinessDataServiceHelper.loadSingleFromCache((Object)currentUserId, (String)"bos_user", (String)"username,phone,email");
        if (userObject == null) {
            logger.info("\u83b7\u53d6\u5230\u7684\u5f53\u524d\u7528\u6237\u4e3a\u7a7a\uff0c\u8f6c\u800c\u83b7\u53d6\u7528\u6237id\u4e3a1\u7684\u7528\u6237\u4fe1\u606f");
            userObject = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bos_user", (String)"username,phone,email");
        }
        Object phone = userObject.get("phone");
        Object email = userObject.get("email");
        Object username = userObject.get("username");
        jsonObject.put("fphoneNumber", phone);
        jsonObject.put("fuserName", username);
        jsonObject.put("fuserEmail", email);
        jsonObject.put("feasUid", (Object)String.valueOf(currentUserId));
        String loginUrl = imageSysInfo.getImageUrl() + TOKEN_URL;
        String result = SSCImageUtils.requestIscApi("image-fpy-gettoken", loginUrl, jsonObject.toJSONString());
        JSONObject jsonObjectRespond = JSONObject.parseObject((String)result);
        jsonObject.remove((Object)"clientId");
        jsonObject.remove((Object)"sign");
        jsonObject.remove((Object)"clientSecret");
        jsonObject.remove((Object)"fuserName");
        jsonObject.remove((Object)"fuserEmail");
        jsonObject.remove((Object)"fphoneNumber");
        logger.info("\u4ece\u5f71\u50cf\u7cfb\u7edf\u83b7\u53d6token,\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a" + loginUrl + ",jsonObject:" + jsonObject.toJSONString());
        String errcode = jsonObjectRespond.getString("errcode");
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            jsonObjectRespond = jsonObjectRespond.getJSONObject("data");
            String token = jsonObjectRespond.getString("accessToken");
            int expired = jsonObjectRespond.getIntValue("expiresTime");
            BosImageDistributeSessionCache.put(FPY_TOKEN_KEY + currentUserId, token, expired / 2);
            return token;
        }
        throw new Exception(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff1a%1$s", (String)"SSCImageUtils_2", (String)"bos-image-formplugin", (Object[])new Object[0]), jsonObjectRespond.toJSONString()));
    }

    public static void removeFPYAccessToken() {
        Long userId = RequestContext.get().getCurrUserId();
        logger.info("\u5220\u9664\u7f13\u5b58\u7684" + userId + "\u8bbf\u95ee\u53d1\u7968\u4e91\u7684token");
        BosImageDistributeSessionCache.remove(FPY_TOKEN_KEY + userId);
    }

    public static String getMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                if ((0xFF & hash[i]) < 16) {
                    hexString.append('0');
                    hexString.append(Integer.toHexString(0xFF & hash[i]));
                    continue;
                }
                hexString.append(Integer.toHexString(0xFF & hash[i]));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            logger.error("md5\u8ba1\u7b97\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static Map<String, DynamicObject> getLatestRemindTime(Set<String> remindImageNumbers) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(16);
        QFilter filter = new QFilter("imagenumber", "in", remindImageNumbers);
        DynamicObject[] imageRemindRecords = BusinessDataServiceHelper.load((String)"bas_imageremindrecord", (String)"id,latestremind,imagenumber,messageid", (QFilter[])new QFilter[]{filter});
        if (imageRemindRecords == null || imageRemindRecords.length == 0) {
            return result;
        }
        for (int i = 0; i < imageRemindRecords.length; ++i) {
            result.put(imageRemindRecords[i].getString("imagenumber"), imageRemindRecords[i]);
        }
        return result;
    }

    public static Object getImageSysParams(String field) {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        Object imageSysParams = SSCImageUtils.getImageSysParams(field, rootOrgId);
        logger.info("\u83b7\u53d6\u6839\u7ec4\u7ec7" + rootOrgId + "\u7684\u7cfb\u7edf\u53c2\u6570" + field + "\u7684\u503c\u4e3a\uff1a" + imageSysParams);
        return imageSysParams;
    }

    public static Object getImageSysParams(String field, long orgId) {
        AppParam param = new AppParam(SYS_APP_ID, Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)field);
    }

    @FunctionalInterface
    public static interface RequestTokenFunction {
        public JSONObject getToken(Map<String, Object> var1) throws Exception;
    }
}

