/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.imageplatform.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.image.dto.ImageStatusSynMessage;
import kd.bos.imageplatform.pojo.ImageStateParamInfo;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaskInterUtils {
    private static final Log log = LogFactory.getLog(TaskInterUtils.class);
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String TASK_BILLIMAGEMAP = "task_billimagemap";
    private static final String BILLID = "billid";
    private static final String TASK_TASK = "task_task";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String SELECT_FIELDS = "id,billid,billtype";
    private static final String STATE = "state";
    private static final String IMAGE_UPLOADTIME = "imageuploadtime";
    private static final String IMAGEOK = "imageok";
    private static final String OLD_TASKSTATE = "oldtaskstate";
    private static final String BILL_TYPE = "billtype";
    private static final String BILLTYPE_ID = "billtype.id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendAllImageInfo2Mq(String imageNumber) {
        QFilter[] qFilters = new QFilter[]{new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber)};
        MessagePublisher publisher = MQFactory.get().createSimplePublisher("fi", "kd.bos.imageplatform.service.status_update");
        if (QueryServiceHelper.exists((String)TASK_BILLIMAGEMAP, (QFilter[])qFilters)) {
            DynamicObject allInfo = QueryServiceHelper.queryOne((String)TASK_BILLIMAGEMAP, (String)"*", (QFilter[])qFilters);
            ImageStatusSynMessage message = ImageStatusSynMessage.transformFromDynamic((DynamicObject)allInfo);
            try {
                publisher.publish((Object)message);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001MQ\u5931\u8d25\uff1a" + e);
            }
            finally {
                publisher.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void batchSendAllImageInfo2Mq(Set<String> imageNoSet) {
        QFilter[] qFilters = new QFilter[]{new QFilter(IMAGE_NUMBER, "in", imageNoSet)};
        DynamicObjectCollection images = QueryServiceHelper.query((String)TASK_BILLIMAGEMAP, (String)"*", (QFilter[])qFilters);
        if (!images.isEmpty()) {
            MessagePublisher publisher = MQFactory.get().createSimplePublisher("fi", "kd.bos.imageplatform.service.status_update");
            for (DynamicObject image : images) {
                ImageStatusSynMessage message = ImageStatusSynMessage.transformFromDynamic((DynamicObject)image);
                try {
                    publisher.publish((Object)message);
                }
                catch (Exception e) {
                    log.info("\u53d1\u9001MQ\u5931\u8d25\uff1a" + e);
                }
                finally {
                    publisher.close();
                }
            }
        }
    }

    public String updatJobIsImaStat(List list, boolean isImageNo) throws KDException {
        BizLog.log((String)("list in updatJobIsImaStat is......" + list));
        String imageNo = null;
        String message = null;
        String scanUserID = null;
        for (Object obj : list) {
            ImageStateParamInfo imageInfo = (ImageStateParamInfo)obj;
            imageNo = imageInfo.getImageNo();
            if (!isImageNo) {
                message = imageInfo.getMessage();
                scanUserID = imageInfo.getScanUserID();
                log.info("imageInfo.getScanUserID()" + scanUserID);
            }
            if (imageNo == null) {
                BizLog.log((String)"imageNo is null");
                continue;
            }
            List jobList = this.getListTask(imageNo);
            List operedJobList = this.getOperedListTask(imageNo);
            List<String> finishJobList = this.getFinishListTask(imageNo);
            if (CollectionUtils.isNotEmpty((Collection)jobList)) {
                log.info("\u67e5\u627e\u5230\u4efb\u52a1List-" + jobList.size() + ":" + jobList);
                boolean bl = this.updaTaskIsImag(jobList, message, scanUserID);
            }
            ORM orm = ORM.create();
            DynamicObject imageMap = orm.queryOne(TASK_BILLIMAGEMAP, "id,billtype,billid", new QFilter[]{new QFilter(IMAGE_NUMBER, "=", (Object)imageNo)});
            if (imageMap != null) {
                QFilter filter1 = new QFilter(BILLID, "=", imageMap.get(BILLID));
                QFilter filter2 = new QFilter("pooltype", "=", (Object)"3");
                log.info("\u66f4\u65b0\u6211\u7684\u4efb\u52a1\u4e3a\u5f85\u5206\u914dtask_task\u8fc7\u6ee4\u6761\u4ef6:billid\uff1a" + imageMap.get(BILLID) + ",imageNo:" + imageNo);
                QFilter[] filters = new QFilter[]{filter1, filter2};
                DynamicObject[] collection = BusinessDataServiceHelper.load((String)TASK_TASK, (String)"billid,createtime,id,imageok,oldtaskstate,state,imageuploadtime,source,billtype.externalerp.number,personid,assignid,pooltype", (QFilter[])filters);
                log.info("\u66f4\u65b0\u6211\u7684\u4efb\u52a1\u4e3a\u5f85\u5206\u914d-start");
                for (DynamicObject d : collection) {
                    d.set("pooltype", (Object)"0");
                    Date now = new Date();
                    d.set("createtime", (Object)now);
                }
                log.info("\u66f4\u65b0\u6211\u7684\u4efb\u52a1\u4e3a\u5f85\u5206\u914dtask_task:" + collection.length);
                SaveServiceHelper.save((DynamicObject[])collection);
                log.info("\u66f4\u65b0\u6211\u7684\u4efb\u52a1\u4e3a\u5f85\u5206\u914d-end");
                for (DynamicObject d : collection) {
                    try {
                        scanUserID = imageInfo.getScanUserID();
                    }
                    catch (Exception e) {
                        log.error("\u83b7\u53d6\u626b\u63cf\u5458id\u62a5\u9519", (Throwable)e);
                    }
                    try {
                        String extenderp = this.getExternalerp(imageMap.get(BILLID));
                        if (!extenderp.equalsIgnoreCase("KDCC")) continue;
                        long scanID = 0L;
                        scanID = this.getDataMapping(scanUserID);
                        if (scanID == -1L) {
                            scanID = Long.parseLong(scanUserID);
                        }
                        DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"addWFCommon", (Object[])new Object[]{new DynamicObject[]{d}, "", ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf\u6210\u529f", (String)"TaskInterUtils_0", (String)"bos-image-formplugin", (Object[])new Object[0]), scanID});
                        DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"updateWFNameAndPersonNocheckPerson", (Object[])new Object[]{new DynamicObject[]{d}, ResManager.loadKDString((String)"\u4e00\u7ea7\u5ba1\u6279", (String)"TaskInterUtils_1", (String)"bos-image-formplugin", (Object[])new Object[0])});
                    }
                    catch (Exception ITaskServiceException) {
                        log.error("\u6539\u53d8\u5de5\u4f5c\u6d41\u72b6\u6001\u9519\u8bef", (Throwable)ITaskServiceException);
                    }
                }
            } else {
                log.info("\u672a\u67e5\u8be2\u5230\u5f71\u50cf\u6620\u5c04\u8868\uff0cimageNo:" + imageNo);
            }
            log.info("\u4fee\u6539\u4efb\u52a1\u6c60\u72b6\u6001\u6210\u529f");
        }
        return imageNo;
    }

    public String updatJobIsImaStat(List list, String State2, boolean isImageNo) throws KDException {
        BizLog.log((String)("list in updatJobIsImaStat is......" + list));
        String imageNo = null;
        String message = null;
        String sscType = null;
        String scanUserID = null;
        for (Object obj : list) {
            ImageStateParamInfo imageInfo = (ImageStateParamInfo)obj;
            imageNo = imageInfo.getImageNo();
            if (!isImageNo) {
                message = imageInfo.getMessage();
                scanUserID = imageInfo.getScanUserID();
                sscType = imageInfo.getSscType();
            }
            if (imageNo == null) {
                BizLog.log((String)"imageNo is null");
                continue;
            }
            List jobList = this.getListTask(imageNo);
            List operedJobList = this.getOperedListTask(imageNo);
            List<String> finishJobList = this.getFinishListTask(imageNo);
            if (jobList.size() == 0) continue;
            boolean bl = this.updaTaskIsImagToRescan(jobList, message);
        }
        return imageNo;
    }

    public List getListTask(String imageNo) {
        QFilter mapFilter;
        QFilter[] mapFilters;
        ArrayList<Long> list = new ArrayList<Long>();
        String billID = "";
        long billtypeid = 0L;
        ORM orm = ORM.create();
        DynamicObjectCollection mapCollection = orm.query(TASK_BILLIMAGEMAP, SELECT_FIELDS, mapFilters = new QFilter[]{mapFilter = new QFilter(IMAGE_NUMBER, "=", (Object)imageNo)});
        if (mapCollection != null && mapCollection.size() != 0) {
            billID = ((DynamicObject)mapCollection.get(0)).getString(BILLID);
        }
        QFilter filter2 = new QFilter(STATE, "<>", (Object)"8");
        QFilter filter3 = new QFilter(BILLID, "=", (Object)billID);
        QFilter[] filters = new QFilter[]{filter2, filter3};
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_TASK, "id", filters);){
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)TASK_TASK);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    list.add(((DynamicObject)collection.get(i)).getLong("id"));
                }
            }
        }
        return list;
    }

    public List getOperedListTask(String imageNo) {
        QFilter mapFilter;
        QFilter[] mapFilters;
        ArrayList<Long> list = new ArrayList<Long>();
        String billID = "";
        Object billtype = null;
        ORM orm = ORM.create();
        DynamicObjectCollection mapCollection = orm.query(TASK_BILLIMAGEMAP, SELECT_FIELDS, mapFilters = new QFilter[]{mapFilter = new QFilter(IMAGE_NUMBER, "=", (Object)imageNo)});
        if (mapCollection != null && mapCollection.size() != 0) {
            billID = ((DynamicObject)mapCollection.get(0)).getString(BILLID);
        }
        QFilter filter2 = new QFilter(BILLID, "=", (Object)billID);
        QFilter[] filters = new QFilter[]{filter2};
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_TASK, "id", filters);){
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)TASK_TASK);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    list.add(((DynamicObject)collection.get(i)).getLong("id"));
                }
            }
        }
        return list;
    }

    public List<String> getFinishListTask(String imageNo) {
        QFilter mapFilter;
        QFilter[] mapFilters;
        ArrayList<String> list = new ArrayList<String>();
        String billID = "";
        Object billtype = null;
        ORM orm = ORM.create();
        DynamicObjectCollection mapCollection = orm.query(TASK_BILLIMAGEMAP, SELECT_FIELDS, mapFilters = new QFilter[]{mapFilter = new QFilter(IMAGE_NUMBER, "=", (Object)imageNo)});
        if (mapCollection != null && mapCollection.size() != 0) {
            billID = ((DynamicObject)mapCollection.get(0)).getString(BILLID);
        }
        QFilter filter = new QFilter(BILLID, "=", (Object)billID);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), "task_taskhistory", "id", filters);){
            DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"task_taskhistory");
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    list.add((String)((Object)Long.valueOf(((DynamicObject)collection.get(i)).getLong("id"))));
                }
            }
        }
        return list;
    }

    public boolean updaTaskIsImag(List jobList, String message) {
        if (jobList == null || jobList.size() == 0) {
            return true;
        }
        try {
            for (int i = 0; i < jobList.size(); ++i) {
                QFilter filter6;
                QFilter filter5;
                MainEntityType metOV;
                MainEntityType e;
                QFilter filter = new QFilter("id", "=", jobList.get(i));
                QFilter filter2 = new QFilter(IMAGE_UPLOADTIME, "=", (Object)"");
                QFilter filter3 = new QFilter(IMAGEOK, "=", (Object)"0");
                QFilter[] filters = new QFilter[]{filter, filter3};
                DynamicObject[] collection = BusinessDataServiceHelper.load((String)TASK_TASK, (String)"id,imageok,oldtaskstate,state,imageuploadtime,pooltype", (QFilter[])filters);
                DynamicObject obj = null;
                if (collection != null && collection.length != 0) {
                    log.info("updaTaskIsImag-\u5f71\u50cf\u4e0a\u4f20:" + collection.length);
                    e = EntityMetadataCache.getDataEntityType((String)TASK_TASK);
                    metOV = EntityMetadataCache.getDataEntityType((String)TASK_TASK);
                    obj = collection[0];
                    obj.set(IMAGEOK, (Object)"1");
                    obj.set(IMAGE_UPLOADTIME, (Object)new Date());
                    String curPoolType = obj.getString("pooltype");
                    if ("3".equals(curPoolType)) {
                        obj.set(OLD_TASKSTATE, (Object)obj.getString(STATE));
                        obj.set(STATE, (Object)"12");
                        obj.set("pooltype", (Object)"0");
                        log.info("Moudle of image start update state " + jobList);
                    }
                    SaveServiceHelper.save((DynamicObject[])collection);
                    continue;
                }
                e = EntityMetadataCache.getDataEntityType((String)TASK_TASK);
                metOV = EntityMetadataCache.getDataEntityType((String)TASK_TASK);
                QFilter filter4 = new QFilter("id", "=", jobList.get(i));
                QFilter[] filters2 = new QFilter[]{filter4, filter5 = new QFilter(IMAGE_UPLOADTIME, "<>", (Object)""), filter6 = new QFilter(STATE, "=", (Object)"2")};
                DynamicObjectCollection collection2 = QueryServiceHelper.query((String)TASK_TASK, (String)"id,imageok,oldtaskstate,state,imageuploadtime,personid.id,tasktypeid.id,billtype.id", (QFilter[])filters2);
                if (collection2 == null || collection2.size() == 0) continue;
                log.info("updaTaskIsImag-\u5f71\u50cf\u91cd\u4f20:" + collection2.size());
                obj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection2.get(0)).getLong("id"), (DynamicObjectType)e);
                TaskInterUtils.addJobStateTime(obj, "16", "7", "0", message, null);
                obj.set(STATE, (Object)"7");
                obj.set(OLD_TASKSTATE, (Object)"4");
                obj.set(IMAGEOK, (Object)"1");
                BusinessDataWriter.save((IDataEntityType)metOV, (Object[])new Object[]{obj});
            }
        }
        catch (Exception e) {
            log.error("updaTaskIsImag \u5931\u8d25. " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean updaTaskIsImag(List jobList, String message, String scanUserID) {
        if (jobList == null || jobList.size() == 0) {
            return true;
        }
        try {
            for (int i = 0; i < jobList.size(); ++i) {
                QFilter filter6;
                QFilter filter5;
                QFilter filter = new QFilter("id", "=", jobList.get(i));
                QFilter filter3 = new QFilter(IMAGEOK, "=", (Object)"0");
                QFilter[] filters = new QFilter[]{filter, filter3};
                DynamicObject[] collection = BusinessDataServiceHelper.load((String)TASK_TASK, (String)"id,imageok,oldtaskstate,state,imageuploadtime,source,billtype.externalerp.number,personid,assignid,pooltype", (QFilter[])filters);
                DynamicObject obj = null;
                if (collection != null) {
                    log.info("updaTaskIsImag-\u5f71\u50cf\u4e0a\u4f20:" + collection.length);
                }
                if (collection != null && collection.length != 0) {
                    obj = collection[0];
                    obj.set(IMAGEOK, (Object)"1");
                    String curPoolType = obj.getString("pooltype");
                    if ("3".equals(curPoolType)) {
                        obj.set(OLD_TASKSTATE, (Object)obj.getString(STATE));
                        obj.set(STATE, (Object)"12");
                        obj.set("pooltype", (Object)"0");
                        log.info("Moudle of image start update state " + jobList);
                    }
                    obj.set(IMAGE_UPLOADTIME, (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])collection);
                    continue;
                }
                MainEntityType e = EntityMetadataCache.getDataEntityType((String)TASK_TASK);
                MainEntityType metOV = EntityMetadataCache.getDataEntityType((String)TASK_TASK);
                QFilter filter4 = new QFilter("id", "=", jobList.get(i));
                QFilter[] filters2 = new QFilter[]{filter4, filter5 = new QFilter(IMAGE_UPLOADTIME, "is not null", (Object)""), filter6 = new QFilter(STATE, "=", (Object)"2")};
                DynamicObjectCollection collection2 = QueryServiceHelper.query((String)TASK_TASK, (String)"id,imageok,oldtaskstate,state,imageuploadtime,personid.id,tasktypeid.id,billtype.id", (QFilter[])filters2);
                if (collection2 == null || collection2.size() == 0) continue;
                log.info("updaTaskIsImag-\u5f71\u50cf\u91cd\u4f20:" + collection2.size());
                obj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)collection2.get(0)).getLong("id"), (DynamicObjectType)e);
                TaskInterUtils.addJobStateTime(obj, "16", "7", "0", message, null);
                obj.set(STATE, (Object)"7");
                obj.set(OLD_TASKSTATE, (Object)"4");
                obj.set(IMAGEOK, (Object)"1");
                BusinessDataWriter.save((IDataEntityType)metOV, (Object[])new Object[]{obj});
            }
        }
        catch (Exception e) {
            log.error("updaTaskIsImag \u5931\u8d25. " + e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean updaTaskToNormal(List jobList, String message) throws KDException {
        if (jobList == null || jobList.size() == 0) {
            return true;
        }
        for (int i = 0; i < jobList.size(); ++i) {
            ORM orm = ORM.create();
            QFilter filter = new QFilter("id", "=", jobList.get(i));
            QFilter[] filters = new QFilter[]{filter};
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_TASK, "id,imageok,oldtaskstate,state,imageuploadtime", filters);){
                DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)TASK_TASK);
                if (collection == null || collection.size() == 0) continue;
                try {
                    DynamicObject obj = (DynamicObject)collection.get(0);
                    TaskInterUtils.addJobStateTime(obj, "16", "7", "0", message, null);
                    obj.set(STATE, (Object)"7");
                    obj.set(OLD_TASKSTATE, (Object)"4");
                    obj.set(IMAGEOK, (Object)"1");
                    orm.update(obj);
                    continue;
                }
                catch (Exception e) {
                    BizLog.log((String)("updaTaskIsImag ERROR. " + e));
                    boolean bl = false;
                    if (ds != null) {
                        if (var8_8 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                var8_8.addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    public static void addJobStateTime(DynamicObject jobObj, String operation, String newJobState, String messageState, String message, String innerMsg) throws KDException {
        ORM orm = ORM.create();
        DynamicObject stateChangeObj = orm.newDynamicObject("task_statechange");
        stateChangeObj.set("jobid", (Object)jobObj.getString("id"));
        stateChangeObj.set("oldjobstate", (Object)jobObj.getString(STATE));
        stateChangeObj.set("newjobstate", (Object)newJobState);
        stateChangeObj.set("message", (Object)message);
        stateChangeObj.set("messagestate", (Object)messageState);
        stateChangeObj.set("operatorid", (Object)jobObj.getLong("personid.id"));
        stateChangeObj.set("operation", (Object)operation);
        stateChangeObj.set("tasktype", (Object)jobObj.getLong("tasktypeid.id"));
        stateChangeObj.set(BILL_TYPE, (Object)jobObj.getLong(BILLTYPE_ID));
        stateChangeObj.set("changetime", (Object)new Date());
        stateChangeObj.set("innermsg", (Object)innerMsg);
        orm.insert(stateChangeObj);
    }

    public boolean isTaskCanRescan(String bosType, String billID, int taskid) {
        ORM orm = ORM.create();
        DynamicObject taskObj = orm.newDynamicObject(TASK_TASK);
        QFilter filter = new QFilter("id", "=", (Object)taskid);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TASK_TASK, (String)"id, islastaudit, state", (QFilter[])filters);
        if (collection == null && collection.size() == 0) {
            throw new KDException(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff01", (String)"TaskInterUtils_2", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        taskObj = (DynamicObject)collection.get(0);
        boolean islastaudit = taskObj.getBoolean("islastaudit");
        String state = taskObj.getString(STATE);
        return !islastaudit || !"3".equals(state);
    }

    public boolean updaTaskIsImagToRescan(List jobList, String message) {
        if (jobList == null || jobList.size() == 0) {
            return true;
        }
        for (int i = 0; i < jobList.size(); ++i) {
            ORM orm = ORM.create();
            QFilter filter = new QFilter("id", "=", jobList.get(i));
            Object[] filters = new QFilter[]{filter};
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), TASK_TASK, filters);){
                DynamicObjectCollection collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)TASK_TASK);
                if (collection == null || collection.size() == 0) continue;
                try {
                    DynamicObject obj = (DynamicObject)collection.get(0);
                    TaskInterUtils.addJobStateTime(obj, "5", "2", "0", message, null);
                    obj.set(STATE, (Object)"2");
                    obj.set(OLD_TASKSTATE, (Object)"3");
                    obj.set(IMAGEOK, (Object)"1");
                    orm.update(obj);
                    continue;
                }
                catch (Exception e) {
                    BizLog.log((String)("updaTaskIsImag ERROR. " + e));
                    boolean bl = false;
                    if (ds != null) {
                        if (var8_8 != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                var8_8.addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    private DynamicObjectCollection getBindBillById(Long id) {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"task_taskbill", (String)"id,bindbill.number", (QFilter[])filters);
        return collection;
    }

    private void ReUploadStateChange(String imageNo) {
        try {
            ORM orm = ORM.create();
            DynamicObject imageMap = orm.queryOne(TASK_BILLIMAGEMAP, "id,billtype,billid", new QFilter[]{new QFilter(IMAGE_NUMBER, "=", (Object)imageNo)});
            Long billtype = 0L;
            Long taskid = 0L;
            Long tasktypeid = 0L;
            if (imageMap != null) {
                DynamicObject[] doa;
                DynamicObjectCollection doc = orm.query(TASK_TASK, new QFilter[]{new QFilter(BILLTYPE_ID, "=", imageMap.get(BILL_TYPE)), new QFilter(BILLID, "=", imageMap.get(BILLID))});
                for (DynamicObject d : doa = (DynamicObject[])doc.toArray((Object[])new DynamicObject[doc.size()])) {
                    billtype = d.getLong(BILLTYPE_ID);
                    taskid = d.getLong("id");
                    DynamicObject dy = (DynamicObject)d.get("tasktypeid");
                    tasktypeid = dy.getLong("id");
                }
            }
            Timestamp changetime = new Timestamp(System.currentTimeMillis());
            long operatorid = Long.parseLong(RequestContext.get().getUserId());
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_statechange");
            DynamicObject stateChangeobj = new DynamicObject((DynamicObjectType)type);
            stateChangeobj.set("message", (Object)ResManager.loadKDString((String)"\u5f71\u50cf\u91cd\u4f20", (String)"TaskInterUtils_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
            stateChangeobj.set("operatorid", (Object)operatorid);
            stateChangeobj.set("operation", (Object)"16");
            stateChangeobj.set("changetime", (Object)changetime);
            stateChangeobj.set("jobid", (Object)taskid);
            stateChangeobj.set("tasktype", (Object)tasktypeid);
            stateChangeobj.set(BILL_TYPE, (Object)billtype);
            stateChangeobj.set("oldjobstate", (Object)"2");
            stateChangeobj.set("newjobstate", (Object)"7");
            BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{stateChangeobj});
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private long getDataMapping(String scanUserID) {
        QFilter idFilter = new QFilter("extdataid", "=", (Object)scanUserID);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject datamapping = QueryServiceHelper.queryOne((String)"bas_datamapping", (String)"dataid", (QFilter[])filters);
        if (datamapping == null) {
            return -1L;
        }
        return datamapping.getLong("dataid");
    }

    private String getExternalerp(Object billid) {
        QFilter idFilter = new QFilter(BILLID, "=", billid);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject taskObject = QueryServiceHelper.queryOne((String)TASK_TASK, (String)BILL_TYPE, (QFilter[])filters);
        if (taskObject == null) {
            return "";
        }
        idFilter = new QFilter("id", "=", (Object)taskObject.getString(BILL_TYPE));
        filters = new QFilter[]{idFilter};
        DynamicObject taskbillObject = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"externalerp.number", (QFilter[])filters);
        return taskbillObject.getString("externalerp.number");
    }
}

