/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.service;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.invoice.util.InvoiceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InvoiceAutoRecognizedTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InvoiceAutoRecognizedTask.class);
    public static final String STATE = "state";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        logger.info("\u5f71\u50cf\u53d1\u7968\u8bc6\u522b\u5f00\u59cb!");
        InvoiceUtil invoiceUtil = new InvoiceUtil();
        boolean isRecog = invoiceUtil.isRecognizaInvoice();
        logger.info("\u6821\u9a8c\u662f\u5426\u8fdb\u884c\u53d1\u7968\u8bc6\u522b\uff1aisRecog=" + isRecog);
        if (isRecog) {
            DynamicObject[] col = this.getImageData();
            if (this.isNullCol(col)) {
                return;
            }
            if (!this.inMQQueue(col)) {
                return;
            }
            this.markReced(col);
        }
    }

    private boolean isNullCol(DynamicObject[] col) {
        logger.info("\u8bc6\u522b\u5f71\u50cf\u6570\uff1a" + col.length);
        if (col.length <= 0) {
            logger.error("\u6ca1\u6709\u5f71\u50cf\u9700\u8981\u8bc6\u522b");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inMQQueue(DynamicObject[] col) {
        logger.error("\u5165\u961fMQ");
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("bos", "kd.bos.invoice.service.invoice_queue");){
            for (DynamicObject obj : col) {
                pub.publish(obj.get("id"));
                logger.info(obj.getString("imagenumber") + "\uff1a\u5165\u961fMQ\u6210\u529f");
            }
        }
        return true;
    }

    private void markReced(DynamicObject[] col) {
        if (col != null && col.length > 0) {
            for (DynamicObject obj : col) {
                obj.set(STATE, (Object)"recognizing");
            }
            SaveServiceHelper.save((DynamicObject[])col);
        }
    }

    public DynamicObject[] getImageData() {
        String field = "id,billid,imagenumber,state";
        QFilter filter1 = new QFilter(STATE, "=", (Object)"");
        QFilter filter = new QFilter(STATE, "=", (Object)"retry").or(filter1);
        return BusinessDataServiceHelper.load((String)"task_imagequeue", (String)field, (QFilter[])filter.toArray(), null, (int)100);
    }
}

