/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.service;

import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.image.api.ImageService;
import kd.bos.invoice.service.InvoiceServiceInterface;
import kd.bos.invoice.util.InvoiceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class InvoiceRecConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(InvoiceRecConsumer.class);
    private static final String BILLID = "billid";
    private static final String IMAGE_NUMBER = "imagenumber";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object arg0, String arg1, boolean arg2, MessageAcker MessageAcker2) {
        String imageUrl;
        logger.info("id : " + arg0);
        if (arg0 == null || StringUtils.isEmpty((String)arg0.toString())) {
            logger.error("id \u4e3anull,\u4e0d\u7528\u8bc6\u522b");
            MessageAcker2.ack(arg1);
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(arg0.toString()), (String)"task_imagequeue");
        String billId = obj.getString(BILLID);
        String imageNumber = obj.getString(IMAGE_NUMBER);
        ImageService imageService = (ImageService)ServiceFactory.getService(ImageService.class);
        String userID = String.valueOf(RequestContext.get().getUserId());
        String userName = String.valueOf(RequestContext.get().getUserName());
        try {
            imageUrl = imageService.viewPhoto(imageNumber, userID, userName);
        }
        catch (Exception e) {
            logger.error("\u67e5\u770b\u5f71\u50cf\u62a5\u9519" + imageNumber, (Throwable)e);
            InvoiceUtil.changeRecStatus(billId, imageNumber, "retry");
            MessageAcker2.ack(arg1);
            return;
        }
        if (StringUtils.isEmpty((String)imageUrl)) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\uff1a%1$s\u65e0\u5f71\u50cf", (String)"InvoiceRecConsumer_0", (String)"bos-image-formplugin", (Object[])new Object[0]), imageNumber);
            InvoiceUtil.sendErrorMessage(msg, msg, "invoice", "kd.bos.invoice.service.InvoiceRecConsumer.onMessage");
            MessageAcker2.ack(arg1);
            return;
        }
        try {
            this.deleteInvoice(obj);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u53d1\u7968\u5b9e\u4f8b\u62a5\u9519" + e.getMessage(), (Throwable)e);
            InvoiceUtil.changeRecStatus(billId, imageNumber, "retry");
            MessageAcker2.ack(arg1);
            return;
        }
        logger.error("billId:" + billId + " imageNumber:" + imageNumber);
        InvoiceServiceInterface invoiceService = null;
        try {
            invoiceService = (InvoiceServiceInterface)this.isRecognizaInvoice();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5b9e\u4f8b\u62a5\u9519" + e.getMessage(), (Throwable)e);
            InvoiceUtil.changeRecStatus(billId, imageNumber, "retry");
            MessageAcker2.ack(arg1);
            return;
        }
        try {
            logger.info("imageUrl :" + imageUrl + ", userID:" + userID + ", userName:" + userName);
            invoiceService.recognitionAndSaveInvoice(imageUrl, billId, imageNumber);
            try {
                String billtype = InvoiceUtil.getBillTypeById(billId);
                HashSet<String> invoiceNoticeType = new HashSet<String>();
                invoiceNoticeType.add("er_dailyloanbill");
                invoiceNoticeType.add("er_dailyreimbursebill");
                invoiceNoticeType.add("er_tripreqbill");
                invoiceNoticeType.add("er_tripreimbursebill");
                invoiceNoticeType.add("market_account_bill");
                invoiceNoticeType.add("channel_account_bill");
                if (invoiceNoticeType.contains(billtype.trim())) {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"InvoiceService", (String)"addInvoiceIntoBill", (Object[])new Object[]{billtype, billId});
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u8d39\u7528\u53d1\u7968\u901a\u77e5\u63a5\u53e3\u51fa\u9519 :" + e.getMessage(), (Throwable)e);
            }
            MessageAcker2.ack(arg1);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u63a5\u53e3\u8bc6\u522b\u5f71\u50cf\u53d1\u7968\u51fa\u9519\uff01\u5355\u636eID\uff1a" + billId + ",\u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + "\u3002\u51fa\u9519\u539f\u56e0\uff1a" + e.getMessage(), (Throwable)e);
            InvoiceUtil.sendErrorMessage(String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\uff1a%1$s\u5728\u53d1\u7968\u8bc6\u522b\u65f6\u62a5\u9519\uff1a%2$s", (String)"InvoiceRecConsumer_1", (String)"bos-image-formplugin", (Object[])new Object[0]), imageNumber, e.getMessage()), imageNumber, "invoice", "kd.bos.invoice.service.InvoiceRecConsumer.onMessage");
            InvoiceUtil.changeRecStatus(billId, imageNumber, "error");
            MessageAcker2.ack(arg1);
        }
        finally {
            logger.info(imageNumber + "\u8bc6\u522b\u5b8c\u6bd5");
        }
    }

    private void changeRecStatus(DynamicObject obj) {
        String billId = obj.getString(BILLID);
        String imageNumber = obj.getString(IMAGE_NUMBER);
        String status = "error";
        QFilter fbillId = new QFilter(BILLID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber);
        QFilter[] filters = new QFilter[]{fbillId, fimageNumber};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"task_imagequeue", (String)"id,state", (QFilter[])filters);
        if (dynObjs != null && dynObjs.length > 0) {
            for (DynamicObject dynObj : dynObjs) {
                dynObj.set("state", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    private void deleteInvoice(DynamicObject obj) {
        String billId = obj.getString(BILLID);
        String imageNumber = obj.getString(IMAGE_NUMBER);
        QFilter fbillId = new QFilter(BILLID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber);
        QFilter filter = new QFilter(BILLID, "=", (Object)Long.parseLong(billId));
        DeleteServiceHelper.delete((String)"task_invoice", (QFilter[])new QFilter[]{fbillId, fimageNumber});
        DeleteServiceHelper.delete((String)"bos_invoice", (QFilter[])new QFilter[]{fbillId, fimageNumber});
        DeleteServiceHelper.delete((String)"task_invoicemaintain", (QFilter[])new QFilter[]{filter});
    }

    public Object isRecognizaInvoice() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        QFilter filter = new QFilter("paramname", "=", (Object)"InvoiceService");
        DynamicObject dy = QueryServiceHelper.queryOne((String)"task_paramcontrol", (String)"paramvalue", (QFilter[])filter.toArray());
        if (dy == null) {
            return Class.forName("kd.bos.invoice.service.InvoiceServiceInstituteImpl").newInstance();
        }
        String paramvalue = dy.getString("paramvalue");
        return Class.forName(paramvalue).newInstance();
    }
}

