/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.invoice.service.InvoiceServiceInterface;
import kd.bos.invoice.util.InvoiceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InvoiceServiceInstituteImpl
implements InvoiceServiceInterface {
    private static final String BILLID = "billid";
    private static final String INVOICE_DATE = "invoicedate";
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String IMAGE_PAGE = "imagepage";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String INVOICE_NUMBER = "invoicenumber";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String COMPANY_SALE = "companysale";
    private static final String TAX_NUMBER_SALE = "taxnumbersale";
    private static final String CONTACTSALE = "contactsale";
    private static final String BANK_INFORMATIONSALE = "bankinformationsale";
    private static final String COMPANY_BUY = "companybuy";
    private static final String TAX_NUMBER_BUY = "taxnumberbuy";
    private static final String CONTACT_BUY = "contactbuy";
    private static final String BANK_INFORMATION_BUY = "bankinformationbuy";
    private static final String AMOUNT = "amount";
    private static final String TAX = "tax";
    private static final String AMOUNT_TAX = "amounttax";
    private static final String TRANSFEROUT = "transferout";
    private static final String DEDUCTIBLE = "deductible";
    private static final String AUTHENTICATE_DATE = "authenticatedate";
    private static final String DUE_DATE = "duedate";
    private static final String AUTHENTICATE_STATUS = "authenticatestatus";
    private static final String AUTHENTICATE_WAY = "authenticateway";
    private static final String AUTHENTICATORID = "authenticatorid";
    private static final String AUTHWORD = "password";
    private static final String IS_CREDITNOTE = "iscreditnote";
    private static final String HAS_STAMP = "hasstamp";
    private static final String IS_TRUE = "istrue";
    private static final String ENTRY = "entryentity";
    private static final String PRODUCT_NAME = "productname";
    private static final String TAX_EXCLUDED = "taxexcluded";
    private static final String TAX_PRICE = "taxprice";
    private static final String QUANTITY = "quantity";
    private static final String MONEY = "money";
    private static final String TAXAMT = "taxamt";
    private static final String TAX_TOTAL = "taxtotal";
    private static final String TAX_RATE = "taxrate";
    private static final String SPECS = "specs";
    private static final String MEASUREUNITID = "measureunitid";
    private static final String MATERIALID = "materialid";
    private static final String VOUCHERID = "voucherid";
    private static final Log logger = LogFactory.getLog(InvoiceServiceInstituteImpl.class);
    private static ORM orm = ORM.create();

    public void recognitionAndSaveInvoice(String imageUrl, String billId, String imageNumber) throws IOException, ParseException, Exception {
        InvoiceUtil invoiceUtil = new InvoiceUtil();
        InvoiceUtil.changeRecStatus(billId, imageNumber, "recognizing");
        logger.info("\u8c03\u7528\u7814\u7a76\u9662\u8bc6\u522b\u63a5\u53e3,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        String result = invoiceUtil.getImageResult(imageUrl);
        logger.error("\u5f71\u50cf\u8bc6\u522b\u7ed3\u679c:" + result);
        logger.info("\u8c03\u7528\u7814\u7a76\u9662\u8bc6\u522b\u63a5\u53e3\u5b8c\u6bd5,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        if (result.equals("")) {
            logger.info("\u8fde\u63a5\u53d1\u7968\u8bc6\u522b\u63a5\u53e3\u8d85\u65f6,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
            InvoiceUtil.changeRecStatus(billId, imageNumber, "overtime");
            return;
        }
        ArrayList invoiceList = new ArrayList();
        this.parseJson(billId, imageNumber, result, null);
        logger.info("\u8f6c\u6362json\u5b8c\u6bd5,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        if (invoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
        }
        InvoiceUtil.changeRecStatus(billId, imageNumber, "recognized");
        InvoiceUtil.deleteRegData(billId, imageNumber);
    }

    public Map parseJson(String billId, String imageNumber, String result, Integer page) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        logger.error("\u7814\u7a76\u9662\u8fd4\u56de\u7684JSON\u7ed3\u679c :" + result);
        JSONObject json = JSONObject.parseObject((String)result);
        HashMap map = new HashMap();
        int errorCode = json.getInteger("errcode");
        if (errorCode == 0) {
            JSONObject data = json.getJSONObject("data");
            int invoiceNum = data.getInteger("resultNum");
            if (invoiceNum > 0) {
                JSONArray resultArray = data.getJSONArray("resultList");
                JSONObject obj = null;
                DynamicObject invoiceObj = null;
                int size = resultArray.size();
                for (int i = 0; i < size; ++i) {
                    obj = resultArray.getJSONObject(i);
                    invoiceObj = orm.newDynamicObject("task_invoice");
                    String fphm = obj.getString("fphm");
                    String fprq = obj.getString("kprq");
                    if (fphm == null || fphm.trim().equals("")) {
                        logger.info("the invoice infomation is incomplete,next\uff01");
                        continue;
                    }
                    try {
                        invoiceObj.set(BILLID, (Object)billId);
                        invoiceObj.set(IMAGE_NUMBER, (Object)imageNumber);
                        invoiceObj.set(IMAGE_PAGE, (Object)obj.getInteger("pageOrder"));
                        if (fprq != null && !"".equals(fprq.trim())) {
                            invoiceObj.set(INVOICE_DATE, (Object)dateFormat.parse(fprq));
                        }
                        invoiceObj.set(INVOICE_CODE, (Object)obj.getString("fpdm"));
                        invoiceObj.set(INVOICE_TYPE, (Object)obj.getString("invoiceType"));
                        invoiceObj.set(INVOICE_NUMBER, (Object)fphm);
                        invoiceObj.set(HAS_STAMP, (Object)obj.getBooleanValue("hasSeal"));
                        invoiceObj.set(IS_TRUE, (Object)(obj.getInteger("verifyStatus") == 1 ? 1 : 0));
                        JSONObject otherInfo = obj.getJSONObject("otherInfo");
                        JSONObject sale = otherInfo.getJSONObject("sale");
                        invoiceObj.set(COMPANY_SALE, (Object)sale.getString("name"));
                        invoiceObj.set(TAX_NUMBER_SALE, (Object)sale.getString("taxpayerId"));
                        invoiceObj.set(CONTACTSALE, (Object)sale.getString("address_PhoneNumber"));
                        invoiceObj.set(BANK_INFORMATIONSALE, (Object)sale.getString("bank_AccountNumber"));
                        JSONObject purchaser = otherInfo.getJSONObject("purchaser");
                        invoiceObj.set(COMPANY_BUY, (Object)purchaser.getString("name"));
                        invoiceObj.set(TAX_NUMBER_BUY, (Object)purchaser.getString("taxpayerId"));
                        invoiceObj.set(CONTACT_BUY, (Object)purchaser.getString("address_PhoneNumber"));
                        invoiceObj.set(BANK_INFORMATION_BUY, (Object)purchaser.getString("bank_AccountNumber"));
                        invoiceObj.set(AMOUNT, (Object)purchaser.getString("sum_money"));
                        invoiceObj.set(TAX, (Object)purchaser.getString("sum_tax"));
                        invoiceObj.set(AMOUNT_TAX, (Object)purchaser.getString("sum"));
                        invoiceObj.set(VOUCHERID, (Object)0);
                        JSONArray service = purchaser.getJSONArray("service");
                        DynamicObjectCollection col = invoiceObj.getDynamicObjectCollection(ENTRY);
                        DynamicObject entry = null;
                        if (service == null) continue;
                        int k = service.size();
                        for (int j = 0; j < k; ++j) {
                            JSONObject ser = service.getJSONObject(j);
                            entry = new DynamicObject(col.getDynamicObjectType());
                            entry.set(PRODUCT_NAME, (Object)ser.getString("service"));
                            entry.set(TAX_EXCLUDED, (Object)ser.getString("unitPrice"));
                            entry.set(QUANTITY, (Object)ser.getString("number"));
                            entry.set(MONEY, (Object)ser.getString(AMOUNT));
                            entry.set(TAXAMT, (Object)ser.getString(TAX));
                            entry.set(TAX_RATE, (Object)ser.getString("taxRate").substring(0, ser.getString("taxRate").length() - 1));
                            entry.set(SPECS, (Object)ser.getString("specification_model"));
                            col.add((Object)entry);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.info("\u89e3\u6790\u53d1\u7968JSON\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage());
                        logger.error("\u89e3\u6790\u53d1\u7968JSON\u6570\u636e\u51fa\u9519\uff0c", (Throwable)e);
                    }
                }
            }
        } else {
            logger.info("The image:" + imageNumber + " recognizate fail.ErrorCode is" + errorCode);
        }
        return map;
    }
}

