/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.invoice.common.InvoiceTypeEnum;
import kd.bos.invoice.service.InvoiceServiceInterface;
import kd.bos.invoice.util.DownLoadImageUtil;
import kd.bos.invoice.util.InvoiceUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class InvoiceServicePiaoZoneImpl
implements InvoiceServiceInterface {
    private static final String BILLID = "billid";
    private static final String INVOICE_DATE = "invoicedate";
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String IMAGE_PAGE = "imagepage";
    private static final String CREATETIME = "createtime";
    private static final String CHECK_CODE = "checkcode";
    private static final String INVOICE_CODE = "invoicecode";
    private static final String INVOICE_NUMBER = "invoicenumber";
    private static final String INVOICE_TYPE = "invoicetype";
    private static final String COMPANY_SALE = "companysale";
    private static final String TAX_NUMBER_SALE = "taxnumbersale";
    private static final String CONTACT_SALE = "contactsale";
    private static final String BANK_INFORMATION_SALE = "bankinformationsale";
    private static final String COMPANY_BUY = "companybuy";
    private static final String TAX_NUMBER_BUY = "taxnumberbuy";
    private static final String CONTACT_BUY = "contactbuy";
    private static final String BANK_INFORMATION_BUY = "bankinformationbuy";
    private static final String AMOUNT = "amount";
    private static final String TAX = "tax";
    private static final String AMOUNT_TAX = "amounttax";
    private static final String IS_TRUE = "istrue";
    private static final String ENTRY = "entryentity";
    private static final String PRODUCT_NAME = "productname";
    private static final String TAX_EXCLUDED = "taxexcluded";
    private static final String QUANTITY = "quantity";
    private static final String MONEY = "money";
    private static final String TAXAMT = "taxamt";
    private static final String TAX_RATE = "taxrate";
    private static final String SPECS = "specs";
    private static final String VOUCHERID = "voucherid";
    private static final String REMARK = "remark";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateFormat0 = new SimpleDateFormat("yyyyMMdd");
    public static final String RESULT = "result";
    public static final String INVOICE_LIST = "invoice_list";
    public static final String AVT_INVOICE_LIST = "avt_invoice_list";
    public static final String SERIAL_LIST = "serial_list";
    public static final String INVOICE_NO = "invoiceNo";
    public static final String ITEMS = "items";
    private static ORM orm = ORM.create();
    private static final Log logger = LogFactory.getLog(InvoiceServicePiaoZoneImpl.class);
    private static final String INVOICECLOUD = "1";
    private static final String ERRORDESCNO_SUCCESS = "0000";
    private static final String ERRORDESCNO_OVERTIME = "1002";
    private static final String RECOG_URL = "/m3/bill/invoice/img/analyze/multiple/check?access_token=";
    private static final HashMap<String, String[]> BUILD_INDEXFIELD_INVOICETYPE = new HashMap<String, String[]>(){
        {
            this.put("9", new String[]{"printingSequenceNo", "trainNum", "invoiceDate"});
            this.put("10", new String[]{"electronicTicketNum", "customerIdentityNum", "printNum"});
        }
    };

    public void recognitionAndSaveInvoice(String imageUrl, String billId, String imageNumber) throws IOException {
        File file;
        InvoiceUtil.changeRecStatus(billId, imageNumber, "recognizing");
        logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u8bc6\u522b\u63a5\u53e3,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber + " \u5f71\u50cf\u94fe\u63a5\uff1a" + imageUrl);
        Map result = new HashMap();
        String baseUrl = InvoiceUtil.getUrl();
        String checkUrl = baseUrl + RECOG_URL;
        String token = InvoiceUtil.getToken(baseUrl, imageNumber);
        if (token == null || "null".equals(token)) {
            InvoiceUtil.sendErrorMessage(ResManager.loadKDString((String)"token\u4e3a\u7a7a", (String)"InvoiceServicePiaoZoneImpl_0", (String)"bos-image-formplugin", (Object[])new Object[0]), imageNumber, "invoice", "kd.bos.invoice.service.InvoiceServicePiaoZoneImpl.recognitionAndSaveInvoice");
            InvoiceUtil.changeRecStatus(billId, imageNumber, "retry");
            return;
        }
        logger.info("checkUrl :" + checkUrl);
        ArrayList invoiceList = new ArrayList();
        ArrayList AvtInvoiceList = new ArrayList();
        ArrayList SerialList = new ArrayList(10);
        List<String> filePath = DownLoadImageUtil.downLoadImage(imageUrl);
        for (int i = 1; i < filePath.size(); ++i) {
            logger.info("\u7b2c" + i + "\u5f20\u5f71\u50cf\u5730\u5740\uff1a" + filePath.get(i));
            File file2 = new File(FilenameUtils.getName((String)filePath.get(i)));
            if (!file2.exists()) {
                logger.info("\u7b2c" + i + "\u5f20\u5f71\u50cf\u8bc6\u522b\u5931\u8d25");
                break;
            }
            try {
                logger.info(filePath.get(i) + "\u5f71\u50cf\u5f00\u59cb\u8bc6\u522b");
                for (int j = 0; j < 2 && StringUtils.isEmpty((String)((String)(result = InvoiceUtil.piaozoneCheck(checkUrl, token, baseUrl, imageNumber, InvoiceUtil.GetImageStr(filePath.get(i)))).get(RESULT))); ++j) {
                }
                logger.info("\u56fe\u7247\u540d\u79f0:" + i + "\u8c03\u7528\u53d1\u7968\u4e91\u8bc6\u522b\u63a5\u53e3\u8bc6\u522b\u7ed3\u679c\u5b8c\u6bd5result:" + (String)result.get(RESULT));
            }
            catch (Exception e) {
                logger.error("\u8bc6\u522b\u5931\u8d25" + e.getMessage(), (Throwable)e);
            }
            if (!file2.delete()) {
                logger.error(filePath.get(i) + "\u5220\u9664\u6587\u4ef6\u5931\u8d25");
            }
            if (StringUtils.isEmpty((String)((String)result.get(RESULT)))) {
                InvoiceUtil.changeRecStatus(billId, imageNumber, "overtime", i);
                InvoiceUtil.saveInvoiceMaintain(INVOICECLOUD, billId, null, null, imageNumber, ERRORDESCNO_OVERTIME, i);
                continue;
            }
            Map map = this.parseJson(billId, imageNumber, (String)result.get(RESULT), i);
            if (map.get(AVT_INVOICE_LIST) != null && ((List)map.get(AVT_INVOICE_LIST)).size() > 0) {
                AvtInvoiceList.addAll((List)map.get(AVT_INVOICE_LIST));
            }
            if (map.get(INVOICE_LIST) != null && ((List)map.get(INVOICE_LIST)).size() > 0) {
                invoiceList.addAll((List)map.get(INVOICE_LIST));
            }
            if (map.get(SERIAL_LIST) == null || ((List)map.get(SERIAL_LIST)).size() <= 0) continue;
            SerialList.addAll((List)map.get(SERIAL_LIST));
        }
        if (filePath.size() >= 1 && !(file = new File(FilenameUtils.getName((String)filePath.get(0)))).delete()) {
            logger.error(filePath.get(0) + "\u5220\u9664\u6587\u4ef6\u5931\u8d25");
        }
        logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u8bc6\u522b\u63a5\u53e3\u5b8c\u6bd5,\u5355\u636eID\uff1a" + billId + " \u5f71\u50cf\u7f16\u7801\uff1a" + imageNumber);
        if (filePath.size() == 1) {
            InvoiceUtil.changeRecStatus(billId, imageNumber, "noinvoice");
            return;
        }
        if (AvtInvoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])AvtInvoiceList.toArray(new DynamicObject[0]));
        }
        if (invoiceList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
            InvoiceUtil.changeRecStatus(billId, imageNumber, "success");
        } else {
            InvoiceUtil.changeRecStatus(billId, imageNumber, "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImageBase64Str(String filepath) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(FilenameUtils.getName((String)filepath));
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u56fe\u7247\u94fe\u63a5\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519");
                }
            }
        }
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(data);
    }

    public Map parseJson(String billId, String imageNumber, String result, Integer page) {
        JSONObject json = JSONObject.parseObject((String)result);
        String errorCode = json.getString("errcode");
        HashMap map = new HashMap();
        DynamicObject avtInvoiceObj = null;
        DynamicObject invoiceObj = null;
        if (ERRORDESCNO_SUCCESS.equals(errorCode)) {
            JSONArray dataArray = json.getJSONArray("data");
            if (dataArray.size() <= 0) {
                return map;
            }
            ArrayList<DynamicObject> avtInvoiceList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> invoiceList = new ArrayList<DynamicObject>();
            ArrayList<String> serialNumberList = new ArrayList<String>();
            JSONObject data = null;
            for (int i = 0; i < dataArray.size(); ++i) {
                try {
                    data = (JSONObject)dataArray.get(i);
                    if (this.isAddedValueTaxInvoice(data.getString("invoiceType"))) {
                        avtInvoiceObj = this.recognizeAVTInvoice(data, billId, imageNumber, page);
                        avtInvoiceList.add(avtInvoiceObj);
                    }
                    invoiceObj = this.recognizeAllInvoice(data, billId, imageNumber, page, serialNumberList);
                    invoiceList.add(invoiceObj);
                    continue;
                }
                catch (Exception e) {
                    logger.error("billid:" + billId + ",imagenumber:" + imageNumber + "\uff0c\u9875\u7801\uff1a" + page + ",\u89e3\u6790\u53d1\u7968JSON\u6570\u636e\u51fa\u9519\uff0c" + e.getMessage(), (Throwable)e);
                    if (data == null) continue;
                    InvoiceUtil.saveInvoiceMaintain(INVOICECLOUD, billId, data.getString(INVOICE_NO), data.getString("invoiceCode"), imageNumber, errorCode, page);
                }
            }
            map.put(AVT_INVOICE_LIST, avtInvoiceList);
            map.put(INVOICE_LIST, invoiceList);
            map.put(SERIAL_LIST, serialNumberList);
        } else {
            InvoiceUtil.saveInvoiceMaintain(INVOICECLOUD, billId, null, null, imageNumber, errorCode, page);
        }
        return map;
    }

    private DynamicObject recognizeAllInvoice(JSONObject data, String billId, String imageNumber, int size, List<String> serialNumberList) throws Exception {
        DynamicObject invoiceObj = orm.newDynamicObject("bos_invoice");
        String isTrue = "0";
        invoiceObj.set(BILLID, (Object)billId);
        invoiceObj.set(IMAGE_NUMBER, (Object)imageNumber);
        invoiceObj.set(IMAGE_PAGE, (Object)size);
        invoiceObj.set(INVOICE_CODE, (Object)data.getString("invoiceCode"));
        invoiceObj.set(INVOICE_DATE, (Object)data.getString("invoiceDate"));
        invoiceObj.set(INVOICE_TYPE, (Object)data.getString("invoiceType"));
        invoiceObj.set("invoiceno", (Object)data.getString(INVOICE_NO));
        invoiceObj.set(CREATETIME, (Object)new Date());
        serialNumberList.add(data.getString("serialNo"));
        String checkStatus = data.getString("checkStatus");
        if (INVOICECLOUD.equals(checkStatus)) {
            isTrue = INVOICECLOUD;
            JSONArray items = data.getJSONArray(ITEMS);
            if (items != null) {
                DynamicObjectCollection entryentityCollection = (DynamicObjectCollection)invoiceObj.get(ENTRY);
                DynamicObjectType entryentityType = entryentityCollection.getDynamicObjectType();
                for (int i = 0; i < items.size(); ++i) {
                    JSONObject ser = items.getJSONObject(i);
                    Iterator iterator0 = ser.entrySet().iterator();
                    while (iterator0.hasNext()) {
                        DynamicObject entryEntity = new DynamicObject(entryentityType);
                        Map.Entry entry0 = (Map.Entry)iterator0.next();
                        entryEntity.set("invoiceentrykey", entry0.getKey());
                        entryEntity.set("invoiceentryvalue", entry0.getValue());
                        entryEntity.set("invoiceentryindex", (Object)i);
                        entryentityCollection.add((Object)entryEntity);
                    }
                }
                data.remove((Object)ITEMS);
            }
        } else {
            InvoiceUtil.saveInvoiceMaintain(INVOICECLOUD, billId, data.getString(INVOICE_NO), data.getString("invoiceCode"), imageNumber, data.getString("checkErrcode"), size);
        }
        DynamicObjectCollection entryKeyValueCollection = (DynamicObjectCollection)invoiceObj.get("entrykeyvalue");
        DynamicObjectType entryKeyValueType = entryKeyValueCollection.getDynamicObjectType();
        Iterator iterator = data.entrySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject entryKeyValue = new DynamicObject(entryKeyValueType);
            Map.Entry entry = (Map.Entry)iterator.next();
            entryKeyValue.set("invoicekey", entry.getKey());
            entryKeyValue.set("invoicevalue", entry.getValue());
            entryKeyValueCollection.add((Object)entryKeyValue);
        }
        DynamicObject entryKeyValue = new DynamicObject(entryKeyValueType);
        entryKeyValue.set("invoicekey", (Object)"isTrue");
        entryKeyValue.set("invoicevalue", (Object)isTrue);
        entryKeyValueCollection.add((Object)entryKeyValue);
        String indexField = this.getIndexField(data, data.getString("invoiceType"));
        if (indexField != null) {
            invoiceObj.set("indexfield", (Object)indexField);
        }
        return invoiceObj;
    }

    private DynamicObject recognizeAVTInvoice(JSONObject data, String billId, String imageNumber, int imagePage) throws Exception {
        DynamicObject invoiceObj = orm.newDynamicObject("task_invoice");
        invoiceObj.set(BILLID, (Object)billId);
        invoiceObj.set(IMAGE_NUMBER, (Object)imageNumber);
        invoiceObj.set(IMAGE_PAGE, (Object)imagePage);
        invoiceObj.set(INVOICE_NUMBER, (Object)data.getString(INVOICE_NO));
        invoiceObj.set(INVOICE_CODE, (Object)data.getString("invoiceCode"));
        invoiceObj.set(INVOICE_DATE, (Object)this.getInvoiceDate(data.getString("invoiceDate")));
        invoiceObj.set(INVOICE_TYPE, (Object)this.transformInvoicetype(data.getString("invoiceType")));
        invoiceObj.set(CHECK_CODE, (Object)data.getString("checkCode"));
        invoiceObj.set(AMOUNT_TAX, (Object)data.getString("totalAmount"));
        invoiceObj.set(AMOUNT, (Object)data.getString("invoiceMoney"));
        invoiceObj.set(CREATETIME, (Object)new Date());
        invoiceObj.set(COMPANY_SALE, (Object)data.getString("salerName"));
        invoiceObj.set(TAX_NUMBER_SALE, (Object)data.getString("salerTaxNo"));
        invoiceObj.set(CONTACT_SALE, (Object)data.getString("salerAddressPhone"));
        invoiceObj.set(BANK_INFORMATION_SALE, (Object)data.getString("salerAccount"));
        invoiceObj.set(COMPANY_BUY, (Object)data.getString("buyerName"));
        invoiceObj.set(TAX_NUMBER_BUY, (Object)data.getString("buyerTaxNo"));
        invoiceObj.set(CONTACT_BUY, (Object)data.getString("buyerAddressPhone"));
        invoiceObj.set(BANK_INFORMATION_BUY, (Object)data.getString("buyerAccount"));
        invoiceObj.set(REMARK, (Object)data.getString(REMARK));
        invoiceObj.set(VOUCHERID, (Object)0);
        invoiceObj.set(TAX, (Object)data.getString("taxAmount"));
        String checkStatus = data.getString("checkStatus");
        if (INVOICECLOUD.equals(checkStatus)) {
            invoiceObj.set(IS_TRUE, (Object)Boolean.TRUE);
            JSONArray items = data.getJSONArray(ITEMS);
            if (items != null) {
                DynamicObjectCollection col = invoiceObj.getDynamicObjectCollection(ENTRY);
                int k = items.size();
                for (int j = 0; j < k; ++j) {
                    JSONObject ser = items.getJSONObject(j);
                    DynamicObject entry = new DynamicObject(col.getDynamicObjectType());
                    if (StringUtils.isNotEmpty((String)ser.getString("taxRate"))) {
                        entry.set(TAX_RATE, (Object)this.parseStringToDecimal(ser.getString("taxRate").substring(0, ser.getString("taxRate").length() - 1)));
                    }
                    col.add((Object)entry);
                }
            }
        } else {
            invoiceObj.set(IS_TRUE, (Object)Boolean.FALSE);
        }
        return invoiceObj;
    }

    private Date getInvoiceDate(String invoiceDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat0 = new SimpleDateFormat("yyyyMMdd");
        if (invoiceDate == null) {
            return null;
        }
        try {
            if (invoiceDate.contains("-")) {
                return dateFormat.parse(invoiceDate);
            }
            return dateFormat0.parse(invoiceDate);
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u5316\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private BigDecimal parseStringToDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            return new BigDecimal("0.00");
        }
    }

    private boolean isAddedValueTaxInvoice(String invoiceType) {
        if (invoiceType == null) {
            return false;
        }
        return INVOICECLOUD.equals(invoiceType) || "3".equals(invoiceType) || "4".equals(invoiceType) || "5".equals(invoiceType);
    }

    private boolean isSupportVerify(String invoiceType) {
        if (invoiceType == null) {
            return false;
        }
        return InvoiceTypeEnum.GENERALELECTRONICINVOICE.getValue().equals(invoiceType) || InvoiceTypeEnum.GENERALPAPERINVOICE.getValue().equals(invoiceType) || InvoiceTypeEnum.PAPERSPECIALINVOICE.getValue().equals(invoiceType) || InvoiceTypeEnum.GENERALPAPERTICKETS.getValue().equals(invoiceType) || InvoiceTypeEnum.MOTORVEHICLEINVOICE.getValue().equals(invoiceType) || InvoiceTypeEnum.USEDCARINVOICE.getValue().equals(invoiceType) || InvoiceTypeEnum.TOLLINVOICE.getValue().equals(invoiceType);
    }

    private String removeTransverseLine(String invoiceDate) {
        char[] chars = invoiceDate.toCharArray();
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            str.append(chars[i]);
        }
        return str.toString();
    }

    private String transformInvoicetype(String type) {
        switch (type) {
            case "1": {
                type = "10";
                break;
            }
            case "2": {
                type = "05";
                break;
            }
            case "3": {
                type = "04";
                break;
            }
            case "4": {
                type = "01";
                break;
            }
            case "12": {
                type = "03";
                break;
            }
            case "5": {
                type = "104";
                break;
            }
        }
        return type;
    }

    private Map<String, String> load() {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter filter = new QFilter("enable", "=", (Object)INVOICECLOUD);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"task_invoicevarietymap", (String)"id,sourceinvoicevarietycode,targetinvoicevarietycode", (QFilter[])filters);
        if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) {
            return null;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            map.put(dynamicObject.getString("sourceinvoicevarietycode").trim(), dynamicObject.getString("targetinvoicevarietycode").trim());
        }
        return map;
    }

    private String getIndexField(JSONObject data, String invoiceType) {
        String[] relyDataKeys = BUILD_INDEXFIELD_INVOICETYPE.get(invoiceType);
        if (relyDataKeys != null) {
            StringBuilder sb = new StringBuilder();
            for (String key : relyDataKeys) {
                String relyString = data.getString(key);
                if (relyString == null) continue;
                sb.append(key).append('=').append(relyString).append('|');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                return sb.toString();
            }
            return null;
        }
        return null;
    }
}

