/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class DownLoadImageUtil {
    private static final Log logger = LogFactory.getLog(DownLoadImageUtil.class);
    private static final String ENCODING = "UTF-8";
    private static final String IMGURL_REG = "href='downloaddata.ashx\"?(.*?)=(\"|>|\\S+)";
    private static final String IMAGENAME_REG = "\\d+.Jpeg";

    public static List<String> downLoadImage(String htmlUrl) {
        logger.info("\u4e0b\u8f7d\u56fe\u7247-start");
        if (StringUtils.isEmpty((Object)htmlUrl)) {
            logger.error("\u83b7\u53d6\u9053\u53ef\u7ef4\u65af\u67e5\u770b\u5f71\u50cf\u7684url\u4e3a\u7a7a\uff0c\u4e0b\u8f7d\u7ed3\u675f");
            return new ArrayList<String>();
        }
        String content = DownLoadImageUtil.getHtml(htmlUrl);
        logger.info("\u83b7\u53d6\u5f71\u50cf\u94fe\u63a5\u7684\u5185\u5bb9\u7684content :" + content);
        List<String> imgUrl = DownLoadImageUtil.getImageUrl(content);
        if (imgUrl != null && imgUrl.size() > 0) {
            logger.info("\u83b7\u53d6\u56fe\u7247\u5730\u5740\u7684imgUrl :" + imgUrl);
            ArrayList<String> filePath = new ArrayList<String>();
            DownLoadImageUtil.downloadImgByNet(imgUrl, filePath, htmlUrl);
            logger.info("\u4e0b\u8f7d\u7ed3\u675f-filePath.size :" + filePath.size() + ",filePath :" + filePath);
            return filePath;
        }
        logger.error("\u83b7\u53d6\u56fe\u7247\u5730\u5740\u7684imgUrl\u4e3a\u7a7a\uff0c\u4e0b\u8f7d\u7ed3\u675f");
        return new ArrayList<String>();
    }

    public static String getHtml(String htmlurl) {
        StringBuilder sb = new StringBuilder();
        try {
            URL url = new URL(htmlurl);
            URLConnection conn = url.openConnection();
            try (InputStream instream = conn.getInputStream();){
                byte[] b = new byte[1024];
                while (instream.read(b, 0, b.length) != -1) {
                    sb.append(new String(b, ENCODING));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6html\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public static List<String> getImageUrl(String htmlContent) {
        ArrayList<String> imgUrl = new ArrayList<String>();
        Matcher matcher = null;
        try {
            matcher = Pattern.compile(IMGURL_REG).matcher(htmlContent);
            while (matcher.find()) {
                if (imgUrl.contains(matcher.group())) continue;
                imgUrl.add(matcher.group());
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e26img\u6807\u7b7e\u7684\u5185\u5bb9\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
        return imgUrl;
    }

    public static void downloadImgByNet(List<String> imgSrc, List<String> filePath, String htmlUrl) {
        String domainName = DownLoadImageUtil.getDomainName(htmlUrl);
        logger.info("domainName :" + domainName);
        Iterator<String> iterator = imgSrc.iterator();
        while (iterator.hasNext()) {
            String src = iterator.next();
            String filename = DownLoadImageUtil.getImageName(src = src.substring(6, src.length() - 1));
            if (filename == null) continue;
            filePath.add(filename);
            src = domainName + src;
            try {
                URL url = new URL(src);
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(3000);
                conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
                byte[] bs = new byte[1024];
                int len = 0;
                File file = new File(FilenameUtils.getName((String)filename));
                try (InputStream str = conn.getInputStream();
                     FileOutputStream out = new FileOutputStream(file);){
                    while ((len = str.read(bs)) != -1) {
                        out.write(bs, 0, len);
                    }
                    out.flush();
                }
            }
            catch (IOException e) {
                logger.error("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25" + e.getMessage(), (Throwable)e);
                iterator.remove();
                continue;
            }
            logger.info("\u56fe\u7247\u4e0b\u8f7d\u6210\u529f\uff1a" + filename);
        }
    }

    private static String getImageName(String src) {
        Pattern patten = Pattern.compile(IMAGENAME_REG);
        Matcher matcher = patten.matcher(src);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static String getDomainName(String url) {
        String content = "http://.*/X-Smart.WebImageViewer/";
        Pattern pattern = Pattern.compile(content);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return "http://kdyx.kingdee.com/X-Smart.WebImageViewer/";
    }
}

