/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.invoice.util;

import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.BosImageDistributeSessionCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class InvoiceUtil {
    private static final String ERRCODE = "errcode";
    private static final String TASK_PARAMCONTROL = "task_paramcontrol";
    private static final String PARAM_VALUE = "paramvalue";
    private static final String PARAM_NAME = "paramname";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String TIMESTAMP = "timestamp";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String BILL_NUMBER = "billnumber";
    private static final String CLIENT_ID1 = "client_id";
    private static final String BILLTYPE = "billtype";
    private static final String BILL_ID = "billid";
    private static final String IMAGE_NUMBER = "imagenumber";
    private static final String TASK_IMAGEQUEUE = "task_imagequeue";
    private static PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
    private static final Log logger;
    private static final int MAX_TOTAL = 4;
    private static final int MAX_PER_ROUTE = 2;
    private static ORM orm;
    private static final String SAVE_URL = "/m4/fpzs/expense/entry/save";
    private static final int CONNECTIONTIMEOUT = 30000;
    private static final int READTIMEOUT = 30000;
    private static final String ERRORDESCNO_SUCCESS = "0000";

    public static String getMD5(String str) {
        try {
            Class<?> mdClass = Class.forName("java.security.MessageDigest");
            Method method = mdClass.getMethod("getInstance", String.class);
            MessageDigest md = (MessageDigest)method.invoke(null, "MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            logger.error("\u8ba1\u7b97md5\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetImageStr(String imgFile) {
        if (StringUtils.isEmpty((String)imgFile)) {
            return "";
        }
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(FilenameUtils.getName((String)imgFile));
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u56fe\u7247\u94fe\u63a5\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u5165\u6d41\u51fa\u9519");
                }
            }
        }
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(data);
    }

    public static Map piaozoneCheck(String checkUrl, String token, String baseUrl, String imageNumber, String bodyJson) {
        HashMap<String, String> content = new HashMap<String, String>();
        content.put("token", token);
        String url = checkUrl + token;
        logger.info("url:" + url + " bodyJson:" + bodyJson);
        String result = InvoiceUtil.sendHttpsRequestByPost(url, bodyJson, 30000, 30000);
        JSONObject json = JSONObject.parseObject((String)result);
        String errorCode = json.getString(ERRCODE);
        if ("1300".equals(errorCode)) {
            String originToken = InvoiceUtil.getOriginToken(baseUrl, imageNumber);
            if (StringUtils.isEmpty((String)originToken)) {
                content.put("result", null);
                return content;
            }
            url = checkUrl + originToken;
            content.put("token", originToken);
            result = InvoiceUtil.sendHttpsRequestByPost(url, bodyJson, 30000, 30000);
        }
        content.put("result", result);
        return content;
    }

    public static String getUrl() {
        DynamicObject invoiceCloudEnv = QueryServiceHelper.queryOne((String)TASK_PARAMCONTROL, (String)PARAM_VALUE, (QFilter[])new QFilter[]{new QFilter(PARAM_NAME, "=", (Object)"invoiceCloudUrl")});
        if (invoiceCloudEnv == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5171\u4eab\u63a7\u5236\u53d8\u91cf\u672a\u8bbe\u7f6e\u53d1\u7968\u4e91url", (String)"InvoiceUtil_8", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String baseUrl = invoiceCloudEnv.getString(PARAM_VALUE);
        return baseUrl;
    }

    public void getInvoiceToken(IFormView iFormView) {
        String baseUrl = InvoiceUtil.getUrl();
        String loginUrl = baseUrl + "/base/oauth/token";
        Map<String, String> clientMap = InvoiceUtil.getClientParam();
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = InvoiceUtil.getMD5(clientId + clientSecret + timeStamp);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CLIENT_ID1, (Object)clientId);
        jsonObject.put("sign", (Object)sign);
        jsonObject.put(TIMESTAMP, (Object)timeStamp);
        StringBuilder showMessage = new StringBuilder();
        showMessage.append(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\uff1a", (String)"InvoiceUtil_9", (String)"bos-image-formplugin", (Object[])new Object[0])).append('\n');
        showMessage.append("loginUrl\uff1a").append(loginUrl).append('\n');
        showMessage.append("clientId\uff1a").append(clientId).append('\n');
        showMessage.append("clientSecret\uff1a").append(clientSecret).append('\n');
        showMessage.append("sign\uff1a").append(sign).append('\n');
        showMessage.append("connectionTimeout\uff1a").append(30000).append('\n');
        showMessage.append("readTimeout\uff1a").append(30000).append('\n');
        showMessage.append(ResManager.loadKDString((String)"\u54cd\u5e94\u7ed3\u679c\uff1a", (String)"InvoiceUtil_10", (String)"bos-image-formplugin", (Object[])new Object[0])).append('\n');
        String result = InvoiceUtil.sendHttpsRequestByPost(loginUrl, jsonObject.toJSONString(), 30000, 30000);
        jsonObject = JSONObject.parseObject((String)result);
        String errcode = jsonObject.getString(ERRCODE);
        if (errcode.equals(ERRORDESCNO_SUCCESS)) {
            showMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6token\u6210\u529f\uff01", (String)"InvoiceUtil_11", (String)"bos-image-formplugin", (Object[])new Object[0])).append('\n');
            showMessage.append("access_token\uff1a").append(jsonObject.getString(ACCESS_TOKEN)).append('\n');
        } else {
            showMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff01", (String)"InvoiceUtil_12", (String)"bos-image-formplugin", (Object[])new Object[0])).append('\n');
            showMessage.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a", (String)"InvoiceUtil_13", (String)"bos-image-formplugin", (Object[])new Object[0])).append(jsonObject.toJSONString()).append('\n');
        }
        iFormView.showMessage(ResManager.loadKDString((String)"\u53d1\u7968\u8bc6\u522b\u83b7\u53d6token\u63a5\u53e3\u6d4b\u8bd5", (String)"InvoiceUtil_14", (String)"bos-image-formplugin", (Object[])new Object[0]), showMessage.toString(), MessageTypes.ImageWithText_m);
    }

    public static String getToken(String baseUrl, String imagenumber) {
        String invoiceToken = BosImageDistributeSessionCache.get("ssc-invoice-token");
        if (StringUtils.isNotEmpty((String)invoiceToken)) {
            return invoiceToken;
        }
        return InvoiceUtil.getOriginToken(baseUrl, imagenumber);
    }

    public static Map<String, String> selectBillNumberByBillId(String billId) {
        String billnumber = "";
        String billtype = "";
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter filter = new QFilter(BILL_ID, "=", (Object)billId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject result = BusinessDataServiceHelper.loadSingle((String)"task_billimagemap", (String)"billnumber,billtype", (QFilter[])filters);
        if (result != null) {
            billnumber = result.getString(BILL_NUMBER);
            billtype = result.getString(BILLTYPE);
        }
        map.put(BILL_NUMBER, billnumber);
        map.put(BILLTYPE, billtype);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOriginToken(String baseUrl, String imagenumber) {
        int expired;
        String loginUrl = baseUrl + "/base/oauth/token";
        Map<String, String> clientMap = InvoiceUtil.getClientParam();
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = InvoiceUtil.getMD5(clientId + clientSecret + timeStamp);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CLIENT_ID1, (Object)clientId);
        jsonObject.put("sign", (Object)sign);
        jsonObject.put(TIMESTAMP, (Object)timeStamp);
        logger.error("\u83b7\u53d6token\u524d--loginUrl:" + loginUrl + ",jsonObject:" + jsonObject.toJSONString());
        String result = InvoiceUtil.sendHttpsRequestByPost(loginUrl, jsonObject.toJSONString(), 30000, 30000);
        jsonObject = JSONObject.parseObject((String)result);
        String errcode = jsonObject.getString(ERRCODE);
        String token = null;
        if (ERRORDESCNO_SUCCESS.equals(errcode)) {
            logger.error("\u7b2c\u4e00\u6b21 \u83b7\u53d6token\u6210\u529f");
            token = jsonObject.getString(ACCESS_TOKEN);
            expired = jsonObject.getIntValue("expires_in");
        } else {
            logger.error("\u7b2c\u4e00\u6b21 token\u83b7\u53d6\u5931\u8d25--jsonObject:" + jsonObject.toJSONString());
            JSONObject jsonObject2 = new JSONObject();
            jsonObject2.put(CLIENT_ID1, (Object)clientId);
            jsonObject2.put("sign", (Object)sign);
            jsonObject2.put(TIMESTAMP, (Object)timeStamp);
            result = InvoiceUtil.sendHttpsRequestByPost(loginUrl, jsonObject2.toJSONString(), 30000, 30000);
            jsonObject2 = JSONObject.parseObject((String)result);
            errcode = jsonObject2.getString(ERRCODE);
            if (ERRORDESCNO_SUCCESS.equals(errcode)) {
                logger.error("\u7b2c\u4e8c\u6b21 \u83b7\u53d6token\u6210\u529f");
                token = jsonObject.getString(ACCESS_TOKEN);
                expired = jsonObject.getIntValue("expires_in");
            } else {
                logger.error("\u7b2c\u4e8c\u6b21 token\u83b7\u53d6\u5931\u8d25--jsonObject:" + jsonObject2.toJSONString());
                JSONObject errorlog = new JSONObject();
                errorlog.put("errorMsg", (Object)String.format(ResManager.loadKDString((String)"\u5f71\u50cf\u7f16\u7801\uff1a%1$s\uff0c\u5728\u53d1\u7968\u8bc6\u522b\u65f6token\u4e3a\u7a7a\u5bfc\u81f4\u65e0\u6cd5\u8bc6\u522b\u53d1\u7968\uff0c\u4e3a\u7a7a\u7684\u539f\u56e0\u662f\uff1a%2$s", (String)"InvoiceUtil_7", (String)"bos-image-formplugin", (Object[])new Object[0]), imagenumber, jsonObject2.toJSONString()));
                errorlog.put("errorStack", (Object)imagenumber);
                errorlog.put("type", (Object)"invoice");
                errorlog.put("method", (Object)"kd.bos.invoice.util.InvoiceUtil.getToken");
                String errorlogString = errorlog.toJSONString();
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.create.ssc_recordexception");){
                    pub.publish(errorlogString);
                }
                return null;
            }
        }
        BosImageDistributeSessionCache.put("ssc-invoice-token", token, expired / 2);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String sendHttpsRequestByPost(String url, String json, int connectionTimeout, int readTimeout) {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String responseContent = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = InvoiceUtil.createHttpClient(connectionTimeout, readTimeout);
            HttpPost httpPost = new HttpPost(url);
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001HTTP POST\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8fde\u63a5\u62a5\u9519" + e.getMessage(), (Throwable)e);
                }
            }
        }
        return responseContent;
    }

    public static void deleteRegData(String billId, String imageNumber) {
        QFilter fbillId = new QFilter(BILL_ID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber);
        QFilter[] filter = new QFilter[]{fbillId, fimageNumber};
        DeleteServiceHelper.delete((String)TASK_IMAGEQUEUE, (QFilter[])filter);
    }

    public static boolean isExistImagequeue(String billId, String imageNumber) {
        ORM orm = ORM.create();
        QFilter fbillId = new QFilter(BILL_ID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber);
        QFilter[] filter = new QFilter[]{fbillId, fimageNumber};
        return orm.exists(TASK_IMAGEQUEUE, filter);
    }

    public static void changeRecStatus(String billId, String imageNumber, String status) {
        QFilter fbillId = new QFilter(BILL_ID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber);
        QFilter[] filters = new QFilter[]{fbillId, fimageNumber};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)TASK_IMAGEQUEUE, (String)"id,state", (QFilter[])filters);
        if (dynObjs != null && dynObjs.length > 0) {
            for (DynamicObject dynObj : dynObjs) {
                dynObj.set("state", (Object)status);
            }
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    public void changeRecSeq(String billId, String imageNumber, String seq) {
        QFilter fbillId = new QFilter(BILL_ID, "=", (Object)billId);
        QFilter fimageNumber = new QFilter(IMAGE_NUMBER, "=", (Object)imageNumber);
        QFilter[] filters = new QFilter[]{fbillId, fimageNumber};
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)TASK_IMAGEQUEUE, (String)"id,imageseq", (QFilter[])filters);
        if (dynObjs != null && dynObjs.length > 0) {
            for (DynamicObject dynObj : dynObjs) {
                dynObj.set("imageseq", (Object)seq);
            }
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendErrorMessage(String errorMsg, String errorStack, String type, String method) {
        JSONObject errorlog = new JSONObject();
        errorlog.put("errorMsg", (Object)errorMsg);
        errorlog.put("errorStack", (Object)errorStack);
        errorlog.put("type", (Object)type);
        errorlog.put("method", (Object)method);
        String errorlogString = errorlog.toJSONString();
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("ssc", "kd.ssc.task.create.ssc_recordexception");){
            pub.publish(errorlogString);
        }
    }

    public static void changeRecStatus(String billId, String imageNumber, String status, int seq) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)TASK_IMAGEQUEUE);
        DynamicObject obj = new DynamicObject((DynamicObjectType)type);
        obj.set("billId", (Object)billId);
        obj.set(IMAGE_NUMBER, (Object)imageNumber);
        obj.set("state", (Object)status);
        obj.set("imageseq", (Object)seq);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public String getImageResult(String imageUrl) throws IOException {
        String url = this.getRecogUrl();
        String result = "";
        if (!url.equals("")) {
            HashMap header = new HashMap();
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put(CLIENT_ID1, 200679);
            body.put("client_secret", InvoiceUtil.getParam("invoiceSecretClient"));
            body.put("accessKeyId", InvoiceUtil.getParam("accessKeyId"));
            body.put("uid", 10489402);
            body.put("url", imageUrl);
            result = HttpClientUtils.post((String)url, header, body, (int)30000, (int)30000);
        }
        return result;
    }

    public static Map<String, Integer> getHttpOverTimeConfig() {
        QFilter buildHttpOverTimeFilter = InvoiceUtil.buildHttpOverTimeFilter();
        DynamicObject[] params = BusinessDataServiceHelper.load((String)TASK_PARAMCONTROL, (String)"paramname,paramvalue", (QFilter[])new QFilter[]{buildHttpOverTimeFilter});
        HashMap<String, Integer> httpOverTimeConfigMap = new HashMap<String, Integer>(16);
        for (DynamicObject param : params) {
            httpOverTimeConfigMap.put(param.getString(PARAM_NAME), param.getInt(PARAM_VALUE));
        }
        if (httpOverTimeConfigMap.isEmpty()) {
            httpOverTimeConfigMap.put("connectionTimeout", 30000);
            httpOverTimeConfigMap.put("readTimeout", 30000);
        }
        return httpOverTimeConfigMap;
    }

    public static QFilter buildHttpOverTimeFilter() {
        QFilter connectionTimeoutFilter = new QFilter(PARAM_NAME, "=", (Object)"connectionTimeout");
        QFilter readTimeoutFilter = new QFilter(PARAM_NAME, "=", (Object)"readTimeout");
        return connectionTimeoutFilter.or(readTimeoutFilter);
    }

    private String getRecogUrl() {
        QFilter filter = new QFilter(PARAM_NAME, "=", (Object)"invoiceurl");
        DynamicObjectCollection dy = orm.query(TASK_PARAMCONTROL, filter.toArray());
        if (dy.size() > 0) {
            return ((DynamicObject)dy.get(0)).getString(PARAM_VALUE);
        }
        return "";
    }

    private static Map<String, String> getClientParam() {
        String clientId = null;
        String clientSecret = null;
        QFilter filter = new QFilter("enable", "=", (Object)"A");
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bas_imageconfig", (String)"clientid,clientsecret", (QFilter[])filter.toArray());
        if (dyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\u672a\u914d\u7f6e", (String)"InvoiceUtil_15", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        clientId = dyn.getString("clientid");
        clientSecret = dyn.getString("clientsecret");
        if (clientId.equals(" ") || clientSecret.equals(" ")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\u672a\u914d\u7f6eclientId,clientSecret", (String)"InvoiceUtil_16", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CLIENT_ID, clientId);
        map.put(CLIENT_SECRET, clientSecret);
        return map;
    }

    public static boolean saveInvoiceMaintain(String systemorignal, String billid, String invoiceno, String invoicecode, String imagenumber, String errorcode, int pageIndex) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HHmmssSSS");
            Date currentDate = new Date();
            String number = formatter.format(currentDate);
            DynamicObject invoiceMaintain = BusinessDataServiceHelper.newDynamicObject((String)"task_invoicemaintain");
            invoiceMaintain.set(BILL_ID, (Object)Long.parseLong(billid));
            invoiceMaintain.set(IMAGE_NUMBER, (Object)imagenumber);
            invoiceMaintain.set("number", (Object)number);
            invoiceMaintain.set("name", (Object)number);
            invoiceMaintain.set("status", (Object)"C");
            invoiceMaintain.set("enable", (Object)1);
            invoiceMaintain.set("createtime", (Object)currentDate);
            invoiceMaintain.set("failcount", (Object)pageIndex);
            invoiceMaintain.set("systemorignal", (Object)systemorignal);
            invoiceMaintain.set("invoiceno", (Object)invoiceno);
            invoiceMaintain.set("invoicecode", (Object)invoicecode);
            invoiceMaintain.set("errorcode", (Object)errorcode);
            invoiceMaintain.set("errordescno", (Object)errorcode);
            invoiceMaintain.set("modifytime", (Object)currentDate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoiceMaintain});
            return true;
        }
        catch (Exception e) {
            logger.error("kd.ssc.task.util.InvoiceMaintainUtil:\u65b0\u589e\u53d1\u7968\u7ef4\u62a4\u8bb0\u5f55\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    public boolean isRecognizaInvoice() {
        QFilter filter = new QFilter(PARAM_NAME, "=", (Object)"isrecognization");
        DynamicObjectCollection dy = orm.query(TASK_PARAMCONTROL, filter.toArray());
        if (dy.size() == 0) {
            return true;
        }
        return ((DynamicObject)dy.get(0)).getString(PARAM_VALUE).equals("1");
    }

    public static String getBillTypeById(String billid) {
        QFilter filter = new QFilter(BILL_ID, "=", (Object)billid);
        DynamicObject dy = QueryServiceHelper.queryOne((String)"task_billimagemap", (String)BILLTYPE, (QFilter[])filter.toArray());
        String sscBillTypeId = dy.getString(BILLTYPE);
        if (sscBillTypeId == null) {
            return " ";
        }
        return sscBillTypeId;
    }

    public static CloseableHttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build();
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(requestConfig).build();
        return httpClient;
    }

    public static String getParam(String key) {
        String result = "";
        QFilter filter = new QFilter(PARAM_NAME, "=", (Object)key);
        DynamicObject param = orm.queryOne(TASK_PARAMCONTROL, filter.toArray());
        if (param != null) {
            result = param.getString(PARAM_VALUE);
        }
        return result;
    }

    static {
        logger = LogFactory.getLog(InvoiceUtil.class);
        orm = ORM.create();
        SSLConnectionSocketFactory sslsf = SSLConnectionSocketFactory.getSocketFactory();
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        poolingHttpClientConnectionManager.setMaxTotal(4);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(2);
    }
}

