/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.api;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.image.api.impl.ImageSysServiceImpl;
import kd.bos.image.pojo.ImageReturnData;
import kd.bos.image.pojo.ViewImageVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class ImageSysApiService
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(ImageSysApiService.class);

    public String getVersion() {
        return "2.0";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        Map params;
        String url = ctx.getRequestURL();
        String serviceApiName = this.getMethodName(url);
        Map data = ctx.getData();
        Map queryString = ctx.getQueryString();
        Object object = CollectionUtils.isEmpty((Map)data) ? (CollectionUtils.isEmpty((Map)queryString) ? null : queryString) : (params = data);
        if (CollectionUtils.isEmpty((Map)params)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u662f\u5426\u6309\u8981\u6c42\u4f20\u53c2\u3002", (String)"ImageSysApiService_6", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
        }
        log.info("\u8c03\u7528\u7684\u63a5\u53e3:" + serviceApiName + ",\u8bf7\u6c42\u53c2\u6570\uff1a" + SerializationUtils.toJsonString((Object)params));
        try {
            Map<String, Object> validateMap = this.validate(serviceApiName, params);
            if (!((Boolean)validateMap.get("success")).booleanValue()) {
                return ApiResult.fail((String)((String)validateMap.get("errMsg")));
            }
            String retData = this.invokeImageSysService(serviceApiName, params);
            log.info("\u8c03\u7528\u7684\u63a5\u53e3:" + serviceApiName + ",\u8fd4\u56de\u7684\u7ed3\u679c:" + retData);
            ImageReturnData returnData = null;
            switch (serviceApiName) {
                case "createImageNo": {
                    if (StringUtils.isEmpty((CharSequence)retData)) {
                        return ApiResult.fail((String)ResManager.loadKDString((String)"\u521b\u5efa\u5f71\u50cf\u7f16\u7801\u5931\u8d25\u3002", (String)"ImageSysApiService_1", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    }
                    String str1 = retData.substring(0, retData.indexOf(45));
                    int length = retData.length();
                    String billNo = retData.substring(str1.length() + 1, length);
                    if (!billNo.equals("null")) {
                        returnData = new ImageReturnData();
                        returnData.setImageNo(retData);
                        return ApiResult.success((Object)SerializationUtils.toJsonString((Object)returnData));
                    }
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u521b\u5efa\u5f71\u50cf\u7f16\u7801\u5931\u8d25\u3002", (String)"ImageSysApiService_1", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                }
                case "deleteImageNo": {
                    if ("success".equals(retData)) {
                        return ApiResult.success((Object)"");
                    }
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"ImageSysApiService_18", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                }
                case "viewImage": {
                    if (StringUtils.isEmpty((CharSequence)retData)) {
                        return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u7684\u5f71\u50cf\u4fe1\u606f\u3002", (String)"ImageSysApiService_17", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    }
                    ViewImageVo vo = (ViewImageVo)SerializationUtils.fromJsonString((String)retData, ViewImageVo.class);
                    if (StringUtils.isBlank((CharSequence)vo.getMessage())) {
                        return ApiResult.success((Object)retData);
                    }
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u7684\u5f71\u50cf\u4fe1\u606f\u3002", (String)"ImageSysApiService_17", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                }
                case "rescanImage": {
                    if ("1".equals(retData)) {
                        return ApiResult.success((Object)"");
                    }
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u9000\u626b\u5f71\u50cf\u5931\u8d25\u3002", (String)"ImageSysApiService_4", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                }
                case "cancelRescanImage": {
                    if ("1".equals(retData)) {
                        return ApiResult.success((Object)"");
                    }
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u626b\u5f71\u50cf\u5931\u8d25\u3002", (String)"ImageSysApiService_5", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                }
            }
            return ApiResult.success((Object)retData);
        }
        catch (Exception exp) {
            log.error("\u5f71\u50cf\u63a5\u53e3\u5185\u90e8\u9519\u8bef\uff1a" + exp.getMessage(), (Throwable)exp);
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u8c03\u5f71\u50cf\u63a5\u53e3\u5185\u90e8\u9519\u8bef\uff1a%1$s", (String)"ImageSysApiService_19", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]), exp.getMessage()));
        }
    }

    private String getMethodName(String url) {
        String quote = Pattern.quote("/");
        return url.split(quote)[url.split(quote).length - 1];
    }

    public String invokeImageSysService(String methodName, Map paras) throws Exception {
        ImageSysServiceImpl service = new ImageSysServiceImpl();
        String retData = "";
        switch (methodName) {
            case "createImageNo": {
                retData = service.createImageNo(paras);
                break;
            }
            case "deleteImageNo": {
                retData = service.deleteImageNo(paras);
                break;
            }
            case "viewImage": {
                retData = service.viewImage(paras);
                break;
            }
            case "rescanImage": {
                retData = service.rescanImage(paras);
                break;
            }
            case "cancelRescanImage": {
                retData = service.cancelRescanImage(paras);
                break;
            }
            case "queryImageNoAndState": {
                retData = service.queryImageNoAndState(paras);
                break;
            }
        }
        return retData;
    }

    private Map<String, Object> validate(String methodName, Map<String, Object> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("success", Boolean.TRUE);
        String sourceSys = null;
        String billno = null;
        String billId = null;
        String orgName = null;
        String orgId = null;
        String userName = null;
        String userAccount = null;
        String rescanMsg = null;
        String cancelRescanMsg = null;
        String imageScan = null;
        try {
            sourceSys = (String)param.get("sourceSys");
            if (StringUtils.isEmpty((CharSequence)sourceSys)) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570sourceSys\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_7", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                return resultMap;
            }
            billno = (String)param.get("billNo");
            if (StringUtils.isBlank((CharSequence)billno)) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570billno\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_8", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                return resultMap;
            }
            switch (methodName) {
                case "createImageNo": {
                    orgName = (String)param.get("orgName");
                    orgId = (String)param.get("orgId");
                    imageScan = (String)param.get("imageScan");
                    billId = (String)param.get("billId");
                    if (StringUtils.isBlank((CharSequence)orgId)) {
                        resultMap.put("success", Boolean.FALSE);
                        resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570orgId\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_9", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    } else if (StringUtils.isEmpty((CharSequence)orgName)) {
                        resultMap.put("success", Boolean.FALSE);
                        resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570orgName\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_10", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    } else if (StringUtils.isNotBlank((CharSequence)imageScan) && !"1".equals(imageScan) && !"2".equals(imageScan)) {
                        resultMap.put("success", Boolean.FALSE);
                        resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570imageScan\u7684\u503c\u5fc5\u987b\u4f201\u6216\u80052\u3002", (String)"ImageSysApiService_16", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    }
                    if (billId == null) break;
                    int length = (billId = billId.trim()).length();
                    if (length > 20) {
                        resultMap.put("success", Boolean.FALSE);
                        resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570billId\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc719\u4f4d\u3002", (String)"ImageSysApiService_20", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    }
                    try {
                        Long.parseLong(billId);
                    }
                    catch (Exception e) {
                        resultMap.put("success", Boolean.FALSE);
                        resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570billId\u7684\u503c\u4ec5\u5305\u542b\u6570\u5b57\u3002", (String)"ImageSysApiService_21", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    }
                    break;
                }
                case "deleteImageNo": {
                    userName = (String)param.get("userAccount");
                    if (!StringUtils.isBlank((CharSequence)userName)) break;
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570userAccount\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_12", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    break;
                }
                case "viewImage": {
                    userAccount = (String)param.get("userAccount");
                    if (!StringUtils.isBlank((CharSequence)userAccount)) break;
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570userAccount\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_12", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    break;
                }
                case "rescanImage": {
                    rescanMsg = (String)param.get("rescanMsg");
                    if (!StringUtils.isBlank((CharSequence)rescanMsg)) break;
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570rescanMsg\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_13", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    break;
                }
                case "cancelRescanImage": {
                    cancelRescanMsg = (String)param.get("cancelRescanMsg");
                    if (!StringUtils.isBlank((CharSequence)cancelRescanMsg)) break;
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("errMsg", ResManager.loadKDString((String)"\u53c2\u6570cancelRescanMsg\u4e3a\u5fc5\u4f20\u5b57\u6bb5\u3002", (String)"ImageSysApiService_14", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
                    break;
                }
                case "queryImageNoAndState": {
                    break;
                }
            }
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("errMsg", ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d\u3002", (String)"ImageSysApiService_11", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
        }
        return resultMap;
    }
}

