/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.api.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.image.api.service.ImageSysService;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.image.pojo.ViewImageVo;
import kd.bos.image.util.ImageBillMapUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.image.ImageServiceNewHelper;

public class ImageSysServiceImpl
implements ImageSysService {
    @Override
    public String createImageNo(Map param) {
        String sourceSys = (String)param.get("sourceSys");
        String billno = (String)param.get("billNo");
        String billId = (String)param.get("billId");
        String billType = (String)param.get("billType");
        String imageScan = (String)param.get("imageScan");
        String creatorAccount = (String)param.get("creatorAccount");
        String creatorName = (String)param.get("creatorName");
        String creatorId = "43007523";
        String orgName = (String)param.get("orgName");
        String orgId = (String)param.get("orgId");
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setSourceSys(sourceSys);
        imageInfo.setBillNo(billno);
        imageInfo.setBillId(billId == null ? "0" : billId);
        imageInfo.setBilltype(billType);
        if (!StringUtils.isEmpty((CharSequence)imageScan)) {
            imageInfo.setImageScan(imageScan);
        }
        imageInfo.setOrgId(orgId);
        imageInfo.setCreatorAccount(creatorAccount);
        imageInfo.setCreatorName(creatorName);
        imageInfo.setCreator(creatorId);
        imageInfo.setOrgName(orgName);
        return ImageServiceNewHelper.createImageInfo(imageInfo);
    }

    @Override
    public String deleteImageNo(Map param) {
        String sourceSys = (String)param.get("sourceSys");
        String billNo = (String)param.get("billNo");
        String updateName = (String)param.get("updateName");
        String imageNo = null;
        DynamicObject billImageMapDyn = ImageBillMapUtil.getBillImageMapDyn(sourceSys, billNo);
        if (billImageMapDyn == null) {
            return "";
        }
        imageNo = billImageMapDyn.getString("imagenumber");
        return ImageServiceNewHelper.deleteImage(imageNo, updateName, "");
    }

    @Override
    public String queryImageNoAndState(Map param) {
        String billNo;
        String sourceSys = (String)param.get("sourceSys");
        DynamicObject imageObj = ImageBillMapUtil.getImageNoAndState(sourceSys, billNo = (String)param.get("billNo"));
        if (imageObj == null) {
            return "{}";
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("imageNo", (Object)imageObj.getString("imagenumber"));
        jsonObject.put("state", (Object)imageObj.getString("imagestate"));
        return jsonObject.toJSONString();
    }

    @Override
    public String viewImage(Map param) {
        String sourceSys = (String)param.get("sourceSys");
        String billNo = (String)param.get("billNo");
        String userAccount = (String)param.get("userAccount");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"A");
        DynamicObject imageConfig = BusinessDataServiceHelper.loadSingle((String)"bas_imageconfig", (String)"isrelatedview,number", (QFilter[])new QFilter[]{enableFilter});
        if (imageConfig == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ImageSysServiceImpl_0", (String)"bos-mservice-imageplatform-api", (Object[])new Object[0]));
        }
        String imageSys = imageConfig.getString("number");
        DynamicObject imageViewDo = ImageBillMapUtil.getImageViewDo(sourceSys, billNo);
        if (imageViewDo == null) {
            return "";
        }
        ViewImageVo viewImageVo = new ViewImageVo();
        viewImageVo.setBillId(imageViewDo.getString("billid"));
        viewImageVo.setUserId(imageViewDo.getString("creator"));
        viewImageVo.setUserName(userAccount);
        viewImageVo.setMobile(false);
        viewImageVo.setBilltype(imageViewDo.getString("billtype"));
        viewImageVo.setImageSys(imageSys);
        return SerializationUtils.toJsonString((Object)ImageServiceNewHelper.viewPhoto(viewImageVo));
    }

    @Override
    public String rescanImage(Map param) throws Exception {
        String sourceSys = (String)param.get("sourceSys");
        String billNo = (String)param.get("billNo");
        String rescanMsg = (String)param.get("rescanMsg");
        String userAccount = (String)param.get("userAccount");
        String imageNo = null;
        String userId = null;
        DynamicObject billImageMapDyn = ImageBillMapUtil.getBillImageMapDyn(sourceSys, billNo);
        if (billImageMapDyn == null) {
            return "";
        }
        imageNo = billImageMapDyn.getString("imagenumber");
        String result = ImageServiceNewHelper.imageRscan(imageNo, rescanMsg, userId = String.valueOf(billImageMapDyn.getLong("creator")));
        if ("1".equals(result)) {
            ImageBillMapUtil.updateAccountDyn(sourceSys, billNo, userAccount);
        }
        return result;
    }

    @Override
    public String cancelRescanImage(Map param) throws Exception {
        String sourceSys = (String)param.get("sourceSys");
        String billNo = (String)param.get("billNo");
        String cancelRescanMsg = (String)param.get("cancelRescanMsg");
        String userAccount = (String)param.get("userAccount");
        DynamicObject billImageMapDyn = ImageBillMapUtil.getBillImageMapDyn(sourceSys, billNo);
        String imageNo = null;
        String userId = null;
        if (billImageMapDyn == null) {
            return "";
        }
        imageNo = billImageMapDyn.getString("imagenumber");
        String result = ImageServiceNewHelper.cancelRescan(imageNo, cancelRescanMsg, userId = String.valueOf(billImageMapDyn.getLong("creator")));
        if ("1".equals(result)) {
            ImageBillMapUtil.updateAccountDyn(sourceSys, billNo, userAccount);
        }
        return result;
    }
}

