/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class ImageExpireRuleUpgradeServiceImpl
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(ImageExpireRuleUpgradeServiceImpl.class);
    private static Map<Long, Long> upgradeDataMapping = new HashMap<Long, Long>(4);
    private static final String CHANNEL_COUNT_SQL = "select count(fid) from t_bas_imageexpire_channel";
    private static final String QUERY_OLD_CHANNEL_SQL = "select fid,fmessagechannel from t_bas_imageremind";
    private static final String INSERT_NEW_CHANNEL_SQL = "insert into t_bas_imageexpire_channel(fpkid,fid,fbasedataid) values (?,?,?)";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        int newTableChannelCount = 0;
        try (DataSet ds = DB.queryDataSet((String)"bos.image.updateImageExpireChannel_queryCount", (DBRoute)DBRoute.of((String)"sys"), (String)CHANNEL_COUNT_SQL);){
            newTableChannelCount = ((Row)ds.iterator().next()).getInteger(0);
        }
        if (newTableChannelCount > 0) {
            log.info("\u8d85\u671f\u63d0\u9192\u6e20\u9053\u591a\u9009\u57fa\u7840\u8d44\u6599\u8868\u5df2\u7ecf\u5b58\u5728\u6570\u636e\uff0c\u8ba4\u5b9a\u4e3a\u5347\u7ea7\u8fc7\uff0c\u672c\u6b21\u5347\u7ea7\u7ed3\u675f\u3002");
            upgradeResult.setSuccess(Boolean.TRUE.booleanValue());
            return upgradeResult;
        }
        int idCount = 0;
        HashMap fidNewChannelIdMap = new HashMap(10);
        try (DataSet ds = DB.queryDataSet((String)"bos.image.updateImageExpireChannel_queryOldChannelInfo", (DBRoute)DBRoute.of((String)"sys"), (String)QUERY_OLD_CHANNEL_SQL);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String messageChannel = row.getString("fmessagechannel");
                messageChannel = messageChannel.substring(1, messageChannel.length() - 1);
                String[] channelArray = messageChannel.split(",");
                ArrayList<Long> targetList = new ArrayList<Long>(channelArray.length);
                for (String s : channelArray) {
                    Long targetId = upgradeDataMapping.get(Long.valueOf(s));
                    if (targetId == null) continue;
                    ++idCount;
                    targetList.add(targetId);
                }
                Long fid = row.getLong("fid");
                fidNewChannelIdMap.put(fid, targetList);
            }
        }
        if (idCount > 0) {
            long[] pkIdArray = DBServiceHelper.genLongIds((String)"t_bas_imageexpire_channel", (int)idCount);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(pkIdArray.length);
            int getIdIndex = -1;
            for (Map.Entry entry : fidNewChannelIdMap.entrySet()) {
                Long fid = (Long)entry.getKey();
                List baseDataIdList = (List)entry.getValue();
                for (Long baseDataId : baseDataIdList) {
                    Object[] param = new Object[]{pkIdArray[++getIdIndex], fid, baseDataId};
                    paramList.add(param);
                }
            }
            if (!paramList.isEmpty()) {
                log.info("\u9700\u8981\u63d2\u5165\u7684\u4e2a\u6570\u4e3a\uff1a" + paramList.size());
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)INSERT_NEW_CHANNEL_SQL, paramList);
            }
        }
        upgradeResult.setSuccess(true);
        return upgradeResult;
    }

    static {
        upgradeDataMapping.put(1L, 475756772099906560L);
        upgradeDataMapping.put(3L, 475773782250774528L);
        upgradeDataMapping.put(4L, 475773159430184960L);
        upgradeDataMapping.put(5L, 702623661995124738L);
    }
}

