/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.privacy.IDesensitizeStrategy;
import kd.bos.privacy.strategy.BankAcctDesenStrategy;
import kd.bos.privacy.strategy.FixLengthDesenStrategy;
import kd.bos.privacy.strategy.HeadTailDesenStrategy;
import kd.bos.privacy.strategy.IdCardDesenStrategy;
import kd.bos.privacy.strategy.LengthDesenStrategy;
import kd.bos.privacy.strategy.NameDesenStrategy;
import kd.bos.privacy.strategy.RegularDesenStrategy;
import kd.bos.privacy.strategy.TelephoneDesenStrategy;
import kd.bos.servicehelper.QueryServiceHelper;

public class DesensitizeStrategyFactory {
    private static final Log log = LogFactory.getLog((String)"DesensitizeStrategyFactory");
    private static Map<String, IDesensitizeStrategy> defaultMap = new ConcurrentHashMap<String, IDesensitizeStrategy>(8);
    private static final String PRIVACY_DESENSITIZE_STRATEGY_REGION = "PRIVACY_DESENSITIZE_STRATEGY_REGION";

    private static void initDefaultStrategy() {
        DesensitizeStrategyFactory.register(new LengthDesenStrategy());
        DesensitizeStrategyFactory.register(new HeadTailDesenStrategy());
        DesensitizeStrategyFactory.register(new FixLengthDesenStrategy());
        DesensitizeStrategyFactory.register(new TelephoneDesenStrategy());
        DesensitizeStrategyFactory.register(new NameDesenStrategy());
        DesensitizeStrategyFactory.register(new IdCardDesenStrategy());
        DesensitizeStrategyFactory.register(new BankAcctDesenStrategy());
    }

    private static void initDB() {
        ArrayList<String> numberList = new ArrayList<String>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"loadDesensitizationRules", (String)"privacy_desen_rules", (String)"id,number,ruletype,matchrules,replacement", (QFilter[])new QFilter[]{new QFilter("number", "!=", (Object)"NO")}, null);){
            HashMap<String, IDesensitizeStrategy> strategyMap = new HashMap<String, IDesensitizeStrategy>(16);
            while (dataSet.hasNext()) {
                Row data = dataSet.next();
                String number = data.getString("number");
                IDesensitizeStrategy strategy = defaultMap.get(number);
                if (strategy == null && "0".equals(data.getString("ruletype"))) {
                    strategy = new RegularDesenStrategy(data.getString("matchrules"), data.getString("replacement"));
                    numberList.add(number);
                }
                strategyMap.put(data.getString("id"), strategy);
            }
            DesensitizeStrategyFactory.getLocalCache().put("allDesensitizationRules", strategyMap);
        }
        log.info("kd.bos.privacy.service.DesensitizeStrategyFactory.initDB(), data={}", numberList);
    }

    public static void reload() {
        DesensitizeStrategyFactory.getLocalCache().clear();
        log.info("kd.bos.privacy.service.DesensitizeStrategyFactory.reload()");
        DesensitizeStrategyFactory.initDB();
    }

    public static void register(IDesensitizeStrategy strategy) {
        defaultMap.put(strategy.getStrategyName(), strategy);
    }

    public static IDesensitizeStrategy unregister(String name) {
        return defaultMap.remove(name);
    }

    public static IDesensitizeStrategy getStrategy(String name) {
        IDesensitizeStrategy strategy = defaultMap.get(name);
        if (strategy == null) {
            Map strategyMap = (Map)DesensitizeStrategyFactory.getLocalCache().get("allDesensitizationRules");
            if (strategyMap == null) {
                DesensitizeStrategyFactory.initDB();
                strategyMap = (Map)DesensitizeStrategyFactory.getLocalCache().get("allDesensitizationRules");
            }
            strategy = (IDesensitizeStrategy)strategyMap.get(name);
        }
        return strategy;
    }

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(1800);
        info.setMaxItemSize(500);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(RequestContext.getOrCreate().getAccountId(), PRIVACY_DESENSITIZE_STRATEGY_REGION, info);
    }

    static {
        DesensitizeStrategyFactory.initDefaultStrategy();
    }
}

