/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.scheme;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.IPrivacyDataStoreService;
import kd.bos.db.privacy.model.MappingModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.model.PrivacyEncryptModel;

public class PrivacyMapping
implements IPrivacyDataStoreService {
    private static final int TABLE_NAME_MAX_LENGTH = 22;
    private static final Log logger = LogFactory.getLog(PrivacyMapping.class);

    public void savePrivacyData(DBRoute dbRoute, Object o, List<Object> shardingIds, Map<String, Object> initValues) {
    }

    public void deletePrivacyData(DBRoute dbRoute, Object o, Object[] objects) {
    }

    public void insertMapping(String entityNumber, String tableName, String fieldName, String dataClassify, String dbRouterStr, String isLocale, String pkName, String orderBy, Integer fieldType) throws Exception {
    }

    public static String buildPrivacyTableName(String bdTableName) {
        if (StringUtils.isBlank((CharSequence)bdTableName)) {
            return "";
        }
        if (bdTableName.length() > 22) {
            return bdTableName.substring(0, 22) + "_py";
        }
        return bdTableName + "_py";
    }

    public static String buildDbTableName(String dbTableName) {
        if (StringUtils.isBlank((CharSequence)dbTableName)) {
            return "";
        }
        if (dbTableName.length() > 22) {
            return dbTableName.substring(0, 22);
        }
        return dbTableName;
    }

    public static boolean existPrivacyTable(DBRoute route, String tableName) {
        return DB.exitsTable((DBRoute)route, (String)PrivacyMapping.buildPrivacyTableName(tableName));
    }

    public void deleteMapping(String dbRouter, Map<String, MappingModel> delModels, String isLocale, String pkName) throws Exception {
    }

    public void updatePrivacyMapping(String dbRouter, String oldClassify, MappingModel mm, String isLocale, String pkName, String orderBy, Integer fieldType) throws Exception {
    }

    private boolean encryptIsChange(String oldClassify, String newClassify, String tableName, String fieldName) {
        return false;
    }

    public Map<String, MappingModel> queryAllMappingModel(String tableName) {
        HashMap<String, MappingModel> result = new HashMap<String, MappingModel>();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean existPrivacyTableField(String tableName, String fieldName) {
        String sql = "SELECT 1 FROM T_PRIVACY_MAPPING  WHERE FTABLE_NAME=? AND FFIELD_NAME=?";
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":FTABLE_NAME", 12, (Object)tableName), new SqlParameter(":FFIELD_NAME", 12, (Object)fieldName)};
        try (DataSet rs = DB.queryDataSet((String)"PrivacyMapping.existPrivacyTableField", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])selectParas);){
            if (rs == null) return false;
            if (!rs.hasNext()) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivacyEncryptModel queryPrivacyDesensitize(String entityNumber, String fieldIdent, String localeId) {
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":fdense_entity_number", 12, (Object)entityNumber), new SqlParameter(":fdense_field_ident", 12, (Object)fieldIdent), new SqlParameter(":fdensefieldlocale", 12, (Object)localeId)};
        try (DataSet rs = DB.queryDataSet((String)"PrivacyMapping.insertMapping", (DBRoute)DBRoute.of((String)"sys"), (String)" SELECT C.fdense_field_ident,C.fdesensitize_rule, C.fdense_entity_number,C.fdensefieldlocale,C.fdesensitize_type,C.fplugin,C.fdense_field_type  FROM T_PRIVACY_SCHEME_DESEN C where C.fdense_entity_number=? and C.fdense_field_ident=? and (C.fdensefieldlocale = ? or (C.fdensefieldlocale =' ' or C.fdensefieldlocale is null or C.fdensefieldlocale ='')) order by fdensefieldlocale desc", (Object[])selectParas);){
            PrivacyEncryptModel model = new PrivacyEncryptModel();
            while (rs != null && rs.hasNext()) {
                Row row = rs.next();
                String fdesensitize_rule = row.getString("fdesensitize_rule");
                if ("FOLLOW".equals(fdesensitize_rule)) continue;
                model.setDesensitizeType(row.getString("FDESENSITIZE_TYPE"));
                model.setDesensitizeRule(row.getString("fdesensitize_rule"));
                model.setEntityNumber(row.getString("fdense_entity_number"));
                model.setFieldIdent(row.getString("fdense_field_ident"));
                model.setFieldLocale(row.getString("fdensefieldlocale"));
                model.setFieldType(row.getString("fdense_field_type"));
                break;
            }
            PrivacyEncryptModel privacyEncryptModel = model;
            return privacyEncryptModel;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivacyEncryptModel queryPrivacyEncrypt(String tableName, String fieldName) {
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":fencrypt_table_name", 12, (Object)tableName), new SqlParameter(":fencrypt_field_name", 12, (Object)fieldName)};
        try (DataSet rs = DB.queryDataSet((String)"PrivacyMapping.insertMapping", (DBRoute)DBRoute.of((String)"sys"), (String)"SELECT top 1 C.fencrypt_table_name,C.fencrypt_field_name,C.fencrypt_field_ident,C.fencrypt_algorithm,C.fversion,C.fencrypt_entity_number FROM T_PRIVACY_SCHEME_ENCRYPT C where  C.fencrypt_table_name=? and C.fencrypt_field_name=? ", (Object[])selectParas);){
            PrivacyEncryptModel model = new PrivacyEncryptModel();
            if (rs != null && rs.hasNext()) {
                Row row = rs.next();
                model.setEncryptAlgorithm(row.getString("fencrypt_algorithm"));
                model.setVersion(row.getInteger("FVERSION"));
                model.setEntityNumber(row.getString("fencrypt_entity_number"));
                model.setFieldIdent(row.getString("fencrypt_field_ident"));
                model.setTableName(row.getString("fencrypt_table_name"));
                model.setFieldName(row.getString("fencrypt_field_name"));
            }
            PrivacyEncryptModel privacyEncryptModel = model;
            return privacyEncryptModel;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    public static PrivacyEncryptModel queryPrivacyEncryptNew(String tableName, String fieldName) {
        PrivacyEncryptModel privacyEncryptModel;
        Throwable throwable;
        DataSet rs;
        block17: {
            block18: {
                Object[] selectParas = new SqlParameter[]{new SqlParameter(":fencrypt_table_name", 12, (Object)tableName), new SqlParameter(":fencrypt_field_name", 12, (Object)fieldName)};
                rs = DB.queryDataSet((String)"PrivacyMapping.insertMapping", (DBRoute)DBRoute.of((String)"sys"), (String)"SELECT  D.fdatacenterid,D.ftenantid,D.fworksecretid,D.falgorithm,C.fencrypt_table_name,C.fencrypt_field_name,\nC.fencrypt_field_ident,C.fencrypt_algorithm,C.fversion,C.fencrypt_entity_number FROM T_PRIVACY_SCHEME_ENCRYPT C INNER JOIN T_PRIVACY_ENCRYPT_SCHEME D on D.FID = C.FENCRYPT_SCHEMEID where  C.fencrypt_table_name=? and C.fencrypt_field_name=? ", (Object[])selectParas);
                throwable = null;
                PrivacyEncryptModel model = new PrivacyEncryptModel();
                if (rs != null && rs.hasNext()) {
                    Row row = rs.next();
                    model.setEncryptAlgorithm(row.getString("fencrypt_algorithm"));
                    model.setVersion(row.getInteger("FVERSION"));
                    model.setEntityNumber(row.getString("fencrypt_entity_number"));
                    model.setFieldIdent(row.getString("fencrypt_field_ident"));
                    model.setTableName(row.getString("fencrypt_table_name"));
                    model.setFieldName(row.getString("fencrypt_field_name"));
                    model.setWorkSecretId(row.getString("fworksecretid"));
                    model.setEncryptAlgorithm(row.getString("falgorithm"));
                    model.setSchemeId(row.getLong("fid"));
                    model.setDataCenterId(row.getString("fdatacenterid"));
                    model.setTenantId(row.getString("ftenantid"));
                }
                privacyEncryptModel = model;
                if (rs == null) break block17;
                if (throwable == null) break block18;
                try {
                    rs.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block17;
            }
            rs.close();
        }
        return privacyEncryptModel;
        catch (Throwable throwable3) {
            try {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (rs != null) {
                            if (throwable != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rs.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    logger.warn((Throwable)e);
                    throw e;
                }
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static void main(String[] args) {
        PrivacyMapping.existPrivacyTable(DBRoute.of((String)"sys"), "");
    }
}

