/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.scheme;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.model.DesensitizeModel;

public class PrivacySchemeSetting {
    private static final Log logger = LogFactory.getLog(PrivacySchemeSetting.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getEncryptTypeBySchemeId(Long schemeId) {
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":FSCHEME_ID", -5, (Object)schemeId)};
        try (DataSet ds = DB.queryDataSet((String)"PrivacySchemeSetting.getEncryptTypeBySchemeId", (DBRoute)DBRoute.of((String)"sys"), (String)"SELECT FENCRYPT_ALGORITHM FROM T_PRIVACY_SCHEME_ENCRYPT WHERE FSCHEME_ID = ?", (Object[])sqlParas);){
            if (ds != null && ds.hasNext()) {
                Row row = ds.next();
                String string = row.getString("FENCRYPT_ALGORITHM");
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<DesensitizeModel> getDesensitizeSetBySchemeId(Long schemeId) {
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":FSCHEME_ID", -5, (Object)schemeId)};
        try (DataSet ds = DB.queryDataSet((String)"PrivacySchemeSetting.getDesensitizeSetBySchemeId", (DBRoute)DBRoute.of((String)"sys"), (String)"SELECT FPLUGIN,FDATA_CLASSIFY,FDESENSITIZE_CODE,FDESENSITIZE_TYPE FROM T_PRIVACY_SCHEME_DESENSITIZE WHERE FSCHEME_ID = ?", (Object[])sqlParas);){
            DesensitizeModel model = null;
            ArrayList<DesensitizeModel> result = new ArrayList<DesensitizeModel>();
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    model = new DesensitizeModel();
                    model.setDataClassify(row.getString("FDATA_CLASSIFY"));
                    model.setDesensitizeRule(row.getString("FDESENSITIZE_RULE"));
                    model.setDesensitizeType(row.getString("FDESENSITIZE_TYPE"));
                    result.add(model);
                }
            }
            ArrayList<DesensitizeModel> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Long getSchemeIdByDataLabel(String dataLabel) {
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":FDATALABEL_ID", -5, (Object)dataLabel)};
        try (DataSet rs = DB.queryDataSet((String)"SchemeRuleSettingPlugin.fillEncryptType", (DBRoute)DBRoute.of((String)"sys"), (String)"SELECT FID FROM T_PRIVACY_SCHEME WHERE FDATALABEL_ID = ?", (Object[])sqlParas);){
            if (rs != null && rs.hasNext()) {
                Long l = rs.next().getLong("FID");
                return l;
            }
            Long l = 0L;
            return l;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDataClassifyFromSetting(String dataClassify) {
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":FDATA_CLASSIFY", 12, (Object)dataClassify)};
        String sql = "select 1 from  t_privacy_secheme_setting where fdata_classify = ?";
        try (DataSet rs = DB.queryDataSet((String)"PrivacySchemeSetting.hasDataClassifyFromSetting", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])selectParas);){
            if (rs != null && rs.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDatalabelFromScheme(Long fid, Long dataLabelId) {
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":FDATALABEL_ID", -5, (Object)dataLabelId), new SqlParameter(":FID", -5, (Object)fid)};
        String sql = "select 1 from  t_privacy_scheme  where fdatalabel_id = ? and fid <> ?";
        try (DataSet rs = DB.queryDataSet((String)"PrivacySchemeSetting.hasDatalabelFromScheme", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])selectParas);){
            if (rs != null && rs.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDataClassifyFromDesensitize(String dataClassify) {
        Object[] selectParas = new SqlParameter[]{new SqlParameter(":FDATA_CLASSIFY", 12, (Object)dataClassify)};
        String sql = "select 1 from  t_privacy_scheme_desensitize where fdata_classify = ?";
        try (DataSet rs = DB.queryDataSet((String)"PrivacySchemeSetting.hasDataClassifyFromDesensitize", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])selectParas);){
            if (rs != null && rs.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw e;
        }
    }
}

