/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.privacy.IPrivacyCenterService;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.db.privacy.IPrivacyDataPermissionService;
import kd.bos.db.privacy.IPrivacyEncryptService;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.lang.Lang;
import kd.bos.privacy.DesensitizeStrategyFactory;
import kd.bos.privacy.IDesensitizeStrategy;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrivacyCenterService
implements IPrivacyCenterService {
    public boolean isEncryptField(IDataEntityProperty prop) {
        String tableGroup;
        if (!PrivacyDataCenterManager.isEnable() || prop == null) {
            return false;
        }
        IDataEntityType entityType = prop.getParent();
        String tableName = null;
        if (entityType != null) {
            tableName = entityType.getAlias();
        }
        if (StringUtils.isNotEmpty((String)(tableGroup = prop.getTableGroup()))) {
            tableName = tableName + "_" + tableGroup;
        }
        String fieldName = prop.getAlias();
        if (StringUtils.isEmpty((String)tableName) || StringUtils.isEmpty((String)fieldName)) {
            return false;
        }
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        return service.isEncryptField(tableName, fieldName);
    }

    public boolean isDesensitizeField(IDataEntityProperty prop, String localeId, String operateType, DynamicObject dynamicObject) {
        IPrivacyDataPermissionService permissionService;
        String strategy;
        if (!PrivacyDataCenterManager.isEnable() || prop == null) {
            return false;
        }
        if (prop instanceof TextProp && ((TextProp)prop).isPassword()) {
            return false;
        }
        if (StringUtils.isEmpty((String)localeId)) {
            localeId = Lang.get().toString();
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldIdent)) {
            return false;
        }
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        boolean isDesen = "FORM".equals(operateType) && prop instanceof ILocaleProperty ? service.isDesensitizeField(entityNum, fieldIdent) : service.isDesensitizeField(entityNum, fieldIdent, localeId, (Object)dynamicObject);
        if (isDesen && "PLAINTEXT".equals(strategy = (permissionService = PrivacyDataCenterManager.getPermissionService()).getDesensitizeStrategy(entityNum, fieldIdent, operateType, (Object)dynamicObject))) {
            isDesen = false;
        }
        return isDesen;
    }

    public boolean isDesensitizeField(IDataEntityProperty prop, String localeId, String operateType) {
        IPrivacyDataPermissionService permissionService;
        String strategy;
        if (!PrivacyDataCenterManager.isEnable() || prop == null) {
            return false;
        }
        if (prop instanceof TextProp && ((TextProp)prop).isPassword()) {
            return false;
        }
        if (StringUtils.isEmpty((String)localeId)) {
            localeId = Lang.get().toString();
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldIdent)) {
            return false;
        }
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        boolean isDesen = "FORM".equals(operateType) && prop instanceof ILocaleProperty ? service.isDesensitizeField(entityNum, fieldIdent) : service.isDesensitizeField(entityNum, fieldIdent, localeId);
        if (isDesen && "PLAINTEXT".equals(strategy = (permissionService = PrivacyDataCenterManager.getPermissionService()).getDesensitizeStrategy(entityNum, fieldIdent, operateType))) {
            isDesen = false;
        }
        return isDesen;
    }

    public Set<String> getEncryptFields(String tableName) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return Collections.emptySet();
        }
        return PrivacyDataCenterManager.getEncryptService().getEncryptFields(tableName);
    }

    public Object getDesensitizeValue(IDataEntityProperty prop, String localeid, String operateType, DynamicObject dynamicObject, Object value) {
        if (!PrivacyDataCenterManager.isEnable() || prop == null) {
            return value;
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldIdent)) {
            return value;
        }
        if (!this.isDesensitizeField(prop, localeid, operateType, dynamicObject)) {
            return value;
        }
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        IPrivacyDataPermissionService permissionService = PrivacyDataCenterManager.getPermissionService();
        String strategy = permissionService.getDesensitizeStrategy(entityNum, fieldIdent, operateType);
        if ("PLAINTEXT".equals(strategy)) {
            return value;
        }
        return service.getDesensitizeValue(entityNum, fieldIdent, localeid, (Object)dynamicObject, value);
    }

    public Object getDesenValueByRule(String desenRuleId, Object value) {
        try (EntityTraceSpan span = EntityTracer.create((String)"privacy", (String)"getDesenValueByRule");){
            if (span.isRealtime()) {
                span.addLocaleTag("desenRuleId", (Object)desenRuleId);
            }
            PrivacyEncryptModel encryptModel = new PrivacyEncryptModel();
            encryptModel.setDesensitizeRule(desenRuleId);
            encryptModel.setFieldType(this.getFieldType(value));
            IDesensitizeStrategy strategy = DesensitizeStrategyFactory.getStrategy(desenRuleId);
            if (strategy == null) {
                throw new RuntimeException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5e94\u8131\u654f\u7b56\u7565\u3002", (String)"PrivacyCenterService_0", (String)"bos-privacy-implement", (Object[])new Object[0]));
            }
            String string = strategy.desensitize(encryptModel, value);
            return string;
        }
    }

    private String getFieldType(Object value) {
        String fieldType = "";
        if (value instanceof String) {
            fieldType = "12";
        } else if (value instanceof Integer) {
            fieldType = "4";
        } else if (value instanceof BigDecimal) {
            fieldType = "3";
        } else if (value instanceof Long) {
            fieldType = "-5";
        } else if (value instanceof ILocaleString) {
            fieldType = "1112";
        } else if (value instanceof Date) {
            fieldType = "91";
        }
        return fieldType;
    }

    public String getDesensitizeStrategy(IDataEntityProperty prop, String operateType) {
        return this.getDesensitizeStrategy(prop, operateType, null);
    }

    public String getDesensitizeStrategy(IDataEntityProperty prop, String operateType, DynamicObject dynamicObject) {
        if (!PrivacyDataCenterManager.isEnable()) {
            return "PLAINTEXT";
        }
        if (prop == null || StringUtils.isEmpty((String)operateType)) {
            return PrivacyDataCenterManager.getPermissionService().getDefaultStrategy();
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldIdent)) {
            return PrivacyDataCenterManager.getPermissionService().getDefaultStrategy();
        }
        return PrivacyDataCenterManager.getPermissionService().getDesensitizeStrategy(entityNum, fieldIdent, operateType, (Object)dynamicObject);
    }

    public void checkDecryptPermission(IDataEntityProperty prop, String operateType, String operateTerminal) {
        this.checkDecryptPermission(prop, operateType, operateTerminal, null);
    }

    public void checkDecryptPermission(IDataEntityProperty prop, String operateType, String operateTerminal, DynamicObject dynamicObject) {
        if (!PrivacyDataCenterManager.isEnable() || prop == null || StringUtils.isEmpty((String)operateTerminal) || StringUtils.isEmpty((String)operateType)) {
            return;
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldName = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldName)) {
            return;
        }
        PrivacyDataCenterManager.getPermissionService().checkDecryptPermission(entityNum, fieldName, operateType, operateTerminal, (Object)dynamicObject);
    }

    public boolean isDesensitizeFieldWithoutPerm(IDataEntityProperty prop, String localeId, String operateType, DynamicObject dynamicObject) {
        if (!PrivacyDataCenterManager.isEnable() || prop == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)localeId)) {
            localeId = Lang.get().toString();
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldIdent)) {
            return false;
        }
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        boolean isDesen = "FORM".equals(operateType) || prop instanceof ILocaleProperty ? service.isDesensitizeField(entityNum, fieldIdent) : service.isDesensitizeField(entityNum, fieldIdent, localeId, (Object)dynamicObject);
        return isDesen;
    }

    public Object getDesensitizeValueWithoutPerm(IDataEntityProperty prop, String localeid, String operateType, DynamicObject dynamicObject, Object value) {
        if (!PrivacyDataCenterManager.isEnable() || prop == null) {
            return value;
        }
        IDataEntityType entityType = prop.getParent();
        String entityNum = this.getEntityNumber(entityType);
        String fieldIdent = prop.getName();
        if (StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)fieldIdent)) {
            return value;
        }
        IPrivacyEncryptService service = PrivacyDataCenterManager.getEncryptService();
        if (!service.isDesensitizeField(entityNum, fieldIdent)) {
            return value;
        }
        return service.getDesensitizeValue(entityNum, fieldIdent, localeid, (Object)dynamicObject, value);
    }

    private String getEntityNumber(IDataEntityType entityType) {
        String entityNum = null;
        while (entityType != null) {
            entityNum = entityType instanceof QueryEntityType ? ((QueryEntityType)entityType).getEntityName() : entityType.getName();
            entityType = entityType.getParent();
        }
        return entityNum;
    }
}

