/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.service;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.database.CollectionPropertyMap;
import kd.bos.dataentity.metadata.database.ComplexPropertyMap;
import kd.bos.dataentity.metadata.database.DataEntityTypeMap;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.privacy.IPrivacyDataQueryService;
import kd.bos.db.privacy.model.DBIdQueryModel;
import kd.bos.db.privacy.model.DBPrivacyDataModel;
import kd.bos.db.privacy.model.MuiltLocaleResultModel;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.model.IPrivacyConst;
import kd.bos.privacy.scheme.PrivacyMapping;
import kd.bos.privacy.service.PrivacyEncryptService;
import kd.bos.privacy.service.PrivacyTableBuilderService;
import kd.bos.privacy.utils.HashAlgorithms;
import kd.bos.privacy.utils.HashTool;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class PrivacyDataQueryService
implements IPrivacyDataQueryService {
    private static final Log logger = LogFactory.getLog(PrivacyDataQueryService.class);
    private static PrivacyEncryptService privacyService = new PrivacyEncryptService();

    private static PrivacyEncryptService getSingtonService() {
        if (privacyService == null) {
            privacyService = new PrivacyEncryptService();
            return privacyService;
        }
        return privacyService;
    }

    public boolean isEncryptField(DBPrivacyDataModel model, int queryType) {
        switch (queryType) {
            case 0: {
                return PrivacyDataQueryService.getSingtonService().isEncryptField(model.getTableName(), model.getFiledName());
            }
            case 1: {
                return false;
            }
        }
        return PrivacyDataQueryService.getSingtonService().isEncryptField(model.getTableName(), model.getFiledName());
    }

    public List<DBPrivacyDataModel> isEncryptField(List<DBPrivacyDataModel> models, int queryType) {
        ArrayList<DBPrivacyDataModel> result = new ArrayList<DBPrivacyDataModel>();
        for (DBPrivacyDataModel md : models) {
            switch (queryType) {
                case 0: {
                    if (!PrivacyDataQueryService.getSingtonService().isEncryptField(md.getTableName(), md.getFiledName())) break;
                    result.add(md);
                }
            }
        }
        return result;
    }

    private Map<String, Map<String, Object>> buildHashInput(List<DBPrivacyDataModel> queryModels) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        HashMap<String, String> sub = null;
        ArrayList<String> oldValues = null;
        ArrayList<String> newValues = null;
        for (DBPrivacyDataModel privacyDataModel : queryModels) {
            sub = (HashMap<String, String>)result.get(privacyDataModel.getFiledName());
            if (sub == null) {
                sub = new HashMap<String, String>();
                result.put(privacyDataModel.getFiledName(), sub);
            }
            sub.put("origin", privacyDataModel.getHashValue());
            oldValues = (ArrayList<String>)sub.get("oldhash");
            if (oldValues == null) {
                oldValues = new ArrayList<String>();
                sub.put("oldhash", (String)((Object)oldValues));
            }
            oldValues.add(HashAlgorithms.FNVHash1(privacyDataModel.getHashValue()) + "");
            newValues = (ArrayList<String>)sub.get("newhash");
            if (newValues == null) {
                newValues = new ArrayList<String>();
                sub.put("newhash", (String)((Object)newValues));
            }
            newValues.add(HashTool.sha512(privacyDataModel.getHashValue()));
            if (!sub.containsKey("localeId")) {
                sub.put("localeId", privacyDataModel.getLocaleId());
            }
            if (sub.containsKey("fuzzySearch")) continue;
            sub.put("fuzzySearch", (String)((Object)Integer.valueOf(privacyDataModel.getFuzzySearch())));
        }
        return result;
    }

    public List<Object> hashQuery(DBRoute dbRoute, List<DBPrivacyDataModel> queryModels) {
        Long timeStart = System.currentTimeMillis();
        ArrayList<Object> result = new ArrayList<Object>();
        SqlBuilder sb = new SqlBuilder();
        String tableName = "";
        if (queryModels == null || queryModels.size() == 0) {
            return result;
        }
        tableName = PrivacyMapping.buildPrivacyTableName(queryModels.get(0).getTableName());
        sb.append("select fbizid from ", new Object[0]);
        sb.append(tableName.toLowerCase(Locale.ENGLISH), new Object[0]);
        sb.append(" where ", new Object[0]);
        int i = 0;
        String localeId = "";
        String fuzzySearch = "";
        Integer fuzzyValue = 0;
        Map<String, Map<String, Object>> buildMap = this.buildHashInput(queryModels);
        for (Map.Entry<String, Map<String, Object>> entry : buildMap.entrySet()) {
            fuzzySearch = entry.getValue().get("fuzzySearch") + "";
            localeId = entry.getValue().get("localeId") + "";
            sb.append(" (ffield = ", new Object[0]);
            sb.append("'" + entry.getKey().toLowerCase(Locale.ENGLISH) + "'", new Object[0]);
            if (StringUtils.isNotEmpty((String)localeId) && !localeId.equalsIgnoreCase("null")) {
                sb.append(" and flocaleid = '" + localeId + "'", new Object[0]);
            }
            if (StringUtils.isNotEmpty((String)fuzzySearch)) {
                fuzzyValue = Integer.parseInt(fuzzySearch);
            }
            if (fuzzyValue == IPrivacyConst.FUZZYTYPE.EQUALS) {
                sb.append(" and (", new Object[0]).appendIn("fhash", (List)entry.getValue().get("oldhash"));
                sb.append(" or ", new Object[0]).appendIn("fhash", (List)entry.getValue().get("newhash"));
                sb.append(")", new Object[0]);
                if (i < buildMap.size() - 1) {
                    sb.append("or", new Object[0]);
                }
            } else if (fuzzyValue == IPrivacyConst.FUZZYTYPE.LIKE) {
                sb.append(" and (ffuzzyhash like '%" + HashTool.sha512(entry.getValue().get("origin") + "") + "%')", new Object[0]);
                if (i < buildMap.size() - 1) {
                    sb.append("or", new Object[0]);
                }
            } else if (fuzzyValue == IPrivacyConst.FUZZYTYPE.NOTLIKE) {
                sb.append(" and (ffuzzyhash not like '%" + HashTool.sha512(entry.getValue().get("origin") + "") + "%')", new Object[0]);
                if (i < buildMap.size() - 1) {
                    sb.append("or", new Object[0]);
                }
            } else if (fuzzyValue == IPrivacyConst.FUZZYTYPE.LEFTLIKE) {
                sb.append(" and (ffuzzyhash like '%" + HashTool.sha512(entry.getValue().get("origin") + "") + "')", new Object[0]);
                if (i < buildMap.size() - 1) {
                    sb.append("or", new Object[0]);
                }
            } else if (fuzzyValue == IPrivacyConst.FUZZYTYPE.RIGHTLIKE) {
                sb.append(" and (ffuzzyhash like '" + HashTool.sha512(entry.getValue().get("origin") + "") + "%')", new Object[0]);
                if (i < buildMap.size() - 1) {
                    sb.append("or", new Object[0]);
                }
            }
            ++i;
            sb.append(")", new Object[0]);
        }
        try (DataSet ds = DB.queryDataSet((String)"DBPrivacyDataCenterService.hashQuery", (DBRoute)dbRoute, (SqlBuilder)sb);){
            if (ds != null) {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    result.add(row.get("fbizid"));
                }
            }
        }
        Long timeEnd = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("hashQuery take up time is " + (timeEnd - timeStart) + " ms\uff0csql is :" + sb);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Map<String, Object>> idQuery(DBRoute dbRoute, DBIdQueryModel queryModel) throws Exception {
        HashSet<String> multiField;
        HashSet<String> fields;
        Long timeStart = System.currentTimeMillis();
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        SqlBuilder sb = new SqlBuilder();
        String tableName = "";
        String localeId = "";
        if (queryModel.getIds() == null) {
            return result;
        }
        tableName = queryModel.getTableName();
        localeId = queryModel.getLocaleId();
        if (StringUtils.isNotEmpty((String)tableName)) {
            tableName = tableName.toLowerCase(Locale.ENGLISH);
        }
        if (!CollectionUtils.isEmpty((Collection)(fields = queryModel.getFields()))) {
            HashSet<String> set = new HashSet<String>(fields.size());
            for (String string : fields) {
                set.add(string.toLowerCase(Locale.ENGLISH));
            }
            fields = set;
            queryModel.setFields(fields);
        }
        if (!CollectionUtils.isEmpty((Collection)(multiField = queryModel.getMultiField()))) {
            HashSet<String> set = new HashSet<String>(multiField.size());
            for (String str : multiField) {
                set.add(str.toLowerCase(Locale.ENGLISH));
            }
            multiField = set;
            queryModel.setMultiField(multiField);
        }
        sb.append("select fbizid, flocaleid,fhash,fdata,fencrypt,fversion,ffield,ffieldtype ", new Object[0]);
        sb.append(" from ", new Object[0]);
        sb.append(PrivacyMapping.buildPrivacyTableName(tableName), new Object[0]);
        sb.append(" where  1=1", new Object[0]);
        if (fields.size() > 0 && multiField.size() <= 0) {
            sb.appendIn(" and (fbizid", queryModel.getIds());
            sb.appendIn(" and ffield", fields.toArray());
            sb.append(" )", new Object[0]);
        } else if (fields.size() <= 0 && multiField.size() > 0) {
            sb.appendIn(" and (fbizid", queryModel.getIds());
            sb.appendIn(" and ffield", multiField.toArray());
            sb.append(" and (flocaleid = '" + queryModel.getLocaleId() + "' or flocaleid='GLang'))", new Object[0]);
        } else if (fields.size() > 0 && multiField.size() > 0) {
            sb.appendIn(" and (fbizid", queryModel.getIds());
            sb.appendIn(" and ffield", multiField.toArray());
            sb.append(" and (flocaleid = '" + queryModel.getLocaleId() + "' or flocaleid='GLang'))", new Object[0]);
            sb.append(" or (", new Object[0]);
            sb.appendIn(" fbizid", queryModel.getIds());
            sb.appendIn(" and ffield", fields.toArray());
            sb.append(" )", new Object[0]);
        }
        HashMap<String, List<PrivacyDataModel>> tmpDataModelList = new HashMap<String, List<PrivacyDataModel>>(10000);
        Long l = 0L;
        try (DataSet rs = DB.queryDataSet((String)"DBPrivacyDataCenter.idQuery", (DBRoute)dbRoute, (SqlBuilder)sb);){
            if (rs != null) {
                HashMap model = null;
                while (rs.hasNext()) {
                    Long l2;
                    void var11_15;
                    Row row = rs.next();
                    String fbizid = row.getString("fbizid");
                    String ffield = row.getString("ffield");
                    PrivacyDataModel qd = new PrivacyDataModel();
                    qd.setBizId((Object)fbizid);
                    model = (HashMap)result.get(fbizid);
                    if (model == null) {
                        model = new HashMap();
                        result.put(fbizid, model);
                    }
                    if (fields.contains(ffield)) {
                        qd.setTableName(tableName);
                        qd.setFieldName(ffield);
                        qd.setEncryptValue(row.getString("fdata"));
                        qd.setFieldType(row.getInteger("ffieldtype").intValue());
                        qd.setEncrypt(row.getString("fencrypt"));
                        qd.setVersion(row.getInteger("fversion").intValue());
                        qd.setHash(row.getString("fhash"));
                    }
                    if (multiField.contains(ffield)) {
                        qd.setTableName(tableName);
                        qd.setFieldName(ffield);
                        qd.setEncryptValue(row.getString("fdata"));
                        qd.setFieldType(row.getInteger("ffieldtype").intValue());
                        qd.setEncrypt(row.getString("fencrypt"));
                        qd.setVersion(row.getInteger("fversion").intValue());
                        qd.setLocaleId(row.getString("flocaleid"));
                        qd.setHash(row.getString("fhash"));
                    }
                    void var19_29 = var11_15;
                    Long l3 = l2 = Long.valueOf(var11_15.longValue() + 1L);
                    this.putModel(tmpDataModelList, qd);
                    if (l2 < 10000L) continue;
                    Long startTime = System.currentTimeMillis();
                    PrivacyDataQueryService.getSingtonService().decode(tmpDataModelList);
                    logger.info("\u9690\u79c1\u5217\u8868\u67e5\u8be2\u6027\u80fd\u4f18\u5316\u8017\u65f6:\u8868\u540d\uff1a" + tableName + "\u6570\u636e\u91cf\u4e3a\uff1a" + l2 + ",\u8017\u65f6\u4e3a:" + (System.currentTimeMillis() - startTime) + " ms");
                    this.fillRecord(queryModel, tmpDataModelList, result);
                    tmpDataModelList.clear();
                    Long l4 = 0L;
                }
                if (tmpDataModelList.size() > 0) {
                    Long startTime1 = System.currentTimeMillis();
                    PrivacyDataQueryService.getSingtonService().decode(tmpDataModelList);
                    logger.info("\u9690\u79c1\u5217\u8868\u67e5\u8be2\u6027\u80fd\u4f18\u5316\u8017\u65f61:" + tableName + "\u6570\u636e\u91cf\u4e3a\uff1a" + tmpDataModelList.size() + ",\u8017\u65f6\u4e3a:" + (System.currentTimeMillis() - startTime1) + " ms");
                    this.fillRecord(queryModel, tmpDataModelList, result);
                    Long l5 = 0L;
                }
                tmpDataModelList.clear();
            }
        }
        Long timeEnd = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.info("idQuery take up time is " + (timeEnd - timeStart) + " ms\uff0csql is :" + sb);
        }
        return result;
    }

    private void putModel(Map<String, List<PrivacyDataModel>> tmpDataModelList, PrivacyDataModel model) {
        if (tmpDataModelList.containsKey(model.getEncrypt())) {
            tmpDataModelList.get(model.getEncrypt()).add(model);
        } else {
            ArrayList<PrivacyDataModel> innerList = new ArrayList<PrivacyDataModel>();
            innerList.add(model);
            tmpDataModelList.put(model.getEncrypt(), innerList);
        }
    }

    private void fillRecord(DBIdQueryModel queryModel, Map<String, List<PrivacyDataModel>> tmpDataModelList, Map<String, Map<String, Object>> result) {
        Set fields = queryModel.getFields();
        Set multiField = queryModel.getMultiField();
        for (Map.Entry<String, List<PrivacyDataModel>> it : tmpDataModelList.entrySet()) {
            List<PrivacyDataModel> pqs = it.getValue();
            for (PrivacyDataModel pq : pqs) {
                if (fields.contains(pq.getFieldName())) {
                    result.get(pq.getBizId()).put(pq.getFieldName() + "#$", pq.getValue());
                }
                if (!multiField.contains(pq.getFieldName())) continue;
                result.get(pq.getBizId()).put(pq.getFieldName() + "#$" + pq.getLocaleId(), pq.getValue());
            }
        }
    }

    public Map<String, Map<String, MuiltLocaleResultModel>> idMuiltAllQuery(DBRoute dbRoute, DBIdQueryModel queryModel) throws Exception {
        Long timeStart = System.currentTimeMillis();
        HashMap<String, Map<String, MuiltLocaleResultModel>> result = new HashMap<String, Map<String, MuiltLocaleResultModel>>();
        SqlBuilder sb = new SqlBuilder();
        String tableName = "";
        if (!queryModel.getLocaleId().equals("all")) {
            return null;
        }
        if (queryModel.getIds() == null || queryModel.getFields() == null || queryModel.getIds().size() == 0 || queryModel.getFields().size() == 0) {
            return result;
        }
        tableName = queryModel.getTableName();
        Set fields = queryModel.getFields();
        sb.append("select fbizid, fdata,fencrypt,fversion,ffield,flocaleid,ffieldtype ", new Object[0]);
        sb.append(" from ", new Object[0]);
        sb.append(PrivacyMapping.buildPrivacyTableName(tableName), new Object[0]);
        sb.append(" where 1=1 ", new Object[0]);
        sb.appendIn("and fbizid", queryModel.getIds());
        sb.appendIn("and ffield", fields.toArray());
        try (DataSet rs = DB.queryDataSet((String)"DBPrivacyDataCenter.idMuiltAllQuery", (DBRoute)dbRoute, (SqlBuilder)sb);){
            if (rs != null) {
                HashMap<String, MuiltLocaleResultModel> privacyRow = null;
                MuiltLocaleResultModel model = null;
                while (rs.hasNext()) {
                    Row row = rs.next();
                    PrivacyDataModel qd = new PrivacyDataModel();
                    privacyRow = (HashMap<String, MuiltLocaleResultModel>)result.get(row.getString("fbizid"));
                    if (privacyRow == null) {
                        privacyRow = new HashMap<String, MuiltLocaleResultModel>();
                        result.put(row.get("fbizid").toString(), privacyRow);
                    }
                    if (!fields.contains(row.getString("ffield"))) continue;
                    model = (MuiltLocaleResultModel)privacyRow.get(row.getString("ffield"));
                    if (model == null) {
                        model = new MuiltLocaleResultModel();
                        privacyRow.put(row.getString("ffield"), model);
                    }
                    qd.setTableName(tableName);
                    qd.setFieldName(row.getString("ffield"));
                    qd.setEncryptValue(row.getString("fdata"));
                    qd.setFieldType(row.getInteger("ffieldtype").intValue());
                    qd.setEncrypt(row.getString("fencrypt"));
                    qd.setVersion(row.getInteger("fversion").intValue());
                    PrivacyDataQueryService.getSingtonService().decode(qd);
                    model.getFieldValue().put(this.getLocalId(row.getString("flocaleid")), qd.getValue());
                }
            }
        }
        Long timeEnd = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.info("idMuiltAllQuery take up time is " + (timeEnd - timeStart) + " ms\uff0csql is :" + sb);
        }
        return result;
    }

    private String getLocalId(String localeId) {
        if (StringUtils.isEmpty((String)localeId)) {
            return "default";
        }
        return localeId;
    }

    public Map<String, Map<String, Map<String, Object>>> idQuery(DBRoute dbRoute, List<DBIdQueryModel> queryModel) throws Exception {
        HashMap<String, Map<String, Map<String, Object>>> result = new HashMap<String, Map<String, Map<String, Object>>>(queryModel.size());
        for (DBIdQueryModel md : queryModel) {
            Map<String, Map<String, Object>> tableMap = this.idQuery(dbRoute, md);
            result.put(md.getTableName(), tableMap);
        }
        return result;
    }

    public Integer toHash(String data) {
        return HashAlgorithms.FNVHash1(data);
    }

    public String toHash512(String data) {
        return HashTool.sha512(data);
    }

    public void read(DBRoute dbRoute, Object dataEntityTypeMap, Object[] dataEntities) {
        if (!(dbRoute instanceof DBRoute) || !(dataEntityTypeMap instanceof DataEntityTypeMap) || dataEntities == null) {
            return;
        }
        try {
            this.handlePrivacyDataEntities(dbRoute, (DataEntityTypeMap)dataEntityTypeMap, dataEntities);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isTableHaveEncryptField(String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return false;
        }
        String sql = "select fencrypt_field_name from t_privacy_scheme_encrypt tpse where fencrypt_table_name = '" + tableName + "' and fencrypt_algorithm != 'NO'and fencrypt_status = '1'";
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        });
    }

    public String getEncryptTableName(String tableName) {
        return PrivacyTableBuilderService.buildPrivacyTableName(tableName);
    }

    private void handlePrivacyDataEntities(DBRoute dbRoute, DataEntityTypeMap dataEntityTypeMap, Object[] dataEntities) throws Exception {
        IDataEntityType dt = dataEntityTypeMap.getDataEntityType();
        for (ComplexPropertyMap cpxPropMap : dataEntityTypeMap.getComplexProperties()) {
            ArrayList<Object> list = new ArrayList<Object>(16);
            Object[] cpxPropType = cpxPropMap.getDataEntityProperty();
            Object[] objectArray = dataEntities;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object obj = objectArray[i];
                list.add(cpxPropType.getValue(obj));
            }
            this.handlePrivacyDataEntities(dbRoute, cpxPropMap.getComplexPropertyTypeMap(), list.toArray(new Object[list.size()]));
        }
        for (CollectionPropertyMap colPropMap : dataEntityTypeMap.getCollectionProperties()) {
            ICollectionProperty colp = (ICollectionProperty)colPropMap.getDataEntityProperty();
            if (colp instanceof DynamicLocaleProperty) continue;
            for (Object obj : dataEntities) {
                List list = (List)colp.getValue(obj);
                this.handlePrivacyDataEntities(dbRoute, colPropMap.getCollectionItemPropertyTypeMap(), list.toArray(new Object[list.size()]));
            }
        }
        if (dataEntityTypeMap.getDbTable() == null) {
            return;
        }
        String tableName = dt.getAlias();
        for (Tuple tuple : dataEntityTypeMap.getDbTable().getColumnsByTableGroup()) {
            String t = StringUtils.isEmpty((String)((String)tuple.item1)) ? tableName : tableName + "_" + (String)tuple.item1;
            this._handlePrivacyDataEntities(dbRoute, dataEntityTypeMap, dataEntities, dt, t);
        }
    }

    private void _handlePrivacyDataEntities(DBRoute dbRoute, DataEntityTypeMap dataEntityTypeMap, Object[] dataEntities, IDataEntityType dt, String tableName) throws Exception {
        Set encryptFields = PrivacyCenterUtils.getEncryptFields((String)tableName);
        if (encryptFields == null || encryptFields.isEmpty()) {
            return;
        }
        HashMap<String, DynamicSimpleProperty> fieldsNames = new HashMap<String, DynamicSimpleProperty>(6);
        ISimpleProperty pkProp = dt.getPrimaryKey();
        for (Object[] prop : dataEntityTypeMap.getDataEntityType().getProperties()) {
            String fieldName = null;
            if (!(prop instanceof DynamicSimpleProperty) || !StringUtils.isNotEmpty((String)(fieldName = prop.getAlias())) || !encryptFields.contains(fieldName = fieldName.toLowerCase(Locale.ENGLISH))) continue;
            fieldsNames.put(fieldName, (DynamicSimpleProperty)prop);
        }
        if (fieldsNames.isEmpty()) {
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>(6);
        for (Object obj : dataEntities) {
            ids.add(pkProp.getValueFast(obj));
        }
        Map<String, Map<String, MuiltLocaleResultModel>> clearVals = this.getPrivacyDataValues(dbRoute, tableName, ids, fieldsNames);
        for (Object obj : dataEntities) {
            DynamicObject dynamicObject = (DynamicObject)obj;
            dynamicObject.beginInit();
            Map<String, MuiltLocaleResultModel> values = clearVals.get(String.valueOf(pkProp.getValueFast((Object)dynamicObject)));
            if (values != null) {
                for (Map.Entry<String, MuiltLocaleResultModel> entry : values.entrySet()) {
                    Object finalVal;
                    IDataEntityProperty sp = (IDataEntityProperty)fieldsNames.get(entry.getKey());
                    MuiltLocaleResultModel model = entry.getValue();
                    Map fieldValue = model.getFieldValue();
                    if (sp instanceof ILocaleProperty) {
                        LocaleString ormLocaleValue = new LocaleString();
                        for (Map.Entry mapEntry : fieldValue.entrySet()) {
                            ormLocaleValue.put(mapEntry.getKey(), (Object)String.valueOf(mapEntry.getValue()));
                        }
                        finalVal = ormLocaleValue;
                    } else {
                        finalVal = fieldValue.get("default");
                    }
                    sp.setValueFast((Object)dynamicObject, finalVal);
                    if (!(sp instanceof ILocaleProperty)) continue;
                    dynamicObject.getDataEntityState().setRemovedItems(Boolean.valueOf(false));
                }
            }
            dynamicObject.endInit();
        }
    }

    private Map<String, Map<String, MuiltLocaleResultModel>> getPrivacyDataValues(DBRoute dbRoute, String tableName, List<Object> ids, Map<String, DynamicSimpleProperty> fieldNames) throws Exception {
        DBIdQueryModel queryModel = new DBIdQueryModel();
        queryModel.setFields(fieldNames.keySet());
        queryModel.setIds(ids);
        queryModel.setLocaleId("all");
        queryModel.setTableName(tableName);
        return this.idMuiltAllQuery(dbRoute, queryModel);
    }
}

