/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SplitTable;
import kd.bos.privacy.model.PrivacyTableModel;
import kd.bos.xdb.mservice.ShardingMetadataService;

public class PrivacyTableBuilderService {
    private static final Log log = LogFactory.getLog(PrivacyTableBuilderService.class);
    private static final int TABLE_NAME_MAX_LENGTH = 22;
    private static final String CREATE_TABLE_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'idx_%s_%s') CREATE INDEX idx_%s_%s ON %s (%s);";
    private static final String CREATE_TABLE_PK = " EXEC P_ALTERPK 'PK_%s', '%s', 'FPKID', '1';";
    private static final String CREATE_TABLE_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s') create table %s (FPKID               varchar(18) not null ,FBIZID                 %s not null, FLOCALEID           varchar(10), FDATA  NCLOB, FHASH varchar(200) , FFIELD  varchar(30) not null, FVERSION int, FCREATORID  bigint, FMODIFIERID bigint, FMODIFYTIME DATETIME, FCREATETIME DATETIME, FENCRYPT varchar(100) ,FSHARDINGID varchar(300) ,FFIELDTYPE int);";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";

    public static String buildPrivacyTableName(String bdTableName) {
        if (StringUtils.isBlank((CharSequence)bdTableName)) {
            return "";
        }
        if (bdTableName.length() > 22) {
            return bdTableName.substring(0, 22) + "_py";
        }
        return bdTableName + "_py";
    }

    private static boolean tableIsExisted(DBRoute dbRoute, String tableName) {
        String sql = String.format(TABLE_IS_EXISTED_SQL, tableName);
        boolean isExisted = (Boolean)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
        return isExisted;
    }

    public static void buildMainPrivacyTable(DBRoute dbRoute, PrivacyTableModel table) {
        PrivacyTableBuilderService.createPrivacyDataTable(dbRoute, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPrivacyDataTable(DBRoute dbRoute, PrivacyTableModel table) {
        block20: {
            if (StringUtils.isBlank((CharSequence)table.getTableName())) {
                log.info("\u4e3b\u8868\u4e0d\u5b58\u5728,\u52a0\u5bc6\u8868\u4e0d\u5141\u8bb8\u521b\u5efa:" + table.getTableName());
                return;
            }
            String privacyTableName = PrivacyTableBuilderService.buildPrivacyTableName(table.getTableName());
            ShardingMetadataService.getInstance().syncPrivacyXDBConfig(table.getTableName(), privacyTableName);
            if (PrivacyTableBuilderService.tableIsExisted(dbRoute, privacyTableName)) {
                log.info("\u52a0\u5bc6\u8868\u5df2\u7ecf\u5b58\u5728:" + privacyTableName);
                return;
            }
            String create_table = String.format(CREATE_TABLE_SQL, privacyTableName, privacyTableName, table.getPkType() == 0 ? "VARCHAR(36) DEFAULT(' ') " : "BIGINT DEFAULT(0) ");
            try (TXHandle h = TX.requiresNew();){
                DLock lock;
                block21: {
                    if (DB.exitsTable((DBRoute)dbRoute, (String)privacyTableName)) break block20;
                    String key = RequestContext.get().getAccountId() + privacyTableName;
                    lock = DLock.create((String)key, (String)String.format(ResManager.loadKDString((String)"\u521b\u5efa\u9690\u79c1\u8868%s", (String)"PrivacyTableBuilderService_0", (String)"bos-privacy-implement", (Object[])new Object[0]), privacyTableName));
                    lock.lock();
                    try {
                        if (DB.exitsTable((DBRoute)dbRoute, (String)privacyTableName)) break block21;
                        DB.execute((DBRoute)dbRoute, (String)create_table);
                        log.info("\u52a0\u5bc6\u8868\u521b\u5efa\u6210\u529f:" + privacyTableName);
                        PrivacyTableBuilderService.buildPrivacyTablePk(dbRoute, privacyTableName);
                        PrivacyTableBuilderService.buildPrivacyTableIndx(dbRoute, privacyTableName, "fhash");
                        PrivacyTableBuilderService.buildPrivacyTableIndx(dbRoute, privacyTableName, "ffield");
                        PrivacyTableBuilderService.buildPrivacyTableIndx(dbRoute, privacyTableName, "fbizid");
                        PrivacyTableBuilderService.buildPrivacyTableIndx(dbRoute, privacyTableName, "fencrypt");
                        PrivacyTableBuilderService.buildPrivacyTableIndx(dbRoute, privacyTableName, "flocaleid");
                    }
                    catch (Throwable e) {
                        try {
                            h.markRollback();
                            if (log.isErrorEnabled()) {
                                log.error("privacy create table error:", e);
                            }
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                lock.unlock();
            }
        }
    }

    public static void buildPrivacyTablePk(DBRoute dbRoute, String privacyTableName) {
        String create_table_index = String.format(CREATE_TABLE_PK, privacyTableName.toUpperCase(), privacyTableName.toUpperCase());
        DB.execute((DBRoute)dbRoute, (String)create_table_index);
        log.info("\u52a0\u5bc6\u8868\u4e3b\u952e\u521b\u5efa\u6210\u529f:" + privacyTableName + " fieldName:id");
    }

    public static void buildPrivacyTableIndx(DBRoute dbRoute, String privacyTableName, String fieldName) {
        String create_table_index = String.format(CREATE_TABLE_INDEX_SQL, privacyTableName, fieldName, privacyTableName, fieldName, privacyTableName, fieldName);
        DB.execute((DBRoute)dbRoute, (String)create_table_index);
        log.info("\u52a0\u5bc6\u8868\u521b\u5efa\u7d22\u5f15\u6210\u529f:{} fieldName:{}", (Object)privacyTableName, (Object)fieldName);
    }

    public static boolean buildPrivacyTable(EntityMetadata entityMetadata) {
        if (entityMetadata == null || !(entityMetadata.getRootEntity() instanceof BillEntity)) {
            return false;
        }
        PrivacyTableModel model = null;
        String splitTbName = "";
        for (Entity entity : entityMetadata.getEntitys()) {
            model = new PrivacyTableModel();
            model.setTableName(entity.getTableName());
            model.setPkType(entityMetadata.getRootEntity().getPkType());
            PrivacyTableBuilderService.createPrivacyDataTable(new DBRoute(entityMetadata.getDBRouteKey()), model);
            List splitTables = entity.getSplitTables();
            if (splitTables == null || splitTables.size() <= 0) continue;
            for (SplitTable table : splitTables) {
                splitTbName = entity.getTableName() + "_" + table.getSuffix();
                model.setTableName(splitTbName);
                model.setPkType(entityMetadata.getRootEntity().getPkType());
                PrivacyTableBuilderService.createPrivacyDataTable(new DBRoute(entityMetadata.getDBRouteKey()), model);
                log.info("\u62c6\u5206\u8868\u521b\u5efa\u6210\u529f:" + splitTbName);
            }
        }
        return true;
    }
}

