/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.strategy;

import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.strategy.AbstractDesensitizeStrategy;
import kd.bos.util.StringUtils;

public class BankAcctDesenStrategy
extends AbstractDesensitizeStrategy {
    @Override
    protected String desensitizeInternal(PrivacyEncryptModel encryptModel, Object value) {
        if (value instanceof String && StringUtils.isNotEmpty((String)((String)value))) {
            String bankNo = (String)value;
            if (bankNo.indexOf(32) >= 0) {
                bankNo = bankNo.replace(" ", "");
            }
            if (bankNo.indexOf(45) >= 0) {
                bankNo = bankNo.replace("-", "");
            }
            if (bankNo.length() > 15) {
                char[] chars = bankNo.toCharArray();
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < chars.length; ++i) {
                    int s1 = i > 5 && i < chars.length - 4 ? 42 : chars[i];
                    buf.append((char)s1);
                }
                return buf.toString();
            }
            if (bankNo.length() < 3) {
                return this.getDefaultValue();
            }
            if (bankNo.length() == 3) {
                return this.hide(bankNo, 1, 2, '*');
            }
            return this.getGeneralValue(bankNo);
        }
        return this.getDefaultValue();
    }

    @Override
    public String getStrategyName() {
        return "BC";
    }

    protected String getGeneralValue(String bankNo) {
        int starLength = (int)Math.ceil((double)bankNo.length() * 0.4);
        int ahead = (bankNo.length() - starLength) / 2;
        return this.hide(bankNo, ahead, ahead + starLength, '*');
    }
}

