/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.strategy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.strategy.AbstractDesensitizeStrategy;
import kd.bos.util.StringUtils;

public class TelephoneDesenStrategy
extends AbstractDesensitizeStrategy {
    private static final String SEPARATOR = "-";

    @Override
    protected String desensitizeInternal(PrivacyEncryptModel encryptModel, Object value) {
        TPStrategy tpStrategy;
        if (StringUtils.isEmpty((String)((String)value))) {
            return this.getDefaultValue();
        }
        String val = (String)value;
        int index = val.indexOf(SEPARATOR);
        if (index <= 0) {
            if (val.length() == 11) {
                return TPStrategy.China.desensitize(val);
            }
            return this.getDefaultValue();
        }
        String code = val.substring(0, index);
        String phone = val.substring(index + 1);
        String country = TPStrategy.getCountry(code);
        if (StringUtils.isNotEmpty((String)phone) && StringUtils.isNotEmpty((String)country) && (tpStrategy = TPStrategy.valueOf(country)) != null) {
            return code + SEPARATOR + tpStrategy.desensitize(phone);
        }
        return this.getDefaultValue();
    }

    @Override
    public String getStrategyName() {
        return "TP";
    }

    @Override
    protected String getDefaultValue() {
        return super.getDefaultValue();
    }

    static enum TPStrategy {
        China{

            @Override
            String desensitize(String phone) {
                return phone.replaceAll("(\\w{3})\\w*(\\w{4})", "$1****$2");
            }
        };

        private static Map<String, String> map;

        public static String getCountry(String code) {
            return map.get(code);
        }

        abstract String desensitize(String var1);

        static {
            map = new ConcurrentHashMap<String, String>();
            map.put("+86", "China");
        }
    }
}

