/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.model.PrivacyTableModel;
import kd.bos.privacy.scheme.PrivacyMapping;
import kd.bos.privacy.service.PrivacyEncryptService;
import kd.bos.privacy.service.PrivacyTableBuilderService;
import kd.bos.privacy.task.ShardingModel;
import kd.bos.privacy.utils.HashTool;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public abstract class BaseTask {
    private static final Log logger = LogFactory.getLog(BaseTask.class);
    private DataSet encodeQueryDs = null;
    private int repeatQueryNumber = 0;
    private int queryBatch = 0;
    private List<ShardingModel> shardingModels = new ArrayList<ShardingModel>();
    private String shardingId;
    private PrivacyEncryptService pdService = new PrivacyEncryptService();
    private Long schemeId;
    private Long taskId;
    private String taskNumber;
    private String tableName;
    private String fieldName;
    private Integer fieldType;
    private String pyTableName;
    private Date lastUpdateDate;
    private Boolean existLastUpdate = false;
    private Long lastHandleBizId;
    private String entityNumber;
    private String entityName;
    private String pkName;
    private String orderBy;
    private String isLocale;
    private String isCommonLang = "FALSE";
    private String dbRouter;
    private String accountId;
    private String tenantId;
    private Integer taskStatus;
    private String errorInfo;
    private Integer taskType;
    private Date startDate;
    private Date endDate;
    private Date createDate;
    private String errorlogs;
    private Integer version;
    private Integer upgrade;
    private String createBy;
    private Object pkValue;
    private String orderByValue;
    private Integer pkType;
    private PrivacyEncryptModel encryptModel;
    private String oldEncryptType;
    private String fieldIdent;
    private String fieldDesc;
    private Long creater;
    private String shardingMasterKey;
    private int shardingMasterKeyType;
    private String shardingMasterTable;
    private boolean isMust;

    public int getShardingMasterKeyType() {
        return this.shardingMasterKeyType;
    }

    public void setShardingMasterKeyType(int shardingMasterKeyType) {
        this.shardingMasterKeyType = shardingMasterKeyType;
    }

    public String getShardingMasterTable() {
        return this.shardingMasterTable;
    }

    public void setShardingMasterTable(String shardingMasterTable) {
        this.shardingMasterTable = shardingMasterTable;
    }

    public String getShardingMasterKey() {
        return this.shardingMasterKey;
    }

    public void setShardingMasterKey(String shardingMasterKey) {
        this.shardingMasterKey = shardingMasterKey;
    }

    public List<ShardingModel> getShardingModels() {
        return this.shardingModels;
    }

    public void setShardingModels(List<ShardingModel> shardingModels) {
        this.shardingModels = shardingModels;
    }

    public String genInnerJoin() {
        StringBuilder result = new StringBuilder();
        if (this.shardingModels != null && this.shardingModels.size() > 0) {
            for (ShardingModel sm : this.shardingModels) {
                result.append(sm.genInnerJoin()).append(" ");
            }
            return result.toString();
        }
        return "";
    }

    public int getRepeatQueryNumber() {
        return this.repeatQueryNumber;
    }

    public void setRepeatQueryNumber(int repeatQueryNumber) {
        this.repeatQueryNumber = repeatQueryNumber;
    }

    public boolean isMust() {
        return this.isMust;
    }

    public void setMust(boolean must) {
        this.isMust = must;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Boolean getExistLastUpdate() {
        return this.existLastUpdate;
    }

    public void setExistLastUpdate(Boolean existLastUpdate) {
        this.existLastUpdate = existLastUpdate;
    }

    public String getIsCommonLang() {
        return this.isCommonLang;
    }

    public void setIsCommonLang(String isCommonLang) {
        this.isCommonLang = isCommonLang;
    }

    public String getOldEncryptType() {
        return this.oldEncryptType;
    }

    public void setOldEncryptType(String oldEncryptType) {
        this.oldEncryptType = oldEncryptType;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public Integer getPkType() {
        return this.pkType;
    }

    public void setPkType(Integer pkType) {
        this.pkType = pkType;
    }

    public String getOrderByValue() {
        return this.orderByValue;
    }

    public void setOrderByValue(String orderByValue) {
        this.orderByValue = orderByValue;
    }

    public Object getPkValue() {
        return this.pkValue;
    }

    public void setPkValue(Object pkValue) {
        this.pkValue = pkValue;
    }

    public Integer getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Integer fieldType) {
        this.fieldType = fieldType;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getPkName() {
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getIsLocale() {
        return this.isLocale;
    }

    public void setIsLocale(String isLocale) {
        this.isLocale = isLocale;
    }

    public String getDbRouter() {
        return this.dbRouter;
    }

    public void setDbRouter(String dbRouter) {
        this.dbRouter = dbRouter;
    }

    public PrivacyEncryptService getPdService() {
        return this.pdService;
    }

    public void setPdService(PrivacyEncryptService pdService) {
        this.pdService = pdService;
    }

    public Long getLastHandleBizId() {
        return this.lastHandleBizId;
    }

    public void setLastHandleBizId(Long lastHandleBizId) {
        this.lastHandleBizId = lastHandleBizId;
    }

    public String getPyTableName() {
        return this.pyTableName;
    }

    public void setPyTableName(String pyTableName) {
        this.pyTableName = pyTableName;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getTaskNumber() {
        return this.taskNumber;
    }

    public void setTaskNumber(String taskNumber) {
        this.taskNumber = taskNumber;
    }

    public PrivacyEncryptModel getEncryptModel() {
        return this.encryptModel;
    }

    public void setEncryptModel(PrivacyEncryptModel encryptModel) {
        this.encryptModel = encryptModel;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getFieldIdent() {
        return this.fieldIdent;
    }

    public void setFieldIdent(String fieldIdent) {
        this.fieldIdent = fieldIdent;
    }

    public String getFieldDesc() {
        return this.fieldDesc;
    }

    public void setFieldDesc(String fieldDesc) {
        this.fieldDesc = fieldDesc;
    }

    public Long getCreater() {
        return this.creater;
    }

    public void setCreater(Long creater) {
        this.creater = creater;
    }

    public void batchAdd(List<PrivacyDataModel> batchList) {
    }

    public void batchEncodePrivacyData(List<PrivacyDataModel> dataList, Boolean isCommonLang) {
        if (dataList == null || dataList.size() <= 0) {
            return;
        }
        String pyTableName = "";
        String sql = "INSERT INTO " + this.getPyTableName() + " (  fpkid, fbizid, flocaleid, fdata, fhash, ffield, fcreatorid, fmodifierid, fmodifytime, fcreatetime,  fversion,fencrypt,fshardingid,ffieldtype)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?);";
        ArrayList<SqlParameter[]> psList = new ArrayList<SqlParameter[]>(dataList.size());
        ArrayList<Object> rootPkList = new ArrayList<Object>(dataList.size());
        HashSet<Object> rootPkSet = new HashSet<Object>(4);
        for (PrivacyDataModel pdModel : dataList) {
            SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fpkid", 12, (Object)DB.genStringId((String)PrivacyMapping.buildPrivacyTableName(pdModel.getTableName()))), new SqlParameter(":fbizid", this.getPkTypes(pdModel.getBizId()), pdModel.getBizId()), new SqlParameter(":flocaleid", 12, (Object)(isCommonLang == true ? "GLang" : pdModel.getLocaleId())), new SqlParameter(":fdata", 12, (Object)pdModel.getEncryptValue()), new SqlParameter(":fhash", 12, (Object)HashTool.sha512(String.valueOf(pdModel.getValue()))), new SqlParameter(":ffield", 12, (Object)pdModel.getFieldName()), new SqlParameter(":fcreatorid", -5, (Object)0), new SqlParameter(":fmodifierid", -5, (Object)0), new SqlParameter(":fmodifytime", 93, (Object)new Date()), new SqlParameter(":fcreatetime", 93, (Object)new Date()), new SqlParameter(":fversion", 4, (Object)1), new SqlParameter(":fencrypt", 12, (Object)pdModel.getEncrypt()), new SqlParameter(":fshardingid", 12, pdModel.getShardingId()), new SqlParameter(":ffieldtype", 4, (Object)pdModel.getFieldType())};
            psList.add(sqlParas);
            rootPkList.add(pdModel.getShardingId());
            rootPkSet.add(pdModel.getShardingId());
        }
        if (DB.isSharded((String)this.getShardingMasterTable())) {
            Map pkIndexMap = ShardingHinter.queryShardingIndex((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)this.getShardingMasterTable(), Arrays.asList(rootPkSet.toArray()));
            HashMap<Object, List> indexParamsListMap = new HashMap<Object, List>();
            HashMap<Object, Set> indexPkListMap = new HashMap<Object, Set>();
            int N = rootPkList.size();
            for (int i = 0; i < N; ++i) {
                Object pk = rootPkList.get(i);
                long index = null != pkIndexMap.get(pk) ? (Long)pkIndexMap.get(pk) : -1L;
                Object[] params = (Object[])psList.get(i);
                indexPkListMap.computeIfAbsent(index, k -> new HashSet()).add(pk);
                indexParamsListMap.computeIfAbsent(index, k -> new ArrayList()).add(params);
            }
            for (Map.Entry entry : indexPkListMap.entrySet()) {
                Set pks = (Set)entry.getValue();
                List paramsList = (List)indexParamsListMap.get(entry.getKey());
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, Arrays.asList(pks.toArray()))});
                Throwable throwable = null;
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, (List)paramsList);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
        } else {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, psList);
        }
    }

    private String buildQuerySql(String fpkId) {
        String sql = "";
        String taskName = "";
        if (fpkId == null) {
            if (StringUtils.isEmpty((CharSequence)this.isLocale) || this.isLocale.equals("TRUE")) {
                if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                    sql = "select top 5000 " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                    taskName = "1taskId";
                } else {
                    sql = "select top 5000 " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                    taskName = "2taskId";
                }
            } else if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select top 5000 " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "' where c.fbizid is null ";
                taskName = "3taskId";
            } else {
                sql = "select top 5000 " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "' where c.fbizid is null ";
                taskName = "4taskId";
            }
        } else if (StringUtils.isEmpty((CharSequence)this.isLocale) || this.isLocale.equals("TRUE")) {
            if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select top 5000 " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                taskName = "5taskId";
            } else {
                sql = "select top 5000 " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                taskName = "6taskId";
            }
        } else if (this.getPkType() == -5) {
            if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select top 5000 " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "'  where c.fbizid is null";
                taskName = "7taskId";
            } else {
                sql = "select top 5000 " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "'  where  c.fbizid is null";
                taskName = "8taskId";
            }
        } else if (this.getPkType() == 12 || this.getPkType() == -9) {
            if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select top 5000 " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid  and c.ffield='" + this.getFieldName() + "'  where   c.fbizid is null";
                taskName = "9taskId";
            } else {
                sql = "select top 5000 " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid  and c.ffield='" + this.getFieldName() + "'  where  c.fbizid is null";
                taskName = "10taskId";
            }
        }
        logger.info(taskName + ":" + this.taskId + " " + this.tableName + " " + this.fieldName + " " + this.orderBy + " " + this.isLocale + " " + this.isCommonLang + " " + this.existLastUpdate);
        return sql;
    }

    private String buildQuerySqlNoTop(String fpkId) {
        String sql = "";
        String taskName = "";
        if (fpkId == null) {
            if (StringUtils.isEmpty((CharSequence)this.isLocale) || this.isLocale.equals("TRUE")) {
                if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                    sql = "select " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                    taskName = "1taskId";
                } else {
                    sql = "select " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                    taskName = "2taskId";
                }
            } else if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "' where c.fbizid is null ";
                taskName = "3taskId";
            } else {
                sql = "select " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "' where c.fbizid is null ";
                taskName = "4taskId";
            }
        } else if (StringUtils.isEmpty((CharSequence)this.isLocale) || this.isLocale.equals("TRUE")) {
            if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                taskName = "5taskId";
            } else {
                sql = "select " + this.shardingId + " b." + this.fieldName + ",b." + this.pkName + ",b.flocaleid,b.fpkid  from " + this.tableName + " a " + this.genInnerJoin() + " INNER JOIN " + this.tableName + "_l b on a." + this.pkName + " = b." + this.pkName + " where b." + this.fieldName + " != ' ' ";
                taskName = "6taskId";
            }
        } else if (this.getPkType() == -5) {
            if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "'  where c.fbizid is null";
                taskName = "7taskId";
            } else {
                sql = "select " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid and c.ffield='" + this.getFieldName() + "'  where  c.fbizid is null";
                taskName = "8taskId";
            }
        } else if (this.getPkType() == 12 || this.getPkType() == -9) {
            if (this.existLastUpdate.booleanValue() && StringUtils.isNotEmpty((CharSequence)this.orderBy)) {
                sql = "select " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid  and c.ffield='" + this.getFieldName() + "'  where   c.fbizid is null";
                taskName = "9taskId";
            } else {
                sql = "select " + this.shardingId + " a." + this.fieldName + ",a." + this.pkName + ",a." + this.pkName + " as fpkid,'' as flocaleid  from " + this.tableName + " a " + this.genInnerJoin() + " LEFT JOIN " + this.pyTableName + " c on a." + this.pkName + " = c.fbizid  and c.ffield='" + this.getFieldName() + "'  where  c.fbizid is null";
                taskName = "10taskId";
            }
        }
        logger.info(taskName + ":" + this.taskId + " " + this.tableName + " " + this.fieldName + " " + this.orderBy + " " + this.isLocale + " " + this.isCommonLang + " " + this.existLastUpdate);
        return sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PrivacyDataModel> batchQueryBizData(DBRoute dbRoute, String fpkId) throws Exception {
        String sql = this.buildQuerySql(fpkId);
        try (DataSet ds = DB.queryDataSet((String)"BaseTask.batchQueryBizData", (DBRoute)dbRoute, (String)sql);){
            logger.info(String.format("\u5b8c\u6210batchQueryBizData:TaskId:%s, buildQuerySql:%s", this.getTaskId(), sql));
            ArrayList<PrivacyDataModel> result = new ArrayList<PrivacyDataModel>();
            if (ds != null) {
                Row row = null;
                Object shardingValue = null;
                PrivacyDataModel dataModel = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    dataModel = new PrivacyDataModel();
                    dataModel.setTableName(this.tableName);
                    dataModel.setFieldName(this.fieldName);
                    dataModel.setBizId(row.get(this.pkName));
                    dataModel.setId(row.getString("fpkid"));
                    dataModel.setLocaleId(row.getString("flocaleid"));
                    dataModel.setValue(row.get(this.fieldName));
                    try {
                        String tmp = row.getString("fshardingid");
                        if (!StringUtils.isEmpty((CharSequence)tmp)) {
                            shardingValue = Long.valueOf(row.getString("fshardingid"));
                        }
                    }
                    catch (Exception e) {
                        shardingValue = row.getString("fshardingid");
                    }
                    dataModel.setShardingId(shardingValue);
                    dataModel.setFieldType(this.fieldType.intValue());
                    result.add(dataModel);
                }
                logger.info("\u5b8c\u6210batchQueryBizData\u8f6c\u6362:TaskId" + this.getTaskId() + ":" + this.getTableName() + ":" + this.getFieldName() + ":" + this.getPkName() + ":" + this.getOrderBy());
            }
            ArrayList<PrivacyDataModel> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public List<PrivacyDataModel> batchQueryBizDataNoTop(DBRoute dbRoute, String fpkId) throws Exception {
        String sql = this.buildQuerySqlNoTop(fpkId);
        int count = 0;
        logger.info("taskId:" + this.taskId + " batchQueryBizDataNoTop,buildQuerySql:" + sql);
        if (this.encodeQueryDs == null) {
            this.encodeQueryDs = DB.queryDataSet((String)"BaseTask.batchQueryBizDataNoTop", (DBRoute)dbRoute, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.encodeQueryDs.close();
            this.encodeQueryDs = DB.queryDataSet((String)"BaseTask.batchQueryBizDataNoTop", (DBRoute)dbRoute, (String)sql);
            this.queryBatch = 0;
            logger.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        logger.info("\u5b8c\u6210batchQueryBizDataNoTop:TaskId" + this.getTaskId());
        ArrayList<PrivacyDataModel> result = new ArrayList<PrivacyDataModel>();
        if (this.encodeQueryDs != null) {
            Row row = null;
            Object shardingValue = null;
            PrivacyDataModel dataModel = null;
            while (this.encodeQueryDs.hasNext()) {
                row = this.encodeQueryDs.next();
                dataModel = new PrivacyDataModel();
                dataModel.setTableName(this.tableName);
                dataModel.setFieldName(this.fieldName);
                dataModel.setBizId(row.get(this.pkName));
                dataModel.setId(row.getString("fpkid"));
                dataModel.setLocaleId(row.getString("flocaleid"));
                dataModel.setValue(row.get(this.fieldName));
                try {
                    String tmp = row.getString("fshardingid");
                    if (!StringUtils.isEmpty((CharSequence)tmp)) {
                        shardingValue = Long.valueOf(row.getString("fshardingid"));
                    }
                }
                catch (Exception e) {
                    shardingValue = row.getString("fshardingid");
                }
                dataModel.setShardingId(shardingValue);
                dataModel.setFieldType(this.fieldType.intValue());
                result.add(dataModel);
                if (++count < 5000) continue;
                ++this.queryBatch;
                break;
            }
            logger.info("\u5b8c\u6210batchQueryBizData\u8f6c\u6362:TaskId" + this.getTaskId() + ":" + this.getTableName() + ":" + this.getFieldName() + ":" + this.getPkName() + ":" + this.getOrderBy());
        }
        return result;
    }

    public void partComplete(String pkValue) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_privacy_task set fpkvalue =?,forderby_value=? where fid = ?", new Object[]{pkValue, null, this.taskId});
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
    }

    public abstract void leaveOutRecord(String var1) throws Exception;

    public void makeUpFor() {
    }

    public void complete() {
        if (this.encodeQueryDs != null) {
            this.encodeQueryDs.close();
            this.encodeQueryDs = null;
        }
        try (TXHandle tx = TX.notSupported();){
            SqlBuilder sb = new SqlBuilder();
            sb.append("update t_privacy_task set fend_date =?,ftask_status=? where fid = ?", new Object[]{new Date(), 3, this.taskId});
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
        }
    }

    public void updateTaskType(int type) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_privacy_task set ftask_type=? where fid = ?", new Object[]{type, this.taskId});
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
        PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
    }

    public String buildErrorInfo(Throwable e, Boolean all) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        String stackTraceString = sw.getBuffer().toString();
        if (all.booleanValue()) {
            return stackTraceString;
        }
        if (stackTraceString.length() > 1500) {
            stackTraceString = stackTraceString.substring(0, 1500);
        }
        return stackTraceString;
    }

    public void fail(String errorInfo) {
        if (StringUtils.isNotEmpty((CharSequence)errorInfo) && errorInfo.length() >= 1800) {
            errorInfo = errorInfo.substring(0, 1800);
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_privacy_task set fend_date =?,ftask_status=?,ferrorlogs = ? where fid = ?", new Object[]{new Date(), 4, errorInfo, this.taskId});
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
        PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
    }

    public void start() {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_privacy_task set fstart_date =?,ftask_status=?,finstanceid=? where fid = ?", new Object[]{new Date(), 2, Instance.getInstanceId(), this.taskId});
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);
        PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
    }

    public void updatePrivacyConfigStatus() throws Exception {
        String sql = "update t_privacy_scheme_encrypt set fencrypt_status = ? where lower(fencrypt_table_name) =? and lower(fencrypt_field_name)=?";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fencrypt_status", 12, (Object)"1"), new SqlParameter(":fencrypt_table_name", 12, (Object)this.getTableName().toLowerCase()), new SqlParameter(":fencrypt_field_name", 12, (Object)this.getFieldName().toLowerCase())};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);
        logger.info("update t_privacy_scheme_encrypt success:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName());
        PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PrivacyDataModel> batchQueryPrivacyData(String fpkId) throws Exception {
        String sql = "";
        sql = fpkId == null ? "select top 5000   fshardingid,fpkid,fbizid,flocaleid,fdata,ffield,fencrypt,fversion,ffieldtype  from " + this.pyTableName + " where ffield = '" + this.getFieldName() + "' " : "select top 5000  fshardingid,fpkid,fbizid,flocaleid,fdata,ffield,fencrypt,fversion,ffieldtype from " + this.pyTableName + " where ffield = '" + this.getFieldName() + "' and fpkid<'" + fpkId + "' ";
        try (DataSet ds = DB.queryDataSet((String)"BaseTask.batchQueryPrivacyData", (DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql);){
            ArrayList<PrivacyDataModel> result = new ArrayList<PrivacyDataModel>();
            if (ds != null) {
                Row row = null;
                PrivacyDataModel dataModel = null;
                Object shardingValue = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    dataModel = new PrivacyDataModel();
                    dataModel.setTableName(this.tableName);
                    dataModel.setFieldName(this.fieldName);
                    if (!row.getString("ffield").equals(this.fieldName)) {
                        throw new Exception("system is error,must repair!!!!");
                    }
                    dataModel.setEncryptValue(row.getString("fdata"));
                    dataModel.setLocaleId(row.getString("flocaleid"));
                    dataModel.setBizId(row.get("fbizid"));
                    dataModel.setId(row.getString("fpkid"));
                    dataModel.setVersion(row.getInteger("fversion").intValue());
                    dataModel.setEncrypt(row.getString("fencrypt"));
                    try {
                        String tmp = row.getString("fshardingid");
                        if (!StringUtils.isEmpty((CharSequence)tmp)) {
                            shardingValue = Long.valueOf(row.getString("fshardingid"));
                        }
                    }
                    catch (Exception e) {
                        shardingValue = row.getString("fshardingid");
                    }
                    dataModel.setShardingId(shardingValue);
                    dataModel.setFieldType(row.getInteger("ffieldtype").intValue());
                    result.add(dataModel);
                }
            }
            ArrayList<PrivacyDataModel> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    public int getPkTypes(Object bizId) {
        if (bizId instanceof Long) {
            return -5;
        }
        if (bizId instanceof String) {
            return 12;
        }
        if (bizId instanceof Double) {
            return 3;
        }
        return -5;
    }

    public void save() {
        String sql = "INSERT INTO t_privacy_task(  fid, ftask_type, ftable_name, fpytable_name, fstart_date, fend_date, fcreate_date, ferrorlogs, fversion, fupgrade,  ftask_status, ffield_name,forderby,fpkname,ffield_type,fdbrouter,fentity_number,fislocale,foldencrypt_type,fpktype,fiscommonlang,fschemeId,ftasknumber,fentityname,ffieldident,ffielddesc,fcreater)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)this.taskId), new SqlParameter(":ftask_type", 4, (Object)this.taskType), new SqlParameter(":ftable_name", 12, (Object)this.tableName), new SqlParameter(":fpytable_name", 12, (Object)this.pyTableName), new SqlParameter(":fstart_date", 91, (Object)this.startDate), new SqlParameter(":fend_date", 91, (Object)this.endDate), new SqlParameter(":fcreate_date", 91, (Object)this.createDate), new SqlParameter(":ferrorlogs", 12, (Object)this.errorlogs), new SqlParameter(":fversion", 4, (Object)this.version), new SqlParameter(":fupgrade", 12, (Object)-1), new SqlParameter(":ftask_status", 4, (Object)this.taskStatus), new SqlParameter(":ffield_name", 12, (Object)this.fieldName), new SqlParameter(":forderby", 12, (Object)this.orderBy), new SqlParameter(":fpkname", 12, (Object)this.pkName), new SqlParameter(":ffield_type", 4, (Object)this.fieldType), new SqlParameter(":fdbrouter", 12, (Object)this.dbRouter), new SqlParameter(":fentity_number", 12, (Object)this.entityNumber), new SqlParameter(":fislocale", 12, (Object)this.isLocale), new SqlParameter(":foldencrypt_type", 12, (Object)this.oldEncryptType), new SqlParameter(":fpktype", 4, (Object)this.pkType), new SqlParameter(":fiscommonlang", 12, (Object)this.isCommonLang), new SqlParameter(":fschemeId", -5, (Object)this.schemeId), new SqlParameter(":ftasknumber", 12, (Object)this.taskNumber), new SqlParameter(":fentityname", 12, (Object)this.getEntityName()), new SqlParameter(":ffieldident", 12, (Object)this.getFieldIdent()), new SqlParameter(":ffielddesc", 12, (Object)this.getFieldDesc()), new SqlParameter(":fcreater", 12, (Object)this.getCreater())};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);
        PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
    }

    public void delete() {
        String sql = "DELETE FROM  t_privacy_task  WHERE fid = ?;";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)this.taskId)};
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])sqlParas);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public void setTaskType(int taskType) {
        this.taskType = taskType;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    public Integer getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Integer getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(Integer upgrade) {
        this.upgrade = upgrade;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getErrorlogs() {
        return this.errorlogs;
    }

    public void setErrorlogs(String errorlogs) {
        this.errorlogs = errorlogs;
    }

    public abstract void execute() throws Exception;

    public void check() throws Exception {
        PrivacyTableModel model = new PrivacyTableModel();
        model.setTableName(this.getTableName());
        String entityId = MetadataDao.getIdByNumber((String)this.entityNumber, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        model.setPkType(entityMeta.getRootEntity().getPkType());
        PrivacyTableBuilderService.createPrivacyDataTable(new DBRoute(this.dbRouter), model);
        logger.info("\u4efb\u52a1\u542f\u52a8\u540e\u8865\u507f\u6027\u5efa\u8868\u5b8c\u6210" + this.taskId + " tableName:" + model.getTableName() + " pkType:" + this.pkType);
        this.setMust(this.isMustRecordField(DBRoute.of((String)this.getDbRouter()), this.getTableName(), this.getFieldName()));
        logger.info("\u4efb\u52a1\u542f\u52a8\u8bbe\u7f6e\u5fc5\u586b\u5b57\u6bb5\u5b8c\u6210" + this.taskId + " tableName:" + model.getTableName() + " fieldName:" + this.getFieldName() + "isMust:" + this.isMust());
        this.ModifyShardingIdField();
        logger.info("\u4efb\u52a1\u542f\u52a8\u5206\u8868\u5b57\u6bb5\u5b8c\u6210" + this.taskId + " tableName:" + model.getTableName() + " fieldName:" + this.getFieldName());
        this.genShardingModels();
        logger.info("\u4efb\u52a1\u542f\u52a8\u8bbe\u7f6eshardingModels" + this.taskId + " tableName:" + model.getTableName() + " fieldName:" + this.getFieldName() + "shardingModels.size():" + this.shardingModels.size());
        PrivacyDataCenterManager.getEncryptService().clearCache();
    }

    private boolean isExistField(String tableName, String fieldName) {
        List fields = DB.getColumnNames((DBRoute)new DBRoute(this.dbRouter), (String)tableName);
        if (fields == null || fields.isEmpty()) {
            return false;
        }
        for (String field : fields) {
            if (!field.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private void ModifyShardingIdField() {
        String privacyTableName = PrivacyTableBuilderService.buildPrivacyTableName(this.getTableName());
        if (!this.isExistField(privacyTableName, "FSHARDINGID")) {
            String sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + privacyTableName + "' AND KSQL_COL_NAME ='fshardingid') \nALTER TABLE " + privacyTableName + " ADD fshardingid VARCHAR(300)";
            DB.execute((DBRoute)new DBRoute(this.dbRouter), (String)sql);
        }
    }

    private String queryTimestampField(String tableName, String fieldName) {
        return "fmodifytime";
    }

    private IDataEntityType getDataEntityTypeInner() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        IDataEntityProperty property = type.findProperty(this.fieldIdent);
        return property.getParent();
    }

    private void genShardingModels() {
        IDataEntityType type = this.getDataEntityTypeInner();
        if (type instanceof SubEntryType) {
            ShardingModel entryModel = new ShardingModel();
            entryModel.setLeftTable(type.getParent().getAlias());
            entryModel.setLeftAlias("privacy_detail");
            entryModel.setLeftId(type.getParent().getPrimaryKey().getAlias());
            entryModel.setRightAlias("a");
            entryModel.setRightId(type.getParent().getPrimaryKey().getAlias());
            this.shardingModels.add(entryModel);
            this.shardingMasterKey = type.getParent().getParent().getPrimaryKey().getAlias();
            this.shardingMasterTable = type.getParent().getParent().getAlias();
            this.shardingId = "privacy_detail." + type.getParent().getParent().getPrimaryKey().getAlias() + " as fshardingid,";
            return;
        }
        if (type instanceof EntryType) {
            this.shardingMasterKey = type.getParent().getPrimaryKey().getAlias();
            this.shardingMasterTable = type.getParent().getAlias();
            this.shardingId = "a." + type.getParent().getPrimaryKey().getAlias() + " as fshardingid,";
            return;
        }
        if (type instanceof MainEntityType) {
            this.shardingMasterKey = type.getPrimaryKey().getAlias();
            this.shardingMasterTable = type.getAlias();
            this.shardingId = "a." + type.getPrimaryKey().getAlias() + " as fshardingid,";
            return;
        }
    }

    public boolean isMustRecordField(DBRoute router, String tableName, String fieldName) {
        return !DB.columnIsNullable((DBRoute)router, (String)tableName, (String)fieldName);
    }

    public static void batchSave(List<Object[]> sqlParams) {
        if (CollectionUtils.isEmpty(sqlParams)) {
            return;
        }
        String sql = "INSERT INTO t_privacy_task(  fid, ftask_type, ftable_name, fpytable_name, fcreate_date, fversion, fupgrade,  ftask_status, ffield_name,forderby,fpkname,ffield_type,fdbrouter,fentity_number,fislocale,foldencrypt_type,fpktype,fiscommonlang,fschemeId,ftasknumber,fentityname,ffieldident,ffielddesc,fcreater)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
        LinkedHashMap<String, Object[]> mulParams = new LinkedHashMap<String, Object[]>(8);
        for (Object[] sqlParam : sqlParams) {
            Object[] params;
            String fid_l;
            String value;
            String localeId;
            Object fid = sqlParam[0];
            if (((SqlParameter)sqlParam[20]).getValue() instanceof ILocaleString) {
                ILocaleString fentityname = (ILocaleString)((SqlParameter)sqlParam[20]).getValue();
                ((SqlParameter)sqlParam[20]).setValue((Object)fentityname.toString());
                for (Map.Entry entry : fentityname.entrySet()) {
                    localeId = (String)entry.getKey();
                    value = (String)entry.getValue();
                    fid_l = localeId + fid;
                    params = (Object[])mulParams.get(fid_l);
                    if (params == null) {
                        params = new Object[5];
                        params[0] = DB.genStringId((String)"t_privacy_task_l");
                        params[1] = fid;
                        params[2] = localeId;
                        mulParams.put(fid_l, params);
                    }
                    params[3] = value;
                }
            }
            if (!(((SqlParameter)sqlParam[22]).getValue() instanceof ILocaleString)) continue;
            ILocaleString ffielddesc = (ILocaleString)((SqlParameter)sqlParam[22]).getValue();
            ((SqlParameter)sqlParam[22]).setValue((Object)ffielddesc.toString());
            for (Map.Entry entry : ffielddesc.entrySet()) {
                localeId = (String)entry.getKey();
                value = (String)entry.getValue();
                fid_l = localeId + fid;
                params = (Object[])mulParams.get(fid_l);
                if (params == null) {
                    params = new Object[5];
                    params[0] = DB.genStringId((String)"t_privacy_task_l");
                    params[1] = fid;
                    params[2] = localeId;
                    mulParams.put(fid_l, params);
                }
                params[4] = value;
            }
        }
        try (TXHandle txHandle = TX.required();){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, sqlParams);
                if (!mulParams.isEmpty()) {
                    String mulSql = "insert into t_privacy_task_l (fpkid,fid,flocaleid,fentityname,ffielddesc) values (?,?,?,?,?) ";
                    DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)mulSql, new ArrayList(mulParams.values()));
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }
}

