/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.privacy.scheme.PrivacyMapping;
import kd.bos.privacy.task.BaseTask;
import kd.bos.privacy.utils.HashTool;
import kd.bos.util.StringUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class EncodeTask
extends BaseTask {
    private static final Log logger = LogFactory.getLog(EncodeTask.class);
    private static final String BOS_PRIVACY_IMPLEMENT = "bos-privacy-implement";
    private static Long queryTime = 0L;
    private static Long encodeTime = 0L;
    private static Long commonLangTime = 0L;
    private static Long privacyDataTime = 0L;
    private static Long clearTime = 0L;
    private static Long totalCount = 0L;

    @Override
    public void execute() throws Exception {
        Long startTime = null;
        Long tmpTime = null;
        logger.info("privacy task execute start!taskId:" + this.getTaskId() + ",FieldName:" + this.getFieldName() + ",TableName:" + this.getTableName());
        List<PrivacyDataModel> result = null;
        this.updateTaskType(1);
        String fid = null;
        if (this.getPkValue() != null) {
            fid = this.getPkValue().toString();
        }
        logger.debug("privacy task batchQueryBizData start!taskId:" + this.getTaskId() + ",dbrouter:" + this.getDbRouter() + ",fid:" + fid);
        while (true) {
            startTime = System.currentTimeMillis();
            result = this.batchQueryBizDataNoTop(DBRoute.of((String)this.getDbRouter()), fid);
            tmpTime = System.currentTimeMillis() - startTime;
            queryTime = queryTime + tmpTime;
            logger.info("\u5b8c\u6210\u52a0\u5bc6\u524d\u67e5\u8be2\u6570\u636e:TaskId:" + this.getTaskId() + "#\u6570\u636e" + result.size() + "\u6761,\u67e5\u8be2\u8017\u65f6" + tmpTime + "\u6beb\u79d2!");
            try (TXHandle txh = TX.requiresNew();){
                if (result == null || result.size() == 0) break;
                try {
                    startTime = System.currentTimeMillis();
                    this.encode(result);
                    tmpTime = System.currentTimeMillis() - startTime;
                    encodeTime = encodeTime + tmpTime;
                    logger.debug("privacy task encode complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u52a0\u5bc6\u8017\u65f6:" + tmpTime + "\u6beb\u79d2!");
                    if ("NOENCRYPTTYPE".equals(result.get(0).getEncryptValue())) {
                        throw new Exception(ResManager.loadKDString((String)"\u672a\u80fd\u83b7\u53d6\u52a0\u5bc6\u7b97\u6cd5\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EncodeTask_0", (String)BOS_PRIVACY_IMPLEMENT, (Object[])new Object[0]));
                    }
                    startTime = System.currentTimeMillis();
                    this.batchEncodeCommonLang(result, true);
                    tmpTime = System.currentTimeMillis() - startTime;
                    commonLangTime = commonLangTime + tmpTime;
                    logger.debug("privacy task batchEncodeCommonLang complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u5904\u7406\u901a\u7528\u8bed\u8a00\u8017\u65f6:" + tmpTime + "\u6beb\u79d2!");
                    startTime = System.currentTimeMillis();
                    this.batchEncodePrivacyData(result, false);
                    tmpTime = System.currentTimeMillis() - startTime;
                    privacyDataTime = privacyDataTime + tmpTime;
                    logger.debug("privacy task batchEncodePrivacyData complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u63d2\u5165\u9690\u79c1\u8868\u6570\u636e\u8017\u65f6:" + tmpTime + "\u6beb\u79d2!");
                    startTime = System.currentTimeMillis();
                    this.clear(result, false);
                    tmpTime = System.currentTimeMillis() - startTime;
                    clearTime = clearTime + tmpTime;
                    logger.debug("privacy task clear complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u6e05\u7406\u4e1a\u52a1\u6570\u636e\u8017\u65f6:" + tmpTime + "\u6beb\u79d2!");
                    totalCount = totalCount + (long)result.size();
                    logger.debug(String.format("\u5404\u9636\u6bb5\u8017\u65f6\u7d2f\u8ba1\uff1aqueryTime:%1$d\u6beb\u79d2,encodeTime:%2$d\u6beb\u79d2,commonLangTime:%3$d\u6beb\u79d2,privacyDataTime:%4$d\u6beb\u79d2,clearTime:%5$d,\u603b\u8bb0\u5f55\u6570:%6$d", queryTime, encodeTime, commonLangTime, privacyDataTime, clearTime, totalCount));
                    result.clear();
                }
                catch (Exception e) {
                    txh.markRollback();
                    throw e;
                }
            }
            startTime = System.currentTimeMillis();
            this.partComplete(fid);
            logger.debug("privacy task partComplete complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u4fee\u6539\u4efb\u52a1\u6570\u636e\u8017\u65f6:" + (System.currentTimeMillis() - startTime) + "\u6beb\u79d2!");
        }
        startTime = System.currentTimeMillis();
        this.lastHandle("encode");
        logger.info("privacy task lastHandle complete!taskId:" + this.getTaskId() + ",fid:" + fid + ",\u8865\u507f\u8017\u65f6:" + (System.currentTimeMillis() - startTime) + "\u6beb\u79d2!");
    }

    private PrivacyDataModel clone(PrivacyDataModel model) {
        PrivacyDataModel cloneObject = new PrivacyDataModel();
        cloneObject.setLocaleId(model.getLocaleId());
        cloneObject.setValue(model.getValue());
        cloneObject.setFieldName(model.getFieldName());
        cloneObject.setTableName(model.getTableName());
        cloneObject.setBizId(model.getBizId());
        cloneObject.setCommonLang(model.getCommonLang());
        cloneObject.setDataClassify(model.getDataClassify());
        cloneObject.setDesensitizeValue(model.getDesensitizeValue());
        cloneObject.setEncrypt(model.getEncrypt());
        cloneObject.setEncryptValue(model.getEncryptValue());
        cloneObject.setFieldType(model.getFieldType());
        cloneObject.setHash(model.getHash());
        cloneObject.setId(model.getId());
        cloneObject.setPageTime(model.getPageTime());
        cloneObject.setVersion(model.getVersion());
        cloneObject.setShardingId(model.getShardingId());
        return cloneObject;
    }

    private void batchEncodeCommonLang(List<PrivacyDataModel> result, Boolean isCommLang) throws Exception {
        String sql = "";
        HashMap<String, PrivacyDataModel> glangModels = new HashMap<String, PrivacyDataModel>();
        ArrayList<Object> bizIds = new ArrayList<Object>();
        if (this.getIsCommonLang().equals("TRUE")) {
            for (PrivacyDataModel model : result) {
                if (bizIds.contains(model.getBizId()) || model.getValue() == null) continue;
                bizIds.add(model.getBizId());
                glangModels.put(model.getBizId().toString(), this.clone(model));
            }
            SqlBuilder sqlBd = new SqlBuilder();
            sqlBd.append("select " + this.getPkName() + "," + this.getFieldName() + " from " + this.getTableName() + " where ", new Object[0]);
            sqlBd.appendIn(this.getPkName(), bizIds);
            try (DataSet ds = DB.queryDataSet((String)"BaseTask.batchEncodeCommonLang", (DBRoute)DBRoute.of((String)this.getDbRouter()), (SqlBuilder)sqlBd);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    PrivacyDataModel cloneObject = (PrivacyDataModel)glangModels.get(row.getString(this.getPkName()));
                    cloneObject.setValue(row.get(this.getFieldName()));
                }
            }
            ArrayList<PrivacyDataModel> enList = new ArrayList<PrivacyDataModel>(glangModels.values());
            this.encode(enList);
            this.batchEncodeCommonLangData(enList, isCommLang);
            this.clear(enList, isCommLang);
        }
    }

    private Set<String> queryGlangModels(List<PrivacyDataModel> dataList, DBRoute route) {
        ArrayList<Object> inIds = new ArrayList<Object>(dataList.size());
        for (PrivacyDataModel pdm : dataList) {
            inIds.add(pdm.getBizId());
        }
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fbizid from " + this.getPyTableName() + " where ", new Object[0]).appendIn("fbizid", inIds.toArray()).append(" and flocaleid='GLang'", new Object[0]);
        return (Set)DB.query((DBRoute)route, (SqlBuilder)sb, resultSet -> {
            HashSet<String> bizIds = new HashSet<String>(6);
            while (resultSet.next()) {
                Object fbizid = resultSet.getObject("fbizid");
                if (fbizid == null) continue;
                bizIds.add(fbizid.toString());
            }
            return bizIds;
        });
    }

    public void batchEncodeCommonLangData(List<PrivacyDataModel> dataList, Boolean isCommonLang) {
        if (dataList == null || dataList.size() <= 0) {
            return;
        }
        Set<String> models = this.queryGlangModels(dataList, DBRoute.of((String)this.getDbRouter()));
        Iterator<PrivacyDataModel> it = dataList.iterator();
        while (it.hasNext()) {
            PrivacyDataModel next = it.next();
            if (!models.contains(String.valueOf(next.getBizId()))) continue;
            it.remove();
        }
        if (dataList == null || dataList.size() <= 0) {
            return;
        }
        String pyTableName = "";
        String sql = "INSERT INTO " + this.getPyTableName() + " (  fpkid, fbizid, flocaleid, fdata, fhash, ffield, fcreatorid, fmodifierid, fmodifytime, fcreatetime,  fversion,fencrypt,fshardingid,ffieldtype)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?) ";
        ArrayList<SqlParameter[]> psList = new ArrayList<SqlParameter[]>(dataList.size());
        ArrayList<Object> rootPkList = new ArrayList<Object>(dataList.size());
        HashSet<Object> rootPkSet = new HashSet<Object>(4);
        for (PrivacyDataModel pdModel : dataList) {
            SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fpkid", 12, (Object)DB.genStringId((String)PrivacyMapping.buildPrivacyTableName(pdModel.getTableName()))), new SqlParameter(":fbizid", this.getPkTypes(pdModel.getBizId()), pdModel.getBizId()), new SqlParameter(":flocaleid", 12, (Object)(isCommonLang == true ? "GLang" : pdModel.getLocaleId())), new SqlParameter(":fdata", 12, (Object)pdModel.getEncryptValue()), new SqlParameter(":fhash", 12, (Object)HashTool.sha512(String.valueOf(pdModel.getValue()))), new SqlParameter(":ffield", 12, (Object)pdModel.getFieldName()), new SqlParameter(":fcreatorid", -5, (Object)0), new SqlParameter(":fmodifierid", -5, (Object)0), new SqlParameter(":fmodifytime", 93, (Object)new Date()), new SqlParameter(":fcreatetime", 93, (Object)new Date()), new SqlParameter(":fversion", 4, (Object)1), new SqlParameter(":fencrypt", 12, (Object)pdModel.getEncrypt()), new SqlParameter(":fshardingid", 12, pdModel.getShardingId()), new SqlParameter(":ffieldtype", 4, (Object)pdModel.getFieldType())};
            psList.add(sqlParas);
            rootPkList.add(pdModel.getShardingId());
            rootPkSet.add(pdModel.getShardingId());
        }
        if (DB.isSharded((String)this.getShardingMasterTable())) {
            Map pkIndexMap = ShardingHinter.queryShardingIndex((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)this.getShardingMasterTable(), Arrays.asList(rootPkSet.toArray()));
            HashMap<Object, List> indexParamsListMap = new HashMap<Object, List>();
            HashMap<Object, Set> indexPkListMap = new HashMap<Object, Set>();
            int N = rootPkList.size();
            for (int i = 0; i < N; ++i) {
                Object pk = rootPkList.get(i);
                long index = null != pkIndexMap.get(pk) ? (Long)pkIndexMap.get(pk) : -1L;
                Object[] params = (Object[])psList.get(i);
                indexPkListMap.computeIfAbsent(index, k -> new HashSet()).add(pk);
                indexParamsListMap.computeIfAbsent(index, k -> new ArrayList()).add(params);
            }
            for (Map.Entry entry : indexPkListMap.entrySet()) {
                Set pks = (Set)entry.getValue();
                List paramsList = (List)indexParamsListMap.get(entry.getKey());
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, Arrays.asList(pks.toArray()))});
                Throwable throwable = null;
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, (List)paramsList);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
        } else {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, psList);
        }
    }

    @Override
    public void leaveOutRecord(String encode) throws Exception {
        List<PrivacyDataModel> result = null;
        String fid = null;
        while (true) {
            result = this.batchQueryBizData(DBRoute.of((String)this.getDbRouter()), fid);
            logger.debug("\u5b8c\u6210\u8865\u507f\u67e5\u8be2\u4e1a\u52a1\u6570\u636e:TaskId:" + this.getTaskId() + "#\u6570\u636e" + result.size() + "\u6761");
            TXHandle txh = TX.requiresNew();
            Throwable throwable = null;
            try {
                if (result == null || result.size() == 0) {
                    this.setRepeatQueryNumber(this.getRepeatQueryNumber() + 1);
                    Thread.sleep(3000L);
                    if (this.getRepeatQueryNumber() > 1) {
                        logger.debug(String.format("\u8865\u507f\u7ed3\u675f:TaskId: %1$d", this.getTaskId()));
                        break;
                    }
                    logger.debug(String.format("\u6301\u7eed\u8865\u507f\u4e2d:TaskId:%1$d \u6b21\u6570\uff1a%2$d", this.getTaskId(), this.getRepeatQueryNumber()));
                    continue;
                }
                this.encode(result);
                logger.debug("\u8865\u507f encode complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                if ("NOENCRYPTTYPE".equals(result.get(0).getEncryptValue())) break;
                try {
                    this.batchEncodeCommonLang(result, true);
                    logger.debug("\u8865\u507f batchEncodeCommonLang complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                    this.batchEncodePrivacyData(result, false);
                    logger.debug("\u8865\u507f batchEncodePrivacyData complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                    this.clear(result, false);
                    logger.debug("\u8865\u507f clear complete!taskId:" + this.getTaskId() + ",fid:" + fid);
                }
                catch (Exception e) {
                    txh.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh == null) continue;
                if (throwable != null) {
                    try {
                        txh.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txh.close();
                continue;
            }
            this.partComplete(fid);
            logger.info("\u8865\u507f partComplete complete!taskId:" + this.getTaskId() + ",fid:" + fid);
        }
    }

    private void lastHandle(String encode) {
        try (TXHandle txh = TX.requiresNew();){
            try {
                this.leaveOutRecord(encode);
                logger.debug("privacy task encode leaveOutRecord success!taskId:" + this.getTaskId() + ",FieldName:" + this.getFieldName() + ",TableName:" + this.getTableName());
                this.updatePrivacyConfigStatus();
                logger.debug("updatePrivacyConfigStatus encode success:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName());
            }
            catch (Exception e) {
                logger.info("\u4efb\u52a1\u6700\u540e\u8865\u507f\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                txh.markRollback();
            }
        }
    }

    private List<Object> splitIds(List<PrivacyDataModel> result) {
        if (result == null || result.size() <= 0) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> ids = new ArrayList<Object>(result.size());
        for (PrivacyDataModel pdModel : result) {
            ids.add(pdModel.getBizId());
        }
        return ids;
    }

    private void encode(List<PrivacyDataModel> list) throws Exception {
        this.getPdService().encode(list);
    }

    private void clear(List<PrivacyDataModel> list, boolean isCommonLang) {
        if (list == null || list.size() <= 0) {
            return;
        }
        ArrayList<Object> shardingIds = new ArrayList<Object>();
        if (StringUtils.isEmpty((String)list.get(0).getLocaleId()) || isCommonLang) {
            String sql = "";
            switch (this.getFieldType()) {
                case -9: 
                case 12: {
                    if (this.isMust()) {
                        sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= ' ' where  " + this.getPkName() + "=?";
                        break;
                    }
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                    break;
                }
                case -5: 
                case 3: 
                case 4: {
                    if (this.isMust()) {
                        sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= 0 where  " + this.getPkName() + "=?";
                        break;
                    }
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (this.isMust()) {
                        sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= '1900-01-01 00:00:00' where  " + this.getPkName() + "=?";
                        break;
                    }
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                    break;
                }
            }
            logger.info("-1 taskId:" + this.getTaskId() + ",localeid:" + list.get(0).getLocaleId() + ",isCommonlang" + isCommonLang + " clear sql is :" + sql);
            ArrayList<SqlParameter[]> values = new ArrayList<SqlParameter[]>();
            for (PrivacyDataModel privacyDataModel : list) {
                SqlParameter[] sqlParas;
                if (privacyDataModel.getBizId() instanceof Long) {
                    sqlParas = new SqlParameter[]{new SqlParameter(":" + this.getPkName(), this.getPkTypes(privacyDataModel.getBizId()), privacyDataModel.getBizId())};
                    values.add(sqlParas);
                } else if (privacyDataModel.getBizId() instanceof String) {
                    sqlParas = new SqlParameter[]{new SqlParameter(":" + this.getPkName(), 12, privacyDataModel.getBizId())};
                    values.add(sqlParas);
                }
                if (shardingIds.contains(privacyDataModel.getShardingId())) continue;
                shardingIds.add(privacyDataModel.getShardingId());
            }
            Throwable throwable = null;
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, shardingIds)});){
                DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, values);
            }
            catch (Throwable sqlParas) {
                Throwable throwable2 = sqlParas;
                throw sqlParas;
            }
        }
        String sql = "update " + this.getTableName() + "_l SET " + this.getFieldName() + "= ' ' where flocaleid = ? and " + this.getPkName() + "=?";
        ArrayList<SqlParameter[]> values = new ArrayList<SqlParameter[]>();
        for (PrivacyDataModel privacyDataModel : list) {
            SqlParameter[] sqlParas;
            if (privacyDataModel.getBizId() instanceof Long) {
                sqlParas = new SqlParameter[]{new SqlParameter(":flocaleid", 12, (Object)privacyDataModel.getLocaleId()), new SqlParameter(":" + this.getPkName(), -5, privacyDataModel.getBizId())};
                values.add(sqlParas);
            } else if (privacyDataModel.getBizId() instanceof String) {
                sqlParas = new SqlParameter[]{new SqlParameter(":flocaleid", 12, (Object)privacyDataModel.getLocaleId()), new SqlParameter(":" + this.getPkName(), 12, privacyDataModel.getBizId())};
                values.add(sqlParas);
            }
            if (shardingIds.contains(privacyDataModel.getShardingId())) continue;
            shardingIds.add(privacyDataModel.getShardingId());
        }
        logger.info(String.format("-2 taskId:%1$s, localeid: %2$s, isCommonlang %b clear sql is :%4$s", this.getTaskId(), list.get(0).getLocaleId(), isCommonLang, sql));
        Throwable throwable = null;
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, shardingIds)});){
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, values);
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throw throwable3;
        }
    }
}

