/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.privacy.scheme.PrivacyMapping;
import kd.bos.privacy.task.BaseTask;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class ExchangeTask
extends BaseTask {
    private static final Log logger = LogFactory.getLog(ExchangeTask.class);

    @Override
    public void execute() throws Exception {
        logger.info("\u542f\u52a8\u8f6c\u6362\u4efb\u52a1:TaskId:" + this.getTaskId() + "TableName:" + this.getTableName() + "FieldName:" + this.getFieldName());
        String oldEncrypt = this.getOldEncryptType();
        PrivacyEncryptModel newModel = PrivacyMapping.queryPrivacyEncrypt(this.getTableName(), this.getFieldName());
        if (kd.bos.util.StringUtils.isEmpty((String)oldEncrypt) && !newModel.getEncryptAlgorithm().equals("NO")) {
            logger.debug("\u52a0\u5bc6\u5904\u7406\uff0c\u56e0\u4e3aTaskId:" + this.getTaskId() + "oldEncrypt:" + oldEncrypt + ",newEncrypt:" + newModel.getEncryptAlgorithm());
            return;
        }
        if (oldEncrypt.equals("NO") && newModel.getEncryptAlgorithm().equals("NO")) {
            logger.debug("\u4e0d\u505a\u5904\u7406\uff0c\u56e0\u4e3a:TaskId" + this.getTaskId() + "oldEncrypt:" + oldEncrypt + ",newEncrypt:" + newModel.getEncryptAlgorithm());
            return;
        }
        if (oldEncrypt.equals(newModel.getEncryptAlgorithm())) {
            logger.debug("\u4e0d\u505a\u5904\u7406\uff0c\u56e0\u4e3aTaskId:" + this.getTaskId() + "oldEncrypt:" + oldEncrypt + ",newEncrypt:" + newModel.getEncryptAlgorithm());
            return;
        }
        logger.debug("\u89e3\u5bc6\u53d8\u66f4\u5904\u7406\uff0c\u56e0\u4e3aTaskId:" + this.getTaskId() + "oldEncrypt:" + oldEncrypt + ",newEncrypt:" + newModel.getEncryptAlgorithm());
        this.exchange(newModel.getEncryptAlgorithm());
    }

    /*
     * Unable to fully structure code
     */
    private void lastHandle(String exchange, String newEncrptyType) throws Exception {
        var3_3 = exchange;
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1298776554: {
                if (!var3_3.equals("encode")) break;
                var4_4 = 0;
                break;
            }
            case -1335717394: {
                if (!var3_3.equals("decode")) break;
                var4_4 = 1;
                break;
            }
            case 1989774883: {
                if (!var3_3.equals("exchange")) break;
                var4_4 = 2;
            }
        }
        switch (var4_4) {
            case 0: {
                txh = TX.requiresNew();
                var6_8 = null;
                try {
                    this.leaveOutRecord(exchange);
                    this.updatePrivacyConfigStatus();
                }
                catch (Exception e) {
                    ExchangeTask.logger.info("\u4efb\u52a1\u6700\u540e\u8865\u507f\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                    txh.markRollback();
                    throw e;
                }
                if (txh == null) break;
                if (var6_8 == null) ** GOTO lbl36
                try {
                    txh.close();
                }
                catch (Throwable e) {
                    var6_8.addSuppressed(e);
                }
                break;
lbl36:
                // 1 sources

                txh.close();
                break;
                catch (Throwable e) {
                    try {
                        var6_8 = e;
                        throw e;
                    }
                    catch (Throwable var8_20) {
                        if (txh != null) {
                            if (var6_8 != null) {
                                try {
                                    txh.close();
                                }
                                catch (Throwable var9_21) {
                                    var6_8.addSuppressed(var9_21);
                                }
                            } else {
                                txh.close();
                            }
                        }
                        throw var8_20;
                    }
                }
            }
            case 1: {
                txh = TX.requiresNew();
                var6_9 = null;
                try {
                    this.leaveOutRecord(exchange);
                    this.updatePrivacyConfigStatus();
                }
                catch (Exception e) {
                    ExchangeTask.logger.info("\u4efb\u52a1\u6700\u540e\u8865\u507f\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                    txh.markRollback();
                    throw e;
                }
                if (txh == null) break;
                if (var6_9 == null) ** GOTO lbl73
                try {
                    txh.close();
                }
                catch (Throwable e) {
                    var6_9.addSuppressed(e);
                }
                break;
lbl73:
                // 1 sources

                txh.close();
                break;
                catch (Throwable e) {
                    try {
                        var6_9 = e;
                        throw e;
                    }
                    catch (Throwable var10_22) {
                        if (txh != null) {
                            if (var6_9 != null) {
                                try {
                                    txh.close();
                                }
                                catch (Throwable var11_23) {
                                    var6_9.addSuppressed(var11_23);
                                }
                            } else {
                                txh.close();
                            }
                        }
                        throw var10_22;
                    }
                }
            }
            case 2: {
                txh = TX.requiresNew();
                var6_10 = null;
                try {
                    this.leaveOutRecord(newEncrptyType);
                    this.updatePrivacyConfigStatus();
                }
                catch (Exception e) {
                    ExchangeTask.logger.info("\u4efb\u52a1\u6700\u540e\u8865\u507f\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                    txh.markRollback();
                    throw e;
                }
                if (txh == null) break;
                if (var6_10 == null) ** GOTO lbl110
                try {
                    txh.close();
                }
                catch (Throwable var7_18) {
                    var6_10.addSuppressed(var7_18);
                }
                break;
lbl110:
                // 1 sources

                txh.close();
                break;
                catch (Throwable var7_19) {
                    try {
                        var6_10 = var7_19;
                        throw var7_19;
                    }
                    catch (Throwable var12_24) {
                        if (txh != null) {
                            if (var6_10 != null) {
                                try {
                                    txh.close();
                                }
                                catch (Throwable var13_25) {
                                    var6_10.addSuppressed(var13_25);
                                }
                            } else {
                                txh.close();
                            }
                        }
                        throw var12_24;
                    }
                }
            }
        }
    }

    @Override
    public void leaveOutRecord(String newEncrptyType) throws Exception {
        List<PrivacyDataModel> result = null;
        String fid = null;
        logger.info("privacy task batchQueryPrivacyData start!taskId:" + this.getTaskId() + ",dbrouter:" + this.getDbRouter() + ",fid:" + fid);
        while (true) {
            result = this.batchQueryPrivacyData(fid);
            logger.debug("\u8bfb\u53d6\u7b97\u6cd5\u5207\u6362\u6570\u636e:TaskId:" + this.getTaskId() + "#\u6570\u636e:" + result.size() + "\u6761");
            TXHandle txh = TX.requiresNew();
            Throwable throwable = null;
            try {
                if (result == null || result.size() == 0) {
                    this.setRepeatQueryNumber(this.getRepeatQueryNumber() + 1);
                    Thread.sleep(3000L);
                    if (this.getRepeatQueryNumber() > 1) {
                        logger.info("\u8865\u507f\u7ed3\u675f:TaskId:" + this.getTaskId());
                        break;
                    }
                    logger.info("\u6301\u7eed\u8865\u507f\u4e2d:TaskId:" + this.getTaskId() + " \u6b21\u6570\uff1a" + this.getRepeatQueryNumber());
                    continue;
                }
                try {
                    this.decode(result, this.getOldEncryptType(), this.getVersion());
                    logger.debug("\u5b8c\u6210exchange\u89e3\u5bc6\u64cd\u4f5c:TaskId:" + this.getTaskId() + result.size() + "\u6761");
                    this.encode(result, newEncrptyType);
                    logger.debug("\u5b8c\u6210exchange\u52a0\u5bc6\u64cd\u4f5c:TaskId:" + this.getTaskId() + result.size() + "\u6761");
                    this.batchPrivacyData(result, newEncrptyType);
                    logger.debug("\u4fee\u6539exchange\u9690\u79c1\u6570\u636e:" + this.getTaskId() + "#\u6570\u636e:" + result.size() + "\u6761");
                }
                catch (Exception e) {
                    logger.info("exchange\u8f6c\u6362\u4efb\u52a1\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                    txh.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh == null) continue;
                if (throwable != null) {
                    try {
                        txh.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txh.close();
                continue;
            }
            this.partComplete(fid);
            logger.info("privacy task partComplete complete!taskId:" + this.getTaskId() + ",dbrouter:" + this.getDbRouter() + ",fid:" + fid);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PrivacyDataModel> batchQueryPrivacyData(String fpkId) throws Exception {
        String sql = "";
        sql = fpkId == null ? "select top 5000  a.fshardingid, a.fmodifytime,a.fpkid,a.fbizid,a.flocaleid,a.fdata,a.ffield,a.fencrypt,a.fversion,a.ffieldtype  from " + this.getPyTableName() + " a  where a.ffield = '" + this.getFieldName() + "' and a.fencrypt='" + this.getOldEncryptType() + "' order by  a.fpkid desc" : "select top 5000  a.fshardingid, a.fmodifytime,a.fpkid,a.fbizid,a.flocaleid,a.fdata,a.ffield,a.fencrypt,a.fversion,a.ffieldtype  from " + this.getPyTableName() + " a  where a.ffield = '" + this.getFieldName() + "' and a.fencrypt='" + this.getOldEncryptType() + "' and a.fpkid<'" + fpkId + "' order by  a.fpkid desc";
        try (DataSet ds = DB.queryDataSet((String)"BaseTask.batchQueryPrivacyData", (DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql);){
            ArrayList<PrivacyDataModel> result = new ArrayList<PrivacyDataModel>();
            if (ds != null) {
                Row row = null;
                Object shardingValue = null;
                PrivacyDataModel dataModel = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    dataModel = new PrivacyDataModel();
                    dataModel.setTableName(this.getTableName());
                    dataModel.setFieldName(this.getFieldName());
                    if (!row.getString("ffield").equals(this.getFieldName())) {
                        throw new Exception("system is error,must repair!!!!");
                    }
                    dataModel.setEncryptValue(row.getString("fdata"));
                    dataModel.setLocaleId(row.getString("flocaleid"));
                    dataModel.setBizId(row.get("fbizid"));
                    dataModel.setId(row.getString("fpkid"));
                    dataModel.setVersion(row.getInteger("fversion").intValue());
                    dataModel.setEncrypt(row.getString("fencrypt"));
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    try {
                        String tmp = row.getString("fshardingid");
                        if (!StringUtils.isEmpty((CharSequence)tmp)) {
                            shardingValue = Long.valueOf(row.getString("fshardingid"));
                        }
                    }
                    catch (Exception e) {
                        shardingValue = row.getString("fshardingid");
                    }
                    dataModel.setShardingId(shardingValue);
                    dataModel.setFieldType(row.getInteger("ffieldtype").intValue());
                    result.add(dataModel);
                }
            }
            ArrayList<PrivacyDataModel> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private void exchange(String newEncrptyType) throws Exception {
        logger.info("privacy task exchange start!taskId:" + this.getTaskId() + ",FieldName:" + this.getFieldName() + ",TableName:" + this.getTableName());
        List<PrivacyDataModel> result = null;
        String fid = null;
        logger.info("privacy task batchQueryPrivacyData start!taskId:" + this.getTaskId() + ",dbrouter:" + this.getDbRouter() + ",fid:" + fid);
        while (true) {
            result = this.batchQueryPrivacyData(fid);
            logger.debug("\u8bfb\u53d6\u7b97\u6cd5\u5207\u6362\u6570\u636e:TaskId:" + this.getTaskId() + "#\u6570\u636e:" + result.size() + "\u6761");
            Throwable throwable = null;
            try (TXHandle txh = TX.requiresNew();){
                if (result == null || result.size() == 0) break;
                this.decode(result, this.getOldEncryptType(), this.getVersion());
                logger.debug("\u5b8c\u6210exchange\u89e3\u5bc6\u64cd\u4f5c:TaskId:" + this.getTaskId() + result.size() + "\u6761");
                this.encode(result, newEncrptyType);
                logger.debug("\u5b8c\u6210exchange\u52a0\u5bc6\u64cd\u4f5c:TaskId:" + this.getTaskId() + result.size() + "\u6761");
                this.batchPrivacyData(result, newEncrptyType);
                logger.debug("\u4fee\u6539exchange\u9690\u79c1\u6570\u636e:" + this.getTaskId() + "#\u6570\u636e:" + result.size() + "\u6761");
                if (result.size() != 5000) break;
                fid = result.get(result.size() - 1).getId();
                result.clear();
            }
            catch (Exception e) {
                logger.info("exchange\u8f6c\u6362\u4efb\u52a1\u8fc7\u7a0b\u4e2d\u62a5\u9519:" + this.getTaskId() + "TableName:" + this.getTableName() + "#FieldName:" + this.getFieldName() + "#\u9519\u8bef:" + e.getMessage());
                txh.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            this.partComplete(fid);
            logger.info("privacy task partComplete complete!taskId:" + this.getTaskId() + ",dbrouter:" + this.getDbRouter() + ",fid:" + fid);
        }
        this.lastHandle("exchange", newEncrptyType);
    }

    private boolean checkDirtyData(PrivacyDataModel pdModel) {
        block39: {
            if (kd.bos.util.StringUtils.isNotEmpty((String)pdModel.getLocaleId())) {
                String multiSql = "select " + pdModel.getFieldName() + " from " + this.getTableName() + "_l  where " + this.getPkName() + " = ? and flocaleid = ?";
                Object[] sqlParas = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter(":" + this.getPkName(), this.getPkTypes(pdModel.getBizId()), pdModel.getBizId()), new kd.bos.db.SqlParameter(":flocaleid", 12, (Object)pdModel.getLocaleId())};
                try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)this.getDbRouter()), (String)multiSql, (Object[])sqlParas);){
                    if (ds.hasNext()) {
                        Row row = ds.next();
                        if (row.get(pdModel.getFieldName()) != null) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    break block39;
                }
            }
            String sql = "select " + pdModel.getFieldName() + " from " + this.getTableName() + " where " + this.getPkName() + "= ? ";
            Object[] sqlParas = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter(":" + this.getPkName(), this.getPkTypes(pdModel.getBizId()), pdModel.getBizId())};
            try (DataSet ds = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, (Object[])sqlParas);){
                if (ds.hasNext()) {
                    Row row = ds.next();
                    if (row.get(pdModel.getFieldName()) != null) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    private void batchDecodePrivacyData(List<PrivacyDataModel> pdList) {
        String sql = "";
        String multiSql = "";
        ArrayList<kd.bos.db.SqlParameter[]> values = new ArrayList<kd.bos.db.SqlParameter[]>();
        ArrayList<kd.bos.db.SqlParameter[]> multiValues = new ArrayList<kd.bos.db.SqlParameter[]>();
        for (PrivacyDataModel pdModel : pdList) {
            kd.bos.db.SqlParameter[] sqlParas;
            if (kd.bos.util.StringUtils.isEmpty((String)pdModel.getLocaleId())) {
                sql = "update " + this.getTableName() + " SET " + pdModel.getFieldName() + " = ? where " + this.getPkName() + "= ? ";
                sqlParas = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter(":" + pdModel.getFieldName(), pdModel.getFieldType(), pdModel.getValue()), new kd.bos.db.SqlParameter(":" + this.getPkName(), this.getPkTypes(pdModel.getBizId()), pdModel.getBizId())};
                values.add(sqlParas);
                continue;
            }
            multiSql = "update " + this.getTableName() + "_l SET " + pdModel.getFieldName() + " = ? where " + this.getPkName() + " = ? and flocaleid = ?";
            sqlParas = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter(":" + pdModel.getFieldName(), pdModel.getFieldType(), pdModel.getValue()), new kd.bos.db.SqlParameter(":" + this.getPkName(), this.getPkTypes(pdModel.getBizId()), pdModel.getBizId()), new kd.bos.db.SqlParameter(":flocaleid", 12, (Object)pdModel.getLocaleId())};
            multiValues.add(sqlParas);
        }
        if (values.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, values);
            logger.debug("\u6267\u884c\u6210\u529fbatchDecodePrivacyData:TaskId:" + this.getTaskId() + "#\u6570\u636e" + values.size() + "\u6761");
        }
        if (multiValues.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)multiSql, multiValues);
            logger.debug("\u6267\u884c\u591a\u8bed\u8a00\u6210\u529fbatchDecodePrivacyData:" + this.getTaskId() + "#\u6570\u636e" + values.size() + "\u6761");
        }
    }

    private List<Object> splitIds(List<PrivacyDataModel> result) {
        ArrayList<Object> ids = new ArrayList<Object>(result.size());
        for (PrivacyDataModel pdModel : result) {
            ids.add(pdModel.getId());
        }
        return ids;
    }

    private void onlyEncodeClear(List<PrivacyDataModel> list) {
        if (list == null || list.size() <= 0) {
            return;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)list.get(0).getLocaleId())) {
            String sql = "";
            switch (this.getFieldType()) {
                case -9: 
                case 12: {
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= '' where  " + this.getPkName() + "=?";
                    break;
                }
                case 4: {
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                    break;
                }
                case 3: {
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                    break;
                }
                case -5: {
                    sql = "update " + this.getTableName() + " SET " + this.getFieldName() + "= null where  " + this.getPkName() + "=?";
                }
            }
            ArrayList<SqlParameter[]> values = new ArrayList<SqlParameter[]>();
            for (PrivacyDataModel model : list) {
                SqlParameter[] sqlParas;
                if (model.getBizId() instanceof Long) {
                    sqlParas = new SqlParameter[]{new SqlParameter(":" + this.getPkName(), this.getPkTypes(model.getBizId()), model.getBizId())};
                    values.add(sqlParas);
                    continue;
                }
                if (!(model.getBizId() instanceof String)) continue;
                sqlParas = new SqlParameter[]{new SqlParameter(":" + this.getPkName(), 12, model.getBizId())};
                values.add(sqlParas);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, values);
        } else {
            String sql = "update " + this.getTableName() + "_l SET " + this.getFieldName() + "= '' where flocaleid = ? and " + this.getPkName() + "=?";
            ArrayList<SqlParameter[]> values = new ArrayList<SqlParameter[]>();
            for (PrivacyDataModel model : list) {
                SqlParameter[] sqlParas;
                if (model.getBizId() instanceof Long) {
                    sqlParas = new SqlParameter[]{new SqlParameter(":flocaleid", 12, (Object)model.getLocaleId()), new SqlParameter(":" + this.getPkName(), -5, model.getBizId())};
                    values.add(sqlParas);
                    continue;
                }
                if (!(model.getBizId() instanceof String)) continue;
                sqlParas = new SqlParameter[]{new SqlParameter(":flocaleid", 12, (Object)model.getLocaleId()), new SqlParameter(":" + this.getPkName(), 12, model.getBizId())};
                values.add(sqlParas);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, values);
        }
    }

    private void decode(List<PrivacyDataModel> list, String encrypt, Integer version) throws Exception {
        if (list == null || list.size() <= 0) {
            return;
        }
        this.getPdService().decode(list, encrypt, version);
    }

    private void encode(List<PrivacyDataModel> list, String newEncryptType) throws Exception {
        if (list == null || list.size() <= 0) {
            return;
        }
        for (PrivacyDataModel model : list) {
            model.setEncrypt(newEncryptType);
        }
        this.getPdService().encode(list);
    }

    private void batchPrivacyData(List<PrivacyDataModel> dataList, String newEncryptType) {
        if (dataList == null || dataList.size() <= 0) {
            return;
        }
        ArrayList<SqlParameter[]> psList = new ArrayList<SqlParameter[]>(dataList.size());
        ArrayList<Object> rootPkList = new ArrayList<Object>(dataList.size());
        HashSet<Object> rootPkSet = new HashSet<Object>(4);
        String sql = "UPDATE  " + this.getPyTableName() + " SET fdata = ?, fversion = ?, fmodifytime = ?, fencrypt = ?  where fpkid = ?";
        for (PrivacyDataModel pdModel : dataList) {
            SqlParameter[] sqlParas = new SqlParameter[]{new SqlParameter(":fdata", 12, (Object)pdModel.getEncryptValue()), new SqlParameter(":fversion", 4, (Object)pdModel.getVersion()), new SqlParameter(":fmodifytime", 93, (Object)new Date()), new SqlParameter(":fencrypt", 12, (Object)newEncryptType), new SqlParameter(":fpkid", 12, (Object)pdModel.getId())};
            psList.add(sqlParas);
            rootPkList.add(pdModel.getShardingId());
            rootPkSet.add(pdModel.getShardingId());
        }
        if (DB.isSharded((String)this.getShardingMasterTable())) {
            Map pkIndexMap = ShardingHinter.queryShardingIndex((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)this.getShardingMasterTable(), Arrays.asList(rootPkSet.toArray()));
            HashMap<Object, List> indexParamsListMap = new HashMap<Object, List>();
            HashMap<Object, Set> indexPkListMap = new HashMap<Object, Set>();
            int N = rootPkList.size();
            for (int i = 0; i < N; ++i) {
                Object pk = rootPkList.get(i);
                long index = null != pkIndexMap.get(pk) ? (Long)pkIndexMap.get(pk) : -1L;
                Object[] params = (Object[])psList.get(i);
                indexPkListMap.computeIfAbsent(index, k -> new HashSet()).add(pk);
                indexParamsListMap.computeIfAbsent(index, k -> new ArrayList()).add(params);
            }
            for (Map.Entry entry : indexPkListMap.entrySet()) {
                Set pks = (Set)entry.getValue();
                List paramsList = (List)indexParamsListMap.get(entry.getKey());
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)this.getShardingMasterTable(), (HintCondition[])new HintCondition[]{new HintCondition(this.getShardingMasterKey(), FilterType.in_range, Arrays.asList(pks.toArray()))});
                Throwable throwable = null;
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, (List)paramsList);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
        } else {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.getDbRouter()), (String)sql, psList);
        }
    }
}

