/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.privacy.PrivacyDataCenterManager;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.task.BaseTask;
import kd.bos.xdb.mservice.ShardingMetadataService;

public class TaskExecute
implements Runnable {
    private static final Log logger = LogFactory.getLog(TaskExecute.class);
    private BaseTask task;

    public TaskExecute(BaseTask tsk) {
        this.task = tsk;
    }

    public BaseTask getTask() {
        return this.task;
    }

    public void setTask(BaseTask task) {
        this.task = task;
    }

    @Override
    public void run() {
        try {
            if (!RequestContext.get().getAccountId().equalsIgnoreCase(this.task.getAccountId()) || !RequestContext.get().getTenantId().equalsIgnoreCase(this.task.getTenantId())) {
                RequestContextCreator.createBatch((String)this.task.getTenantId(), (String)this.task.getAccountId(), (String)"0");
            }
            ShardingMetadataService.getInstance().syncPrivacyXDBConfig(this.task.getTableName(), this.task.getPyTableName());
            this.task.start();
            logger.info("privacy task start success!taskId:" + this.task.getTaskId() + ",FieldName:" + this.task.getFieldName() + ",TableName:" + this.task.getTableName());
            this.task.check();
            logger.debug("privacy task check success!taskId:" + this.task.getTaskId() + ",FieldName:" + this.task.getFieldName() + ",TableName:" + this.task.getTableName());
            Thread.sleep(1000L);
            try {
                logger.debug("privacy task lockTable success!taskId:" + this.task.getTaskId() + ",FieldName:" + this.task.getFieldName() + ",TableName:" + this.task.getTableName());
                this.task.execute();
                logger.debug("privacy task execute success!taskId:" + this.task.getTaskId() + ",FieldName:" + this.task.getFieldName() + ",TableName:" + this.task.getTableName());
            }
            finally {
                logger.info("privacy task unLockTable success!taskId:" + this.task.getTaskId() + ",FieldName:" + this.task.getFieldName() + ",TableName:" + this.task.getTableName());
            }
            this.task.complete();
            logger.debug("privacy task complete success!taskId:" + this.task.getTaskId() + ",FieldName:" + this.task.getFieldName() + ",TableName:" + this.task.getTableName());
        }
        catch (Throwable e) {
            try {
                logger.error("DispatchTaskService run error :" + this.task.buildErrorInfo(e, true) + "TableName:" + this.task.getTableName() + "FieldName:" + this.task.getFieldName() + "DbRouter:" + this.task.getDbRouter() + "PkName:" + this.task.getPkName() + "OrderBy:" + this.task.getOrderBy() + "taskType:" + this.task.getTaskType() + "taskId:" + this.task.getTaskId());
                this.task.fail(this.task.buildErrorInfo(e, false));
            }
            catch (Throwable throwable) {
                if (TX.inTX()) {
                    TX.addCommitListener((CommitListener)new CommitListener(){

                        public void onEnded(boolean rollbacked) {
                            PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
                        }
                    });
                } else {
                    PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
                }
                throw throwable;
            }
            if (TX.inTX()) {
                TX.addCommitListener((CommitListener)new /* invalid duplicate definition of identical inner class */);
            } else {
                PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
            }
        }
        if (TX.inTX()) {
            TX.addCommitListener((CommitListener)new /* invalid duplicate definition of identical inner class */);
        } else {
            PrivacyDataCenterManager.getEncryptService().clearCache("ISDATAMIGRATING");
        }
    }

    private void lockTable(String tableName) {
        DBShardingRuntime.get().setTableRWAtCurrentNode(false, false, tableName);
        DBShardingRuntime.get().fireLimitTableRW(tableName, false);
    }

    private void unLockTable(String tableName) {
        DBShardingRuntime.get().setTableRWAtCurrentNode(true, true, tableName);
        DBShardingRuntime.get().fireLimitTableRW(tableName, true);
    }
}

