/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.task;

import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.task.TaskExecute;
import kd.bos.threads.ThreadPools;

public class WatchTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(WatchTask.class);
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static final WatchTask wt = new WatchTask();
    public static AtomicInteger watchThread = new AtomicInteger(0);

    public static void pushTask(TaskExecute task) {
        if (task != null && task.getTask() != null) {
            task.getTask().setAccountId(RequestContext.get().getAccountId());
            task.getTask().setTenantId(RequestContext.get().getTenantId());
            try {
                queue.put(task);
            }
            catch (InterruptedException e) {
                logger.error("queue put task error " + e.getMessage());
            }
            logger.debug("taskId:" + task.getTask().getTaskId() + " pushTask");
        }
    }

    public static void executeTask() {
        if (watchThread.get() <= 0) {
            ThreadPools.executeOnce((String)("privacy_watch" + UUID.randomUUID()), (Runnable)wt);
            watchThread.incrementAndGet();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Object obj;
                    TaskExecute te;
                    if ((te = (TaskExecute)(obj = queue.take())) == null || te.getTask() == null) {
                        continue;
                    }
                    ((TaskExecute)obj).run();
                }
            }
            catch (Exception e) {
                logger.error("watch task run error " + e.getMessage());
                continue;
            }
            break;
        }
    }

    public static int getTaskSize() {
        return queue.size();
    }
}

