/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.privacy.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.privacy.model.PrivacyDataModel;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.privacy.utils.PrivacyDataTools;
import kd.bos.util.StringUtils;

public class PrivacyDBUtils {
    private static final String SQL_INSERT = "insert into %s (fpkid,fbizid,flocaleid,fdata,fhash,ffield,fversion,ffieldtype,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fencrypt) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_INSERT_SHARDING = "insert into %s (fpkid,fbizid,flocaleid,fdata,fhash,ffield,fversion,ffieldtype,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fencrypt,fshardingid) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String SQL_UPDATE = "update %s set fencrypt = ?,fdata = ?,fhash = ?, fmodifierid = ?, fmodifytime = ? where fbizid = ? and ffield = ? and fversion = ?";
    private static final String SQL_DELETE = "delete from %s where fbizid = ? and fversion = ?";
    private static final String SQL_DELETE_MUL = "delete from %s where fbizid = ? and fversion = ? and flocaleid = ?";

    public static void insert(DBRoute dbRoute, String tableName, List<PrivacyDataModel> datas, boolean isMultilanguage) {
        if (StringUtils.isEmpty((String)tableName) || datas == null || datas.isEmpty()) {
            return;
        }
        int version = PrivacyDBUtils.getRunTimeVersion();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(16);
        if (DB.isSharded((String)tableName)) {
            for (PrivacyDataModel data : datas) {
                SqlParameter[] params = new SqlParameter[14];
                String fpkId = DB.genStringId((String)tableName);
                params[0] = new SqlParameter(":fpkid", 12, (Object)fpkId);
                params[1] = new SqlParameter(":fbizid", PrivacyDBUtils.getBizIdType(data.getBizId()), data.getBizId());
                params[2] = new SqlParameter(":flocaleid", 12, (Object)data.getLocaleId());
                params[3] = new SqlParameter(":fdata", 2005, (Object)data.getEncryptValue());
                params[4] = new SqlParameter(":fhash", 2005, (Object)data.getHash());
                params[5] = new SqlParameter(":ffield", 12, (Object)data.getFieldName());
                params[6] = new SqlParameter(":fversion", 4, (Object)version);
                params[7] = new SqlParameter(":ffieldtype", 4, (Object)data.getFieldType());
                params[8] = new SqlParameter(":fcreatorid", -5, (Object)userId);
                params[9] = new SqlParameter(":fcreatetime", 93, (Object)timestamp);
                params[10] = new SqlParameter(":fmodifierid", -5, (Object)userId);
                params[11] = new SqlParameter(":fmodifytime", 93, (Object)timestamp);
                params[12] = new SqlParameter(":fencrypt", 12, (Object)data.getEncrypt());
                params[13] = new SqlParameter(":fshardingid", 12, data.getShardingId());
                paramList.add(params);
            }
            String sql = String.format(SQL_INSERT_SHARDING, PrivacyDataTools.getPrivacyDataTableName(tableName));
            DB.executeBatch((DBRoute)dbRoute, (String)sql, paramList);
        } else {
            for (PrivacyDataModel data : datas) {
                SqlParameter[] params = new SqlParameter[13];
                String fpkId = DB.genStringId((String)tableName);
                params[0] = new SqlParameter(":fpkid", 12, (Object)fpkId);
                params[1] = new SqlParameter(":fbizid", PrivacyDBUtils.getBizIdType(data.getBizId()), data.getBizId());
                params[2] = new SqlParameter(":flocaleid", 12, (Object)data.getLocaleId());
                params[3] = new SqlParameter(":fdata", 2005, (Object)data.getEncryptValue());
                params[4] = new SqlParameter(":fhash", 2005, (Object)data.getHash());
                params[5] = new SqlParameter(":ffield", 12, (Object)data.getFieldName());
                params[6] = new SqlParameter(":fversion", 4, (Object)version);
                params[7] = new SqlParameter(":ffieldtype", 4, (Object)data.getFieldType());
                params[8] = new SqlParameter(":fcreatorid", -5, (Object)userId);
                params[9] = new SqlParameter(":fcreatetime", 93, (Object)timestamp);
                params[10] = new SqlParameter(":fmodifierid", -5, (Object)userId);
                params[11] = new SqlParameter(":fmodifytime", 93, (Object)timestamp);
                params[12] = new SqlParameter(":fencrypt", 12, (Object)data.getEncrypt());
                paramList.add(params);
            }
            String sql = String.format(SQL_INSERT, PrivacyDataTools.getPrivacyDataTableName(tableName));
            DB.executeBatch((DBRoute)dbRoute, (String)sql, paramList);
        }
    }

    public static void update(DBRoute dbRoute, String tableName, List<PrivacyDataModel> datas, boolean isMultilanguage) {
        if (StringUtils.isEmpty((String)tableName) || datas == null || datas.isEmpty()) {
            return;
        }
        int version = PrivacyDBUtils.getRunTimeVersion();
        StringBuilder existSql = new StringBuilder("select  fbizid,  ffield, fversion,flocaleid from %s where fversion = ? and fbizid in ( ");
        StringBuilder ffieldSql = new StringBuilder(" and ffield in ( ");
        LinkedHashMap<String, PrivacyDataModel> allMap = new LinkedHashMap<String, PrivacyDataModel>(datas.size());
        ArrayList<Integer> param = new ArrayList<Integer>(16);
        param.add(version);
        ArrayList<Object> idParam = new ArrayList<Object>(16);
        ArrayList<String> ffieldSqlParam = new ArrayList<String>(16);
        for (PrivacyDataModel data : datas) {
            existSql.append("?,");
            ffieldSql.append("?,");
            idParam.add(data.getBizId());
            ffieldSqlParam.add(data.getFieldName());
            StringBuilder key = new StringBuilder(String.valueOf(data.getBizId())).append(data.getFieldName()).append(version);
            if (isMultilanguage) {
                key.append(data.getLocaleId());
            }
            allMap.put(key.toString(), data);
        }
        existSql.setLength(existSql.length() - 1);
        existSql.append(")");
        ffieldSql.setLength(ffieldSql.length() - 1);
        ffieldSql.append(")");
        String sql = String.format(existSql.toString(), PrivacyDataTools.getPrivacyDataTableName(tableName)) + ffieldSql;
        param.addAll(idParam);
        param.addAll(ffieldSqlParam);
        Set exitSet = (Set)DB.query((DBRoute)dbRoute, (String)sql, (Object[])param.toArray(), rs -> {
            HashSet<String> set = new HashSet<String>(datas.size());
            while (rs.next()) {
                Object fbizid = rs.getObject("fbizid");
                String ffield = rs.getString("ffield");
                int fversion = rs.getInt("fversion");
                StringBuilder key = new StringBuilder(String.valueOf(fbizid)).append(ffield).append(fversion);
                if (isMultilanguage) {
                    key.append(rs.getString("flocaleid"));
                }
                if (!allMap.containsKey(key.toString())) continue;
                set.add(key.toString());
            }
            return set;
        });
        ArrayList<PrivacyDataModel> updateDatas = new ArrayList<PrivacyDataModel>(datas.size());
        ArrayList<PrivacyDataModel> insertDatas = new ArrayList<PrivacyDataModel>(datas.size());
        for (Map.Entry entry : allMap.entrySet()) {
            if (exitSet.contains(entry.getKey())) {
                updateDatas.add((PrivacyDataModel)entry.getValue());
                continue;
            }
            insertDatas.add((PrivacyDataModel)entry.getValue());
        }
        if (!updateDatas.isEmpty()) {
            PrivacyDBUtils._update(dbRoute, tableName, updateDatas, isMultilanguage);
        }
        if (!insertDatas.isEmpty()) {
            PrivacyDBUtils.insert(dbRoute, tableName, insertDatas, isMultilanguage);
        }
    }

    private static void _update(DBRoute dbRoute, String tableName, List<PrivacyDataModel> datas, boolean isMultilanguage) {
        int version = PrivacyDBUtils.getRunTimeVersion();
        Timestamp modifytime = new Timestamp(System.currentTimeMillis());
        long modifierid = RequestContext.get().getCurrUserId();
        String sql = SQL_UPDATE;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (PrivacyDataModel data : datas) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(16);
            params.add(new SqlParameter(":fencrypt", 12, (Object)data.getEncrypt()));
            params.add(new SqlParameter(":fdata", 2005, (Object)data.getEncryptValue()));
            params.add(new SqlParameter(":fhash", 2005, (Object)data.getHash()));
            params.add(new SqlParameter(":fmodifierid", -5, (Object)modifierid));
            params.add(new SqlParameter(":fmodifytime", 93, (Object)modifytime));
            params.add(new SqlParameter(":fbizid", PrivacyDBUtils.getBizIdType(data.getBizId()), data.getBizId()));
            params.add(new SqlParameter(":ffield", 12, (Object)data.getFieldName()));
            params.add(new SqlParameter(":fversion", 4, (Object)version));
            if (isMultilanguage) {
                params.add(new SqlParameter(":flocaleid", 12, (Object)data.getLocaleId()));
            }
            paramList.add(params.toArray());
        }
        if (isMultilanguage) {
            sql = sql + "and flocaleid = ? ";
        }
        String pyTable = PrivacyDataTools.getPrivacyDataTableName(tableName);
        String ksql = String.format(sql, pyTable);
        DB.executeBatch((DBRoute)dbRoute, (String)ksql, paramList);
    }

    public static void delete(DBRoute dbRoute, String tableName, List<PrivacyDataModel> datas) {
        PrivacyDBUtils.delete(dbRoute, tableName, datas, false);
    }

    public static void delete(DBRoute dbRoute, String tableName, List<PrivacyDataModel> datas, boolean isMultilanguage) {
        if (StringUtils.isEmpty((String)tableName) || datas == null || datas.isEmpty()) {
            return;
        }
        int version = PrivacyDBUtils.getRunTimeVersion();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (PrivacyDataModel data : datas) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(6);
            params.add(new SqlParameter(":fbizid", PrivacyDBUtils.getBizIdType(data.getBizId()), data.getBizId()));
            params.add(new SqlParameter(":fversion", 4, (Object)version));
            if (isMultilanguage) {
                params.add(new SqlParameter(":flocaleid", 12, (Object)data.getLocaleId()));
            }
            paramList.add(params.toArray());
        }
        String sqlStr = isMultilanguage ? SQL_DELETE_MUL : SQL_DELETE;
        String sql = String.format(sqlStr, PrivacyDataTools.getPrivacyDataTableName(tableName));
        DB.executeBatch((DBRoute)dbRoute, (String)sql, paramList);
    }

    public static List<kd.bos.db.SqlParameter> getPKs(Object[] oids, int dbtype) {
        ArrayList<kd.bos.db.SqlParameter> sps = new ArrayList<kd.bos.db.SqlParameter>(oids.length);
        if (oids.length > 0) {
            for (int i = 0; i < oids.length; ++i) {
                sps.add(new kd.bos.db.SqlParameter(dbtype, oids[i] instanceof DynamicObject ? ((DynamicObject)oids[i]).getPkValue() : oids[i]));
            }
        } else {
            sps.add(new kd.bos.db.SqlParameter(dbtype, dbtype == 12 || dbtype == -9 || dbtype == -15 ? "" : Integer.valueOf(0)));
        }
        return sps;
    }

    private static int getBizIdType(Object bizId) {
        int bizIdType = bizId instanceof Long ? -5 : 12;
        return bizIdType;
    }

    private static int getRunTimeVersion() {
        return 1;
    }

    public static void createDefaultTable() {
        try (TXHandle h = TX.requiresNew();){
            String sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_privacy_scheme_encrypt')\nCREATE TABLE t_privacy_scheme_encrypt\n(\n    fid bigint NOT NULL,\n    fentryid bigint NOT NULL,\n    fseq integer NOT NULL DEFAULT 0,\n    fencrypt_field_ident VARCHAR(50) ,\n    fencrypt_field_type VARCHAR(50) ,\n    fencrypt_cloud_number VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fencrypt_field_name VARCHAR(50) ,\n    fencrypt_algorithm VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fencrypt_entity_number VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fencrypt_app_number VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fversion bigint,\n    fencrypt_table_name VARCHAR(50) ,\n    fencrypt_field_desc VARCHAR(60) ,\n    fencrypt_entity_name VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fencrypt_app_name VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fencrypt_cloud_name VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n\tfencrypt_status VARCHAR(50)  DEFAULT ' ' NOT NULL,\n\tfapp_route VARCHAR(50)  DEFAULT ' ' NOT NULL,\n\tflabelid bigint NOT NULL,\n    CONSTRAINT pk_privacy_scheme_encrypt PRIMARY KEY (fentryid)\n);";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql);
            sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_privacy_task')\nCREATE TABLE t_privacy_task\n(\n    fid bigint NOT NULL,\n    ftask_type VARCHAR(100) ,\n    fstart_date datetime,\n    fend_date datetime,\n    fcreate_date datetime,\n    fversion integer,\n    fupgrade integer,\n    ftask_status VARCHAR(50)  DEFAULT ' '  NOT NULL ,\n    fcreate_by bigint,\n    ffield_name VARCHAR(50)  DEFAULT ' '  NOT NULL ,\n    ftable_name VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fpytable_name VARCHAR(50)  DEFAULT ' '  NOT NULL ,\n    ffield_type VARCHAR(50)  DEFAULT ' ',\n    forderby VARCHAR(50)  DEFAULT ' ',\n    fpkname VARCHAR(50)  DEFAULT ' ',\n    foldEncrypt VARCHAR(50) ,\n\tfpkvalue VARCHAR(255) ,\n\tforderby_value  VARCHAR(255),\n    ferrorlogs VARCHAR(2000) DEFAULT ' ',\n    fschemeid bigint,\n    fentity_number VARCHAR(50) DEFAULT ' ',\n    fislocale VARCHAR(50)  DEFAULT ' ',\n    fdbrouter VARCHAR(50) DEFAULT ' ',\n    foldencrypt_type VARCHAR(50) DEFAULT ' ',\n    fpktype integer,\n    fiscommonlang VARCHAR(50) DEFAULT ' '  NOT NULL,\n    CONSTRAINT t_privacy_task_pkey PRIMARY KEY (fid)\n);";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql);
            sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 't_privacy_scheme_desen')\nCREATE TABLE t_privacy_scheme_desen\n(\n    fid bigint NOT NULL,\n    fentryid bigint NOT NULL,\n    fseq integer NOT NULL DEFAULT 0,\n    fdense_field_ident VARCHAR(50),\n    fdense_field_name VARCHAR(50),\n    fdense_field_type VARCHAR(50),\n    fdesensitize_rule VARCHAR(50)    DEFAULT ' ' NOT NULL,\n    fdense_entity_number VARCHAR(50)  DEFAULT ' ' NOT NULL ,\n    fdense_app_number VARCHAR(50)   DEFAULT ' ' NOT NULL,\n    fdense_cloud_number VARCHAR(50)   DEFAULT ' ' NOT NULL,\n    fdense_field_locale VARCHAR(50)   DEFAULT ' ' NOT NULL ,\n    fdesensitize_type VARCHAR(50)   DEFAULT ' ' NOT NULL,\n    fplugin VARCHAR(50)    DEFAULT ' ' NOT NULL ,\n    fdense_table_name VARCHAR(50) DEFAULT ' '  NOT NULL ,\n    fdense_field_desc VARCHAR(60)  DEFAULT ' ' NOT NULL ,\n    fdense_entity_name VARCHAR(50)   DEFAULT ' ' NOT NULL,\n    fdense_app_name VARCHAR(50)   DEFAULT ' ' NOT NULL ,\n    fdense_cloud_name VARCHAR(50)    DEFAULT ' ' NOT NULL,\n\tfdesensitiz_status  VARCHAR(50)    DEFAULT ' ' NOT NULL,\n\tfdensefieldlocale VARCHAR(50)    DEFAULT ' ',\n\tflabelid bigint NOT NULL,\n    CONSTRAINT pk_privacy_scheme_desen PRIMARY KEY (fentryid)\n);";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql);
        }
    }
}

