/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.event;

import com.alibaba.fastjson.JSON;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.service.ServiceFactory;

public abstract class AbstractOrgChangeEventServicePlugin
implements IEventServicePlugin {
    protected static final Log logger = LogFactory.getLog(AbstractOrgChangeEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("AbstractOrgChangeEventServicePlugin#handleEvent start. variables is {}", (Object)evt.getVariables());
        OrgChangeCheckReport orgChangeCheckReport = this.handleEventAndReturnCheckReport(evt);
        logger.info("AbstractOrgChangeEventServicePlugin#handleEvent orgChangeCheckReport is {}", (Object)JSON.toJSONString((Object)orgChangeCheckReport));
        OrgApiResult orgApiResult = this.saveOrgChangeReport(orgChangeCheckReport, evt);
        logger.info(String.format("AbstractOrgChangeEventServicePlugin#handleEvent success status:%s Msg:%s", orgApiResult.isSuccess(), orgApiResult.getErrorMsg()));
        return evt.getEventId();
    }

    public OrgApiResult saveOrgChangeReport(OrgChangeCheckReport report, KDBizEvent event) {
        OrgApiResult orgApiResult = new OrgApiResult();
        if (report == null) {
            orgApiResult.setSuccess(true);
            return orgApiResult;
        }
        if (report.getChangeRecordId() == null || report.getEventId() == null) {
            orgApiResult.setSuccess(false);
            orgApiResult.setErrorMsg("ChangeRecordId is null or EventId is null");
            return orgApiResult;
        }
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        return orgService.saveOrgChangeCheckReport(report);
    }

    protected abstract OrgChangeCheckReport handleEventAndReturnCheckReport(KDBizEvent var1);
}

