/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.HZPinyin;
import kd.bos.util.JSONUtils;

public class Utils {
    public static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";

    public static Date strToDate(String strDate, String format) {
        if (StringUtils.isBlank((CharSequence)strDate) || StringUtils.isBlank((CharSequence)format)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String formatDate(Date date, String format) {
        if (date == null || StringUtils.isBlank((CharSequence)format)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD);
        return formatter.format(date);
    }

    public static boolean isListEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static boolean isListNotEmpty(List list) {
        return !Utils.isListEmpty(list);
    }

    public static Object nullToEmpty(Object srcObj) {
        if (srcObj == null) {
            return "";
        }
        return srcObj;
    }

    public static Object nullToZero(Object srcObj) {
        if (srcObj == null) {
            return "0";
        }
        return srcObj;
    }

    public static String nullDataToEmptyList(String sHttpResponse) throws IOException {
        if (StringUtils.isBlank((CharSequence)sHttpResponse)) {
            return sHttpResponse;
        }
        Map resMap = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class, (boolean)true);
        if (resMap != null && StringUtils.isBlank(resMap.get("data"))) {
            resMap.put("data", new ArrayList());
            return JSONUtils.toString((Object)resMap);
        }
        return sHttpResponse;
    }

    public static boolean isNumber(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static boolean isNotNumber(String str) {
        return !Utils.isNumber(str);
    }

    public static boolean isValidDate(String dateStr, String dateFormat) {
        return Utils.strToDate(dateStr, dateFormat) != null;
    }

    public static Date getDate(int addDays) {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(5, addDays);
        return c.getTime();
    }

    public static Date addDay(Date date, int addDays) {
        if (date == null) {
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, addDays);
        return cal.getTime();
    }

    public static Date getEndDate() {
        Calendar c = Calendar.getInstance();
        c.set(1, 2999);
        c.set(2, 11);
        c.set(5, 31);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static int countInnerStr(String str, String patternStr) {
        int count = 0;
        if (StringUtils.isBlank((CharSequence)str) || StringUtils.isBlank((CharSequence)patternStr)) {
            return count;
        }
        Pattern r = Pattern.compile(patternStr);
        Matcher m = r.matcher(str);
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static String transNumberToString(Object obj) {
        if (StringUtils.isBlank((Object)obj)) {
            return "";
        }
        try {
            BigDecimal bd = new BigDecimal(obj.toString());
            return String.valueOf(bd.intValue());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void transUserNamePinyin(Map<String, Object> data) {
        Object nameObj = data.get("name");
        if (StringUtils.isBlank((Object)nameObj)) {
            return;
        }
        String name = nameObj.toString();
        try {
            String simplePinyin;
            String fullPinyin = HZPinyin.getFullSpell((String)name, (String)"");
            if (fullPinyin != null && fullPinyin.length() <= 100) {
                data.put("fullpinyin", fullPinyin);
                if (StringUtils.isBlank((Object)data.get("username"))) {
                    data.put("username", fullPinyin);
                }
            }
            if ((simplePinyin = HZPinyin.getFirstSpell((String)name)) != null && simplePinyin.length() <= 50) {
                data.put("simplepinyin", simplePinyin);
            }
        }
        catch (UnsupportedEncodingException e) {
            data.put("name", nameObj);
        }
    }

    public static boolean isContainChinese(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(str);
        return m.find();
    }
}

