/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.IBasedataController;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.DynamicScriptPlugin;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.FormConfig;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.util.SimpleScriptInfo;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.kingscript.host.ScriptProxyFactory;

@SdkPublic
public class BasedataHelper {
    private static final String ENVSCRIPTS = "/FormPlugin.js";
    private static String envScript;
    private static ScriptExecutor scriptExecutor;
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String SCRIPTTYPE = "scripttype";

    public static List<IBasedataController> createPlugin(List<Plugin> plugins) {
        ArrayList<IBasedataController> formPlugins = new ArrayList<IBasedataController>();
        if (plugins != null) {
            for (Plugin ins : plugins) {
                IBasedataController splugin;
                if (0 == ins.getType()) {
                    formPlugins.add((IBasedataController)TypesContainer.createInstance((String)ins.getClassName()));
                    continue;
                }
                if (1 == ins.getType()) {
                    try {
                        splugin = null;
                        if (ins instanceof DynamicScriptPlugin) {
                            DynamicScriptPlugin scriptIns = (DynamicScriptPlugin)ins;
                            splugin = BasedataHelper.createScriptPlugin(scriptIns.getScriptNumber(), scriptIns.getScript());
                        } else {
                            splugin = BasedataHelper.createScriptPlugin(ins.getClassName());
                        }
                        if (splugin == null) continue;
                        formPlugins.add(splugin);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (4 != ins.getType() || !Plugin.enableRunKingScript()) continue;
                try {
                    splugin = (IBasedataController)ScriptProxyFactory.createPluginProxy((String)ins.getClassName(), scriptPath -> ProjectInitializerManager.getEngineAutoDebug(scriptPath));
                    if (splugin == null) continue;
                    formPlugins.add(splugin);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return formPlugins;
    }

    private static synchronized IBasedataController createScriptPlugin(String classname) {
        if (StringUtils.isBlank((CharSequence)classname)) {
            return null;
        }
        Map<String, String> scritpInfo = BasedataHelper.getScriptInfo(classname);
        if (scritpInfo == null) {
            return null;
        }
        String scriptContent = scritpInfo.get("scriptcontext");
        String scriptNumber = scritpInfo.get(SCRIPTNUMBER);
        String scriptType = scritpInfo.get(SCRIPTTYPE);
        BasedataHelper.getjs();
        if (scriptExecutor == null) {
            scriptExecutor = ScriptExecutor.getOrCreate();
            scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            scriptExecutor.begin();
        }
        if ("6".equals(scriptType)) {
            scriptExecutor.exec(new String[]{scriptContent});
            return null;
        }
        scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo(ENVSCRIPTS, envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
        return (IBasedataController)scriptExecutor.getContext().get("plugin");
    }

    private static synchronized IBasedataController createScriptPlugin(String classname, String scriptContent) {
        if (StringUtils.isBlank((CharSequence)classname)) {
            return null;
        }
        Map<String, String> scritpInfo = BasedataHelper.getScriptInfo(classname);
        if (scritpInfo == null) {
            return null;
        }
        String scriptNumber = scritpInfo.get(SCRIPTNUMBER);
        String scriptType = scritpInfo.get(SCRIPTTYPE);
        BasedataHelper.getjs();
        if (scriptExecutor == null) {
            scriptExecutor = ScriptExecutor.getOrCreate();
            scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            scriptExecutor.begin();
        }
        if ("6".equals(scriptType)) {
            scriptExecutor.exec(new String[]{scriptContent});
            return null;
        }
        scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo(ENVSCRIPTS, envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
        return (IBasedataController)scriptExecutor.getContext().get("plugin");
    }

    private static Map<String, String> getScriptInfo(String classname) {
        HashMap<String, String> map;
        block15: {
            map = new HashMap<String, String>();
            String sql = "select fscriptnumber,fscriptcontext_tag,fscripttype from t_meta_pluginscript where fclassname = ?";
            Object[] params = new Object[]{classname};
            try (DataSet ds = DB.queryDataSet((String)"FormConfig.t_meta_pluginscript.getScriptInfo", (DBRoute)DBRoute.meta, (String)sql, (Object[])params);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    map.put(SCRIPTNUMBER, row.getString("fscriptnumber"));
                    map.put(SCRIPTTYPE, row.getString("fscripttype"));
                    map.put("scriptcontext", row.getString("fscriptcontext_tag"));
                    break block15;
                }
                Map<String, String> map2 = null;
                return map2;
            }
        }
        return map;
    }

    private static void getjs() {
        try (InputStream in = FormConfig.class.getResourceAsStream(ENVSCRIPTS);){
            envScript = BasedataHelper.getContent(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getContent(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        in.close();
        return sb.toString();
    }
}

