/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.decode;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.IDecodeHandler;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.ProFormDesigner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.utils.KDEncodeUtil;

public class Base64DecodeHandler
implements IDecodeHandler {
    private static Log logger = LogFactory.getLog(Base64DecodeHandler.class);
    private static final String ENCODE_HEADER = "kdbase64:";

    @Override
    public void decode(Map<String, Object> value, FormDesigner control) {
        Map formmeta = (Map)value.get("formmeta");
        Map entitymeta = (Map)value.get("entitymeta");
        Map listmeta = (Map)value.get("listmeta");
        if (formmeta != null) {
            if (control instanceof ProFormDesigner) {
                entitymeta = (Map)formmeta.get("entitymeta");
                formmeta = (Map)formmeta.get("formmeta");
            }
            this.toDecode(formmeta);
        }
        if (entitymeta != null) {
            this.toDecode(entitymeta);
        }
        if (listmeta != null) {
            if (control instanceof ProFormDesigner) {
                listmeta = (Map)listmeta.get("formmeta");
            }
            this.toDecode(listmeta);
        }
    }

    @Override
    public String decode(String value) {
        return KDEncodeUtil.kdDecoding((String)value);
    }

    @Override
    public void decode(Map<String, Object> value) {
        Map entitymeta = (Map)value.get("entitymeta");
        this.toDecode(entitymeta);
    }

    private void toDecode(Map<String, Object> metaData) {
        if (metaData == null) {
            return;
        }
        List metaList = (List)metaData.get("Items");
        if (CollectionUtils.isEmpty((Collection)metaList)) {
            return;
        }
        for (Map map : metaList) {
            Object filter;
            Object mustInputCondition;
            Object operations;
            Object clientRules;
            if (map == null) continue;
            Object rules = map.get("Rules");
            if (rules instanceof String) {
                String decodeStr = this.decodeContent(rules.toString());
                List ruleList = (List)SerializationUtils.fromJsonString((String)decodeStr, List.class);
                map.put("Rules", ruleList);
            }
            if ((clientRules = map.get("ClientRules")) instanceof String) {
                String decodeStr = this.decodeContent(clientRules.toString());
                List ruleList = (List)SerializationUtils.fromJsonString((String)decodeStr, List.class);
                map.put("ClientRules", ruleList);
            }
            if ((operations = map.get("Operations")) instanceof String) {
                String decodeStr = this.decodeContent(operations.toString());
                List operationList = (List)SerializationUtils.fromJsonString((String)decodeStr, List.class);
                map.put("Operations", operationList);
            }
            if ((mustInputCondition = map.get("MustInputCondition")) instanceof String) {
                String decodeStr = this.decodeContent(mustInputCondition.toString());
                Map mustInputConditionMap = (Map)SerializationUtils.fromJsonString((String)decodeStr, Map.class);
                map.put("MustInputCondition", mustInputConditionMap);
            }
            if ((filter = map.get("Filter")) instanceof String) {
                String decodeStr = this.decodeContent(filter.toString());
                Map filterMap = (Map)SerializationUtils.fromJsonString((String)decodeStr, Map.class);
                map.put("Filter", filterMap);
            }
            Map mobListMeta = (Map)map.get("MobListMeta");
            this.toDecode(mobListMeta);
            Map mobMeta = (Map)map.get("MobMeta");
            this.toDecode(mobMeta);
            Map listMeta = (Map)map.get("ListMeta");
            this.toDecode(listMeta);
        }
    }

    private String decodeContent(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return content;
        }
        return KDEncodeUtil.kdDecoding((String)content);
    }
}

