/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter.helper;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.ICustomController;
import kd.bos.filter.helper.QueryLookUpdataParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.orm.query.fulltext.ESAdapter;
import kd.bos.param.ParameterReader;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public final class BaseDataSearchHelper {
    private static final Log log = LogFactory.getLog(BaseDataSearchHelper.class);
    public static final String BOS_FORM_METADATA = "bos-form-metadata";
    private QueryLookUpdataParameter queryLookUpdataParameter;

    public BaseDataSearchHelper(QueryLookUpdataParameter queryLookUpdataParameter) {
        this.queryLookUpdataParameter = queryLookUpdataParameter;
    }

    private boolean isQuickSearch() {
        String qsEnable = System.getProperty("quicksearch.enable");
        return "true".equals(qsEnable);
    }

    private boolean isEsStorage() {
        String qsStorage = System.getProperty("quicksearch.storage", "elasticsearch");
        return "elasticsearch".equals(qsStorage);
    }

    public static QFilter getSearchFilter(String searchKey, List<String> searchFields, String entityName) {
        QFilter searchQFilter = null;
        if (StringUtils.isNotBlank((CharSequence)searchKey) && !searchFields.isEmpty()) {
            Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)entityName);
            String searchtype = "1";
            if (pubSysParam != null) {
                searchtype = (String)pubSysParam.get("searchtype");
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            ArrayList<String> encryptFields = new ArrayList<String>(6);
            searchFields = new ArrayList<String>(searchFields);
            Iterator<String> iterator = searchFields.iterator();
            while (iterator.hasNext()) {
                String searchField = iterator.next();
                IDataEntityProperty prop = entityType.findProperty(searchField);
                boolean isEncrypt = PrivacyCenterUtils.isEncryptField((IDataEntityProperty)prop);
                if (isEncrypt) {
                    iterator.remove();
                    encryptFields.add(searchField);
                    continue;
                }
                if (!PrivacyCenterUtils.isDesenAndNoSearch((IDataEntityProperty)prop)) continue;
                log.info("\u8131\u654f\u5b57\u6bb5\u652f\u6301\u67e5\u8be2\u672a\u5f00\u542f\u6216\u8131\u654f\u7b56\u7565\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u56e0\u6b64\u5c4f\u853d\u8be5\u8131\u654f\u5b57\u6bb5\u3002searchField\uff1a{}", (Object)searchField);
                iterator.remove();
            }
            if (!searchFields.isEmpty()) {
                searchQFilter = QFilter.ftlike((boolean)"2".equals(searchtype), (String)searchKey, (String[])searchFields.toArray(new String[0]));
            }
            for (String encryptField : encryptFields) {
                if (searchQFilter == null) {
                    searchQFilter = new QFilter(encryptField, "=", (Object)searchKey);
                    continue;
                }
                searchQFilter.or(new QFilter(encryptField, "=", (Object)searchKey));
            }
        }
        return searchQFilter;
    }

    public static Map<String, Integer> getFieldsIndexMap(BasedataEntityType basedataEntityType, List<String> showFields) {
        HashMap<String, Integer> fieldsIndexMap = new HashMap<String, Integer>();
        for (String showField : showFields) {
            if (showField.equals(basedataEntityType.getPrimaryKey().getName())) {
                fieldsIndexMap.put(showField, 0);
                continue;
            }
            if (showField.equals(basedataEntityType.getNumberProperty())) {
                fieldsIndexMap.put(showField, 1);
                continue;
            }
            if (!showField.equals(basedataEntityType.getNameProperty())) continue;
            fieldsIndexMap.put(showField, 2);
        }
        return fieldsIndexMap;
    }

    public static FuzzySearch loadLookUpSetting(BasedataEntityType refBDType) {
        FuzzySearch setting = null;
        BillParam billParam = ParameterHelper.getBillParam((String)refBDType.getName());
        if (billParam.getFuzzySearch() != null) {
            if (StringUtils.isNotBlank((CharSequence)refBDType.getMasteridPropName()) && refBDType.getMasteridType() == 2) {
                IDataEntityProperty masteridProp = refBDType.findProperty(refBDType.getMasteridPropName());
                if (masteridProp instanceof MasterBasedataProp) {
                    setting = BaseDataSearchHelper.buildDefLookUpSetting(refBDType);
                    for (ShowColumn column : billParam.getFuzzySearch().getComboListFields()) {
                        if ("name".equals(column.getId()) || "number".equals(column.getId())) continue;
                        if ("id".equals(column.getId())) {
                            ParameterHelper.addItem((FuzzySearch)setting, (String)refBDType.getPrimaryKey().getName(), (String)"ID", (float)0.0f, (int)-1, (int)0, (boolean)column.isVisible());
                            continue;
                        }
                        ParameterHelper.addItem((FuzzySearch)setting, (String)column.getId(), (String)column.getCaption(), (float)column.getWidth(), (boolean)column.isVisible());
                    }
                }
            } else {
                setting = billParam.getFuzzySearch();
            }
        } else {
            setting = BaseDataSearchHelper.buildDefLookUpSetting(refBDType);
        }
        ParameterHelper.addItem((FuzzySearch)setting, (String)refBDType.getPrimaryKey().getName(), (String)"ID", (float)0.0f, (int)-1, (int)0, (boolean)false);
        return setting;
    }

    public static void setComboFieldCaption(BasedataEntityType refBDType, FuzzySearch setting) {
        if (refBDType == null || setting == null) {
            return;
        }
        for (ShowColumn column : setting.getComboListFields()) {
            IDataEntityProperty masteridProp;
            String[] fields;
            String fieldId = column.getId();
            if ("id".equals(fieldId)) continue;
            IDataEntityProperty prop = null;
            if (StringUtils.isNotBlank((CharSequence)fieldId) && (fields = fieldId.split("\\.")).length == 2 && refBDType.getProperty(fields[0]) instanceof EntryProp) {
                prop = refBDType.findProperty(fields[1]);
            }
            if (prop == null) {
                prop = refBDType.findProperty(fieldId);
            }
            if (StringUtils.isNotBlank((CharSequence)refBDType.getMasteridPropName()) && refBDType.getMasteridType() == 2 && (masteridProp = refBDType.findProperty(refBDType.getMasteridPropName())) instanceof MasterBasedataProp) {
                RefEntityType refDBType2 = (RefEntityType)((MasterBasedataProp)masteridProp).getComplexType();
                String number = String.format("%s.%s", refBDType.getMasteridPropName(), refDBType2.getNumberProperty());
                String name = String.format("%s.%s", refBDType.getMasteridPropName(), refDBType2.getNameProperty());
                if (fieldId.equals(number)) {
                    prop = refDBType2.getProperty(refDBType2.getNumberProperty());
                }
                if (fieldId.equals(name)) {
                    prop = refDBType2.getProperty(refDBType2.getNameProperty());
                }
            }
            if (prop == null) continue;
            column.setCaption(prop.getDisplayName().toString());
        }
    }

    private static FuzzySearch buildDefLookUpSetting(BasedataEntityType refBDType) {
        FuzzySearch setting = new FuzzySearch();
        String number = refBDType.getNumberProperty();
        String name = refBDType.getNameProperty();
        if (StringUtils.isNotBlank((CharSequence)refBDType.getMasteridPropName()) && refBDType.getMasteridType() == 2) {
            IDataEntityProperty masteridProp = refBDType.findProperty(refBDType.getMasteridPropName());
            number = refBDType.getNumberProperty();
            name = refBDType.getNameProperty();
            if (masteridProp instanceof MasterBasedataProp) {
                RefEntityType refDBType2 = (RefEntityType)((MasterBasedataProp)masteridProp).getComplexType();
                if (StringUtils.isNotBlank((CharSequence)refDBType2.getNumberProperty())) {
                    number = String.format("%s.%s", refBDType.getMasteridPropName(), refDBType2.getNumberProperty());
                }
                if (StringUtils.isNotBlank((CharSequence)refDBType2.getNameProperty())) {
                    name = String.format("%s.%s", refBDType.getMasteridPropName(), refDBType2.getNameProperty());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)number)) {
                ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)ResManager.loadKDString((String)"\u7f16\u7801", (String)"BizBasedataEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), (float)156.0f, (boolean)true);
            }
            if (StringUtils.isNotBlank((CharSequence)name) && !StringUtils.equals((CharSequence)number, (CharSequence)name)) {
                ParameterHelper.addItem((FuzzySearch)setting, (String)name, (String)ResManager.loadKDString((String)"\u540d\u79f0", (String)"BizBasedataEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), (float)156.0f, (boolean)true);
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)number)) {
                ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)refBDType.findProperty(number).getDisplayName().toString(), (float)156.0f, (boolean)true);
            }
            if (StringUtils.isNotBlank((CharSequence)name) && !name.equals(number)) {
                ParameterHelper.addItem((FuzzySearch)setting, (String)name, (String)refBDType.findProperty(name).getDisplayName().toString(), (float)156.0f, (boolean)true);
            }
        }
        return setting;
    }

    public List<Object> queryLookUpdata() {
        Log log = LogFactory.getLog(BasedataEdit.class);
        ListShowParameter para = this.queryLookUpdataParameter.getPara();
        if (para == null) {
            return new ArrayList<Object>();
        }
        BasedataEntityType dt = this.queryLookUpdataParameter.getDt();
        String customController = dt.getCustomControllerProperty();
        if (customController != null) {
            try {
                Class<?> clz = Class.forName(customController);
                Object newInst = clz.newInstance();
                if (newInst instanceof ICustomController) {
                    ICustomController controller = (ICustomController)newInst;
                    controller.setCustomQFilters(para);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.beanCreation, new Object[]{ResManager.loadKDString((String)"BaseDataSearchHelper\u521b\u5efa\u81ea\u52a8\u5b9a\u4e49\u63a7\u5236\u5668\u5b9e\u4f8b\u5931\u8d25\uff01", (String)"BaseDataSearchHelper_0", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
        }
        List filters = para.getListFilterParameter().getQFilters();
        if (!this.queryLookUpdataParameter.getSearchFields().isEmpty()) {
            int limit;
            int start;
            DynamicObjectCollection queryCollection;
            block49: {
                String orderBy = para.getListFilterParameter().getOrderBy();
                if (!StringUtils.equals((CharSequence)"no", (CharSequence)this.queryLookUpdataParameter.getSortOrder())) {
                    orderBy = this.addSortOrder(orderBy, dt, this.queryLookUpdataParameter.getSortOrder());
                }
                LinkedHashSet<String> selectFiledSet = new LinkedHashSet<String>(16);
                selectFiledSet.addAll(this.queryLookUpdataParameter.getShowFields());
                if (!StringUtils.isEmpty((CharSequence)orderBy)) {
                    String[] tempStrs;
                    for (String temp : tempStrs = orderBy.trim().split(",")) {
                        selectFiledSet.add(temp.trim().split(" ")[0].toLowerCase());
                    }
                }
                String fields = selectFiledSet.stream().collect(Collectors.joining(","));
                queryCollection = null;
                start = this.queryLookUpdataParameter.getStart();
                limit = this.queryLookUpdataParameter.getLimit();
                if (this.isQuickSearch() && this.isEsStorage()) {
                    try (ESAdapter esAdapter = ESAdapter.create();
                         DataSet ds = esAdapter.queryDataSet(this.getClass().getName(), dt.getName(), fields, filters.toArray(new QFilter[0]), orderBy, limit + 1, (Distinctable)WithEntityEntryDistinctable.get());){
                        queryCollection = esAdapter.toPlainDynamicObjectCollection(ds, start - 1, limit + 1);
                        break block49;
                    }
                    catch (IOException e) {
                        return new ArrayList<Object>();
                    }
                }
                ORM orm = ORM.create();
                try (DataSet ds = orm.queryDataSet(this.getClass().getName(), dt.getName(), fields, filters.toArray(new QFilter[0]), orderBy, limit + 1, (Distinctable)WithEntityEntryDistinctable.get());){
                    queryCollection = orm.toPlainDynamicObjectCollection(ds, start - 1, limit + 1);
                }
            }
            for (int i = 0; i < queryCollection.size() && i < limit - start + 1; ++i) {
                DynamicObject dynamicObject = (DynamicObject)queryCollection.get(i);
                dynamicObject = this.getNameVersionData(dynamicObject, dt);
                queryCollection.set(i, (Object)dynamicObject);
            }
            return BaseDataSearchHelper.assembleData(this.queryLookUpdataParameter.getShowFields(), start, limit, queryCollection, this.queryLookUpdataParameter.getFieldsIndexMap());
        }
        return new ArrayList<Object>();
    }

    private String addSortOrder(String orderBy, BasedataEntityType dt, String sortOrder) {
        if (StringUtils.isEmpty((CharSequence)sortOrder)) {
            sortOrder = dt.getNumberProperty();
        } else if (!StringUtils.equals((CharSequence)sortOrder, (CharSequence)dt.getNumberProperty()) && !StringUtils.equals((CharSequence)sortOrder, (CharSequence)dt.getNameProperty())) {
            log.info("\u672a\u627e\u6a21\u7cca\u67e5\u8be2\u6392\u5e8f\u5b57\u6bb5{}\uff0c", (Object)sortOrder);
            sortOrder = dt.getNumberProperty();
        }
        if (StringUtils.isEmpty((CharSequence)sortOrder)) {
            return orderBy;
        }
        if (StringUtils.isNotEmpty((CharSequence)orderBy)) {
            String[] orderFields;
            for (String field : orderFields = orderBy.split("\\s+desc\\s*,|\\s+DESC\\s*,|\\s+desc|\\s+DESC|\\s+asc\\s*,|\\s+ASC\\s*,|\\s+asc|\\s+ASC|,")) {
                if (!StringUtils.equals((CharSequence)sortOrder, (CharSequence)field.trim())) continue;
                return orderBy;
            }
            orderBy = orderBy + "," + sortOrder;
        } else {
            orderBy = sortOrder;
        }
        return orderBy;
    }

    public static List<Object> assembleData(List<String> showFields, int start, int limit, DynamicObjectCollection queryCollection, Map<String, Integer> fieldsIndexMap) {
        return BaseDataSearchHelper.assembleData(showFields, start, limit, queryCollection, fieldsIndexMap, new HashSet<String>(0));
    }

    @NotNull
    public static List<Object> assembleDataDistinct(List<String> showFields, int start, int limit, DynamicObjectCollection queryCollection, Map<String, Integer> fieldsIndexMap, Set<String> distinctFields) {
        return BaseDataSearchHelper.assembleData(showFields, start, limit, queryCollection, fieldsIndexMap, distinctFields);
    }

    @NotNull
    private static List<Object> assembleData(List<String> showFields, int start, int limit, DynamicObjectCollection queryCollection, Map<String, Integer> fieldsIndexMap, Set<String> distinctFields) {
        ArrayList<Object> data = new ArrayList<Object>();
        int keyFieldsCount = showFields.size() > 3 ? showFields.size() : 3;
        int size = queryCollection.size();
        HashSet<String> keySet = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            if (i >= limit - start + 1) continue;
            DynamicObject dynamicObject = (DynamicObject)queryCollection.get(i);
            Object[] arr = new String[keyFieldsCount];
            for (int j = 0; j < keyFieldsCount; ++j) {
                arr[j] = "";
            }
            BaseDataSearchHelper.setDataByColumns(showFields, dynamicObject, arr, fieldsIndexMap);
            StringBuilder sb = new StringBuilder();
            if (!distinctFields.isEmpty()) {
                ArrayList<Integer> values = new ArrayList<Integer>(distinctFields.size());
                for (String distinctField : distinctFields) {
                    values.add(fieldsIndexMap.get(distinctField));
                }
                for (int j = 0; j < keyFieldsCount; ++j) {
                    if (!values.contains(j)) continue;
                    sb.append(arr[j]);
                    sb.append("_");
                }
                if (!keySet.add(sb.toString())) continue;
                data.add(Arrays.asList(arr));
                continue;
            }
            data.add(Arrays.asList(arr));
        }
        return data;
    }

    private DynamicObject getNameVersionData(DynamicObject baseData, BasedataEntityType baseEntityType) {
        Object versioncontrol;
        if (this.queryLookUpdataParameter.getPara() != null && (versioncontrol = this.queryLookUpdataParameter.getPara().getCustomParam("versioncontrol")) instanceof String) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Date versioncontrolDate = null;
            try {
                versioncontrolDate = sf.parse((String)versioncontrol);
                return NameVersionService.getInstance().getNameVersionData(baseData, baseEntityType, versioncontrolDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return baseData;
    }

    private static void setDataByColumns(List<String> showFields, DynamicObject dynamicObject, Object[] arr, Map<String, Integer> fieldsIndexMap) {
        int fieldIndex = 0;
        for (String showField : showFields) {
            String value;
            String string = value = dynamicObject.get(showField) == null ? "" : String.valueOf(dynamicObject.get(showField));
            if (fieldsIndexMap.get(showField) != null) {
                arr[fieldsIndexMap.get((Object)showField).intValue()] = value;
            } else {
                arr[fieldIndex] = value;
            }
            ++fieldIndex;
        }
    }
}

