/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.GetMainOrgIdsParameter;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.param.CustomParam;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.filter.helper.QueryBaseDataParameter;
import kd.bos.filter.helper.QueryBaseDataParameterWithDt;
import kd.bos.filter.helper.QueryBaseDataParameterWithTopSize;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.list.ListShowParameter;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;

public final class DataPermFilterHelper {
    private String appId;
    private String fieldName;
    private MainEntityType entityType;
    private int start;
    private int topSize;
    private Control control;
    private String entityId;
    private long userId;
    private PermissionService permissionService;
    private static IParameterReaderService parameterReaderService;

    public DataPermFilterHelper(String appId, String fieldName, MainEntityType entityType, int topSize, Control control) {
        this(appId, fieldName, entityType, 0, topSize, control);
    }

    public DataPermFilterHelper(String appId, String fieldName, MainEntityType entityType, int start, int topSize, Control control) {
        this.appId = appId;
        this.fieldName = fieldName;
        this.entityType = entityType;
        this.start = start;
        this.topSize = topSize;
        this.control = control;
        this.entityId = entityType.getName();
        this.userId = RequestContext.get().getCurrUserId();
        this.permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
    }

    public DynamicObjectCollection queryMainOrgItems(IBasedataField basedataProp, List<Plugin> baseDataCustomControllerPlugins, QueryBaseDataParameter queryBaseDataParameter) {
        DynamicObjectCollection dynamicObjectCollection;
        ListShowParameter param = new ListShowParameter();
        if (basedataProp instanceof OrgProp) {
            param.getCustomParams().putAll(((OrgProp)basedataProp).getShowFormCustomParams());
        }
        try (EntityTraceSpan span = EntityTracer.create((String)"list", (String)"DataPermFilterHelper.queryMainOrgItems");){
            param.getListFilterParameter().getQFilters().addAll(queryBaseDataParameter.getQfilters());
            BaseDataCustomControllerEvent event = DataPermFilterHelper.buildBaseDataCoreFilter(this.control, baseDataCustomControllerPlugins, param);
            ArrayList<QFilter> eventQFilters = new ArrayList<QFilter>(queryBaseDataParameter.getQfilters());
            if (!event.getQfilters().isEmpty()) {
                eventQFilters.addAll(event.getQfilters());
            }
            dynamicObjectCollection = PermissionFilterUtil.getMainOrgIds((GetMainOrgIdsParameter)new GetMainOrgIdsParameter(basedataProp, this.entityId, this.appId, this.joinAllQFiltersToAnd(eventQFilters), queryBaseDataParameter.getSelectFields(), queryBaseDataParameter.getOrderBy(), this.start, this.topSize, "47150e89000000ac"));
            if (span.isRealtime()) {
                span.addLocaleTag("inQFilter", queryBaseDataParameter.getQfilters());
                span.addLocaleTag("baseDataCoreFIlter", eventQFilters);
                span.addLocaleTag("size", (Object)dynamicObjectCollection.size());
            }
        }
        return dynamicObjectCollection;
    }

    private QFilter joinAllQFiltersToAnd(List<QFilter> mergeQFilters) {
        QFilter qfilter = null;
        for (QFilter filter : mergeQFilters) {
            if (qfilter == null) {
                if (filter == null) continue;
                qfilter = filter.copy();
                continue;
            }
            if (filter == null) continue;
            qfilter.and(filter.copy());
        }
        return qfilter;
    }

    QFilter getDataPermFilter() {
        Map<Object, Object> customParams = new HashMap(16);
        if (this.control != null && this.control.getView() != null) {
            customParams = this.control.getView().getFormShowParameter().getCustomParams();
        }
        return this.permissionService.getDataPermWithOrg(this.userId, this.appId, this.entityId, customParams);
    }

    QFilter getDataRuleFilter(QueryBaseDataParameterWithDt parameterObject) {
        Map<String, Object> customParams = new HashMap<String, String>(16);
        if (this.control != null && this.control.getView() != null) {
            customParams = this.control.getView().getFormShowParameter().getCustomParams();
        }
        if (parameterObject.getBasedataProp() instanceof ItemClassProp) {
            customParams.put("itemClassType", parameterObject.getBaseDataEntityId());
        }
        return this.permissionService.getDataRuleForBdProp(this.userId, this.appId, this.entityId, this.fieldName, "47150e89000000ac", customParams);
    }

    private static IParameterReaderService getParameterReaderService() {
        if (parameterReaderService == null) {
            parameterReaderService = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class);
        }
        return parameterReaderService;
    }

    private Object loadCustom(String key) {
        CustomParam customParam = new CustomParam();
        customParam.setGroupNumber("kd_svc_customerparam");
        HashSet<String> set = new HashSet<String>();
        set.add(key);
        customParam.setSearchKeySet(set);
        return DataPermFilterHelper.getParameterReaderService().loadCustomParameterFromCache(customParam);
    }

    public DynamicObjectCollection queryBaseDataCollections(QueryBaseDataParameterWithDt parameterObject) {
        DynamicObjectCollection dynamicObjectCollection;
        boolean isNeedPerm = this.isNeedPerm(parameterObject.getBasedataProp(), parameterObject.getQfilters(), parameterObject.isMainOrg());
        IOrgService orgService = (IOrgService)ServiceFactory.getService(IOrgService.class);
        String orgSortFields = orgService.getOrgSortFields();
        String orderBy = "";
        if (StringUtils.isNotBlank((CharSequence)parameterObject.getOrderBy())) {
            orderBy = parameterObject.getOrderBy();
        } else if (parameterObject.getBasedataProp() instanceof OrgProp && StringUtils.isNotBlank((CharSequence)orgSortFields)) {
            orderBy = orgSortFields;
        } else {
            Map enableF7SchemeMap = (Map)this.loadCustom("enableBasedataOrderById");
            if (enableF7SchemeMap != null && "1".equals(enableF7SchemeMap.getOrDefault("enableBasedataOrderById", "0"))) {
                orderBy = parameterObject.getDt().getPrimaryKey().getName();
            } else {
                String string = orderBy = StringUtils.isNotEmpty((CharSequence)parameterObject.getDt().getNumberProperty()) ? parameterObject.getDt().getNumberProperty() : parameterObject.getDt().getPrimaryKey().getName();
            }
        }
        if (isNeedPerm) {
            dynamicObjectCollection = this.queryMainOrgItems(parameterObject.getBasedataProp(), parameterObject.getDt().getBasedataControllersProp(), new QueryBaseDataParameter(parameterObject.getQfilters(), orderBy, this.entityId, parameterObject.getSelectFields()));
        } else {
            try (EntityTraceSpan span = EntityTracer.create((String)"list", (String)"DataPermFilterHelper.queryBaseDataCollections");){
                IDataEntityProperty enableProp;
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
                qfilters.addAll(parameterObject.getQfilters());
                QFilter dataRuleFilter = this.getDataRuleFilter(parameterObject);
                if (dataRuleFilter != null) {
                    qfilters.add(dataRuleFilter);
                }
                if ((enableProp = EntityMetadataCache.getDataEntityType((String)parameterObject.getDt().getName()).findProperty("enable")) instanceof BillStatusProp) {
                    parameterObject.addQfilter(new QFilter("enable", "=", (Object)"1"));
                }
                dynamicObjectCollection = DataPermFilterHelper.queryBaseData(new QueryBaseDataParameterWithTopSize(new QueryBaseDataParameter(qfilters, orderBy, parameterObject.getBaseDataEntityId(), parameterObject.getSelectFields()), parameterObject.getShowFormCustomParams(), parameterObject.getParentDt(), this.control, this.start, this.topSize));
                if (span.isRealtime()) {
                    span.addLocaleTag("fieldName", (Object)this.fieldName);
                    span.addLocaleTag("baseDataEntityId", (Object)parameterObject.getBaseDataEntityId());
                    span.addLocaleTag("inQFilter", parameterObject.getQfilters());
                    span.addLocaleTag("dataRuleFilter", (Object)dataRuleFilter);
                    span.addLocaleTag("size", (Object)dynamicObjectCollection.size());
                    span.addLocaleTag("showFormCustomParams", parameterObject.getShowFormCustomParams());
                }
            }
        }
        return dynamicObjectCollection;
    }

    public static DynamicObjectCollection queryBaseData(QueryBaseDataParameterWithTopSize parameterObject) {
        DynamicObjectCollection dynamicObjectCollection;
        ORM orm = ORM.create();
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.addAll(parameterObject.getQFilters());
        if (parameterObject.getParentDt() != null) {
            ListShowParameter param = new ListShowParameter();
            param.getCustomParams().putAll(parameterObject.getShowFormCustomParams());
            param.getListFilterParameter().getQFilters().addAll(listFilters);
            BaseDataCustomControllerEvent event = DataPermFilterHelper.buildBaseDataCoreFilter(parameterObject.getControl(), parameterObject.getParentDt().getBasedataControllersProp(), param);
            if (!event.getQfilters().isEmpty()) {
                listFilters.addAll(event.getQfilters());
            }
        }
        String orderByStr = parameterObject.getOrderBy();
        String selectFieldStr = parameterObject.getSelectFields();
        if (StringUtils.isNotBlank((CharSequence)orderByStr)) {
            String[] tempStrs = orderByStr.trim().split(",");
            String[] selectFieldArray = selectFieldStr.split(",");
            LinkedHashSet<String> selectFieldList = new LinkedHashSet<String>(Arrays.asList(selectFieldArray));
            for (String tempStr : tempStrs) {
                selectFieldList.add(tempStr.trim().split(" ")[0].toLowerCase());
            }
            selectFieldStr = String.join((CharSequence)",", selectFieldList);
        }
        try (DataSet ds = orm.queryDataSet("kd.bos.filter.CommonFilterColumn." + parameterObject.getBaseDataEntityId(), parameterObject.getBaseDataEntityId(), selectFieldStr, listFilters.toArray(new QFilter[0]), parameterObject.getOrderBy(), parameterObject.getStart(), parameterObject.getTopSize(), (Distinctable)WithEntityEntryDistinctable.get());){
            dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
        }
        return dynamicObjectCollection;
    }

    private boolean isNeedPerm(IBasedataField basedataProp, List<QFilter> qfilters, boolean isMainOrg) {
        boolean isControlFuction;
        boolean isNeedPerm = false;
        String dimFldKey = "";
        String dimFldKeyStr = this.entityType.getPermissionControlType().getDataDimensionField();
        if (StringUtils.isNotBlank((CharSequence)dimFldKeyStr)) {
            String[] dimFldKeys = dimFldKeyStr.split("\\.");
            dimFldKey = dimFldKeys.length == 2 ? dimFldKeys[1] : dimFldKeys[0];
        }
        boolean isUseDimField = (isControlFuction = this.entityType.getPermissionControlType().isControlFunction()) && StringUtils.isNotBlank((CharSequence)dimFldKey) && !"null".equals(dimFldKey);
        String dimAssistFidKey = "";
        String dimAssistFidKeyStr = this.entityType.getPermissionControlType().getDataAssistDimensionField();
        if (StringUtils.isNotBlank((CharSequence)dimAssistFidKeyStr)) {
            String[] dimAssistFldKeys = dimAssistFidKeyStr.split("\\.");
            String string = dimAssistFidKey = dimAssistFldKeys.length == 2 ? dimAssistFldKeys[1] : dimAssistFldKeys[0];
        }
        if (isUseDimField && (dimFldKey.equals(basedataProp.getName()) || StringUtils.isNotBlank((CharSequence)dimAssistFidKey) && dimAssistFidKey.equals(basedataProp.getName()))) {
            if (basedataProp instanceof OrgProp) {
                isNeedPerm = true;
            } else {
                this.getAppointFieldPermOrgs(basedataProp, qfilters);
            }
        } else if (!isUseDimField && isMainOrg) {
            isNeedPerm = true;
        }
        return isNeedPerm;
    }

    private void getAppointFieldPermOrgs(IBasedataField basedataProp, List<QFilter> qfilters) {
        HasPermOrgResult hasPermOrgResult = this.permissionService.getAppointFieldPermOrgs(this.userId, this.appId, this.entityId, "47150e89000000ac", basedataProp.getName());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter idFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            qfilters.add(idFilter);
        }
    }

    private static BaseDataCustomControllerEvent buildBaseDataCoreFilter(Control control, List<Plugin> baseDataCustomControllerPlugins, ListShowParameter param) {
        BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent(control, param, BasedataControllerSourceEnum.COMMON);
        List<IBasedataController> controllers = BasedataHelper.createPlugin(baseDataCustomControllerPlugins);
        for (IBasedataController controller : controllers) {
            controller.buildBaseDataCoreFilter(event);
        }
        return event;
    }
}

