/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.helper.RefBillQueryLookUpdataParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.ESAdapter;
import kd.bos.param.ParameterReader;

public final class RefBillDataSearchHelper {
    public static final String BOS_FORM_METADATA = "bos-form-metadata";
    private RefBillQueryLookUpdataParameter queryLookUpdataParameter;

    public RefBillDataSearchHelper(RefBillQueryLookUpdataParameter queryLookUpdataParameter) {
        this.queryLookUpdataParameter = queryLookUpdataParameter;
    }

    private boolean isQuickSearch() {
        String qsEnable = System.getProperty("quicksearch.enable");
        return "true".equals(qsEnable);
    }

    private boolean isEsStorage() {
        String qsStorage = System.getProperty("quicksearch.storage", "elasticsearch");
        return "elasticsearch".equals(qsStorage);
    }

    public static QFilter getSearchFilter(String searchKey, List<String> searchFields, String entityName) {
        QFilter searchQFilter = null;
        if (StringUtils.isNotBlank((CharSequence)searchKey) && !searchFields.isEmpty()) {
            Map pubSysParam = ParameterReader.loadBillParameterObjectFromCache((String)entityName);
            String searchtype = "1";
            if (pubSysParam != null) {
                searchtype = (String)pubSysParam.get("searchtype");
            }
            String finalSearchKey = searchKey;
            if ("2".equals(searchtype)) {
                finalSearchKey = searchKey + "%";
            }
            searchQFilter = QFilter.ftlike((String)finalSearchKey, (String[])searchFields.toArray(new String[0]));
        }
        return searchQFilter;
    }

    public static Map<String, Integer> getFieldsIndexMap(BillEntityType basedataEntityType, List<String> showFields) {
        HashMap<String, Integer> fieldsIndexMap = new HashMap<String, Integer>();
        for (String showField : showFields) {
            if (showField.equals(basedataEntityType.getPrimaryKey().getName())) {
                fieldsIndexMap.put(showField, 0);
                continue;
            }
            if (!showField.equals(basedataEntityType.getBillNo())) continue;
            fieldsIndexMap.put(showField, 1);
        }
        return fieldsIndexMap;
    }

    public static FuzzySearch loadLookUpSetting(BillEntityType refBDType) {
        FuzzySearch setting = null;
        BillParam billParam = ParameterHelper.getBillParam((String)refBDType.getName());
        setting = billParam.getFuzzySearch() != null ? billParam.getFuzzySearch() : RefBillDataSearchHelper.buildDefLookUpSetting(refBDType);
        ParameterHelper.addItem((FuzzySearch)setting, (String)refBDType.getPrimaryKey().getName(), (String)"ID", (float)0.0f, (int)-1, (int)0, (boolean)false);
        return setting;
    }

    public static void setComboFieldCaption(BillEntityType refBDType, FuzzySearch setting) {
        if (refBDType == null || setting == null) {
            return;
        }
        for (ShowColumn column : setting.getComboListFields()) {
            DynamicProperty prop = refBDType.getProperty(column.getId());
            String fieldId = column.getId();
            if ("id".equals(fieldId) || prop == null) continue;
            column.setCaption(prop.getDisplayName().toString());
        }
    }

    private static FuzzySearch buildDefLookUpSetting(BillEntityType refBDType) {
        FuzzySearch setting = new FuzzySearch();
        String number = refBDType.getBillNo();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)refBDType.findProperty(number).getDisplayName().toString(), (float)200.0f, (boolean)true);
        }
        DataEntityPropertyCollection properties = refBDType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof FieldProp) || property.getDisplayName() == null || "id".equalsIgnoreCase(property.getName()) || number.equalsIgnoreCase(property.getName())) continue;
            ParameterHelper.addItem((FuzzySearch)setting, (String)property.getName(), (String)property.getDisplayName().toString(), (float)156.0f, (int)-1, (int)setting.getSearchFields().size(), (boolean)false);
            break;
        }
        return setting;
    }

    public List<Object> queryLookUpdata() {
        Log log = LogFactory.getLog(BasedataEdit.class);
        ListShowParameter para = this.queryLookUpdataParameter.getPara();
        if (para == null) {
            return new ArrayList<Object>();
        }
        BillEntityType dt = this.queryLookUpdataParameter.getDt();
        List filters = para.getListFilterParameter().getQFilters();
        if (!this.queryLookUpdataParameter.getSearchFields().isEmpty()) {
            int limit;
            int start;
            DynamicObjectCollection queryCollection;
            block46: {
                List<String> showFields = this.queryLookUpdataParameter.getShowFields();
                for (String showField : showFields) {
                    RefBillDataSearchHelper.checkRefBillIsExistTableFields(dt, this.queryLookUpdataParameter.getDisplayName(), showField);
                }
                String fields = showFields.stream().collect(Collectors.joining(","));
                String orderBy = para.getListFilterParameter().getOrderBy();
                if (this.queryLookUpdataParameter.isDefaultSort()) {
                    if (StringUtils.isNotEmpty((CharSequence)orderBy) && StringUtils.isNotEmpty((CharSequence)dt.getBillNo())) {
                        orderBy = orderBy + "," + String.format("%s", dt.getBillNo());
                    } else if (StringUtils.isEmpty((CharSequence)orderBy) && StringUtils.isNotEmpty((CharSequence)dt.getBillNo())) {
                        orderBy = String.format("%s", dt.getBillNo());
                    }
                }
                queryCollection = null;
                start = this.queryLookUpdataParameter.getStart();
                limit = this.queryLookUpdataParameter.getLimit();
                if (this.isQuickSearch() && this.isEsStorage()) {
                    try (ESAdapter esAdapter = ESAdapter.create();
                         DataSet ds = esAdapter.queryDataSet(this.getClass().getName(), dt.getName(), fields, filters.toArray(new QFilter[0]), orderBy, limit + 1);){
                        queryCollection = esAdapter.toPlainDynamicObjectCollection(ds, start - 1, limit + 1);
                        break block46;
                    }
                    catch (IOException e) {
                        return new ArrayList<Object>();
                    }
                }
                ORM orm = ORM.create();
                try (DataSet ds = orm.queryDataSet(this.getClass().getName(), dt.getName(), fields, filters.toArray(new QFilter[0]), orderBy, limit + 1);){
                    queryCollection = orm.toPlainDynamicObjectCollection(ds, start - 1, limit + 1);
                }
            }
            return RefBillDataSearchHelper.assembleData(this.queryLookUpdataParameter.getShowFields(), start, limit, queryCollection, this.queryLookUpdataParameter.getFieldsIndexMap());
        }
        return new ArrayList<Object>();
    }

    public static List<Object> assembleData(List<String> showFields, int start, int limit, DynamicObjectCollection queryCollection, Map<String, Integer> fieldsIndexMap) {
        ArrayList<Object> data = new ArrayList<Object>();
        int keyFieldsCount = showFields.size() > 3 ? showFields.size() : 3;
        HashSet<Object> set = new HashSet<Object>(queryCollection.size());
        for (int i = 0; i < queryCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)queryCollection.get(i);
            Object id = dynamicObject.get("ID");
            if (id != null) {
                if (set.contains(id)) continue;
                set.add(id);
            }
            if (i >= limit - start + 1) continue;
            Object[] arr = new String[keyFieldsCount];
            for (int j = 0; j < keyFieldsCount; ++j) {
                arr[j] = "";
            }
            RefBillDataSearchHelper.setDataByColumns(showFields, dynamicObject, arr, fieldsIndexMap);
            data.add(Arrays.asList(arr));
        }
        return data;
    }

    private static void setDataByColumns(List<String> showFields, DynamicObject dynamicObject, Object[] arr, Map<String, Integer> fieldsIndexMap) {
        int fieldIndex = 0;
        for (String showField : showFields) {
            String value;
            String string = value = dynamicObject.get(showField) == null ? "" : String.valueOf(dynamicObject.get(showField));
            if (fieldsIndexMap.get(showField) != null) {
                arr[fieldsIndexMap.get((Object)showField).intValue()] = value;
            } else {
                arr[fieldIndex] = value;
            }
            ++fieldIndex;
        }
    }

    public static void checkRefBillIsExistTableFields(BillEntityType dt, String refBillDisplayName, String field) {
        DynamicProperty property = dt.getProperty(field);
        if (property != null && StringUtils.isEmpty((CharSequence)property.getAlias())) {
            throw new KDBizException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7684\u5b57\u6bb5\u3010%2$s\u3011\u6ca1\u6709\u8bbe\u7f6e\u7269\u7406\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"RefBillDataSearchHelper_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), refBillDisplayName, field)});
        }
    }
}

