/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.form.field.ComboItem;

public class NlpAnalysisHttpRequest
implements Serializable {
    private static final long serialVersionUID = -863665324951918560L;
    private String text;
    private String userName;
    private String userDept;
    private EntityMeta entityMeta;

    public NlpAnalysisHttpRequest() {
    }

    public NlpAnalysisHttpRequest(String text, String userName, String userDept, EntityMeta entityMeta) {
        this.text = text;
        this.userName = userName;
        this.userDept = userDept;
        this.entityMeta = entityMeta;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserDept() {
        return this.userDept;
    }

    public void setUserDept(String userDept) {
        this.userDept = userDept;
    }

    public EntityMeta getEntityMeta() {
        return this.entityMeta;
    }

    public void setEntityMeta(EntityMeta entityMeta) {
        this.entityMeta = entityMeta;
    }

    public static class EntityMeta {
        private String fieldCaption;
        private String name;
        private List<FieldBean> field;

        public String getFieldCaption() {
            return this.fieldCaption;
        }

        public void setFieldCaption(String fieldCaption) {
            this.fieldCaption = fieldCaption;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<FieldBean> getField() {
            return this.field;
        }

        public void setField(List<FieldBean> field) {
            this.field = field;
        }

        public static class FieldBean {
            private String fieldName;
            private FieldCaptionBean fieldCaption;
            private String type;
            private List<NlpComboItem> comboItems;
            private List<ComparetypesBean> compareTypes;

            public FieldBean() {
            }

            public FieldBean(String fieldName, LocaleString fieldCaption, String type, List<ValueMapItem> comboItemsArrayList, List<CompareType> compareTypes) {
                this.fieldName = fieldName;
                this.fieldCaption = new FieldCaptionBean(fieldCaption);
                this.type = type;
                this.comboItems = new ArrayList<NlpComboItem>();
                this.compareTypes = new ArrayList<ComparetypesBean>();
                if (comboItemsArrayList != null) {
                    for (ValueMapItem valueMapItem : comboItemsArrayList) {
                        ComboItem item;
                        if (valueMapItem instanceof ComboItem) {
                            item = (ComboItem)valueMapItem;
                            this.comboItems.add(new NlpComboItem(item));
                            continue;
                        }
                        if (!(valueMapItem instanceof ValueMapItem)) continue;
                        item = valueMapItem;
                        ComboItem comboItem = new ComboItem(item.getName(), item.getValue());
                        this.comboItems.add(new NlpComboItem(comboItem));
                    }
                }
                if (compareTypes != null) {
                    for (ValueMapItem valueMapItem : compareTypes) {
                        ComparetypesBean comparetypesBean;
                        if (valueMapItem instanceof CompareTypeDto) {
                            CompareTypeDto compareTypeDto = (CompareTypeDto)valueMapItem;
                            comparetypesBean = new ComparetypesBean(compareTypeDto);
                            if (null == comparetypesBean.getOperate()) continue;
                            this.compareTypes.add(comparetypesBean);
                            continue;
                        }
                        if (!(valueMapItem instanceof CompareType)) continue;
                        CompareType compareType = (CompareType)valueMapItem;
                        comparetypesBean = new ComparetypesBean(compareType);
                        this.compareTypes.add(comparetypesBean);
                    }
                }
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public void setFieldName(String fieldName) {
                this.fieldName = fieldName;
            }

            public FieldCaptionBean getFieldCaption() {
                return this.fieldCaption;
            }

            public void setFieldCaption(FieldCaptionBean fieldCaption) {
                this.fieldCaption = fieldCaption;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public List<NlpComboItem> getComboItems() {
                return this.comboItems;
            }

            public void setComboItems(List<NlpComboItem> comboItems) {
                this.comboItems = comboItems;
            }

            public List<ComparetypesBean> getCompareTypes() {
                return this.compareTypes;
            }

            public void setCompareTypes(List<ComparetypesBean> compareTypes) {
                this.compareTypes = compareTypes;
            }

            public static class ComparetypesBean {
                private String operate;
                private int groupId;
                private NameBean name;
                private String id;

                public ComparetypesBean() {
                }

                public ComparetypesBean(String operate, int groupId, NameBean name, String id) {
                    this.operate = operate;
                    this.groupId = groupId;
                    this.name = name;
                    this.id = id;
                }

                public ComparetypesBean(CompareTypeDto compareTypeDto) {
                    this.id = compareTypeDto.getId();
                    this.groupId = compareTypeDto.getGroupId();
                    this.name = new NameBean(compareTypeDto.getName());
                    CompareType compareType = FilterMetadata.get().getCompareType(String.valueOf(compareTypeDto.getGroupId()), compareTypeDto.getId());
                    if (compareType != null) {
                        this.operate = compareType.getOperate();
                    }
                }

                public ComparetypesBean(CompareType compareType) {
                    this.id = compareType.getId();
                    this.groupId = compareType.getGroupId();
                    this.name = new NameBean(compareType.getName());
                    this.operate = compareType.getOperate();
                }

                public String getOperate() {
                    return this.operate;
                }

                public void setOperate(String operate) {
                    this.operate = operate;
                }

                public int getGroupId() {
                    return this.groupId;
                }

                public void setGroupId(int groupId) {
                    this.groupId = groupId;
                }

                public NameBean getName() {
                    return this.name;
                }

                public void setName(NameBean name) {
                    this.name = name;
                }

                public String getId() {
                    return this.id;
                }

                public void setId(String id) {
                    this.id = id;
                }

                public static class NameBean {
                    private String zh_CN;
                    private String en_US;
                    private String zh_TW;

                    public NameBean() {
                    }

                    public NameBean(LocaleString localeString) {
                        if (Objects.nonNull(localeString)) {
                            this.zh_CN = localeString.getLocaleValue_zh_CN();
                            this.en_US = localeString.getLocaleValue_en();
                            this.zh_TW = localeString.getLocaleValue_zh_TW();
                        }
                    }

                    public String getZh_CN() {
                        return this.zh_CN;
                    }

                    public void setZh_CN(String zh_CN) {
                        this.zh_CN = zh_CN;
                    }

                    public String getEn_US() {
                        return this.en_US;
                    }

                    public void setEn_US(String en_US) {
                        this.en_US = en_US;
                    }

                    public String getZh_TW() {
                        return this.zh_TW;
                    }

                    public void setZh_TW(String zh_TW) {
                        this.zh_TW = zh_TW;
                    }
                }
            }

            public static class NlpComboItem {
                private CaptionBean caption;
                private String disable;

                public NlpComboItem(ComboItem comboItem) {
                    this.disable = String.valueOf(comboItem.isDisable());
                    this.caption = new CaptionBean(comboItem.getCaption());
                }

                public CaptionBean getCaption() {
                    return this.caption;
                }

                public void setCaption(CaptionBean caption) {
                    this.caption = caption;
                }

                public String isDisable() {
                    return this.disable;
                }

                public void setDisable(String disable) {
                    this.disable = disable;
                }

                public static class CaptionBean {
                    private String zh_CN;

                    public CaptionBean() {
                    }

                    public CaptionBean(LocaleString localeString) {
                        if (Objects.nonNull(localeString)) {
                            this.zh_CN = localeString.getLocaleValue_zh_CN();
                        }
                    }

                    public String getZh_CN() {
                        return this.zh_CN;
                    }

                    public void setZh_CN(String zh_CN) {
                        this.zh_CN = zh_CN;
                    }
                }
            }

            public static class FieldCaptionBean {
                private String zh_CN;

                public FieldCaptionBean() {
                }

                public FieldCaptionBean(LocaleString localeString) {
                    if (Objects.nonNull(localeString)) {
                        this.zh_CN = localeString.getLocaleValue_zh_CN();
                    }
                }

                public String getZh_CN() {
                    return this.zh_CN;
                }

                public void setZh_CN(String zh_CN) {
                    this.zh_CN = zh_CN;
                }
            }
        }
    }
}

