/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.license.api.ICoreLicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.param.ParameterReader;
import kd.bos.service.ServiceFactory;

public class CoreSingleOrgContextHelper {
    private static final Log logger = LogFactory.getLog(CoreSingleOrgContextHelper.class);
    private static final String ORG_ENTITY_NUMBER = "bos_org";
    private static final String ITEM = "items";
    private static final String THREAD_CACHE_KEY_IS_SINGLE_ORG_MANAGE_MODE = "bos_license_is_single_org_manage_mode";
    private static final String ORG_FUNC_ADMIN = "01";

    @Deprecated
    public static void createFormSingleOrgContext(FormShowParameter params, Map<String, Object> config) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateFormSingleOrgContext(params, config);
        }
    }

    private static void doCreateFormSingleOrgContext(FormShowParameter params, Map<String, Object> config) {
        HashMap<String, Control> mapFields = new HashMap<String, Control>();
        ArrayList<Control> lstEntrys = new ArrayList<Control>();
        CoreSingleOrgContextHelper.getSingleOrgFieldControlsFromFormRoot(params, mapFields, lstEntrys);
        ArrayList<Control> lstValidOrgs = new ArrayList<Control>();
        CoreSingleOrgContextHelper.addOrgEditAndBasedataProEditToValidOrgs(mapFields, lstValidOrgs);
        CoreSingleOrgContextHelper.addSochToConfig(config, mapFields, lstEntrys);
        List<Map<String, Object>> configItems = CoreSingleOrgContextHelper.getConfigItemsFromConfig(config);
        CoreSingleOrgContextHelper.setCtrlInvisible(lstValidOrgs, configItems);
    }

    private static void setCtrlInvisible(List<Control> lstValidOrgs, List<Map<String, Object>> configItems) {
        for (Control org : lstValidOrgs) {
            HashMap<String, Object> mapCtrl = new HashMap<String, Object>(16);
            mapCtrl.put("id", org.getKey());
            mapCtrl.put("vi", 0);
            configItems.add(mapCtrl);
        }
    }

    private static void addOrgEditAndBasedataProEditToValidOrgs(Map<String, Control> mapFields, List<Control> lstValidOrgs) {
        for (Map.Entry<String, Control> field : mapFields.entrySet()) {
            Control value = field.getValue();
            if (!CoreSingleOrgContextHelper.isControlField(value, mapFields)) continue;
            lstValidOrgs.add(value);
        }
    }

    private static void addSochToConfig(Map<String, Object> config, Map<String, Control> mapFields, List<Control> lstEntrys) {
        Map<String, List<String>> mapEntry = CoreSingleOrgContextHelper.getValidEntryMap(mapFields, lstEntrys, null);
        if (mapEntry.size() > 0) {
            config.put("soch", mapEntry);
        }
    }

    private static void getSingleOrgFieldControlsFromFormRoot(FormShowParameter params, Map<String, Control> mapFields, List<Control> lstEntrys) {
        FormRoot root = FormMetadataCache.getRootControl(params.getFormId());
        List<Control> rootItems = root.getItems();
        for (Control item : rootItems) {
            CoreSingleOrgContextHelper.getSingleOrgFieldControls(item, mapFields, lstEntrys);
        }
    }

    private static List<Map<String, Object>> getConfigItemsFromConfig(Map<String, Object> config) {
        ArrayList configItems;
        HashMap metas = (HashMap)config.get("metas");
        if (metas == null) {
            metas = new HashMap(16);
            config.put("metas", metas);
        }
        if ((configItems = (ArrayList)metas.get(ITEM)) == null) {
            configItems = new ArrayList(10);
            metas.put(ITEM, configItems);
        }
        return configItems;
    }

    public static void createReportSingleOrgContext(List<AbstractReportColumn> columns) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateReportSingleOrgContext(columns);
        }
    }

    private static void doCreateReportSingleOrgContext(List<AbstractReportColumn> columns) {
        if (columns == null) {
            return;
        }
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                String xzzn;
                boolean isOrg = ((ReportColumn)column).isRefOrg();
                if (!isOrg || StringUtils.isNotBlank((CharSequence)(xzzn = ((ReportColumn)column).getOrgFuncs())) && xzzn.equals(ORG_FUNC_ADMIN)) continue;
                ((ReportColumn)column).setHide(true);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            List children = ((ReportColumnGroup)column).getChildren();
            CoreSingleOrgContextHelper.doCreateReportSingleOrgContext(children);
        }
    }

    private static boolean isControlField(Object orgOrBase, Map<String, Control> mapFields) {
        boolean ret = false;
        String xzzn = "";
        if (orgOrBase instanceof OrgProp) {
            ret = true;
            xzzn = ((OrgProp)orgOrBase).getOrgFunc();
            if (StringUtils.isNotBlank((CharSequence)xzzn) && xzzn.equals(ORG_FUNC_ADMIN)) {
                ret = false;
            }
        } else if (orgOrBase instanceof BasedataProp && !(orgOrBase instanceof ItemClassProp)) {
            String refEntity = ((BasedataProp)orgOrBase).getBaseEntityId();
            if (ORG_ENTITY_NUMBER.equals(refEntity)) {
                ret = true;
            }
        } else if (orgOrBase instanceof MulBasedataProp) {
            String refEntity = ((MulBasedataProp)orgOrBase).getBaseEntityId();
            if (ORG_ENTITY_NUMBER.equals(refEntity)) {
                ret = true;
                xzzn = ((MulBasedataProp)orgOrBase).getOrgFunc();
                if (StringUtils.isNotBlank((CharSequence)xzzn) && xzzn.equals(ORG_FUNC_ADMIN)) {
                    ret = false;
                }
            }
        } else if (orgOrBase instanceof OrgEdit) {
            ret = true;
            xzzn = ((OrgProp)((OrgEdit)orgOrBase).getProperty()).getOrgFunc();
            if (StringUtils.isNotBlank((CharSequence)xzzn) && xzzn.equals(ORG_FUNC_ADMIN)) {
                ret = false;
            }
        } else if (orgOrBase instanceof BasedataPropEdit) {
            String ref = ((BasedataPropEdit)orgOrBase).getRefBasedataProp();
            if (mapFields != null && StringUtils.isNotBlank((Object)ref)) {
                String refDisplayName;
                Control refCtrl = mapFields.get(ref);
                if (refCtrl instanceof OrgEdit && CoreSingleOrgContextHelper.isControlField(refCtrl, null)) {
                    ret = true;
                } else if (refCtrl instanceof BasedataEdit && StringUtils.isNotBlank((CharSequence)(refDisplayName = ((BasedataPropEdit)orgOrBase).getRefDisplayProp()))) {
                    String[] dps = refDisplayName.split("\\.");
                    String baseEntityNumber = ((BasedataProp)((BasedataEdit)refCtrl).getProperty()).getBaseEntityId();
                    if (StringUtils.isNotBlank((CharSequence)baseEntityNumber)) {
                        MainEntityType tp = EntityMetadataCache.getDataEntityType((String)baseEntityNumber);
                        DynamicProperty prop = tp.getProperty(dps[0]);
                        ret = CoreSingleOrgContextHelper.isControlField(prop, null);
                    }
                }
            }
        } else if (orgOrBase instanceof BasedataEdit && !(orgOrBase instanceof ItemClassEdit)) {
            IDataEntityProperty prop = ((BasedataEdit)orgOrBase).getProperty();
            ret = CoreSingleOrgContextHelper.isControlField(prop, null);
        }
        return ret;
    }

    public static void createReportSearchConditionSingleOrgContext(List<String> fields, IFormView view) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateReportSearchConditionSingleOrgContext(fields, view);
        }
    }

    private static void doCreateReportSearchConditionSingleOrgContext(List<String> fields, IFormView view) {
        HashMap<String, Control> mapFields = new HashMap<String, Control>();
        HashMap<String, List<Control>> mapCardEntryFields = new HashMap<String, List<Control>>();
        HashMap<String, CardEntry> cardEntrys = new HashMap<String, CardEntry>();
        ArrayList<Control> ctls = new ArrayList<Control>();
        FormRoot root = (FormRoot)view.getRootControl();
        List<Control> lstItems = root.getItems();
        for (Control item : lstItems) {
            CoreSingleOrgContextHelper.createOrgAndBasedataPropControl(item, ctls, mapFields, cardEntrys, mapCardEntryFields);
        }
        Iterator<String> it = fields.iterator();
        while (it.hasNext()) {
            String key = it.next();
            Object fd = view.getControl(key);
            if (fd == null || !CoreSingleOrgContextHelper.isControlField(fd, mapFields)) continue;
            it.remove();
        }
    }

    public static void createFilterGridSingleOrgContext(Map<String, List<Map<String, Object>>> fieldMap, MainEntityType mainType) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateFilterGridSingleOrgContext(fieldMap, mainType);
        }
    }

    private static void doCreateFilterGridSingleOrgContext(Map<String, List<Map<String, Object>>> fieldMap, MainEntityType mainType) {
        List<Map<String, Object>> lstField = fieldMap.get("filterColumns");
        CoreSingleOrgContextHelper.hideFilterSearchOrgByName(lstField, mainType);
    }

    @Deprecated
    public static void createListFilterSingleOrgContext(Map<String, Object> clientMeta, MainEntityType mainType) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateListFilterSingleOrgContext(clientMeta, mainType);
        }
    }

    private static void doCreateListFilterSingleOrgContext(Map<String, Object> clientMeta, MainEntityType mainType) {
        CoreSingleOrgContextHelper.hideFilterSearchOrgByName(clientMeta, mainType, "fast");
        CoreSingleOrgContextHelper.hideFilterSearchOrgByName(clientMeta, mainType, "common");
        Map mapScheme = (Map)clientMeta.get("scheme");
        CoreSingleOrgContextHelper.hideFilterSearchOrgByName(mapScheme, mainType, "conditions");
    }

    private static void hideFilterSearchOrgByName(Map<String, Object> clientMeta, MainEntityType mainType, String name) {
        Object nameObj = clientMeta.get(name);
        if (mainType == null) {
            return;
        }
        if (!(nameObj instanceof List)) {
            return;
        }
        List lstName = (List)nameObj;
        CoreSingleOrgContextHelper.hideFilterSearchOrgByName(lstName, mainType);
    }

    private static void hideFilterSearchOrgByName(List<Map<String, Object>> lstName, MainEntityType mainType) {
        String ret = lstName.toString();
        Iterator<Map<String, Object>> it = lstName.iterator();
        while (it.hasNext()) {
            Map<String, Object> mapName = it.next();
            String type = (String)mapName.get("type");
            String entryEntity = (String)mapName.get("entryEntity");
            String fieldName = (String)mapName.get("fieldName");
            FilterField filterField = null;
            if (filterField == null) {
                filterField = FilterField.create((MainEntityType)mainType, (String)fieldName);
            }
            if (filterField == null || !CoreSingleOrgContextHelper.isNeedHideOrg(filterField)) continue;
            it.remove();
        }
    }

    public static void createFormSingleOrgContext(IFormView view) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateFormSingleOrgContext(view);
        }
    }

    public static boolean isSingleOrgManageMode() {
        return (Boolean)ThreadCache.get((Object)THREAD_CACHE_KEY_IS_SINGLE_ORG_MANAGE_MODE, (CacheLoader)new CacheLoader<Boolean>(){

            public Boolean load() {
                ICoreLicenseService service = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
                return service.isSingleOrgManageMode();
            }
        });
    }

    public static void createSystemParamSingleOrgContext(IFormView view, boolean visible) {
        if (CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            CoreSingleOrgContextHelper.doCreateSystemParamSingleOrgContext(view, visible);
        }
    }

    private static void doCreateSystemParamSingleOrgContext(IFormView view, boolean visible) {
        view.setVisible(false, "orgfield");
        view.setVisible(false, "viewtype");
        view.setVisible(false, "groupcontrol");
        view.setVisible(visible, "headpanel");
    }

    private static void doCreateFormSingleOrgContext(IFormView view) {
        HashMap<String, Control> mapFields = new HashMap<String, Control>();
        HashMap<String, List<Control>> mapCardEntryFields = new HashMap<String, List<Control>>();
        HashMap<String, CardEntry> cardEntrys = new HashMap<String, CardEntry>();
        ArrayList<Control> ctls = new ArrayList<Control>();
        FormRoot root = (FormRoot)view.getRootControl();
        List<Control> lstItems = root.getItems();
        for (Control control : lstItems) {
            CoreSingleOrgContextHelper.createOrgAndBasedataPropControl(control, ctls, mapFields, cardEntrys, mapCardEntryFields);
        }
        for (Control control : ctls) {
            if (!CoreSingleOrgContextHelper.isControlField(control, mapFields)) continue;
            view.setVisible(false, control.getKey());
        }
        if (mapCardEntryFields.size() > 0) {
            for (Map.Entry entry : mapCardEntryFields.entrySet()) {
                List items = (List)entry.getValue();
                CardEntry cn = (CardEntry)cardEntrys.get(entry.getKey());
                for (Control item : items) {
                    if (!CoreSingleOrgContextHelper.isControlField(item, mapFields)) continue;
                    cn.setChildVisible(false, -1, item.getKey());
                }
            }
        }
    }

    private static void getSingleOrgFieldControls(Control parent, Map<String, Control> lstField, List<Control> lstEntry) {
        if (parent instanceof EntryGrid) {
            lstEntry.add(parent);
        }
        if (parent instanceof Container) {
            List<Control> lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    CoreSingleOrgContextHelper.getSingleOrgFieldControls(ctl, lstField, lstEntry);
                    continue;
                }
                CoreSingleOrgContextHelper.addOrgAndBasedataProp(lstField, ctl);
            }
        } else {
            CoreSingleOrgContextHelper.addOrgAndBasedataProp(lstField, parent);
        }
    }

    private static boolean isControlType(Control ctl) {
        return ctl instanceof OrgEdit || ctl instanceof BasedataPropEdit || ctl instanceof BasedataEdit && !(ctl instanceof ItemClassEdit);
    }

    private static void addOrgAndBasedataProp(Map<String, Control> lst, Control ctl) {
        if (CoreSingleOrgContextHelper.isControlType(ctl) || ctl instanceof EntryGrid) {
            lst.put(ctl.getKey(), ctl);
        }
    }

    private static Map<String, List<String>> getValidEntryMap(Map<String, Control> mapFields, List<Control> lstEntrys, Map<String, List<String>> mapEntry) {
        if (mapEntry == null) {
            mapEntry = new HashMap<String, List<String>>();
        }
        for (Control entry : lstEntrys) {
            if (!(entry instanceof Container)) continue;
            List<Control> lstCtls = ((Container)entry).getItems();
            for (Control ctl : lstCtls) {
                if (CoreSingleOrgContextHelper.isControlField(ctl, mapFields)) {
                    List lstMapCtls = mapEntry.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                    lstMapCtls.add(ctl.getKey());
                    continue;
                }
                if (!(ctl instanceof Container)) continue;
                mapEntry = CoreSingleOrgContextHelper.getValidEntryMap(mapFields, ((Container)ctl).getItems(), mapEntry);
            }
        }
        return mapEntry;
    }

    private static void createOrgAndBasedataPropControl(Control parent, List<Control> ctls, Map<String, Control> mapFields, Map<String, CardEntry> cardEntrys, Map<String, List<Control>> mapCardEntryFields) {
        if (parent instanceof CardEntry) {
            cardEntrys.put(parent.getKey(), (CardEntry)parent);
            List<Control> fields = CoreSingleOrgContextHelper.createCardEntryControl(parent);
            mapCardEntryFields.put(parent.getKey(), fields);
        } else if (parent instanceof Container) {
            List<Control> lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    CoreSingleOrgContextHelper.createOrgAndBasedataPropControl(ctl, ctls, mapFields, cardEntrys, mapCardEntryFields);
                    continue;
                }
                if (!CoreSingleOrgContextHelper.isControlType(ctl)) continue;
                ctls.add(ctl);
                mapFields.put(ctl.getKey(), ctl);
            }
        } else if (CoreSingleOrgContextHelper.isControlType(parent)) {
            ctls.add(parent);
            mapFields.put(parent.getKey(), parent);
        }
    }

    private static List<Control> createCardEntryControl(Control cardentry) {
        ArrayList<Control> fields = new ArrayList<Control>();
        CoreSingleOrgContextHelper.recursionGetFields(cardentry, fields);
        return fields;
    }

    private static void recursionGetFields(Control parent, List<Control> ctls) {
        if (parent instanceof Container) {
            List<Control> lstCtls = ((Container)parent).getItems();
            for (Control ctl : lstCtls) {
                if (ctl instanceof Container) {
                    CoreSingleOrgContextHelper.recursionGetFields(ctl, ctls);
                    continue;
                }
                if (!CoreSingleOrgContextHelper.isControlType(ctl)) continue;
                ctls.add(ctl);
            }
        } else if (CoreSingleOrgContextHelper.isControlType(parent)) {
            ctls.add(parent);
        }
    }

    public static int getOrgmanageMode() {
        Map paramMap = ParameterReader.loadPublicParameterFromCache();
        if (paramMap == null) {
            return 2;
        }
        Object mode = paramMap.get("orgmanagemode");
        return StringUtils.isBlank(mode) ? 2 : Integer.parseInt(mode.toString());
    }

    public static boolean isNeedHideOrg(FilterField filterField) {
        if (!CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            return false;
        }
        boolean bRet = false;
        IDataEntityProperty ref0 = filterField.getSrcFieldProp();
        IDataEntityProperty ref1 = filterField.getRefProp1();
        IDataEntityProperty ref2 = filterField.getRefProp2();
        if (ref0 != null && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref0) || ref1 != null && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref1) || ref2 != null && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)ref2)) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isNeedHideOrgForCommonFilterColumn(FilterField filterField) {
        if (!CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            return false;
        }
        boolean bRet = false;
        IDataEntityProperty ref0 = filterField.getSrcFieldProp();
        IDataEntityProperty ref1 = filterField.getRefProp1();
        IDataEntityProperty ref2 = filterField.getRefProp2();
        if (ref0 != null && SingleOrgContextHelper.isFieldNeedHideForCommonFilterColumn((IDataEntityProperty)ref0) || ref1 != null && SingleOrgContextHelper.isFieldNeedHideForCommonFilterColumn((IDataEntityProperty)ref1) || ref2 != null && SingleOrgContextHelper.isFieldNeedHideForCommonFilterColumn((IDataEntityProperty)ref2)) {
            bRet = true;
        }
        return bRet;
    }

    public static boolean isFieldNeedHide(IDataEntityProperty prop) {
        if (!CoreSingleOrgContextHelper.isSingleOrgManageMode()) {
            return false;
        }
        boolean ret = false;
        if (prop instanceof OrgProp && !ORG_FUNC_ADMIN.equals(((OrgProp)prop).getOrgFunc())) {
            ret = true;
        }
        if (!(prop instanceof OrgProp) && prop instanceof BasedataProp && !(prop instanceof ItemClassProp) && ORG_ENTITY_NUMBER.equals(((BasedataProp)prop).getBaseEntityId())) {
            ret = true;
        }
        if (prop instanceof MulBasedataProp && ORG_ENTITY_NUMBER.equals(((MulBasedataProp)prop).getBaseEntityId()) && !ORG_FUNC_ADMIN.equals(((MulBasedataProp)prop).getOrgFunc())) {
            ret = true;
        }
        return ret;
    }
}

