/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.entity.operate.IOperate;
import kd.bos.entity.rule.AbstractRule;
import kd.bos.entity.rule.EntityBR;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.BinderMap;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataLocalCache;
import kd.bos.form.FormOperateTypes;
import kd.bos.form.IFormMetadataProvide;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.session.SystemPropertyUtils;

class FormMetadataProvide
implements IFormMetadataProvide {
    private static Log log = LogFactory.getLog(FormMetadataProvide.class);
    private static final String CONFIG = "Config";
    private static final String FILTER = "Filter";
    private static final String QINGVIEW2 = "qingview";
    private static final String TOOL_BAR = "ToolBar";
    private static final String LIST = "List";
    private MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static String[] guestFormWhiteList = new String[]{"srm_portal", "bos_portal_setlayout", "bos_assistantdata_detail", "bd_admindivision", "bos_admindivisionf7", "bd_country", "bd_taxrate", "bd_invoicetype", "bos_templatetreelistf7", "bd_settlementtype", "bd_paycondition", "bd_taxcategory", "bd_bebank", "bd_resinlistf7", "bos_list", "bos_org", "bos_orgtreelistf7", "bd_currency", "bos_listf7", "bos_treelistf7", "bos_moblistf7", "bos_mobtreelistf7", "bos_customlistf7", "bos_moblisttabf7", "bos_dateselect", "bos_moblist", "bos_moblistmodalf7", "rebm_announcement", "resp_registered", "resp_org_alias", "bd_suppliergroup", "bd_datagrouptreelistf7", "resp_message", "resm_suppliernaturef7"};

    FormMetadataProvide() {
    }

    @Override
    public FormConfig getFormConfig(String formId) {
        String strConfig = FormMetadataLocalCache.getFormConfig(formId);
        if (strConfig == null) {
            strConfig = this.metadataService.loadFormConfig(formId);
            FormMetadataLocalCache.putFormConfig(formId, strConfig);
        }
        if (StringUtils.isEmpty((CharSequence)strConfig)) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"FormMetadataProvide_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), formId)});
        }
        try {
            PermissionControlType permControlType;
            FormConfig formConfig = this.toFormConfig(strConfig);
            if (!(!"-1".equals(RequestContext.get().getUserId()) || this.isGuestWhiteList(formId) || (permControlType = EntityMetadataCache.getPermissionControlType((String)formConfig.getEntityTypeId())) != null && permControlType.isAnonymousUserControl())) {
                throw new KDBizException(BosErrorCode.oAuthSecurity, new Object[]{ResManager.loadKDString((String)"guest\u7528\u6237\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u5148\u767b\u5f55\u3002", (String)"FormMetadataProvide_1", (String)BOS_FORM_METADATA, (Object[])new Object[0])});
            }
            String version = this.metadataService.getRuntimeMetadataVersion(formId);
            if (!version.equals(formConfig.getVersion())) {
                this.metadataService.removeCache(formId);
                strConfig = this.metadataService.loadFormConfig(formId);
                formConfig = this.toFormConfig(strConfig);
            }
            return formConfig;
        }
        catch (KDBizException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            String msg = String.format("error:%s,formid:%s,formconfig:%s", e.getMessage(), formId, strConfig);
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{msg});
        }
    }

    private boolean isGuestWhiteList(String formId) {
        log.info("isGuestWhiteList0 : " + formId);
        for (String form : guestFormWhiteList) {
            if (!form.equals(formId)) continue;
            return true;
        }
        String tenantId = RequestContext.get().getTenantId();
        StringBuilder builder = new StringBuilder();
        builder.append("isGuestWhiteList1 : ").append(tenantId);
        String guestForms = SystemPropertyUtils.getProptyByTenant((String)"security.meta.guestwhitelist", (String)tenantId);
        builder.append("isGuestWhiteList2 : ").append(guestForms);
        log.info(builder.toString());
        if (StringUtils.isNotBlank((CharSequence)guestForms)) {
            String[] guestFormArray;
            for (String form : guestFormArray = guestForms.split(",")) {
                if (!form.equals(formId)) continue;
                return true;
            }
        }
        return false;
    }

    public FormConfig toFormConfig(String strConfig) {
        FormConfig formConfig;
        try {
            formConfig = (FormConfig)ControlTypes.fromJsonStringToObj(strConfig);
        }
        catch (Exception e) {
            formConfig = (FormConfig)SerializationUtils.fromJsonString((String)strConfig, FormConfig.class);
        }
        return formConfig;
    }

    @Override
    public FormRoot getRootControl(String formId) {
        String formMetaStr = FormMetadataLocalCache.getRootControl(formId);
        if (formMetaStr == null) {
            formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Form.getValue(), formId);
            if (StringUtils.isBlank((CharSequence)formMetaStr)) {
                throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u4e0d\u5b58\u5728", (String)"FormMetadataProvide_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), formId)});
            }
            FormMetadataLocalCache.putRootControl(formId, formMetaStr);
        } else if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"%s\u8fd0\u884c\u671f\u5143\u6570\u636e\u7f13\u5b58\u88ab\u7834\u574f", (String)"FormMetadataProvide_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), formId)});
        }
        return (FormRoot)ControlTypes.fromJsonString(formMetaStr);
    }

    @Override
    public <T extends Control> T getControl(String formId, String key) {
        String formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Control.getValue(), key);
        return ControlTypes.fromJsonString(formMetaStr);
    }

    @Override
    public Map<String, List<AbstractRule>> getAllEntityRules(String formId) {
        String formRulesStr = FormMetadataLocalCache.getAllEntityRules(formId);
        if (formRulesStr == null) {
            formRulesStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Rule.getValue(), "_formrules");
            if (formRulesStr == null) {
                formRulesStr = "";
            }
            FormMetadataLocalCache.putAllEntityRules(formId, formRulesStr);
        }
        HashMap<String, List<AbstractRule>> mapRules = new HashMap<String, List<AbstractRule>>();
        if (StringUtils.isNotBlank((CharSequence)formRulesStr)) {
            List list = SerializationUtils.fromJsonStringToList((String)formRulesStr, EntityBR.class);
            for (EntityBR ebr : list) {
                ArrayList rules = (ArrayList)mapRules.get(ebr.getKey());
                if (rules == null) {
                    rules = new ArrayList(list.size());
                    mapRules.put(ebr.getKey(), rules);
                }
                rules.addAll(ebr.getRules());
            }
        }
        return mapRules;
    }

    @Override
    public String getFormPluginScripts(String formId, String key) {
        return this.metadataService.loadFormPluginScriptMeta(formId, key);
    }

    @Override
    public FormOperate getFormOperation(String entityId, String operationKey) {
        HashMap<String, Object> op;
        String operateStr = this.metadataService.loadEntityOperationMeta(entityId, operationKey);
        if (!StringUtils.isEmpty((CharSequence)operateStr)) {
            op = (HashMap<String, Object>)SerializationUtils.fromJsonString((String)operateStr, Map.class);
        } else {
            op = new HashMap<String, Object>(16);
            op.put("type", operationKey.toLowerCase());
            op.put("key", operationKey.toLowerCase());
            HashMap<String, String> name = new HashMap<String, String>(16);
            name.put(Locale.getDefault().toString(), operationKey.toLowerCase());
            op.put("name", name);
        }
        return (FormOperate)FormOperateTypes.createFormOperate(op);
    }

    @Override
    public AbstractOperateWebApi getFormOperationApi(String entityId, String operationKey) {
        HashMap<String, String> op;
        String operateStr = this.metadataService.loadEntityOperationMeta(entityId, operationKey);
        if (!StringUtils.isEmpty((CharSequence)operateStr)) {
            op = (HashMap<String, String>)SerializationUtils.fromJsonString((String)operateStr, Map.class);
        } else {
            op = new HashMap<String, String>(16);
            op.put("webapi", operationKey);
        }
        String api = (String)op.get("webapi");
        if (api == null) {
            api = "kd.bos.entity.operate.webapi.DefaultOperate";
        }
        AbstractOperateWebApi operate = (AbstractOperateWebApi)TypesContainer.createInstance((String)api);
        operate.setOperationNumber(operationKey);
        return operate;
    }

    public List<IOperate> getFormAllOperation(String entityId) {
        ArrayList<IOperate> formOperateList = new ArrayList<IOperate>();
        List operateStrList = this.metadataService.loadEntityAllOperationMeta(entityId);
        for (String operateStr : operateStrList) {
            Map op = (Map)SerializationUtils.fromJsonString((String)operateStr, Map.class);
            if (op.isEmpty()) continue;
            IOperate operate = FormOperateTypes.createFormOperate(op);
            formOperateList.add(operate);
        }
        return formOperateList;
    }

    @Override
    public Map<String, Object> getListMeta(String formId) {
        Map runtimeMetaTypeMeta = (HashMap)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, LIST);
        if (runtimeMetaTypeMeta != null) {
            return runtimeMetaTypeMeta;
        }
        String str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.List.getValue(), LIST);
        runtimeMetaTypeMeta = StringUtils.isBlank((CharSequence)str) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, LIST, runtimeMetaTypeMeta);
        return runtimeMetaTypeMeta;
    }

    @Override
    public Map<String, Object> getMobListMeta(String formId) {
        Map runtimeMetaTypeMeta = (HashMap)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.MobList, LIST);
        if (runtimeMetaTypeMeta != null) {
            return runtimeMetaTypeMeta;
        }
        String str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.MobList.getValue(), LIST);
        runtimeMetaTypeMeta = StringUtils.isBlank((CharSequence)str) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.MobList, LIST, runtimeMetaTypeMeta);
        return runtimeMetaTypeMeta;
    }

    @Override
    public Map<String, Object> getListToolBar(String formId) {
        Map runtimeMetaTypeMeta = (HashMap)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, TOOL_BAR);
        if (runtimeMetaTypeMeta != null) {
            return runtimeMetaTypeMeta;
        }
        String str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.List.getValue(), TOOL_BAR);
        runtimeMetaTypeMeta = StringUtils.isBlank((CharSequence)str) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, TOOL_BAR, runtimeMetaTypeMeta);
        return runtimeMetaTypeMeta;
    }

    @Override
    public Object getListQingView(String billFormId) {
        String str = (String)FormMetadataLocalCache.getRuntimeMetaTypeMeta(billFormId, RuntimeMetaType.List, QINGVIEW2);
        if (StringUtils.isBlank((CharSequence)str)) {
            str = this.metadataService.loadFormRuntimeMeta(billFormId, RuntimeMetaType.List.getValue(), QINGVIEW2);
            if (StringUtils.isBlank((CharSequence)str)) {
                return null;
            }
            FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(billFormId, RuntimeMetaType.List, QINGVIEW2, str);
        }
        return ControlTypes.fromJsonString(str);
    }

    @Override
    public Map<String, Object> getFilterMeta(String formId) {
        Map runtimeMetaTypeMeta = (HashMap)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, FILTER);
        if (runtimeMetaTypeMeta != null) {
            return runtimeMetaTypeMeta;
        }
        String str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.List.getValue(), FILTER);
        runtimeMetaTypeMeta = StringUtils.isBlank((CharSequence)str) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, FILTER, runtimeMetaTypeMeta);
        return runtimeMetaTypeMeta;
    }

    @Override
    public FormConfig getListFormConfig(String formId) {
        String str = (String)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, CONFIG);
        if (str == null) {
            str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.List.getValue(), CONFIG);
            if (str == null) {
                str = "";
            }
            FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.List, CONFIG, str);
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return this.toFormConfig(str);
    }

    @Override
    public FormConfig getMobListFormConfig(String formId) {
        String str = (String)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.MobList, CONFIG);
        if (str == null) {
            str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.MobList.getValue(), CONFIG);
            if (str == null) {
                str = "";
            }
            FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.MobList, CONFIG, str);
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return (FormConfig)SerializationUtils.fromJsonString((String)str, FormConfig.class);
    }

    @Override
    public List<String> getHeadDecimalFields(String formId) {
        String formMetaStr = (String)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.DecimalFields);
        if (formMetaStr == null) {
            formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.DecimalFields.getValue(), formId);
            if (formMetaStr == null) {
                formMetaStr = "";
            }
            FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.DecimalFields, formMetaStr);
        }
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            return new ArrayList<String>(0);
        }
        return SerializationUtils.fromJsonStringToList((String)formMetaStr, String.class);
    }

    @Override
    public List<String> getHeadDateTimeFields(String formId) {
        String formMetaStr = (String)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.DateTimeFields);
        if (formMetaStr == null) {
            formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.DateTimeFields.getValue(), formId);
            if (formMetaStr == null) {
                formMetaStr = "";
            }
            FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.DateTimeFields, formMetaStr);
        }
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            return new ArrayList<String>(0);
        }
        return SerializationUtils.fromJsonStringToList((String)formMetaStr, String.class);
    }

    @Override
    public Map<String, Object> getMobFilterMeta(String formId) {
        Map runtimeMetaTypeMeta = (HashMap)FormMetadataLocalCache.getRuntimeMetaTypeMeta(formId, RuntimeMetaType.MobList, FILTER);
        if (runtimeMetaTypeMeta != null) {
            return runtimeMetaTypeMeta;
        }
        String str = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.MobList.getValue(), FILTER);
        runtimeMetaTypeMeta = StringUtils.isBlank((CharSequence)str) ? new HashMap(0) : (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        FormMetadataLocalCache.cacheRuntimeMetaTypeMeta(formId, RuntimeMetaType.MobList, FILTER, runtimeMetaTypeMeta);
        return runtimeMetaTypeMeta;
    }

    @Override
    public BinderMap getBinderMap(String formId) {
        String formMetaStr = this.metadataService.loadFormRuntimeMeta(formId, RuntimeMetaType.Control.getValue(), "_bindermap_");
        if (StringUtils.isBlank((CharSequence)formMetaStr)) {
            return null;
        }
        return (BinderMap)ControlTypes.fromJsonString(formMetaStr);
    }
}

