/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheData;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.CloudInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorPageCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.AnimationType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameterBuilder;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.QingCachedFormParameter;
import kd.bos.form.ShowType;
import kd.bos.form.dynplugin.FormDynamicProxyPluginFactory;
import kd.bos.form.dynplugin.KingScriptFormDynamicProxyPlugin;
import kd.bos.form.dynplugin.KingScriptFormDynamicProxyPluginFactory;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.LoadWaterMarkInfoEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.rule.DecodeRulesHandle;
import kd.bos.form.watermark.WaterMark;
import kd.bos.inte.api.IInteService;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.SelectedRowCondition;
import kd.bos.list.SelectedRowValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.mservice.image.IImageService;
import kd.bos.mservice.svc.watermark.IWaterMarkProxy;
import kd.bos.param.service.IParameterReaderService;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.share.ShareInfo;
import kd.bos.share.ShareUrlService;
import kd.bos.url.UrlService;
import kd.bos.utils.TabLayoutUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;

@KSObject
@SdkPublic
public class FormShowParameter
implements Serializable {
    private static final long serialVersionUID = 8537231501643197810L;
    protected static final String FORM_SETTING = "FormSetting";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final Log log = LogFactory.getLog((String)"FormShowParameter");
    private boolean debugModel;
    private String parentFormId;
    private String formId;
    private OpenStyle openStyle;
    private String parentPageId;
    private String pageId;
    protected String appId;
    private String rootPageId;
    private Map<String, Object> customParams = new HashMap<String, Object>();
    private Map<String, Object> clientParams = new HashMap<String, Object>();
    private String caption;
    private String subSystemId;
    private AnimationType animationType = AnimationType.none;
    private boolean is_ShowTitle = true;
    private boolean is_ShowClose = true;
    private boolean is_ListentimerElapsed = false;
    protected FormConfig formConfig;
    private boolean hasRight;
    private String permissionItemId;
    private int cancelRight;
    private boolean cancelDataRight;
    private CloseCallBack closeCallBack;
    private long cacheExpireTime;
    private boolean sendToClient;
    private boolean is_ShowFullScreen;
    private boolean showWaterMark = Boolean.TRUE;
    private String shareId;
    protected OperationStatus status = OperationStatus.ADDNEW;
    private boolean is_Initialized;
    private static final String CONSTANT_FORMID = "formId";
    private static final String CONSTANT_APPID = "appId";
    private static final String MAINPAGEID = "mainPageId";
    private static final String PATCHVERSION = "patchVersion";
    private static final String COSMIC_BIZ = "cosmic_biz";
    private static final String COSMIC_BOS = "cosmic_bos";
    private static Map<String, Class<?>> ptypes = new HashMap();
    private String sessionId;
    private static final String NUMBER = "number";
    private static final String PHONE = "phone";
    private static final String PARAMKEY_CAPTION = "caption";
    private static Set<String> bampMoveAppList = new HashSet<String>(7);
    protected transient FormShowParameterBuilder formShowParameterBuilder;
    private transient boolean isFormShowParameterBuilderInit = false;
    private int invokeTimeout = 180000;
    private static final int DEF_INVOKE_TIMEOUT = 180000;

    public static void putPTypes(String name, Class<?> classz) {
        if (ptypes == null) {
            ptypes = new HashMap();
        }
        ptypes.put(name, classz);
    }

    private FormShowParameterBuilder getBuilder() {
        if (this.formShowParameterBuilder == null && !this.isFormShowParameterBuilderInit) {
            this.formShowParameterBuilder = FormShowParameterBuilder.create(this.getClass().getSimpleName());
            if (this.formShowParameterBuilder != null) {
                this.formShowParameterBuilder.setFormShowParameter(this);
            }
            this.isFormShowParameterBuilderInit = true;
        }
        return this.formShowParameterBuilder;
    }

    @SdkInternal
    public String toString() {
        return FormShowParameter.toJsonString(this);
    }

    @SdkInternal
    public static String toJsonString(FormShowParameter type) {
        return ControlTypes.toJsonString(type);
    }

    @SdkInternal
    public static FormShowParameter fromJsonString(String str) {
        return (FormShowParameter)ControlTypes.fromJsonStringToObj(str);
    }

    public void addCustPlugin(String pluginClassName) {
        try (EntityTraceSpan span = EntityTracer.create((String)"formshowparameter", (String)"addCustPlugin");){
            span.addLocaleTag("pluginName", (Object)pluginClassName);
            Plugin plugin = new Plugin();
            plugin.setDynamicPlugin(true);
            plugin.setClassName(pluginClassName);
            this.initFormConfig();
            this.formConfig.getPlugins().add(plugin);
        }
    }

    @SdkInternal
    public List<IFormPlugin> createPlugin() {
        return this.formConfig.createPlugin(this.getScriptPluginClass(), this.getFormId());
    }

    @SdkInternal
    public static FormShowParameter createFormShowParameter(Map<String, Object> openParameter) {
        FormShowParameter showParameter;
        String billFormId;
        String formId = (String)openParameter.get(CONSTANT_FORMID);
        String type = (String)openParameter.get("type");
        if ("list".equals(type)) {
            ListShowParameter lShowParameter = new ListShowParameter();
            billFormId = (String)openParameter.get("billFormId");
            lShowParameter.setBillFormId(billFormId);
            FormShowParameter.setListShowParameter(openParameter, lShowParameter);
            showParameter = lShowParameter;
        } else if ("mobilelist".equals(type)) {
            MobileListShowParameter mlShowParameter = new MobileListShowParameter();
            billFormId = (String)openParameter.get("billFormId");
            mlShowParameter.setBillFormId(billFormId);
            showParameter = mlShowParameter;
        } else {
            if (openParameter.get(CONSTANT_FORMID) == null) {
                throw new KDException(BosErrorCode.variableNotFound, new Object[0]);
            }
            FormConfig formConfig = FormMetadataCache.getFormConfig(formId);
            type = formConfig.getModelType();
            if (type == null) {
                type = "form";
            }
            Class<?> clasz = ptypes.get(type);
            showParameter = (FormShowParameter)TypesContainer.createInstance(clasz);
            String pkId = (String)openParameter.get("pkId");
            if (StringUtils.isNotEmpty((CharSequence)pkId)) {
                String status = (String)openParameter.get("Status");
                showParameter.status = Integer.toString(OperationStatus.VIEW.getValue()).equals(status) ? OperationStatus.VIEW : OperationStatus.EDIT;
            }
            if (!type.equals("list")) {
                showParameter.setFormConfig(formConfig);
            }
        }
        if (openParameter.get("flag") != null) {
            FormShowParameter.setShareFlag(openParameter, formId, showParameter);
        }
        try {
            Object closeCallBackVals;
            openParameter.remove(CONSTANT_APPID);
            openParameter.remove("appid");
            openParameter.remove("ticket");
            Object status = openParameter.get("status");
            if (status instanceof String) {
                if (OperationStatus.VIEW.toString().equals(status)) {
                    showParameter.status = OperationStatus.VIEW;
                } else if (OperationStatus.ADDNEW.toString().equals(status)) {
                    showParameter.status = OperationStatus.ADDNEW;
                } else if (OperationStatus.EDIT.toString().equals(status)) {
                    showParameter.status = OperationStatus.EDIT;
                }
                openParameter.remove("status");
            }
            String appId = (String)openParameter.remove("app");
            Object ocp = openParameter.get("customParams");
            if (ocp instanceof String) {
                String strcp = URLDecoder.decode((String)ocp, "UTF-8");
                Map cp = (Map)SerializationUtils.fromJsonString((String)strcp, Map.class);
                showParameter.getCustomParams().putAll(cp);
                openParameter.remove("customParams");
            }
            if ((closeCallBackVals = openParameter.get("closeCallBack")) != null) {
                ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(1);
                dataEntityTypes.add(OrmUtils.getDataEntityType(CloseCallBack.class));
                DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
                CloseCallBack closeCallBack = (CloseCallBack)dcJsonSerializer.deserializeFromString(closeCallBackVals.toString(), null);
                showParameter.setCloseCallBack(closeCallBack);
                openParameter.remove("closeCallBack");
            }
            BeanUtils.copyProperties((Object)showParameter, openParameter);
            Object captionStr = FormShowParameter.getCaptionStrFromOpenParam(openParameter);
            if (!ObjectUtils.isEmpty((Object)captionStr)) {
                showParameter.setCaption(captionStr.toString());
            }
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                showParameter.setAppId(appId);
            }
            if (openParameter != null && openParameter.size() > 0) {
                for (String propName : openParameter.keySet()) {
                    boolean writable = BeanUtilsBean.getInstance().getPropertyUtils().isWriteable((Object)showParameter, propName);
                    if (writable) continue;
                    showParameter.setCustomParam(propName, openParameter.get(propName));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return showParameter;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getFormId() {
        return this.formId;
    }

    @KSMethod
    public void setFormId(String value) {
        this.formId = value.toLowerCase();
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getParentFormId() {
        return this.parentFormId;
    }

    @KSMethod
    public void setParentFormId(String parentFormId) {
        this.parentFormId = parentFormId;
    }

    @SimplePropertyAttribute
    @KSMethod
    public final String getParentPageId() {
        return this.parentPageId;
    }

    @KSMethod
    public final void setParentPageId(String value) {
        this.parentPageId = value;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceAppId() {
        String serviceAppId = "";
        serviceAppId = StringUtils.isNotBlank((CharSequence)((CharSequence)this.getCustomParam("ServiceAppId"))) ? (String)this.getCustomParam("ServiceAppId") : (this.formConfig != null ? ((serviceAppId = this.formConfig.getAppId()) == null ? "bos" : serviceAppId) : FormMetadataCache.getFormAppId(this.getFormId()));
        serviceAppId = this.convertBOSAppId(serviceAppId);
        return serviceAppId;
    }

    protected String convertBOSAppId(String serviceAppId) {
        AppInfo appInfo;
        if ("bos".equals(serviceAppId) && this.appId != null && (appInfo = EntityMetadataCache.getAppInfo((String)this.appId)) != null && !BOSRuntime.isBOSCloud((String)appInfo.getCloudId()) && !CloudInfo.isVirtualCloud((String)appInfo.getCloudId()) && !this.isBAMPMoveApp(appInfo.getNumber())) {
            serviceAppId = appInfo.getNumber();
        }
        return serviceAppId;
    }

    private boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    public String getCheckRightAppId() {
        String checkRightAppId = null;
        if (this.customParams.containsKey("checkRightAppId")) {
            checkRightAppId = (String)this.getCustomParam("checkRightAppId");
        }
        if (StringUtils.isBlank(checkRightAppId)) {
            checkRightAppId = this.appId;
        }
        return checkRightAppId;
    }

    @SimplePropertyAttribute
    @KSMethod
    public final String getPageId() {
        if (StringUtils.isBlank((CharSequence)this.pageId)) {
            this.pageId = UUID.randomUUID().toString().replace("-", "").replace("#", "");
            if (this.getOpenStyle().getShowType() == ShowType.NewWindow || this.getOpenStyle().getShowType() == ShowType.IFrame) {
                this.rootPageId = this.pageId = "root" + this.pageId;
            }
        }
        return this.pageId;
    }

    @KSMethod
    public final void setPageId(String value) {
        this.pageId = value;
    }

    @SimplePropertyAttribute
    @SdkInternal
    public final String getSessionId() {
        if (StringUtils.isBlank((CharSequence)this.sessionId) && RequestContext.get() != null) {
            this.sessionId = RequestContext.get().getGlobalSessionId();
        }
        return this.sessionId;
    }

    @SdkInternal
    public final void setSessionId(String value) {
        this.sessionId = value;
    }

    @SimplePropertyAttribute
    @KSMethod
    public final Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    @KSMethod
    public void setCustomParams(Map<String, Object> value) {
        if (this.is_Initialized) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u53c2\u6570\u5bf9\u8c61\uff0c\u8bf7\u4f7f\u7528 setCustomParam\u65b9\u6cd5", (String)"FormShowParameter_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
        if (value != null) {
            this.customParams = value;
        }
    }

    @SimplePropertyAttribute
    @KSMethod
    public final String getCaption() {
        return this.caption;
    }

    @KSMethod
    public final void setCaption(String value) {
        this.caption = value;
    }

    @KSMethod
    public String getFormName() {
        if (StringUtils.isNotBlank((CharSequence)this.getCaption())) {
            return this.getCaption();
        }
        return this.getFormConfig().getCaption() == null ? "" : this.getFormConfig().getCaption().toString();
    }

    @SdkInternal
    public String getIdentifyFormId() {
        return this.getFormId();
    }

    @SimplePropertyAttribute
    @SdkInternal
    public final String getSubSystemId() {
        return this.subSystemId;
    }

    @SdkInternal
    public final void setSubSystemId(String value) {
        this.subSystemId = value;
    }

    public FormShowParameter() {
        this.openStyle = new OpenStyle();
    }

    @ComplexPropertyAttribute
    @KSMethod
    public OpenStyle getOpenStyle() {
        return this.openStyle;
    }

    public void setOpenStyle(OpenStyle value) {
        this.openStyle = value;
    }

    @ComplexPropertyAttribute
    @KSMethod
    @SdkInternal
    public FormConfig getFormConfig() {
        return this.formConfig;
    }

    @SdkInternal
    public FormShowParameter getShowParameter() {
        return this;
    }

    @SdkInternal
    public void setFormConfig(FormConfig config) {
        this.formConfig = config;
    }

    @KSMethod
    public boolean isShowTitle() {
        return this.is_ShowTitle;
    }

    @KSMethod
    public void setShowTitle(boolean isShowTitle) {
        this.is_ShowTitle = isShowTitle;
    }

    public boolean isShowClose() {
        return this.is_ShowClose;
    }

    public void setShowClose(boolean showClose) {
        this.is_ShowClose = showClose;
    }

    @SimplePropertyAttribute(name="isShowFullScreen")
    public boolean isShowFullScreen() {
        return this.is_ShowFullScreen;
    }

    public void setShowFullScreen(boolean isShowFullScreen) {
        this.is_ShowFullScreen = isShowFullScreen;
    }

    public boolean isShowWaterMark() {
        return this.showWaterMark;
    }

    public void setShowWaterMark(boolean showWaterMark) {
        this.showWaterMark = showWaterMark;
    }

    @SimplePropertyAttribute
    public String getShareId() {
        return this.shareId;
    }

    public void setShareId(String shareId) {
        this.shareId = shareId;
    }

    @SdkInternal
    public Map<String, Object> createClientConfig(Map<String, Object> settting) {
        this.initFormConfig();
        if (this.formConfig != null) {
            this.addDynamicProxyPlugin();
            this.registerKingScriptDynamicPlugin();
        }
        HashMap<String, Object> config = new HashMap<String, Object>(16);
        List<IFormPlugin> plugins = this.getFormConfig().createPlugin(this.getScriptPluginClass(), this.getFormId());
        boolean notShowForm = this.couldnotShowForm(plugins, config);
        if (StringUtils.isNotBlank((CharSequence)this.getCaption())) {
            config.put(PARAMKEY_CAPTION, new LocaleString(this.getCaption()));
        } else {
            config.put(PARAMKEY_CAPTION, this.getFormConfig().getCaption());
        }
        if (notShowForm) {
            config.put("errorCode", ErrorPageCode.ERROR_403);
            return config;
        }
        IParameterReaderService parameterReaderService = (IParameterReaderService)ServiceSvcFactory.getService(IParameterReaderService.class);
        Map paramData = parameterReaderService.loadPublicParameterFromCache();
        if (paramData != null && paramData.containsKey("file_edit_mode") && StringUtils.isNotBlank(paramData.get("file_edit_mode"))) {
            config.put("officeEditMode", paramData.get("file_edit_mode"));
        }
        config.put("parentPageId", this.getParentPageId());
        config.put("pageId", this.getPageId());
        config.put(CONSTANT_APPID, this.getServiceAppId());
        if (this.getCustomParam(MAINPAGEID) != null) {
            config.put(MAINPAGEID, this.getCustomParam(MAINPAGEID));
        }
        if (this.status != OperationStatus.ADDNEW) {
            config.put("status", this.status.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCaption())) {
            config.put(PARAMKEY_CAPTION, new LocaleString(this.getCaption()));
        } else {
            config.put(PARAMKEY_CAPTION, this.getFormConfig().getCaption());
        }
        if (this.animationType != AnimationType.none) {
            config.put("animation", (Object)this.animationType);
        }
        if (this.openStyle.getInlineStyleCss() != null && this.openStyle.getInlineStyleCss().getWidth() != null) {
            config.put("width", this.openStyle.getInlineStyleCss().getWidth());
        } else if (this.formConfig.getWidth() != null) {
            config.put("width", this.getFormConfig().getWidth().toString());
        }
        if (this.openStyle.getInlineStyleCss() != null && this.openStyle.getInlineStyleCss().getHeight() != null) {
            config.put("height", this.openStyle.getInlineStyleCss().getHeight());
        } else if (this.formConfig.getHeight() != null) {
            config.put("height", this.getFormConfig().getHeight().toString());
        }
        if (!this.formConfig.isShowTitle()) {
            config.put("isShowTitle", this.getFormConfig().isShowTitle());
        }
        if (!this.is_ShowTitle) {
            config.put("isShowTitle", this.is_ShowTitle);
        }
        if (!this.is_ShowClose) {
            config.put("isShowClose", false);
        }
        config.put(CONSTANT_FORMID, this.getFormId());
        config.put("version", this.formConfig.getVersion());
        config.put("type", "kdform");
        if (this.isBOSDesigner()) {
            config.put("isCosmicUI", true);
        }
        this.loadCustomControlMetas(plugins, config);
        config.put("openStyle", this.openStyle.getConfig());
        if (this.clientParams.size() > 0) {
            config.put("clientParams", this.clientParams);
        }
        HashMap<String, Map> fmtInfo = new HashMap<String, Map>();
        Map<String, Object> numFmtInfo = this.getNumFmtInfo();
        fmtInfo.put("numFmtInfo", numFmtInfo);
        if (this.getPageId().equals(this.getRootPageId()) || this.getOpenStyle().getClientShowType() == ShowType.ReplaceHomePage) {
            fmtInfo.put("userFmtInfo", this.getFmtInfo());
            fmtInfo.put("_MainCurrency_", FmtInfoUtils.getMainCurrencyFmt());
            IAttachmentService attService = (IAttachmentService)ServiceFactory.getService(IAttachmentService.class);
            config.putAll(attService.getAttSetting());
            config.put("i18nUserInfo", this.getI18nUserInfo());
        }
        config.put("fmtInfo", fmtInfo);
        String mobDomainUrl = UrlService.getMobileDomainContextUrl();
        config.put("mobdomainurl", mobDomainUrl);
        String imageFullUrl = UrlService.getCheckAuthImageUrl((String)"");
        String fileServerUrl = UrlService.getCheckAuthImageUrl((String)"");
        config.put("fileserver", fileServerUrl);
        config.put("imageurl", imageFullUrl);
        String imageVersion = System.getProperty("imageserver.imageversion");
        if (StringUtils.isEmpty((CharSequence)imageVersion)) {
            config.put("imgversion", "0.5");
        } else {
            config.put("imgversion", imageVersion);
        }
        if (this.isShowFullScreen()) {
            config.put("isShowFullScreen", this.isShowFullScreen());
        }
        RequestContext rc = RequestContext.get();
        String wsurl = System.getProperty("websocket.wsurl");
        HashMap<String, String> wsconfig = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)wsurl)) {
            wsurl = UrlService.getWebSocketPreUrl();
        }
        wsconfig.put("wsurl", wsurl);
        config.put("wsconfig", wsconfig);
        String attachmentfileServerUrl = UrlService.getAttachmentFullUrl((String)"");
        config.put("attachmentserver", attachmentfileServerUrl);
        config.putAll(this.getImageSetting());
        this.loadWaterMarkInfo(plugins, config);
        this.loadTabLayout(config);
        config.put("bizAppId", this.getAppId());
        config.put("publicKey", DecodeRulesHandle.getRsaPublicKey());
        config.put("kdEncoding", this.formConfig.getKdEncoding());
        config.put("invokeTimeout", this.getInvokeTimeout());
        return this.callBuilderFunc(() -> this.formShowParameterBuilder.createClientConfig(config), () -> config);
    }

    private Map<String, Object> getImageSetting() {
        IImageService iImageService = (IImageService)ServiceFactory.getService(IImageService.class);
        Map imageSetting = iImageService.getImageSetting();
        return imageSetting;
    }

    private FileService getFileService() {
        return FileServiceFactory.getAttachmentFileService();
    }

    private Map<String, Object> getFmtInfo() {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        Map fmt = inteService.getUserFormFormat(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
        return fmt;
    }

    private Map<String, Object> getI18nUserInfo() {
        IInteService inteService = (IInteService)ServiceFactory.getService(IInteService.class);
        return inteService.getUserInfo(Long.valueOf(Long.parseLong(RequestContext.get().getUserId())));
    }

    private void loadCustomControlMetas(List<IFormPlugin> plugins, Map<String, Object> config) {
        LoadCustomControlMetasArgs e = new LoadCustomControlMetasArgs(this, config);
        for (IFormPlugin plugIn : plugins) {
            plugIn.loadCustomControlMetas(e);
        }
        List<Map<String, Object>> items = e.getItems();
        HashMap<String, List<Map<String, Object>>> metas = new HashMap<String, List<Map<String, Object>>>(2);
        if (e.getInvisibleInstructions().size() > 0) {
            metas.put("invisible", e.getInvisibleInstructions());
        }
        if (items.size() > 0) {
            metas.put("items", items);
        }
        if (!metas.isEmpty()) {
            config.put("metas", metas);
        }
    }

    protected boolean couldnotShowForm(List<IFormPlugin> plugins, Map<String, Object> config) {
        PreOpenFormEventArgs e = new PreOpenFormEventArgs(this);
        for (IFormPlugin plugIn : plugins) {
            plugIn.preOpenForm(e);
        }
        if (e.isCancel()) {
            config.put("cancel", true);
            config.put("cancelMessage", e.getCancelMessage());
            if (StringUtils.isNotEmpty((CharSequence)e.getCancelFormShowParameter())) {
                config.put("cancelFormShowParameter", e.getCancelFormShowParameter());
            }
            return true;
        }
        return false;
    }

    @SdkInternal
    protected Class<?> getScriptPluginClass() {
        return FormConfig.class;
    }

    private Map<String, Object> getNumFmtInfo() {
        HashMap<String, Object> numFmtInfo = new HashMap<String, Object>();
        numFmtInfo.put("nds", ".");
        numFmtInfo.put("ngs", ",");
        numFmtInfo.put("cnp", "-");
        numFmtInfo.put("cpp", "");
        numFmtInfo.put("nsi", "");
        return numFmtInfo;
    }

    @SdkInternal
    public void initFormConfig() {
        if (this.formConfig == null) {
            this.getFormConfigFromMeta();
        }
    }

    private void addDynamicProxyPlugin() {
        if (this.formConfig != null) {
            Plugin dynProxyPlugin = this.getDynProxyPlugin();
            List<Plugin> plugins = this.formConfig.getPlugins();
            for (int i = plugins.size() - 1; i >= 0; --i) {
                Plugin plugin = plugins.get(i);
                if (plugin == null || !StringUtils.isNotEmpty((CharSequence)plugin.getClassName()) || !plugin.getClassName().equals(dynProxyPlugin.getClassName())) continue;
                return;
            }
            plugins.add(dynProxyPlugin);
        }
    }

    @SdkInternal
    public Plugin getDynProxyPlugin() {
        return FormDynamicProxyPluginFactory.getProxyPlugin("1", "1", this.formConfig.getPlugins().size() + 1);
    }

    @SdkInternal
    protected void registerKingScriptDynamicPlugin() {
        KingScriptFormDynamicProxyPlugin proxyPlugin = KingScriptFormDynamicProxyPluginFactory.create(KingScriptFormDynamicProxyPluginFactory.PluginObject.createFormPluginProxy(this.formConfig.getPlugins(), this.getFormId(), false));
        proxyPlugin.register();
    }

    protected void getFormConfigFromMeta() {
        FormConfig fConfig = FormMetadataCache.getFormConfig(this.getFormId());
        this.setFormConfig(fConfig);
    }

    @SdkInternal
    public IFormView createView() {
        IFormView formView = (IFormView)TypesContainer.createInstance((String)this.getViewClassImpl());
        return formView;
    }

    public IFormView createViewForWebApi() {
        throw new RuntimeException("Form  no suport WebApi");
    }

    private String getViewClassImpl() {
        return this.callBuilderFunc(() -> this.formShowParameterBuilder.getViewClass(), this::getViewClass);
    }

    @SdkInternal
    protected String getViewClass() {
        return "kd.bos.mvc.form.FormView";
    }

    protected <R> R callBuilderFunc(Supplier<R> builderFunc, Supplier<R> defaultFunc) {
        R r = null;
        if (this.getBuilder() != null) {
            r = builderFunc.get();
        }
        if (r == null && defaultFunc != null) {
            r = defaultFunc.get();
        }
        return r;
    }

    @ComplexPropertyAttribute
    @KSMethod
    public CloseCallBack getCloseCallBack() {
        return this.closeCallBack;
    }

    @KSMethod
    public void setCloseCallBack(CloseCallBack closeCallBack) {
        this.closeCallBack = closeCallBack;
    }

    @KSMethod
    public <T> T getCustomParam(String name) {
        return (T)this.customParams.get(name);
    }

    @KSMethod
    public void setCustomParam(String name, Object value) {
        this.customParams.put(name, value);
    }

    @KSMethod
    public void setClientParam(String name, Object value) {
        this.clientParams.put(name, value);
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getRootPageId() {
        return this.rootPageId;
    }

    public void setRootPageId(String rootPageId) {
        this.rootPageId = rootPageId;
    }

    @KSMethod
    public OperationStatus getStatus() {
        return this.status;
    }

    @KSMethod
    public void setStatus(OperationStatus value) {
        this.status = value;
    }

    @SdkInternal
    @SimplePropertyAttribute
    public int getStatusValue() {
        return this.status.getValue();
    }

    @SdkInternal
    public void setStatusValue(int statusValue) {
        this.status = OperationStatus.forValue(statusValue);
    }

    public String getSettingKey() {
        return this.getFormId() + "." + FORM_SETTING;
    }

    @SdkInternal
    public void beginInit() {
        this.is_Initialized = false;
    }

    @SdkInternal
    public void endInit() {
        this.is_Initialized = true;
    }

    @SdkInternal
    public boolean isInitialized() {
        return this.is_Initialized;
    }

    @SdkInternal
    public boolean isListentimerElapsed() {
        return this.is_ListentimerElapsed;
    }

    @SdkInternal
    public void setListentimerElapsed(boolean isListentimerElapsed) {
        this.is_ListentimerElapsed = isListentimerElapsed;
    }

    @SimplePropertyAttribute(name="DebugModel")
    public boolean isDebugModel() {
        return this.debugModel;
    }

    public void setDebugModel(boolean debugModel) {
        this.debugModel = debugModel;
    }

    public AnimationType getAnimationType() {
        return this.animationType;
    }

    public void setAnimationType(AnimationType animationType) {
        this.animationType = animationType;
    }

    @SimplePropertyAttribute(name="HasRight")
    public boolean isHasRight() {
        return this.hasRight;
    }

    public void setHasRight(boolean hasRight) {
        this.hasRight = hasRight;
    }

    @SimplePropertyAttribute(name="CancelRight")
    public int getCancelRight() {
        return this.cancelRight;
    }

    public void setCancelRight(int cancelRight) {
        this.cancelRight = cancelRight;
    }

    @SimplePropertyAttribute(name="CancelDataRight")
    public boolean isCancelDataRight() {
        return this.cancelDataRight;
    }

    public void setCancelDataRight(boolean cancelDataRight) {
        this.cancelDataRight = cancelDataRight;
    }

    public String getPermissionItemId() {
        return StringUtils.isBlank((CharSequence)this.permissionItemId) ? "47150e89000000ac" : this.permissionItemId;
    }

    public void setPermissionItemId(String permissionItemId) {
        this.permissionItemId = permissionItemId;
    }

    @SimplePropertyAttribute
    @SdkInternal
    public long getCacheExpireTime() {
        return this.cacheExpireTime;
    }

    @SdkInternal
    public void setCacheExpireTime(long cacheExpireTime) {
        this.cacheExpireTime = cacheExpireTime;
    }

    @SdkInternal
    public boolean isMeetExpireThreshold() {
        long expireThreshold = System.currentTimeMillis() - this.cacheExpireTime;
        SecureRandom random = new SecureRandom();
        Double val = random.nextDouble() + 1.2;
        return (double)expireThreshold > (double)CacheKeyUtil.getPageCacheKeyTimeout() / val * 1000.0;
    }

    @SdkInternal
    public QingCachedFormParameter createQingCachedFormParameter() {
        return new QingCachedFormParameter(this.getFormId(), this.getAppId(), this.getCaption(), this.getCustomParams());
    }

    @SdkInternal
    public boolean isSendToClient() {
        return this.sendToClient;
    }

    @KSMethod
    public void setSendToClient(boolean sendToClient) {
        if ("true".equals(System.getProperty("allowformsendToClient")) || "true".equals(System.getProperty("audit.enable"))) {
            this.sendToClient = sendToClient;
        }
    }

    private void loadWaterMarkInfo(List<IFormPlugin> plugins, Map<String, Object> config) {
        try (EntityTraceSpan span = EntityTracer.create((String)"formshowparameter", (String)"loadWaterMarkInfo");){
            StringBuilder builder = new StringBuilder();
            builder.append("loadWaterMarkInfo  start ").append("\n");
            if (!this.showWaterMark) {
                return;
            }
            LoadWaterMarkInfoEventArgs e = new LoadWaterMarkInfoEventArgs((Object)this);
            WaterMark waterMark = null;
            for (IFormPlugin plugIn : plugins) {
                plugIn.setWaterMarkInfo(e);
            }
            if (e.getWaterMark() != null) {
                waterMark = e.getWaterMark();
                builder.append("LoadWaterMarkInfoEventArgs getWaterMark is --- ").append(SerializationUtils.toJsonString((Object)waterMark)).append("\n");
            } else {
                waterMark = this.getWaterMarkInfoFromSetting();
                builder.append("getWaterMarkInfoFromSetting is --- ").append(SerializationUtils.toJsonString((Object)waterMark)).append("\n");
            }
            IWaterMarkProxy wmservice = (IWaterMarkProxy)ServiceFactory.getService(IWaterMarkProxy.class);
            waterMark = wmservice.setWaterMarkText(waterMark);
            config.put("watermark", waterMark);
            builder.append("return final result is --- ").append("SerializationUtils.toJsonString(waterMark)").append("\n");
            if (span.isRealtime()) {
                span.addTag("loadWaterMarkInfoLog", builder.toString());
            }
        }
    }

    private WaterMark getWaterMarkInfoFromSetting() {
        String formPkId = this.formConfig.getEntityTypeId();
        if (this instanceof ListShowParameter) {
            formPkId = ((ListShowParameter)this).getBillFormId();
        }
        if (StringUtils.isEmpty((CharSequence)formPkId)) {
            formPkId = this.formId;
        }
        log.debug("getWaterMarkInfoFromSetting formId is " + formPkId);
        if (StringUtils.isEmpty((CharSequence)formPkId)) {
            return null;
        }
        IWaterMarkProxy wmservice = (IWaterMarkProxy)ServiceFactory.getService(IWaterMarkProxy.class);
        return wmservice.loadFromCache(formPkId);
    }

    private void loadTabLayout(Map<String, Object> config) {
        if (!this.formConfig.isTabLayout()) {
            return;
        }
        if (TabLayoutUtil.enable()) {
            config.put("minorVersion", System.currentTimeMillis());
        }
    }

    private boolean isBOSDesigner() {
        return "ide_formdesigner".equals(this.getFormId()) || "ide_printdesigner".equals(this.getFormId());
    }

    private static Object getCaptionStrFromOpenParam(Map<String, Object> openParameter) {
        if (openParameter.get(PARAMKEY_CAPTION) == null) {
            return null;
        }
        if (openParameter.get(PARAMKEY_CAPTION) instanceof String) {
            return openParameter.get(PARAMKEY_CAPTION).toString();
        }
        if (openParameter.get(PARAMKEY_CAPTION) instanceof Map) {
            Map captionMap = (Map)openParameter.get(PARAMKEY_CAPTION);
            Object str = captionMap.get(Lang.get().toString());
            return captionMap.get(Lang.get().toString()) == null ? captionMap.get(Lang.zh_CN.toString()) : str;
        }
        return null;
    }

    private static void setShareFlag(Map<String, Object> openParameter, String formId, FormShowParameter showParameter) {
        ShareInfo shareInfo;
        String shareFlag;
        String flag = String.valueOf(openParameter.get("flag"));
        if (StringUtils.isNotBlank((CharSequence)flag) && StringUtils.isNotBlank((CharSequence)(shareFlag = CacheData.getAttribute((String)"flag", (String)(formId + flag)))) && (shareInfo = ShareUrlService.getShareInfo((String)shareFlag)) != null) {
            openParameter.put(CONSTANT_FORMID, formId);
            openParameter.put("pkId", shareInfo.getPkId());
            openParameter.put("Status", "2");
            showParameter.getCustomParams().put("isIgnoreLicense", true);
            showParameter.setShareId(shareFlag);
        }
    }

    public int getInvokeTimeout() {
        if (this.invokeTimeout == 180000 && ("pc_main_console".equals(this.getFormId()) || "home_page".equals(this.getFormId()))) {
            return 300;
        }
        return this.invokeTimeout;
    }

    public void setInvokeTimeout(int timeout) {
        this.invokeTimeout = timeout;
    }

    public boolean isRuntimeMetaChanged() {
        if (this.getFormConfig() == null) {
            return false;
        }
        FormConfig newFormConfig = FormMetadataCache.getFormConfig(this.getFormId());
        if (!Objects.equals(newFormConfig.getEntityTypeId(), this.getFormConfig().getEntityTypeId())) {
            return false;
        }
        if (newFormConfig.getFieldHashCode() == null) {
            return false;
        }
        if (this.getFormConfig().getFieldHashCode() == null) {
            return false;
        }
        return !Objects.equals(newFormConfig.getVersion(), this.getFormConfig().getVersion()) && !newFormConfig.getFieldHashCode().equals(this.getFormConfig().getFieldHashCode());
    }

    private static void setListShowParameter(Map<String, Object> openParameter, ListShowParameter lShowParameter) {
        Object listFilterParameterVals;
        Object selectedRowConditionVals;
        Object selectedRowsVals;
        List linkQueryPkIdIntervalList;
        List linkQueryPkIdList;
        Object linkQueryPkIds = openParameter.get("linkQueryPkIds");
        if (linkQueryPkIds instanceof List && !(linkQueryPkIdList = (List)linkQueryPkIds).isEmpty()) {
            for (Object linkQueryPkId : linkQueryPkIdList) {
                lShowParameter.addLinkQueryPkId(linkQueryPkId);
            }
        }
        if (linkQueryPkIds instanceof String && StringUtils.isNotBlank((Object)linkQueryPkIds) && !(linkQueryPkIdList = (List)SerializationUtils.fromJsonString((String)((String)linkQueryPkIds), List.class)).isEmpty()) {
            for (Object linkQueryPkId : linkQueryPkIdList) {
                lShowParameter.addLinkQueryPkId(linkQueryPkId);
            }
        }
        Object linkQueryPkIdIntervals = openParameter.get("linkQueryPkIdIntervals");
        if (linkQueryPkIds != null && linkQueryPkIdIntervals instanceof List && !(linkQueryPkIdIntervalList = (List)linkQueryPkIdIntervals).isEmpty()) {
            for (Long[] linkQueryPkIdInterval : linkQueryPkIdIntervalList) {
                lShowParameter.addLinkQueryPkId(linkQueryPkIdInterval[0], linkQueryPkIdInterval[1]);
            }
        }
        if ((selectedRowsVals = openParameter.get("selectedRows")) instanceof List) {
            lShowParameter.setSelectedRows(((List)selectedRowsVals).toArray());
            openParameter.remove("selectedRows");
        }
        if ((selectedRowConditionVals = openParameter.get("selectedRowCondition")) != null) {
            ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(2);
            dataEntityTypes.add(OrmUtils.getDataEntityType(SelectedRowCondition.class));
            dataEntityTypes.add(OrmUtils.getDataEntityType(SelectedRowValue.class));
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
            SelectedRowCondition selectedRowCondition = (SelectedRowCondition)dcJsonSerializer.deserializeFromString(selectedRowConditionVals.toString(), null);
            lShowParameter.setSelectedRowCondition(selectedRowCondition);
            openParameter.remove("selectedRowCondition");
        }
        if ((listFilterParameterVals = openParameter.get("listFilterParameter")) != null) {
            ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>(1);
            dataEntityTypes.add(OrmUtils.getDataEntityType(ListFilterParameter.class));
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
            ListFilterParameter listFilterParameter = (ListFilterParameter)((Object)dcJsonSerializer.deserializeFromString(listFilterParameterVals.toString(), null));
            lShowParameter.setListFilterParameter(listFilterParameter);
            openParameter.remove("listFilterParameter");
        }
    }

    static {
        ptypes.put("form", FormShowParameter.class);
        ptypes.put("bill", BillShowParameter.class);
        ptypes.put("base", BaseShowParameter.class);
        ptypes.put("list", ListShowParameter.class);
        ptypes.put("parameter", ParameterShowParameter.class);
        ptypes.put("mobilebase", MobileBaseShowParameter.class);
        ptypes.put("mobilebill", MobileBillShowParameter.class);
        ptypes.put("mobileform", MobileFormShowParameter.class);
        ptypes.put("mobilelist", MobileListShowParameter.class);
        ptypes.put("mobiletreelist", MobileListShowParameter.class);
        bampMoveAppList.add("base");
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

