/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FloatingDirection;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class OpenStyle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ShowType showType = ShowType.forValue(0);
    private String targetKey;
    private String cacheId;
    private StyleCss inlineStyleCss;
    private FloatingDirection floatingDirection;
    private boolean noSwitchFocus = false;
    private ShowType clientShowType = ShowType.forValue(0);
    private boolean placeholder = true;
    private Map<String, String> custParam;

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="true")
    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
    }

    @KSMethod
    @SimplePropertyAttribute
    public FloatingDirection getFloatingDirection() {
        return this.floatingDirection;
    }

    public void setFloatingDirection(FloatingDirection floatingDirection) {
        this.floatingDirection = floatingDirection;
    }

    @SimplePropertyAttribute(name="NoSwitchFocus")
    @DefaultValueAttribute(value="false")
    public boolean isNoSwitchFocus() {
        return this.noSwitchFocus;
    }

    @SimplePropertyAttribute
    public void setNoSwitchFocus(boolean noSwitchFocus) {
        this.noSwitchFocus = noSwitchFocus;
    }

    @KSMethod
    @SimplePropertyAttribute
    public Map<String, String> getCustParam() {
        return this.custParam;
    }

    @KSMethod
    public void setCustParam(Map<String, String> custParam) {
        this.custParam = custParam;
    }

    public OpenStyle() {
        this.setShowType(ShowType.Default);
    }

    @KSMethod
    public ShowType getShowType() {
        return this.showType;
    }

    @KSMethod
    public void setShowType(ShowType value) {
        this.clientShowType = value;
        if (value != ShowType.InCurrentForm) {
            this.showType = value;
        }
    }

    @SdkInternal
    @SimplePropertyAttribute
    @KSMethod
    public int getShowTypeValue() {
        return this.showType.getValue();
    }

    @SdkInternal
    public void setShowTypeValue(int showTypeValue) {
        this.showType = ShowType.forValue(showTypeValue);
    }

    @SdkInternal
    @KSMethod
    public ShowType getClientShowType() {
        return this.clientShowType;
    }

    @SdkInternal
    public void setClientShowType(ShowType value) {
        this.clientShowType = value;
    }

    @SdkInternal
    @SimplePropertyAttribute
    @KSMethod
    public int getClientShowTypeValue() {
        return this.clientShowType.getValue();
    }

    @SdkInternal
    public void setClientShowTypeValue(int clientShowTypeValue) {
        this.clientShowType = ShowType.forValue(clientShowTypeValue);
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getTargetKey() {
        if (!StringUtils.isEmpty((CharSequence)this.targetKey)) {
            return this.targetKey.toLowerCase();
        }
        return this.targetKey;
    }

    @KSMethod
    public void setTargetKey(String value) {
        this.targetKey = value;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getCacheId() {
        return this.cacheId;
    }

    @KSMethod
    public void setCacheId(String value) {
        this.cacheId = value;
    }

    @ComplexPropertyAttribute
    public StyleCss getInlineStyleCss() {
        return this.inlineStyleCss;
    }

    public void setInlineStyleCss(StyleCss value) {
        this.inlineStyleCss = value;
    }

    @SdkInternal
    public Map<String, Object> getConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("showType", this.getClientShowType().getValue());
        if (StringUtils.isNotBlank((CharSequence)this.targetKey)) {
            config.put("targetKey", this.targetKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cacheId)) {
            config.put("cacheId", this.cacheId);
        }
        if (this.custParam != null) {
            for (Map.Entry<String, String> entry : this.custParam.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                config.put(key, value);
            }
        }
        if (this.floatingDirection != null) {
            config.put("direction", this.floatingDirection.getValue());
        }
        if (this.isNoSwitchFocus()) {
            config.put("noSwitchFocus", this.noSwitchFocus);
        }
        if (!this.isPlaceholder()) {
            config.put("placeholder", this.isPlaceholder());
        }
        return config;
    }
}

