/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import com.tongtech.backport.java.util.Collections;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.orm.query.QFilter;

public class OrgFullNameService {
    private static final String LONG_NUMBER = "longnumber";
    private static final String FULL_NAME = "fullname";
    private BasedataProp basedataProp;

    public OrgFullNameService(BasedataProp basedataProp) {
        this.basedataProp = basedataProp;
    }

    public void preLoadOrgData(Object v, String displayProp) {
        boolean isNeedReLoad = this.isNeedReLoadOrgData(v, displayProp);
        this.basedataProp.setNeedReLoad(isNeedReLoad);
        if (isNeedReLoad) {
            DynamicObject orgObj = (DynamicObject)v;
            this.reLoadOrgData(Collections.singletonList((Object)orgObj.getLong("id")));
        }
    }

    public void resetOrgDatas() {
        this.basedataProp.setOrgDatas(new HashMap());
        this.basedataProp.setNeedReLoad(false);
        this.basedataProp.setViewNumber("");
        this.basedataProp.setOrgFuncId("");
    }

    public void reLoadOrgData(List<Long> ids) {
        List<String> selectFields = Arrays.asList("id", FULL_NAME, LONG_NUMBER, "view.id", "view.number", "view.treetype", "view.isdefault");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectType dt = EntityMetadataCache.getSubDataEntityType((String)"bos_org", selectFields);
        this.basedataProp.setOrgDatas(BusinessDataReader.loadFromCache((DynamicObjectType)dt, (QFilter[])filters));
    }

    public boolean isNeedReLoadOrgData(Object v, String displayProp) {
        if (!(LONG_NUMBER.equalsIgnoreCase(displayProp) || FULL_NAME.equalsIgnoreCase(displayProp) || displayProp.toLowerCase().contains(LONG_NUMBER) || displayProp.toLowerCase().contains(FULL_NAME))) {
            return false;
        }
        BasedataEntityType dt = null;
        dt = ((DynamicObject)v).getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)((DynamicObject)v).getDataEntityType() : (BasedataEntityType)this.basedataProp.getComplexType();
        if (!this.isOrgType(dt.getName())) {
            return false;
        }
        String orgFunc = this.basedataProp.getOrgFunc();
        if (StringUtils.isBlank((CharSequence)orgFunc)) {
            if ("bos_org".equals(this.basedataProp.getBaseEntityId())) {
                orgFunc = "15";
            } else if ("bos_adminorg".equals(this.basedataProp.getBaseEntityId())) {
                orgFunc = "01";
            }
        }
        this.basedataProp.setOrgFuncId(orgFunc);
        boolean isContainsView = false;
        if (this.basedataProp instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)this.basedataProp;
            boolean bl = isContainsView = orgProp.getOrgViewScheme() != null;
        }
        if (isContainsView) {
            this.basedataProp.setViewNumber(((OrgProp)this.basedataProp).getOrgViewScheme().getNumber());
        }
        if (!(v instanceof DynamicObject)) {
            return false;
        }
        boolean containsLongNumber = true;
        boolean containsFullName = true;
        if (!displayProp.toLowerCase().contains(LONG_NUMBER)) {
            containsLongNumber = false;
        }
        if (!displayProp.toLowerCase().contains(FULL_NAME)) {
            containsFullName = false;
        }
        if (containsLongNumber && dt.findProperty(LONG_NUMBER) == null) {
            return true;
        }
        if (containsFullName && dt.findProperty(FULL_NAME) == null) {
            return true;
        }
        IDataEntityProperty viewProp = dt.findProperty("view");
        if (viewProp == null) {
            return true;
        }
        IDataEntityType viewType = ((BasedataProp)viewProp).getComplexType();
        if (viewType == null) {
            return false;
        }
        if (viewType.getProperties().containsKey((Object)"number") && viewType.getProperties().containsKey((Object)"isdefault") && viewType.getProperties().containsKey((Object)"treetype")) {
            return false;
        }
        if (isContainsView) {
            return false;
        }
        return !"01".equals(orgFunc) && !"15".equals(orgFunc);
    }

    private boolean isOrgType(String name) {
        return StringUtils.equals((CharSequence)"bos_org", (CharSequence)name) || StringUtils.equals((CharSequence)"bos_adminorg", (CharSequence)name);
    }
}

