/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.cardentry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EmbedSubEntryGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class CardEntry
extends EntryGrid {
    private List<PullRefreshListener> pullRefreshlisteners;

    @Override
    public void itemClick(String itemKey, String operationKey) {
        this.getView().invokeOperation(operationKey);
    }

    @Override
    @SdkInternal
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        if (this.getSubEntryGrids() != null) {
            for (String subEntryKey : this.getSubEntryGrids()) {
                Object ctl = this.getView().getControl(subEntryKey);
                if (!(ctl instanceof EmbedSubEntryGrid)) continue;
                ((Control)ctl).bindData(bctx);
            }
        }
    }

    @Override
    protected void focusedRowChanged(int newRow, int oldRow) {
        if (this.getSubEntryGrids() != null) {
            for (String subEntryKey : this.getSubEntryGrids()) {
                Object control = this.getView().getControl(subEntryKey);
                if (control instanceof EmbedSubEntryGrid) continue;
                this.getView().updateView(subEntryKey);
            }
        }
    }

    @Override
    protected List<Object> getAppendRows() {
        Boolean needPaged = this.isNeedPaged();
        AbstractGrid.GridState entryState = this.getEntryState();
        int startIndex = 0;
        int endIndex = 0;
        int rowCount = this.getRowCount();
        int pageCount = 0;
        if (needPaged.booleanValue()) {
            pageCount = rowCount / entryState.getPageRows() + (rowCount % entryState.getPageRows() > 0 ? 1 : 0);
            startIndex = (entryState.getCurrentPageIndex() - 1) * entryState.getPageRows();
            endIndex = Math.min(startIndex + this.getPageRow(), rowCount);
            endIndex = startIndex > endIndex ? startIndex : endIndex;
        } else {
            endIndex = rowCount;
        }
        ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        DynamicObject[] dataEntitys = this.getEntryDataEntities(startIndex, endIndex);
        if (dataEntitys != null && dataEntitys.length > 0) {
            Map<String, Object> flexMeta = this.getFlexInfo(dataEntitys);
            this.clientViewProxy.setEntryProperty(this.getKey(), "flexMeta", flexMeta);
            IDataEntityType entityType = dataEntitys[0].getDataEntityType();
            for (int rowIndex = 0; rowIndex < endIndex - startIndex; ++rowIndex) {
                objs.add(new RowDataEntity(rowIndex + startIndex, dataEntitys[rowIndex]));
            }
            RuleContainer ruleContaiber = (RuleContainer)this.view.getService(RuleContainer.class);
            ruleContaiber.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.view));
            for (RowDataEntity obj : objs) {
                BindingContext bindCtx = new BindingContext(entityType, obj.getDataEntity(), obj.getRowIndex());
                rows.add(this.getRowBindValue(bindCtx));
                this.setNumFmtInfo(obj);
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", rowCount);
        data.put("rows", rows);
        data.put("pagerows", entryState.getPageRows());
        data.put("pageindex", entryState.getCurrentPageIndex());
        data.put("isSplitPage", needPaged);
        data.put("pagecount", pageCount);
        data.put("datacount", rowCount);
        data.put("dataindex", this.getDataIndex());
        this.fireBindEntryGridDataEvent(objs, data, startIndex);
        return (List)data.get("rows");
    }

    private void setNumFmtInfo(RowDataEntity rowObj) {
        EntryProp entryProp = (EntryProp)this.getModel().getProperty(this.getEntryKey());
        HashSet<String> ctlNumber = new HashSet<String>();
        for (IDataEntityProperty entryproperty : entryProp.getItemType().getProperties()) {
            String key;
            DynamicObject o;
            if (!(entryproperty instanceof CurrencyProp) && !(entryproperty instanceof UnitProp) || (o = (DynamicObject)entryproperty.getValueFast((Object)rowObj.getDataEntity())) == null || !ctlNumber.add(key = this.getKey() + "." + entryproperty.getClass().getName() + "." + o.get("number"))) continue;
            this.setNumFmtInfo(entryproperty, o);
        }
    }

    public void addPullRefreshlisteners(PullRefreshListener listener) {
        if (this.pullRefreshlisteners == null) {
            this.pullRefreshlisteners = new ArrayList<PullRefreshListener>();
        }
        this.pullRefreshlisteners.add(listener);
    }

    public void refreshData() {
        PullRefreshEvent evt = new PullRefreshEvent(this);
        if (this.pullRefreshlisteners != null) {
            for (PullRefreshListener l : this.pullRefreshlisteners) {
                l.pullRefesh(evt);
            }
        }
    }

    @KSMethod
    public void setCardScrollBarToTop() {
        this.clientViewProxy.invokeControlMethod(this.key, "setCardScrollBartoTop", true);
    }

    public void setChildVisible(boolean value, int rowIndex, String ... ctlKeys) {
        String policy = "";
        ArrayList<String> keys = new ArrayList<String>(10);
        for (String k : ctlKeys) {
            keys.add(k);
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("o", policy);
        fieldMap.put("k", keys);
        fieldMap.put("r", rowIndex);
        fieldMap.put("vi", value);
        this.clientViewProxy.setVisibleState(this.key, fieldMap);
    }

    public void setChildEnable(boolean value, int rowIndex, String ... ctlKeys) {
        String policy = "";
        for (String k : ctlKeys) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            fieldMap.put("o", policy);
            fieldMap.put("k", k);
            fieldMap.put("r", rowIndex);
            fieldMap.put("l", value);
            this.clientViewProxy.setLockState(this.key, fieldMap);
        }
    }

    public void selectCard(Integer row) {
        this.selectRows(row);
    }

    @Override
    protected void selectRows(int[] rowIndex, int focusRowIndex, boolean forceRefocus) {
        this.clientViewProxy.invokeControlMethod(this.getEntryKey(), "clearSelRows", new Object[0]);
        super.selectRows(rowIndex, focusRowIndex, forceRefocus);
    }

    @Override
    public void setMustInput(String fieldKey, boolean value) {
        HashMap<String, Object> prop = new HashMap<String, Object>(1);
        prop.put("mi", value);
        HashMap<String, Boolean> editor = new HashMap<String, Boolean>(1);
        editor.put("mi", value);
        prop.put("item", editor);
        this.view.updateControlMetadata(fieldKey, prop);
    }

    public void setLongPressItemProp(int index, String key, boolean visible, boolean lock) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ArrayList props = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", key);
        map.put("visible", visible ? Boolean.TRUE : Boolean.FALSE);
        map.put("lock", lock ? Boolean.TRUE : Boolean.FALSE);
        props.add(map);
        HashMap data = new HashMap();
        data.put("longPressInvokeAction", props);
        this.clientViewProxy.invokeControlMethod(this.key, "setCustomProperties", index, data);
    }

    public void setLongPressItemVisible(int index, String key, boolean visible) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ArrayList props = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", key);
        map.put("visible", visible ? Boolean.TRUE : Boolean.FALSE);
        props.add(map);
        HashMap data = new HashMap();
        data.put("longPressInvokeAction", props);
        this.clientViewProxy.invokeControlMethod(this.key, "setCustomProperties", index, data);
    }

    public void setLongPressItemLock(int index, String key, boolean lock) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        ArrayList props = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", key);
        map.put("lock", lock ? Boolean.TRUE : Boolean.FALSE);
        props.add(map);
        HashMap data = new HashMap();
        data.put("longPressInvokeAction", props);
        this.clientViewProxy.invokeControlMethod(this.key, "setCustomProperties", index, data);
    }

    public void cardOperations(String id, String operationKey) {
        if (StringUtils.isNotBlank((CharSequence)operationKey)) {
            this.getView().invokeOperation(operationKey);
        }
    }

    public void entryRowOperations(String key, String opKey) {
        this.getView().invokeOperation(opKey);
    }
}

